/* db-reader.c generated by valac 0.56.17, the Vala compiler
 * generated from db-reader.vala, do not modify */

/* db-reader.vala
 *
 * Copyright © 2011-2012 Collabora Ltd.
 *             By Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 *             By Seif Lotfy <seif@lotfy.com>
 * Copyright © 2011 Canonical Ltd.
 *             By Michal Hruby <michal.hruby@canonical.com>
 *
 * Based upon a Python implementation (2009-2011) by:
 *  Markus Korn <thekorn@gmx.net>
 *  Mikkel Kamstrup Erlandsen <mikkel.kamstrup@gmail.com>
 *  Seif Lotfy <seif@lotfy.com>
 *  Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "zeitgeist-internal.h"
#include <glib-object.h>
#include "zeitgeist-datamodel.h"
#include <glib.h>
#include <sqlite3.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	ZEITGEIST_DB_READER_0_PROPERTY,
	ZEITGEIST_DB_READER_DATABASE_PROPERTY,
	ZEITGEIST_DB_READER_NUM_PROPERTIES
};
static GParamSpec* zeitgeist_db_reader_properties[ZEITGEIST_DB_READER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_byte_array_unref0(var) ((var == NULL) ? NULL : (var = (g_byte_array_unref (var), NULL)))
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))

#define ZEITGEIST_DB_READER_TYPE_RELATED_URI (zeitgeist_db_reader_related_uri_get_type ())
typedef struct _ZeitgeistDbReaderRelatedUri ZeitgeistDbReaderRelatedUri;
#define _zeitgeist_db_reader_related_uri_free0(var) ((var == NULL) ? NULL : (var = (zeitgeist_db_reader_related_uri_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _ZeitgeistDbReaderPrivate {
	ZeitgeistSQLiteDatabase* _database;
};

struct _ZeitgeistDbReaderRelatedUri {
	guint32 id;
	gint64 timestamp;
	gchar* uri;
	gint32 counter;
};

static gint ZeitgeistDbReader_private_offset;
static gpointer zeitgeist_db_reader_parent_class = NULL;

static void _g_object_unref0_ (gpointer var);
static gchar* zeitgeist_db_reader_group_and_sort (ZeitgeistDbReader* self,
                                           const gchar* field,
                                           ZeitgeistWhereClause* where,
                                           gboolean* count_asc,
                                           const gchar* aggregation_type);
static void _vala_array_add1 (guint32* * array,
                       gint* length,
                       gint* size,
                       guint32 value);
static GType zeitgeist_db_reader_related_uri_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static ZeitgeistDbReaderRelatedUri* zeitgeist_db_reader_related_uri_dup (const ZeitgeistDbReaderRelatedUri* self);
static void zeitgeist_db_reader_related_uri_free (ZeitgeistDbReaderRelatedUri* self);
static void zeitgeist_db_reader_related_uri_copy (const ZeitgeistDbReaderRelatedUri* self,
                                           ZeitgeistDbReaderRelatedUri* dest);
static void zeitgeist_db_reader_related_uri_destroy (ZeitgeistDbReaderRelatedUri* self);
static void _zeitgeist_db_reader_related_uri_free0_ (gpointer var);
static void _g_free0_ (gpointer var);
static gboolean _vala_uint32_array_contains (guint32 * stack,
                                      gssize stack_length,
                                      const guint32 needle);
static gint ___lambda8_ (ZeitgeistDbReaderRelatedUri* a,
                  ZeitgeistDbReaderRelatedUri* b);
static gint ____lambda8__gcompare_func (gconstpointer a,
                                 gconstpointer b);
static gint ___lambda9_ (ZeitgeistDbReaderRelatedUri* a,
                  ZeitgeistDbReaderRelatedUri* b);
static gint ____lambda9__gcompare_func (gconstpointer a,
                                 gconstpointer b);
static gint ____lambda10_ (ZeitgeistDbReaderRelatedUri* a,
                    ZeitgeistDbReaderRelatedUri* b);
static gint _____lambda10__gcompare_func (gconstpointer a,
                                   gconstpointer b);
static inline void _g_list_free__zeitgeist_db_reader_related_uri_free0_ (GList* self);
static void zeitgeist_db_reader_real_close (ZeitgeistDbReader* self);
static ZeitgeistWhereClause* zeitgeist_db_reader_get_where_clause_from_event_template (ZeitgeistDbReader* self,
                                                                                ZeitgeistEvent* template,
                                                                                GError** error);
static void zeitgeist_db_reader_delete_from_cache (ZeitgeistDbReader* self,
                                            const gchar* table,
                                            gint64 rowid);
static GObject * zeitgeist_db_reader_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
static void _zeitgeist_db_reader_delete_from_cache_zeitgeist_sq_lite_deletion_callback (const gchar* table,
                                                                                 gint64 rowid,
                                                                                 gpointer self);
static void zeitgeist_db_reader_finalize (GObject * obj);
static GType zeitgeist_db_reader_get_type_once (void);
static void _vala_zeitgeist_db_reader_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_zeitgeist_db_reader_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
zeitgeist_db_reader_get_instance_private (ZeitgeistDbReader* self)
{
	return G_STRUCT_MEMBER_P (self, ZeitgeistDbReader_private_offset);
}

ZeitgeistDbReader*
zeitgeist_db_reader_construct (GType object_type,
                               GError** error)
{
	ZeitgeistDbReader * self = NULL;
	ZeitgeistSQLiteDatabase* _tmp0_ = NULL;
	ZeitgeistSQLiteDatabase* _tmp1_;
	GError* _inner_error0_ = NULL;
	_tmp1_ = zeitgeist_sq_lite_database_new_read_only (&_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	self = (ZeitgeistDbReader*) g_object_new (object_type, "database", _tmp0_, NULL);
	_g_object_unref0 (_tmp0_);
	return self;
}

ZeitgeistDbReader*
zeitgeist_db_reader_new (GError** error)
{
	return zeitgeist_db_reader_construct (ZEITGEIST_TYPE_DB_READER, error);
}

ZeitgeistEvent*
zeitgeist_db_reader_get_event_from_row (ZeitgeistDbReader* self,
                                        sqlite3_stmt* stmt,
                                        guint32 event_id,
                                        GError** error)
{
	ZeitgeistEvent* event = NULL;
	ZeitgeistEvent* _tmp0_;
	ZeitgeistEvent* _tmp1_;
	ZeitgeistEvent* _tmp2_;
	const gchar* _tmp3_ = NULL;
	ZeitgeistSQLiteTableLookup* _tmp4_;
	const gchar* _tmp5_;
	ZeitgeistEvent* _tmp6_;
	const gchar* _tmp7_ = NULL;
	ZeitgeistSQLiteTableLookup* _tmp8_;
	const gchar* _tmp9_;
	ZeitgeistEvent* _tmp10_;
	const gchar* _tmp11_ = NULL;
	ZeitgeistSQLiteTableLookup* _tmp12_;
	const gchar* _tmp13_;
	ZeitgeistEvent* _tmp14_;
	ZeitgeistEvent* _tmp15_;
	const gchar* _tmp16_;
	guint8* data = NULL;
	void* _tmp17_;
	gint data_length1;
	gint _data_size_;
	guint8* _tmp18_;
	gint _tmp18__length1;
	GError* _inner_error0_ = NULL;
	ZeitgeistEvent* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (stmt != NULL, NULL);
	_tmp0_ = zeitgeist_event_new ();
	event = _tmp0_;
	_tmp1_ = event;
	zeitgeist_event_set_id (_tmp1_, event_id);
	_tmp2_ = event;
	zeitgeist_event_set_timestamp (_tmp2_, sqlite3_column_int64 (stmt, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_TIMESTAMP));
	_tmp4_ = self->interpretations_table;
	_tmp5_ = zeitgeist_sq_lite_table_lookup_get_value (_tmp4_, sqlite3_column_int (stmt, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_INTERPRETATION), &_inner_error0_);
	_tmp3_ = _tmp5_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (event);
			return NULL;
		} else {
			_g_object_unref0 (event);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp6_ = event;
	zeitgeist_event_set_interpretation (_tmp6_, _tmp3_);
	_tmp8_ = self->manifestations_table;
	_tmp9_ = zeitgeist_sq_lite_table_lookup_get_value (_tmp8_, sqlite3_column_int (stmt, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_MANIFESTATION), &_inner_error0_);
	_tmp7_ = _tmp9_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (event);
			return NULL;
		} else {
			_g_object_unref0 (event);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp10_ = event;
	zeitgeist_event_set_manifestation (_tmp10_, _tmp7_);
	_tmp12_ = self->actors_table;
	_tmp13_ = zeitgeist_sq_lite_table_lookup_get_value (_tmp12_, sqlite3_column_int (stmt, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_ACTOR), &_inner_error0_);
	_tmp11_ = _tmp13_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (event);
			return NULL;
		} else {
			_g_object_unref0 (event);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp14_ = event;
	zeitgeist_event_set_actor (_tmp14_, _tmp11_);
	_tmp15_ = event;
	_tmp16_ = (const gchar*) sqlite3_column_text (stmt, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_EVENT_ORIGIN_URI);
	zeitgeist_event_set_origin (_tmp15_, _tmp16_);
	_tmp17_ = sqlite3_column_blob (stmt, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_PAYLOAD);
	data = (guint8*) _tmp17_;
	data_length1 = -1;
	_data_size_ = data_length1;
	data_length1 = sqlite3_column_bytes (stmt, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_PAYLOAD);
	_tmp18_ = data;
	_tmp18__length1 = data_length1;
	if (_tmp18_ != NULL) {
		ZeitgeistEvent* _tmp19_;
		GByteArray* _tmp20_;
		GByteArray* _tmp21_;
		ZeitgeistEvent* _tmp22_;
		GByteArray* _tmp23_;
		GByteArray* _tmp24_;
		guint8* _tmp25_;
		gint _tmp25__length1;
		_tmp19_ = event;
		_tmp20_ = g_byte_array_new ();
		_tmp21_ = _tmp20_;
		zeitgeist_event_set_payload (_tmp19_, _tmp21_);
		_g_byte_array_unref0 (_tmp21_);
		_tmp22_ = event;
		_tmp23_ = zeitgeist_event_get_payload (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = data;
		_tmp25__length1 = data_length1;
		g_byte_array_append (_tmp24_, _tmp25_, (gint) _tmp25__length1);
	}
	result = event;
	return result;
}

ZeitgeistSubject*
zeitgeist_db_reader_get_subject_from_row (ZeitgeistDbReader* self,
                                          sqlite3_stmt* stmt,
                                          GError** error)
{
	ZeitgeistSubject* subject = NULL;
	ZeitgeistSubject* _tmp0_;
	ZeitgeistSubject* _tmp1_;
	const gchar* _tmp2_;
	ZeitgeistSubject* _tmp3_;
	const gchar* _tmp4_;
	ZeitgeistSubject* _tmp5_;
	const gchar* _tmp6_;
	ZeitgeistSubject* _tmp7_;
	const gchar* _tmp8_;
	ZeitgeistSubject* _tmp9_;
	const gchar* _tmp10_;
	ZeitgeistSubject* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_ = NULL;
	ZeitgeistSQLiteTableLookup* _tmp14_;
	const gchar* _tmp15_;
	ZeitgeistSubject* _tmp16_;
	const gchar* _tmp17_ = NULL;
	ZeitgeistSQLiteTableLookup* _tmp18_;
	const gchar* _tmp19_;
	ZeitgeistSubject* _tmp20_;
	const gchar* _tmp21_ = NULL;
	ZeitgeistSQLiteTableLookup* _tmp22_;
	const gchar* _tmp23_;
	ZeitgeistSubject* _tmp24_;
	GError* _inner_error0_ = NULL;
	ZeitgeistSubject* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (stmt != NULL, NULL);
	_tmp0_ = zeitgeist_subject_new ();
	subject = _tmp0_;
	_tmp1_ = subject;
	_tmp2_ = (const gchar*) sqlite3_column_text (stmt, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_URI);
	zeitgeist_subject_set_uri (_tmp1_, _tmp2_);
	_tmp3_ = subject;
	_tmp4_ = (const gchar*) sqlite3_column_text (stmt, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_TEXT);
	zeitgeist_subject_set_text (_tmp3_, _tmp4_);
	_tmp5_ = subject;
	_tmp6_ = (const gchar*) sqlite3_column_text (stmt, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_STORAGE);
	zeitgeist_subject_set_storage (_tmp5_, _tmp6_);
	_tmp7_ = subject;
	_tmp8_ = (const gchar*) sqlite3_column_text (stmt, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_ORIGIN_URI);
	zeitgeist_subject_set_origin (_tmp7_, _tmp8_);
	_tmp9_ = subject;
	_tmp10_ = (const gchar*) sqlite3_column_text (stmt, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_CURRENT_URI);
	zeitgeist_subject_set_current_uri (_tmp9_, _tmp10_);
	_tmp11_ = subject;
	_tmp12_ = (const gchar*) sqlite3_column_text (stmt, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_CURRENT_ORIGIN_URI);
	zeitgeist_subject_set_current_origin (_tmp11_, _tmp12_);
	_tmp14_ = self->interpretations_table;
	_tmp15_ = zeitgeist_sq_lite_table_lookup_get_value (_tmp14_, sqlite3_column_int (stmt, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_INTERPRETATION), &_inner_error0_);
	_tmp13_ = _tmp15_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (subject);
			return NULL;
		} else {
			_g_object_unref0 (subject);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp16_ = subject;
	zeitgeist_subject_set_interpretation (_tmp16_, _tmp13_);
	_tmp18_ = self->manifestations_table;
	_tmp19_ = zeitgeist_sq_lite_table_lookup_get_value (_tmp18_, sqlite3_column_int (stmt, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_MANIFESTATION), &_inner_error0_);
	_tmp17_ = _tmp19_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (subject);
			return NULL;
		} else {
			_g_object_unref0 (subject);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp20_ = subject;
	zeitgeist_subject_set_manifestation (_tmp20_, _tmp17_);
	_tmp22_ = self->mimetypes_table;
	_tmp23_ = zeitgeist_sq_lite_table_lookup_get_value (_tmp22_, sqlite3_column_int (stmt, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_SUBJECT_MIMETYPE), &_inner_error0_);
	_tmp21_ = _tmp23_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (subject);
			return NULL;
		} else {
			_g_object_unref0 (subject);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp24_ = subject;
	zeitgeist_subject_set_mimetype (_tmp24_, _tmp21_);
	result = subject;
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

static void
g_ptr_array_set (GPtrArray* self,
                 guint index,
                 gpointer data)
{
	gpointer _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = data;
	data = NULL;
	g_ptr_array_add (self, _tmp0_);
	g_ptr_array_remove_index_fast (self, index);
}

GPtrArray*
zeitgeist_db_reader_get_events (ZeitgeistDbReader* self,
                                guint32* event_ids,
                                gint event_ids_length1,
                                const char* sender,
                                GError** error)
{
	gchar* sql_event_ids = NULL;
	ZeitgeistSQLiteDatabase* _tmp1_;
	gchar* _tmp2_;
	gchar* sql = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	sqlite3_stmt* stmt = NULL;
	gint rc = 0;
	sqlite3* _tmp5_;
	const gchar* _tmp6_;
	sqlite3_stmt* _tmp7_ = NULL;
	gint _tmp8_;
	ZeitgeistSQLiteDatabase* _tmp9_;
	GHashTable* events = NULL;
	GHashFunc _tmp10_;
	GEqualFunc _tmp11_;
	GHashTable* _tmp12_;
	ZeitgeistSQLiteDatabase* _tmp30_;
	GPtrArray* results = NULL;
	GPtrArray* _tmp31_;
	GPtrArray* _tmp32_;
	gint i = 0;
	GError* _inner_error0_ = NULL;
	GPtrArray* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (event_ids_length1 == 0) {
		GPtrArray* _tmp0_;
		_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
		result = _tmp0_;
		return result;
	}
	_tmp1_ = self->priv->_database;
	_tmp2_ = zeitgeist_sq_lite_database_get_sql_string_from_event_ids (_tmp1_, event_ids, (gint) event_ids_length1);
	sql_event_ids = _tmp2_;
	_tmp3_ = sql_event_ids;
	_tmp4_ = g_strdup_printf ("\n" \
"            SELECT * FROM event_view\n" \
"            WHERE id IN (%s)\n" \
"            ", _tmp3_);
	sql = _tmp4_;
	_tmp5_ = self->db;
	_tmp6_ = sql;
	_tmp8_ = sqlite3_prepare_v2 (_tmp5_, _tmp6_, -1, &_tmp7_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp7_;
	rc = _tmp8_;
	_tmp9_ = self->priv->_database;
	zeitgeist_sq_lite_database_assert_query_success (_tmp9_, rc, "db-reader.vala:142: SQL error", SQLITE_OK, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_sqlite3_finalize0 (stmt);
			_g_free0 (sql);
			_g_free0 (sql_event_ids);
			return NULL;
		} else {
			_sqlite3_finalize0 (stmt);
			_g_free0 (sql);
			_g_free0 (sql_event_ids);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp10_ = g_direct_hash;
	_tmp11_ = g_direct_equal;
	_tmp12_ = g_hash_table_new_full (_tmp10_, _tmp11_, NULL, _g_object_unref0_);
	events = _tmp12_;
	while (TRUE) {
		sqlite3_stmt* _tmp13_;
		guint32 event_id = 0U;
		sqlite3_stmt* _tmp14_;
		ZeitgeistEvent* event = NULL;
		GHashTable* _tmp15_;
		gconstpointer _tmp16_;
		ZeitgeistEvent* _tmp17_;
		ZeitgeistEvent* _tmp18_;
		ZeitgeistSubject* subject = NULL;
		sqlite3_stmt* _tmp26_;
		ZeitgeistSubject* _tmp27_;
		ZeitgeistEvent* _tmp28_;
		ZeitgeistSubject* _tmp29_;
		_tmp13_ = stmt;
		rc = sqlite3_step (_tmp13_);
		if (!(rc == SQLITE_ROW)) {
			break;
		}
		_tmp14_ = stmt;
		event_id = (guint32) sqlite3_column_int64 (_tmp14_, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_ID);
		_tmp15_ = events;
		_tmp16_ = g_hash_table_lookup (_tmp15_, (gpointer) ((guintptr) event_id));
		_tmp17_ = _g_object_ref0 ((ZeitgeistEvent*) _tmp16_);
		event = _tmp17_;
		_tmp18_ = event;
		if (_tmp18_ == NULL) {
			ZeitgeistEvent* _tmp19_ = NULL;
			sqlite3_stmt* _tmp20_;
			ZeitgeistEvent* _tmp21_;
			ZeitgeistEvent* _tmp22_;
			GHashTable* _tmp23_;
			ZeitgeistEvent* _tmp24_;
			ZeitgeistEvent* _tmp25_;
			_tmp20_ = stmt;
			_tmp21_ = zeitgeist_db_reader_get_event_from_row (self, _tmp20_, event_id, &_inner_error0_);
			_tmp19_ = _tmp21_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (event);
					_g_hash_table_unref0 (events);
					_sqlite3_finalize0 (stmt);
					_g_free0 (sql);
					_g_free0 (sql_event_ids);
					return NULL;
				} else {
					_g_object_unref0 (event);
					_g_hash_table_unref0 (events);
					_sqlite3_finalize0 (stmt);
					_g_free0 (sql);
					_g_free0 (sql_event_ids);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp22_ = _tmp19_;
			_tmp19_ = NULL;
			_g_object_unref0 (event);
			event = _tmp22_;
			_tmp23_ = events;
			_tmp24_ = event;
			_tmp25_ = _g_object_ref0 (_tmp24_);
			g_hash_table_insert (_tmp23_, (gpointer) ((guintptr) event_id), _tmp25_);
			_g_object_unref0 (_tmp19_);
		}
		_tmp26_ = stmt;
		_tmp27_ = zeitgeist_db_reader_get_subject_from_row (self, _tmp26_, &_inner_error0_);
		subject = _tmp27_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (event);
				_g_hash_table_unref0 (events);
				_sqlite3_finalize0 (stmt);
				_g_free0 (sql);
				_g_free0 (sql_event_ids);
				return NULL;
			} else {
				_g_object_unref0 (event);
				_g_hash_table_unref0 (events);
				_sqlite3_finalize0 (stmt);
				_g_free0 (sql);
				_g_free0 (sql_event_ids);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp28_ = event;
		_tmp29_ = subject;
		zeitgeist_event_add_subject (_tmp28_, _tmp29_);
		_g_object_unref0 (subject);
		_g_object_unref0 (event);
	}
	_tmp30_ = self->priv->_database;
	zeitgeist_sq_lite_database_assert_query_success (_tmp30_, rc, "Error", SQLITE_DONE, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_hash_table_unref0 (events);
			_sqlite3_finalize0 (stmt);
			_g_free0 (sql);
			_g_free0 (sql_event_ids);
			return NULL;
		} else {
			_g_hash_table_unref0 (events);
			_sqlite3_finalize0 (stmt);
			_g_free0 (sql);
			_g_free0 (sql_event_ids);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp31_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	results = _tmp31_;
	_tmp32_ = results;
	g_ptr_array_set_size (_tmp32_, event_ids_length1);
	i = 0;
	{
		guint32* id_collection = NULL;
		gint id_collection_length1 = 0;
		gint _id_collection_size_ = 0;
		gint id_it = 0;
		id_collection = event_ids;
		id_collection_length1 = event_ids_length1;
		for (id_it = 0; id_it < id_collection_length1; id_it = id_it + 1) {
			guint32 id = 0U;
			id = id_collection[id_it];
			{
				GPtrArray* _tmp33_;
				gint _tmp34_;
				GHashTable* _tmp35_;
				gconstpointer _tmp36_;
				ZeitgeistEvent* _tmp37_;
				_tmp33_ = results;
				_tmp34_ = i;
				i = _tmp34_ + 1;
				_tmp35_ = events;
				_tmp36_ = g_hash_table_lookup (_tmp35_, (gpointer) ((guintptr) id));
				_tmp37_ = _g_object_ref0 ((ZeitgeistEvent*) _tmp36_);
				g_ptr_array_set (_tmp33_, (guint) _tmp34_, _tmp37_);
			}
		}
	}
	result = results;
	_g_hash_table_unref0 (events);
	_sqlite3_finalize0 (stmt);
	_g_free0 (sql);
	_g_free0 (sql_event_ids);
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gpointer
_g_ptr_array_ref0 (gpointer self)
{
	return self ? g_ptr_array_ref (self) : NULL;
}

static guint64
uint64_parse (const gchar* str,
              guint _base)
{
	guint64 result;
	g_return_val_if_fail (str != NULL, 0ULL);
	result = g_ascii_strtoull (str, NULL, _base);
	return result;
}

static void
_vala_array_add1 (guint32* * array,
                  gint* length,
                  gint* size,
                  guint32 value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint32, *array, *size);
	}
	(*array)[(*length)++] = value;
}

guint32*
zeitgeist_db_reader_find_event_ids_for_clause (ZeitgeistDbReader* self,
                                               ZeitgeistWhereClause* where,
                                               guint max_events,
                                               guint result_type,
                                               gint* result_length1,
                                               GError** error)
{
	gchar* sql = NULL;
	gchar* _tmp0_;
	gchar* where_sql = NULL;
	gchar* _tmp1_;
	gboolean time_asc = FALSE;
	const gchar* _tmp68_ = NULL;
	const gchar* _tmp69_;
	gchar* _tmp70_;
	gchar* _tmp71_;
	gchar* _tmp72_;
	gint rc = 0;
	sqlite3_stmt* stmt = NULL;
	sqlite3* _tmp75_;
	const gchar* _tmp76_;
	sqlite3_stmt* _tmp77_ = NULL;
	gint _tmp78_;
	ZeitgeistSQLiteDatabase* _tmp79_;
	GPtrArray* arguments = NULL;
	GPtrArray* _tmp80_;
	GPtrArray* _tmp81_;
	guint32* event_ids = NULL;
	guint32* _tmp92_;
	gint event_ids_length1;
	gint _event_ids_size_;
	gboolean _tmp102_ = FALSE;
	guint32* _tmp110_;
	gint _tmp110__length1;
	GError* _inner_error0_ = NULL;
	guint32* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (where != NULL, NULL);
	_tmp0_ = g_strdup ("SELECT id FROM event_view ");
	sql = _tmp0_;
	_tmp1_ = g_strdup ("");
	where_sql = _tmp1_;
	if (!zeitgeist_where_clause_is_empty (where)) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = zeitgeist_where_clause_get_sql_conditions (where);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strconcat ("WHERE ", _tmp3_, NULL);
		_g_free0 (where_sql);
		where_sql = _tmp4_;
		_g_free0 (_tmp3_);
	}
	switch (result_type) {
		case ZEITGEIST_RESULT_TYPE_MOST_RECENT_EVENTS:
		{
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp5_ = sql;
			_tmp6_ = where_sql;
			_tmp7_ = g_strconcat (_tmp6_, " ORDER BY ", NULL);
			_tmp8_ = _tmp7_;
			_tmp9_ = g_strconcat (_tmp5_, _tmp8_, NULL);
			_g_free0 (sql);
			sql = _tmp9_;
			_g_free0 (_tmp8_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_RECENT_EVENTS:
		{
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			_tmp10_ = sql;
			_tmp11_ = where_sql;
			_tmp12_ = g_strconcat (_tmp11_, " ORDER BY ", NULL);
			_tmp13_ = _tmp12_;
			_tmp14_ = g_strconcat (_tmp10_, _tmp13_, NULL);
			_g_free0 (sql);
			sql = _tmp14_;
			_g_free0 (_tmp13_);
			break;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_RECENT_EVENT_ORIGIN:
		{
			gchar* _tmp15_;
			_tmp15_ = zeitgeist_db_reader_group_and_sort (self, "origin", where, NULL, "max");
			_g_free0 (sql);
			sql = _tmp15_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_RECENT_EVENT_ORIGIN:
		{
			gchar* _tmp16_;
			_tmp16_ = zeitgeist_db_reader_group_and_sort (self, "origin", where, NULL, "max");
			_g_free0 (sql);
			sql = _tmp16_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_POPULAR_EVENT_ORIGIN:
		{
			gboolean _tmp17_;
			gchar* _tmp18_;
			_tmp17_ = FALSE;
			_tmp18_ = zeitgeist_db_reader_group_and_sort (self, "origin", where, &_tmp17_, "max");
			_g_free0 (sql);
			sql = _tmp18_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_EVENT_ORIGIN:
		{
			gboolean _tmp19_;
			gchar* _tmp20_;
			_tmp19_ = TRUE;
			_tmp20_ = zeitgeist_db_reader_group_and_sort (self, "origin", where, &_tmp19_, "max");
			_g_free0 (sql);
			sql = _tmp20_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_RECENT_SUBJECTS:
		{
			gchar* _tmp21_;
			_tmp21_ = zeitgeist_db_reader_group_and_sort (self, "subj_id", where, NULL, "max");
			_g_free0 (sql);
			sql = _tmp21_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_RECENT_SUBJECTS:
		{
			gchar* _tmp22_;
			_tmp22_ = zeitgeist_db_reader_group_and_sort (self, "subj_id", where, NULL, "max");
			_g_free0 (sql);
			sql = _tmp22_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_POPULAR_SUBJECTS:
		{
			gboolean _tmp23_;
			gchar* _tmp24_;
			_tmp23_ = FALSE;
			_tmp24_ = zeitgeist_db_reader_group_and_sort (self, "subj_id", where, &_tmp23_, "max");
			_g_free0 (sql);
			sql = _tmp24_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_SUBJECTS:
		{
			gboolean _tmp25_;
			gchar* _tmp26_;
			_tmp25_ = TRUE;
			_tmp26_ = zeitgeist_db_reader_group_and_sort (self, "subj_id", where, &_tmp25_, "max");
			_g_free0 (sql);
			sql = _tmp26_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_RECENT_CURRENT_URI:
		{
			gchar* _tmp27_;
			_tmp27_ = zeitgeist_db_reader_group_and_sort (self, "subj_id_current", where, NULL, "max");
			_g_free0 (sql);
			sql = _tmp27_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_RECENT_CURRENT_URI:
		{
			gchar* _tmp28_;
			_tmp28_ = zeitgeist_db_reader_group_and_sort (self, "subj_id_current", where, NULL, "max");
			_g_free0 (sql);
			sql = _tmp28_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_POPULAR_CURRENT_URI:
		{
			gboolean _tmp29_;
			gchar* _tmp30_;
			_tmp29_ = FALSE;
			_tmp30_ = zeitgeist_db_reader_group_and_sort (self, "subj_id_current", where, &_tmp29_, "max");
			_g_free0 (sql);
			sql = _tmp30_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_CURRENT_URI:
		{
			gboolean _tmp31_;
			gchar* _tmp32_;
			_tmp31_ = TRUE;
			_tmp32_ = zeitgeist_db_reader_group_and_sort (self, "subj_id_current", where, &_tmp31_, "max");
			_g_free0 (sql);
			sql = _tmp32_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_RECENT_ACTOR:
		{
			gchar* _tmp33_;
			_tmp33_ = zeitgeist_db_reader_group_and_sort (self, "actor", where, NULL, "max");
			_g_free0 (sql);
			sql = _tmp33_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_RECENT_ACTOR:
		{
			gchar* _tmp34_;
			_tmp34_ = zeitgeist_db_reader_group_and_sort (self, "actor", where, NULL, "max");
			_g_free0 (sql);
			sql = _tmp34_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_POPULAR_ACTOR:
		{
			gboolean _tmp35_;
			gchar* _tmp36_;
			_tmp35_ = FALSE;
			_tmp36_ = zeitgeist_db_reader_group_and_sort (self, "actor", where, &_tmp35_, "max");
			_g_free0 (sql);
			sql = _tmp36_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_ACTOR:
		{
			gboolean _tmp37_;
			gchar* _tmp38_;
			_tmp37_ = TRUE;
			_tmp38_ = zeitgeist_db_reader_group_and_sort (self, "actor", where, &_tmp37_, "max");
			_g_free0 (sql);
			sql = _tmp38_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_OLDEST_ACTOR:
		{
			gchar* _tmp39_;
			_tmp39_ = zeitgeist_db_reader_group_and_sort (self, "actor", where, NULL, "min");
			_g_free0 (sql);
			sql = _tmp39_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_RECENT_ORIGIN:
		{
			gchar* _tmp40_;
			_tmp40_ = zeitgeist_db_reader_group_and_sort (self, "subj_origin", where, NULL, "max");
			_g_free0 (sql);
			sql = _tmp40_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_RECENT_ORIGIN:
		{
			gchar* _tmp41_;
			_tmp41_ = zeitgeist_db_reader_group_and_sort (self, "subj_origin", where, NULL, "max");
			_g_free0 (sql);
			sql = _tmp41_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_POPULAR_ORIGIN:
		{
			gboolean _tmp42_;
			gchar* _tmp43_;
			_tmp42_ = FALSE;
			_tmp43_ = zeitgeist_db_reader_group_and_sort (self, "subj_origin", where, &_tmp42_, "max");
			_g_free0 (sql);
			sql = _tmp43_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_ORIGIN:
		{
			gboolean _tmp44_;
			gchar* _tmp45_;
			_tmp44_ = TRUE;
			_tmp45_ = zeitgeist_db_reader_group_and_sort (self, "subj_origin", where, &_tmp44_, "max");
			_g_free0 (sql);
			sql = _tmp45_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_RECENT_CURRENT_ORIGIN:
		{
			gchar* _tmp46_;
			_tmp46_ = zeitgeist_db_reader_group_and_sort (self, "subj_origin_current", where, NULL, "max");
			_g_free0 (sql);
			sql = _tmp46_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_RECENT_CURRENT_ORIGIN:
		{
			gchar* _tmp47_;
			_tmp47_ = zeitgeist_db_reader_group_and_sort (self, "subj_origin_current", where, NULL, "max");
			_g_free0 (sql);
			sql = _tmp47_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_POPULAR_CURRENT_ORIGIN:
		{
			gboolean _tmp48_;
			gchar* _tmp49_;
			_tmp48_ = FALSE;
			_tmp49_ = zeitgeist_db_reader_group_and_sort (self, "subj_origin_current", where, &_tmp48_, "max");
			_g_free0 (sql);
			sql = _tmp49_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_CURRENT_ORIGIN:
		{
			gboolean _tmp50_;
			gchar* _tmp51_;
			_tmp50_ = TRUE;
			_tmp51_ = zeitgeist_db_reader_group_and_sort (self, "subj_origin_current", where, &_tmp50_, "max");
			_g_free0 (sql);
			sql = _tmp51_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_RECENT_SUBJECT_INTERPRETATION:
		{
			gchar* _tmp52_;
			_tmp52_ = zeitgeist_db_reader_group_and_sort (self, "subj_interpretation", where, NULL, "max");
			_g_free0 (sql);
			sql = _tmp52_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_RECENT_SUBJECT_INTERPRETATION:
		{
			gchar* _tmp53_;
			_tmp53_ = zeitgeist_db_reader_group_and_sort (self, "subj_interpretation", where, NULL, "max");
			_g_free0 (sql);
			sql = _tmp53_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_POPULAR_SUBJECT_INTERPRETATION:
		{
			gboolean _tmp54_;
			gchar* _tmp55_;
			_tmp54_ = FALSE;
			_tmp55_ = zeitgeist_db_reader_group_and_sort (self, "subj_interpretation", where, &_tmp54_, "max");
			_g_free0 (sql);
			sql = _tmp55_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_SUBJECT_INTERPRETATION:
		{
			gboolean _tmp56_;
			gchar* _tmp57_;
			_tmp56_ = TRUE;
			_tmp57_ = zeitgeist_db_reader_group_and_sort (self, "subj_interpretation", where, &_tmp56_, "max");
			_g_free0 (sql);
			sql = _tmp57_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_RECENT_MIMETYPE:
		{
			gchar* _tmp58_;
			_tmp58_ = zeitgeist_db_reader_group_and_sort (self, "subj_mimetype", where, NULL, "max");
			_g_free0 (sql);
			sql = _tmp58_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_RECENT_MIMETYPE:
		{
			gchar* _tmp59_;
			_tmp59_ = zeitgeist_db_reader_group_and_sort (self, "subj_mimetype", where, NULL, "max");
			_g_free0 (sql);
			sql = _tmp59_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_MOST_POPULAR_MIMETYPE:
		{
			gboolean _tmp60_;
			gchar* _tmp61_;
			_tmp60_ = FALSE;
			_tmp61_ = zeitgeist_db_reader_group_and_sort (self, "subj_mimetype", where, &_tmp60_, "max");
			_g_free0 (sql);
			sql = _tmp61_;
			break;
		}
		case ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_MIMETYPE:
		{
			gboolean _tmp62_;
			gchar* _tmp63_;
			_tmp62_ = TRUE;
			_tmp63_ = zeitgeist_db_reader_group_and_sort (self, "subj_mimetype", where, &_tmp62_, "max");
			_g_free0 (sql);
			sql = _tmp63_;
			break;
		}
		default:
		{
			gchar* error_message = NULL;
			gchar* _tmp64_;
			const gchar* _tmp65_;
			const gchar* _tmp66_;
			GError* _tmp67_;
			_tmp64_ = g_strdup ("Invalid ResultType.");
			error_message = _tmp64_;
			_tmp65_ = error_message;
			g_warning ("db-reader.vala:292: %s", _tmp65_);
			_tmp66_ = error_message;
			_tmp67_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_INVALID_ARGUMENT, _tmp66_);
			_inner_error0_ = _tmp67_;
			if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (error_message);
				_g_free0 (where_sql);
				_g_free0 (sql);
				return NULL;
			} else {
				_g_free0 (error_message);
				_g_free0 (where_sql);
				_g_free0 (sql);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_g_free0 (error_message);
		}
	}
	time_asc = zeitgeist_result_type_is_sort_order_asc ((ZeitgeistResultType) result_type);
	if (time_asc) {
		_tmp68_ = "ASC";
	} else {
		_tmp68_ = "DESC";
	}
	_tmp69_ = sql;
	_tmp70_ = g_strdup_printf (" timestamp %s", _tmp68_);
	_tmp71_ = _tmp70_;
	_tmp72_ = g_strconcat (_tmp69_, _tmp71_, NULL);
	_g_free0 (sql);
	sql = _tmp72_;
	_g_free0 (_tmp71_);
	if (zeitgeist_where_clause_get_is_simple (where)) {
		const gchar* _tmp73_;
		gchar* _tmp74_;
		_tmp73_ = sql;
		_tmp74_ = string_replace (_tmp73_, "FROM event_view", "FROM event");
		_g_free0 (sql);
		sql = _tmp74_;
	}
	_tmp75_ = self->db;
	_tmp76_ = sql;
	_tmp78_ = sqlite3_prepare_v2 (_tmp75_, _tmp76_, -1, &_tmp77_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp77_;
	rc = _tmp78_;
	_tmp79_ = self->priv->_database;
	zeitgeist_sq_lite_database_assert_query_success (_tmp79_, rc, "db-reader.vala:307: SQL error", SQLITE_OK, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_sqlite3_finalize0 (stmt);
			_g_free0 (where_sql);
			_g_free0 (sql);
			return NULL;
		} else {
			_sqlite3_finalize0 (stmt);
			_g_free0 (where_sql);
			_g_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp80_ = zeitgeist_where_clause_get_bind_arguments (where);
	_tmp81_ = _g_ptr_array_ref0 (_tmp80_);
	arguments = _tmp81_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp82_ = FALSE;
			_tmp82_ = TRUE;
			while (TRUE) {
				GPtrArray* _tmp84_;
				gint _tmp85_;
				gint _tmp86_;
				sqlite3_stmt* _tmp87_;
				GPtrArray* _tmp88_;
				gconstpointer _tmp89_;
				gchar* _tmp90_;
				GDestroyNotify _tmp91_;
				if (!_tmp82_) {
					gint _tmp83_;
					i = i + 1;
					_tmp83_ = i;
				}
				_tmp82_ = FALSE;
				_tmp84_ = arguments;
				_tmp85_ = vala_g_ptr_array_get_length (_tmp84_);
				_tmp86_ = _tmp85_;
				if (!(i < _tmp86_)) {
					break;
				}
				_tmp87_ = stmt;
				_tmp88_ = arguments;
				_tmp89_ = g_ptr_array_index (_tmp88_, (guint) i);
				_tmp90_ = g_strdup ((const gchar*) _tmp89_);
				_tmp91_ = g_free;
				sqlite3_bind_text (_tmp87_, i + 1, _tmp90_, -1, _tmp91_);
			}
		}
	}
	_tmp92_ = g_new0 (guint32, 0);
	event_ids = _tmp92_;
	event_ids_length1 = 0;
	_event_ids_size_ = event_ids_length1;
	while (TRUE) {
		sqlite3_stmt* _tmp93_;
		guint32 event_id = 0U;
		sqlite3_stmt* _tmp94_;
		const gchar* _tmp95_;
		gboolean _tmp96_ = FALSE;
		guint32* _tmp97_;
		gint _tmp97__length1;
		_tmp93_ = stmt;
		rc = sqlite3_step (_tmp93_);
		if (!(rc == SQLITE_ROW)) {
			break;
		}
		_tmp94_ = stmt;
		_tmp95_ = (const gchar*) sqlite3_column_text (_tmp94_, (gint) ZEITGEIST_SQ_LITE_EVENT_VIEW_ROWS_ID);
		event_id = (guint32) uint64_parse (_tmp95_, (guint) 0);
		_tmp97_ = event_ids;
		_tmp97__length1 = event_ids_length1;
		if (_tmp97__length1 == 0) {
			_tmp96_ = TRUE;
		} else {
			guint32* _tmp98_;
			gint _tmp98__length1;
			guint32* _tmp99_;
			gint _tmp99__length1;
			guint32 _tmp100_;
			_tmp98_ = event_ids;
			_tmp98__length1 = event_ids_length1;
			_tmp99_ = event_ids;
			_tmp99__length1 = event_ids_length1;
			_tmp100_ = _tmp98_[_tmp99__length1 - 1];
			_tmp96_ = _tmp100_ != event_id;
		}
		if (_tmp96_) {
			guint32* _tmp101_;
			gint _tmp101__length1;
			_vala_array_add1 (&event_ids, &event_ids_length1, &_event_ids_size_, event_id);
			_tmp101_ = event_ids;
			_tmp101__length1 = event_ids_length1;
			if (((guint) _tmp101__length1) == max_events) {
				break;
			}
		}
	}
	if (rc != SQLITE_DONE) {
		_tmp102_ = rc != SQLITE_ROW;
	} else {
		_tmp102_ = FALSE;
	}
	if (_tmp102_) {
		gchar* error_message = NULL;
		sqlite3* _tmp103_;
		const gchar* _tmp104_;
		gchar* _tmp105_;
		const gchar* _tmp106_;
		ZeitgeistSQLiteDatabase* _tmp107_;
		const gchar* _tmp108_;
		GError* _tmp109_;
		_tmp103_ = self->db;
		_tmp104_ = sqlite3_errmsg (_tmp103_);
		_tmp105_ = g_strdup_printf ("Error in find_event_ids: %d, %s", rc, _tmp104_);
		error_message = _tmp105_;
		_tmp106_ = error_message;
		g_warning ("db-reader.vala:333: %s", _tmp106_);
		_tmp107_ = self->priv->_database;
		zeitgeist_sq_lite_database_assert_not_corrupt (_tmp107_, rc, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (error_message);
				event_ids = (g_free (event_ids), NULL);
				_g_ptr_array_unref0 (arguments);
				_sqlite3_finalize0 (stmt);
				_g_free0 (where_sql);
				_g_free0 (sql);
				return NULL;
			} else {
				_g_free0 (error_message);
				event_ids = (g_free (event_ids), NULL);
				_g_ptr_array_unref0 (arguments);
				_sqlite3_finalize0 (stmt);
				_g_free0 (where_sql);
				_g_free0 (sql);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp108_ = error_message;
		_tmp109_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_ERROR, _tmp108_);
		_inner_error0_ = _tmp109_;
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (error_message);
			event_ids = (g_free (event_ids), NULL);
			_g_ptr_array_unref0 (arguments);
			_sqlite3_finalize0 (stmt);
			_g_free0 (where_sql);
			_g_free0 (sql);
			return NULL;
		} else {
			_g_free0 (error_message);
			event_ids = (g_free (event_ids), NULL);
			_g_ptr_array_unref0 (arguments);
			_sqlite3_finalize0 (stmt);
			_g_free0 (where_sql);
			_g_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_g_free0 (error_message);
	}
	_tmp110_ = event_ids;
	_tmp110__length1 = event_ids_length1;
	if (result_length1) {
		*result_length1 = _tmp110__length1;
	}
	result = _tmp110_;
	_g_ptr_array_unref0 (arguments);
	_sqlite3_finalize0 (stmt);
	_g_free0 (where_sql);
	_g_free0 (sql);
	return result;
}

guint32*
zeitgeist_db_reader_find_event_ids (ZeitgeistDbReader* self,
                                    ZeitgeistTimeRange* time_range,
                                    GPtrArray* event_templates,
                                    guint storage_state,
                                    guint max_events,
                                    guint result_type,
                                    const char* sender,
                                    gint* result_length1,
                                    GError** error)
{
	ZeitgeistWhereClause* where = NULL;
	ZeitgeistWhereClause* _tmp0_;
	guint32* _tmp1_ = NULL;
	ZeitgeistWhereClause* _tmp2_;
	gint _tmp3_ = 0;
	guint32* _tmp4_;
	gint _tmp1__length1;
	gint __tmp1__size_;
	guint32* _tmp5_;
	gint _tmp5__length1;
	guint32* _tmp6_;
	gint _tmp6__length1;
	GError* _inner_error0_ = NULL;
	guint32* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (time_range != NULL, NULL);
	g_return_val_if_fail (event_templates != NULL, NULL);
	_tmp0_ = zeitgeist_db_reader_get_where_clause_for_query (self, time_range, event_templates, storage_state, &_inner_error0_);
	where = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = where;
	_tmp4_ = zeitgeist_db_reader_find_event_ids_for_clause (self, _tmp2_, max_events, result_type, &_tmp3_, &_inner_error0_);
	_tmp1_ = _tmp4_;
	_tmp1__length1 = _tmp3_;
	__tmp1__size_ = _tmp1__length1;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (where);
			return NULL;
		} else {
			_g_object_unref0 (where);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp5_ = _tmp1_;
	_tmp5__length1 = _tmp1__length1;
	_tmp1_ = NULL;
	_tmp1__length1 = 0;
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _tmp5__length1;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	_g_object_unref0 (where);
	return result;
}

GPtrArray*
zeitgeist_db_reader_find_events (ZeitgeistDbReader* self,
                                 ZeitgeistTimeRange* time_range,
                                 GPtrArray* event_templates,
                                 guint storage_state,
                                 guint max_events,
                                 guint result_type,
                                 const char* sender,
                                 GError** error)
{
	guint32* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	guint32* _tmp2_;
	gint _tmp0__length1;
	gint __tmp0__size_;
	GPtrArray* _tmp3_ = NULL;
	GPtrArray* _tmp4_;
	GPtrArray* _tmp5_;
	GError* _inner_error0_ = NULL;
	GPtrArray* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (time_range != NULL, NULL);
	g_return_val_if_fail (event_templates != NULL, NULL);
	_tmp2_ = zeitgeist_db_reader_find_event_ids (self, time_range, event_templates, storage_state, max_events, result_type, NULL, &_tmp1_, &_inner_error0_);
	_tmp0_ = _tmp2_;
	_tmp0__length1 = _tmp1_;
	__tmp0__size_ = _tmp0__length1;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp4_ = zeitgeist_db_reader_get_events (self, _tmp0_, (gint) _tmp0__length1, NULL, &_inner_error0_);
	_tmp3_ = _tmp4_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_tmp0_ = (g_free (_tmp0_), NULL);
			return NULL;
		} else {
			_tmp0_ = (g_free (_tmp0_), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp5_ = _tmp3_;
	_tmp3_ = NULL;
	result = _tmp5_;
	_g_ptr_array_unref0 (_tmp3_);
	_tmp0_ = (g_free (_tmp0_), NULL);
	return result;
}

ZeitgeistWhereClause*
zeitgeist_db_reader_get_where_clause_for_query (ZeitgeistDbReader* self,
                                                ZeitgeistTimeRange* time_range,
                                                GPtrArray* event_templates,
                                                guint storage_state,
                                                GError** error)
{
	ZeitgeistWhereClause* where = NULL;
	ZeitgeistWhereClause* _tmp0_;
	gint64 _tmp1_;
	gint64 _tmp2_;
	gint64 _tmp8_;
	gint64 _tmp9_;
	gboolean _tmp15_ = FALSE;
	ZeitgeistWhereClause* tpl_conditions = NULL;
	ZeitgeistWhereClause* _tmp24_;
	ZeitgeistWhereClause* _tmp25_;
	ZeitgeistWhereClause* _tmp26_;
	GError* _inner_error0_ = NULL;
	ZeitgeistWhereClause* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (time_range != NULL, NULL);
	g_return_val_if_fail (event_templates != NULL, NULL);
	_tmp0_ = zeitgeist_where_clause_new (ZEITGEIST_WHERE_CLAUSE_TYPE_AND, FALSE);
	where = _tmp0_;
	_tmp1_ = zeitgeist_time_range_get_start (time_range);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != ((gint64) 0)) {
		ZeitgeistWhereClause* _tmp3_;
		gint64 _tmp4_;
		gint64 _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp3_ = where;
		_tmp4_ = zeitgeist_time_range_get_start (time_range);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strdup_printf ("timestamp >= %" G_GINT64_FORMAT, _tmp5_);
		_tmp7_ = _tmp6_;
		zeitgeist_where_clause_add (_tmp3_, _tmp7_, NULL);
		_g_free0 (_tmp7_);
	}
	_tmp8_ = zeitgeist_time_range_get_end (time_range);
	_tmp9_ = _tmp8_;
	if (_tmp9_ != ((gint64) 0)) {
		ZeitgeistWhereClause* _tmp10_;
		gint64 _tmp11_;
		gint64 _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp10_ = where;
		_tmp11_ = zeitgeist_time_range_get_end (time_range);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strdup_printf ("timestamp <= %" G_GINT64_FORMAT, _tmp12_);
		_tmp14_ = _tmp13_;
		zeitgeist_where_clause_add (_tmp10_, _tmp14_, NULL);
		_g_free0 (_tmp14_);
	}
	if (storage_state == ((guint) ZEITGEIST_STORAGE_STATE_AVAILABLE)) {
		_tmp15_ = TRUE;
	} else {
		_tmp15_ = storage_state == ((guint) ZEITGEIST_STORAGE_STATE_NOT_AVAILABLE);
	}
	if (_tmp15_) {
		ZeitgeistWhereClause* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		ZeitgeistWhereClause* _tmp19_;
		_tmp16_ = where;
		_tmp17_ = g_strdup_printf ("%u", storage_state);
		_tmp18_ = _tmp17_;
		zeitgeist_where_clause_add (_tmp16_, "(subj_storage_state=? OR subj_storage_state IS NULL)", _tmp18_);
		_g_free0 (_tmp18_);
		_tmp19_ = where;
		zeitgeist_where_clause_set_is_simple (_tmp19_, FALSE);
	} else {
		if (storage_state != ((guint) ZEITGEIST_STORAGE_STATE_ANY)) {
			gchar* _tmp20_;
			gchar* _tmp21_;
			GError* _tmp22_;
			GError* _tmp23_;
			_tmp20_ = g_strdup_printf ("Unknown storage state '%u'", storage_state);
			_tmp21_ = _tmp20_;
			_tmp22_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_INVALID_ARGUMENT, _tmp21_);
			_tmp23_ = _tmp22_;
			_g_free0 (_tmp21_);
			_inner_error0_ = _tmp23_;
			if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (where);
				return NULL;
			} else {
				_g_object_unref0 (where);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	}
	_tmp24_ = zeitgeist_db_reader_get_where_clause_from_event_templates (self, event_templates, &_inner_error0_);
	tpl_conditions = _tmp24_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (where);
			return NULL;
		} else {
			_g_object_unref0 (where);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp25_ = where;
	_tmp26_ = tpl_conditions;
	zeitgeist_where_clause_extend (_tmp25_, _tmp26_);
	result = where;
	_g_object_unref0 (tpl_conditions);
	return result;
}

static void
_zeitgeist_db_reader_related_uri_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (zeitgeist_db_reader_related_uri_free (var), NULL));
}

static gpointer
_zeitgeist_db_reader_related_uri_dup0 (gpointer self)
{
	return self ? zeitgeist_db_reader_related_uri_dup (self) : NULL;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static gboolean
_vala_uint32_array_contains (guint32 * stack,
                             gssize stack_length,
                             const guint32 needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (needle == stack[i]) {
			return TRUE;
		}
	}
	return FALSE;
}

static gint
___lambda8_ (ZeitgeistDbReaderRelatedUri* a,
             ZeitgeistDbReaderRelatedUri* b)
{
	gint result;
	result = (gint) ((*a).counter - (*b).counter);
	return result;
}

static gint
____lambda8__gcompare_func (gconstpointer a,
                            gconstpointer b)
{
	gint result;
	result = ___lambda8_ ((ZeitgeistDbReaderRelatedUri*) a, (ZeitgeistDbReaderRelatedUri*) b);
	return result;
}

static gint
___lambda9_ (ZeitgeistDbReaderRelatedUri* a,
             ZeitgeistDbReaderRelatedUri* b)
{
	gint64 delta = 0LL;
	gint result;
	delta = (*a).timestamp - (*b).timestamp;
	if (delta < ((gint64) 0)) {
		result = 1;
		return result;
	} else {
		if (delta > ((gint64) 0)) {
			result = -1;
			return result;
		} else {
			result = 0;
			return result;
		}
	}
}

static gint
____lambda9__gcompare_func (gconstpointer a,
                            gconstpointer b)
{
	gint result;
	result = ___lambda9_ ((ZeitgeistDbReaderRelatedUri*) a, (ZeitgeistDbReaderRelatedUri*) b);
	return result;
}

static gint
____lambda10_ (ZeitgeistDbReaderRelatedUri* a,
               ZeitgeistDbReaderRelatedUri* b)
{
	gint64 delta = 0LL;
	gint result;
	delta = (*a).timestamp - (*b).timestamp;
	if (delta < ((gint64) 0)) {
		result = 1;
		return result;
	} else {
		if (delta > ((gint64) 0)) {
			result = -1;
			return result;
		} else {
			result = 0;
			return result;
		}
	}
}

static gint
_____lambda10__gcompare_func (gconstpointer a,
                              gconstpointer b)
{
	gint result;
	result = ____lambda10_ ((ZeitgeistDbReaderRelatedUri*) a, (ZeitgeistDbReaderRelatedUri*) b);
	return result;
}

static inline void
_g_list_free__zeitgeist_db_reader_related_uri_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _zeitgeist_db_reader_related_uri_free0_);
}

gchar**
zeitgeist_db_reader_find_related_uris (ZeitgeistDbReader* self,
                                       ZeitgeistTimeRange* time_range,
                                       GPtrArray* event_templates,
                                       GPtrArray* result_event_templates,
                                       guint storage_state,
                                       guint max_results,
                                       guint result_type,
                                       const char* sender,
                                       gint* result_length1,
                                       GError** error)
{
	gboolean _tmp0_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (time_range != NULL, NULL);
	g_return_val_if_fail (event_templates != NULL, NULL);
	g_return_val_if_fail (result_event_templates != NULL, NULL);
	if (result_type == ((guint) ZEITGEIST_RELEVANT_RESULT_TYPE_RECENT)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = result_type == ((guint) ZEITGEIST_RELEVANT_RESULT_TYPE_RELATED);
	}
	if (_tmp0_) {
		guint32* ids = NULL;
		gint _tmp1_ = 0;
		guint32* _tmp2_;
		gint ids_length1;
		gint _ids_size_;
		gboolean _tmp3_ = FALSE;
		gint _tmp4_;
		gint _tmp5_;
		guint32* result_ids = NULL;
		gint result_ids_length1 = 0;
		gint _result_ids_size_ = 0;
		guint32* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		guint32* _tmp10_;
		gint _tmp8__length1;
		gint __tmp8__size_;
		guint32* _tmp11_;
		gint _tmp11__length1;
		guint32* pot = NULL;
		guint32* _tmp12_;
		gint _tmp12__length1;
		guint32* _tmp13_;
		gint _tmp13__length1;
		guint32* _tmp14_;
		gint pot_length1;
		gint _pot_size_;
		sqlite3_stmt* stmt = NULL;
		gchar* sql_event_ids = NULL;
		ZeitgeistSQLiteDatabase* _tmp29_;
		guint32* _tmp30_;
		gint _tmp30__length1;
		gchar* _tmp31_;
		gchar* sql = NULL;
		const gchar* _tmp32_;
		gchar* _tmp33_;
		gint rc = 0;
		sqlite3* _tmp34_;
		const gchar* _tmp35_;
		sqlite3_stmt* _tmp36_ = NULL;
		gint _tmp37_;
		ZeitgeistSQLiteDatabase* _tmp38_;
		GPtrArray* temp_related_uris = NULL;
		GPtrArray* _tmp39_;
		ZeitgeistSQLiteDatabase* _tmp52_;
		GHashTable* uri_counter = NULL;
		GHashFunc _tmp53_;
		GEqualFunc _tmp54_;
		GHashTable* _tmp55_;
		GList* temp_ruris = NULL;
		GList* values = NULL;
		GHashTable* _tmp123_;
		GList* _tmp124_;
		GList* _tmp127_;
		gchar** results = NULL;
		GList* _tmp134_;
		gchar** _tmp135_;
		gint results_length1;
		gint _results_size_;
		gint i = 0;
		GList* _tmp136_;
		gchar** _tmp143_;
		gint _tmp143__length1;
		_tmp2_ = zeitgeist_db_reader_find_event_ids (self, time_range, event_templates, storage_state, (guint) 0, (guint) ZEITGEIST_RESULT_TYPE_LEAST_RECENT_EVENTS, NULL, &_tmp1_, &_inner_error0_);
		ids = _tmp2_;
		ids_length1 = _tmp1_;
		_ids_size_ = ids_length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp4_ = vala_g_ptr_array_get_length (event_templates);
		_tmp5_ = _tmp4_;
		if (_tmp5_ > 0) {
			guint32* _tmp6_;
			gint _tmp6__length1;
			_tmp6_ = ids;
			_tmp6__length1 = ids_length1;
			_tmp3_ = _tmp6__length1 == 0;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			GError* _tmp7_;
			_tmp7_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_INVALID_ARGUMENT, "No results found for the event_templates");
			_inner_error0_ = _tmp7_;
			if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				ids = (g_free (ids), NULL);
				return NULL;
			} else {
				ids = (g_free (ids), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp10_ = zeitgeist_db_reader_find_event_ids (self, time_range, result_event_templates, storage_state, (guint) 0, (guint) ZEITGEIST_RESULT_TYPE_LEAST_RECENT_EVENTS, NULL, &_tmp9_, &_inner_error0_);
		_tmp8_ = _tmp10_;
		_tmp8__length1 = _tmp9_;
		__tmp8__size_ = _tmp8__length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				result_ids = (g_free (result_ids), NULL);
				ids = (g_free (ids), NULL);
				return NULL;
			} else {
				result_ids = (g_free (result_ids), NULL);
				ids = (g_free (ids), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp11_ = _tmp8_;
		_tmp11__length1 = _tmp8__length1;
		_tmp8_ = NULL;
		_tmp8__length1 = 0;
		result_ids = (g_free (result_ids), NULL);
		result_ids = _tmp11_;
		result_ids_length1 = _tmp11__length1;
		_result_ids_size_ = result_ids_length1;
		_tmp12_ = ids;
		_tmp12__length1 = ids_length1;
		_tmp13_ = result_ids;
		_tmp13__length1 = result_ids_length1;
		_tmp14_ = g_new0 (guint32, _tmp12__length1 + _tmp13__length1);
		pot = _tmp14_;
		pot_length1 = _tmp12__length1 + _tmp13__length1;
		_pot_size_ = pot_length1;
		{
			guint32 i = 0U;
			i = (guint32) 0;
			{
				gboolean _tmp15_ = FALSE;
				_tmp15_ = TRUE;
				while (TRUE) {
					guint32* _tmp17_;
					gint _tmp17__length1;
					guint32* _tmp18_;
					gint _tmp18__length1;
					guint32* _tmp19_;
					gint _tmp19__length1;
					guint32 _tmp20_;
					if (!_tmp15_) {
						guint32 _tmp16_;
						_tmp16_ = i;
						i = _tmp16_ + 1;
					}
					_tmp15_ = FALSE;
					_tmp17_ = ids;
					_tmp17__length1 = ids_length1;
					if (!(i < ((guint32) _tmp17__length1))) {
						break;
					}
					_tmp18_ = pot;
					_tmp18__length1 = pot_length1;
					_tmp19_ = ids;
					_tmp19__length1 = ids_length1;
					_tmp20_ = _tmp19_[i];
					_tmp18_[i] = _tmp20_;
				}
			}
		}
		{
			guint32 i = 0U;
			i = (guint32) 0;
			{
				gboolean _tmp21_ = FALSE;
				_tmp21_ = TRUE;
				while (TRUE) {
					guint32* _tmp23_;
					gint _tmp23__length1;
					guint32* _tmp24_;
					gint _tmp24__length1;
					guint32* _tmp25_;
					gint _tmp25__length1;
					guint32* _tmp26_;
					gint _tmp26__length1;
					guint32* _tmp27_;
					gint _tmp27__length1;
					guint32 _tmp28_;
					if (!_tmp21_) {
						guint32 _tmp22_;
						_tmp22_ = i;
						i = _tmp22_ + 1;
					}
					_tmp21_ = FALSE;
					_tmp23_ = result_ids;
					_tmp23__length1 = result_ids_length1;
					if (!(i < ((guint32) _tmp23__length1))) {
						break;
					}
					_tmp24_ = pot;
					_tmp24__length1 = pot_length1;
					_tmp25_ = ids;
					_tmp25__length1 = ids_length1;
					_tmp26_ = result_ids;
					_tmp26__length1 = result_ids_length1;
					_tmp27_ = ids;
					_tmp27__length1 = ids_length1;
					_tmp28_ = _tmp26_[_tmp27__length1 + i];
					_tmp24_[_tmp25__length1 + i] = _tmp28_;
				}
			}
		}
		_tmp29_ = self->priv->_database;
		_tmp30_ = pot;
		_tmp30__length1 = pot_length1;
		_tmp31_ = zeitgeist_sq_lite_database_get_sql_string_from_event_ids (_tmp29_, _tmp30_, (gint) _tmp30__length1);
		sql_event_ids = _tmp31_;
		_tmp32_ = sql_event_ids;
		_tmp33_ = g_strdup_printf ("\n" \
"               SELECT id, timestamp, subj_uri FROM event_view \n" \
"               WHERE id IN (%s) ORDER BY timestamp ASC\n" \
"               ", _tmp32_);
		sql = _tmp33_;
		_tmp34_ = self->db;
		_tmp35_ = sql;
		_tmp37_ = sqlite3_prepare_v2 (_tmp34_, _tmp35_, -1, &_tmp36_, NULL);
		_sqlite3_finalize0 (stmt);
		stmt = _tmp36_;
		rc = _tmp37_;
		_tmp38_ = self->priv->_database;
		zeitgeist_sq_lite_database_assert_query_success (_tmp38_, rc, "db-reader.vala:459: SQL error", SQLITE_OK, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (sql);
				_g_free0 (sql_event_ids);
				_sqlite3_finalize0 (stmt);
				pot = (g_free (pot), NULL);
				_tmp8_ = (g_free (_tmp8_), NULL);
				result_ids = (g_free (result_ids), NULL);
				ids = (g_free (ids), NULL);
				return NULL;
			} else {
				_g_free0 (sql);
				_g_free0 (sql_event_ids);
				_sqlite3_finalize0 (stmt);
				pot = (g_free (pot), NULL);
				_tmp8_ = (g_free (_tmp8_), NULL);
				result_ids = (g_free (result_ids), NULL);
				ids = (g_free (ids), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp39_ = g_ptr_array_new_full ((guint) 0, _zeitgeist_db_reader_related_uri_free0_);
		temp_related_uris = _tmp39_;
		while (TRUE) {
			sqlite3_stmt* _tmp40_;
			ZeitgeistDbReaderRelatedUri ruri = {0};
			sqlite3_stmt* _tmp41_;
			const gchar* _tmp42_;
			sqlite3_stmt* _tmp43_;
			sqlite3_stmt* _tmp44_;
			const gchar* _tmp45_;
			gchar* _tmp46_;
			ZeitgeistDbReaderRelatedUri _tmp47_ = {0};
			GPtrArray* _tmp48_;
			ZeitgeistDbReaderRelatedUri _tmp49_;
			ZeitgeistDbReaderRelatedUri _tmp50_;
			ZeitgeistDbReaderRelatedUri* _tmp51_;
			_tmp40_ = stmt;
			rc = sqlite3_step (_tmp40_);
			if (!(rc == SQLITE_ROW)) {
				break;
			}
			_tmp41_ = stmt;
			_tmp42_ = (const gchar*) sqlite3_column_text (_tmp41_, 0);
			_tmp43_ = stmt;
			_tmp44_ = stmt;
			_tmp45_ = (const gchar*) sqlite3_column_text (_tmp44_, 2);
			_tmp46_ = g_strdup (_tmp45_);
			memset (&_tmp47_, 0, sizeof (ZeitgeistDbReaderRelatedUri));
			_tmp47_.id = (guint32) uint64_parse (_tmp42_, (guint) 0);
			_tmp47_.timestamp = sqlite3_column_int64 (_tmp43_, 1);
			_g_free0 (_tmp47_.uri);
			_tmp47_.uri = _tmp46_;
			_tmp47_.counter = (gint32) 0;
			ruri = _tmp47_;
			_tmp48_ = temp_related_uris;
			_tmp49_ = ruri;
			_tmp50_ = _tmp49_;
			_tmp51_ = _zeitgeist_db_reader_related_uri_dup0 (&_tmp50_);
			g_ptr_array_add (_tmp48_, _tmp51_);
			zeitgeist_db_reader_related_uri_destroy (&ruri);
		}
		_tmp52_ = self->priv->_database;
		zeitgeist_sq_lite_database_assert_query_success (_tmp52_, rc, "Error in find_related_uris", SQLITE_DONE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_ptr_array_unref0 (temp_related_uris);
				_g_free0 (sql);
				_g_free0 (sql_event_ids);
				_sqlite3_finalize0 (stmt);
				pot = (g_free (pot), NULL);
				_tmp8_ = (g_free (_tmp8_), NULL);
				result_ids = (g_free (result_ids), NULL);
				ids = (g_free (ids), NULL);
				return NULL;
			} else {
				_g_ptr_array_unref0 (temp_related_uris);
				_g_free0 (sql);
				_g_free0 (sql_event_ids);
				_sqlite3_finalize0 (stmt);
				pot = (g_free (pot), NULL);
				_tmp8_ = (g_free (_tmp8_), NULL);
				result_ids = (g_free (result_ids), NULL);
				ids = (g_free (ids), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp53_ = g_str_hash;
		_tmp54_ = g_str_equal;
		_tmp55_ = g_hash_table_new_full (_tmp53_, _tmp54_, _g_free0_, _zeitgeist_db_reader_related_uri_free0_);
		uri_counter = _tmp55_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp56_ = FALSE;
				_tmp56_ = TRUE;
				while (TRUE) {
					GPtrArray* _tmp58_;
					gint _tmp59_;
					gint _tmp60_;
					GPtrArray* window = NULL;
					GPtrArray* _tmp61_;
					gboolean count_in_window = FALSE;
					if (!_tmp56_) {
						gint _tmp57_;
						_tmp57_ = i;
						i = _tmp57_ + 1;
					}
					_tmp56_ = FALSE;
					_tmp58_ = temp_related_uris;
					_tmp59_ = vala_g_ptr_array_get_length (_tmp58_);
					_tmp60_ = _tmp59_;
					if (!(i < _tmp60_)) {
						break;
					}
					_tmp61_ = g_ptr_array_new_full ((guint) 0, NULL);
					window = _tmp61_;
					count_in_window = FALSE;
					{
						gint j = 0;
						j = MAX (0, i - 5);
						{
							gboolean _tmp62_ = FALSE;
							_tmp62_ = TRUE;
							while (TRUE) {
								GPtrArray* _tmp64_;
								gint _tmp65_;
								gint _tmp66_;
								GPtrArray* _tmp67_;
								GPtrArray* _tmp68_;
								gconstpointer _tmp69_;
								GPtrArray* _tmp70_;
								gconstpointer _tmp71_;
								guint32* _tmp72_;
								gint _tmp72__length1;
								if (!_tmp62_) {
									gint _tmp63_;
									_tmp63_ = j;
									j = _tmp63_ + 1;
								}
								_tmp62_ = FALSE;
								_tmp64_ = temp_related_uris;
								_tmp65_ = vala_g_ptr_array_get_length (_tmp64_);
								_tmp66_ = _tmp65_;
								if (!(j < MIN (i, _tmp66_))) {
									break;
								}
								_tmp67_ = window;
								_tmp68_ = temp_related_uris;
								_tmp69_ = g_ptr_array_index (_tmp68_, (guint) j);
								g_ptr_array_add (_tmp67_, (ZeitgeistDbReaderRelatedUri*) _tmp69_);
								_tmp70_ = temp_related_uris;
								_tmp71_ = g_ptr_array_index (_tmp70_, (guint) j);
								_tmp72_ = ids;
								_tmp72__length1 = ids_length1;
								if (_vala_uint32_array_contains (_tmp72_, _tmp72__length1, (*((ZeitgeistDbReaderRelatedUri*) _tmp71_)).id)) {
									count_in_window = TRUE;
									break;
								}
							}
						}
					}
					if (count_in_window) {
						{
							gint j = 0;
							j = 0;
							{
								gboolean _tmp73_ = FALSE;
								_tmp73_ = TRUE;
								while (TRUE) {
									GPtrArray* _tmp75_;
									gint _tmp76_;
									gint _tmp77_;
									GPtrArray* _tmp78_;
									gconstpointer _tmp79_;
									guint32* _tmp80_;
									gint _tmp80__length1;
									if (!_tmp73_) {
										gint _tmp74_;
										_tmp74_ = j;
										j = _tmp74_ + 1;
									}
									_tmp73_ = FALSE;
									_tmp75_ = window;
									_tmp76_ = vala_g_ptr_array_get_length (_tmp75_);
									_tmp77_ = _tmp76_;
									if (!(j < _tmp77_)) {
										break;
									}
									_tmp78_ = window;
									_tmp79_ = g_ptr_array_index (_tmp78_, (guint) j);
									_tmp80_ = result_ids;
									_tmp80__length1 = result_ids_length1;
									if (_vala_uint32_array_contains (_tmp80_, _tmp80__length1, (*((ZeitgeistDbReaderRelatedUri*) _tmp79_)).id)) {
										GHashTable* _tmp81_;
										GPtrArray* _tmp82_;
										gconstpointer _tmp83_;
										const gchar* _tmp84_;
										gconstpointer _tmp85_;
										GHashTable* _tmp103_;
										GPtrArray* _tmp104_;
										gconstpointer _tmp105_;
										const gchar* _tmp106_;
										gconstpointer _tmp107_;
										gint32 _tmp108_;
										GHashTable* _tmp109_;
										GPtrArray* _tmp110_;
										gconstpointer _tmp111_;
										const gchar* _tmp112_;
										gconstpointer _tmp113_;
										GPtrArray* _tmp114_;
										gconstpointer _tmp115_;
										_tmp81_ = uri_counter;
										_tmp82_ = window;
										_tmp83_ = g_ptr_array_index (_tmp82_, (guint) j);
										_tmp84_ = (*((ZeitgeistDbReaderRelatedUri*) _tmp83_)).uri;
										_tmp85_ = g_hash_table_lookup (_tmp81_, _tmp84_);
										if (((ZeitgeistDbReaderRelatedUri*) _tmp85_) == NULL) {
											ZeitgeistDbReaderRelatedUri ruri = {0};
											GPtrArray* _tmp86_;
											gconstpointer _tmp87_;
											GPtrArray* _tmp88_;
											gconstpointer _tmp89_;
											GPtrArray* _tmp90_;
											gconstpointer _tmp91_;
											const gchar* _tmp92_;
											gchar* _tmp93_;
											ZeitgeistDbReaderRelatedUri _tmp94_ = {0};
											GHashTable* _tmp95_;
											GPtrArray* _tmp96_;
											gconstpointer _tmp97_;
											const gchar* _tmp98_;
											gchar* _tmp99_;
											ZeitgeistDbReaderRelatedUri _tmp100_;
											ZeitgeistDbReaderRelatedUri _tmp101_;
											ZeitgeistDbReaderRelatedUri* _tmp102_;
											_tmp86_ = window;
											_tmp87_ = g_ptr_array_index (_tmp86_, (guint) j);
											_tmp88_ = window;
											_tmp89_ = g_ptr_array_index (_tmp88_, (guint) j);
											_tmp90_ = window;
											_tmp91_ = g_ptr_array_index (_tmp90_, (guint) j);
											_tmp92_ = (*((ZeitgeistDbReaderRelatedUri*) _tmp91_)).uri;
											_tmp93_ = g_strdup (_tmp92_);
											memset (&_tmp94_, 0, sizeof (ZeitgeistDbReaderRelatedUri));
											_tmp94_.id = (*((ZeitgeistDbReaderRelatedUri*) _tmp87_)).id;
											_tmp94_.timestamp = (*((ZeitgeistDbReaderRelatedUri*) _tmp89_)).timestamp;
											_g_free0 (_tmp94_.uri);
											_tmp94_.uri = _tmp93_;
											_tmp94_.counter = (gint32) 0;
											ruri = _tmp94_;
											_tmp95_ = uri_counter;
											_tmp96_ = window;
											_tmp97_ = g_ptr_array_index (_tmp96_, (guint) j);
											_tmp98_ = (*((ZeitgeistDbReaderRelatedUri*) _tmp97_)).uri;
											_tmp99_ = g_strdup (_tmp98_);
											_tmp100_ = ruri;
											_tmp101_ = _tmp100_;
											_tmp102_ = _zeitgeist_db_reader_related_uri_dup0 (&_tmp101_);
											g_hash_table_insert (_tmp95_, _tmp99_, _tmp102_);
											zeitgeist_db_reader_related_uri_destroy (&ruri);
										}
										_tmp103_ = uri_counter;
										_tmp104_ = window;
										_tmp105_ = g_ptr_array_index (_tmp104_, (guint) j);
										_tmp106_ = (*((ZeitgeistDbReaderRelatedUri*) _tmp105_)).uri;
										_tmp107_ = g_hash_table_lookup (_tmp103_, _tmp106_);
										_tmp108_ = (*((ZeitgeistDbReaderRelatedUri*) _tmp107_)).counter;
										(*((ZeitgeistDbReaderRelatedUri*) _tmp107_)).counter = _tmp108_ + 1;
										_tmp109_ = uri_counter;
										_tmp110_ = window;
										_tmp111_ = g_ptr_array_index (_tmp110_, (guint) j);
										_tmp112_ = (*((ZeitgeistDbReaderRelatedUri*) _tmp111_)).uri;
										_tmp113_ = g_hash_table_lookup (_tmp109_, _tmp112_);
										_tmp114_ = window;
										_tmp115_ = g_ptr_array_index (_tmp114_, (guint) j);
										if ((*((ZeitgeistDbReaderRelatedUri*) _tmp113_)).timestamp < (*((ZeitgeistDbReaderRelatedUri*) _tmp115_)).timestamp) {
											GHashTable* _tmp116_;
											GPtrArray* _tmp117_;
											gconstpointer _tmp118_;
											const gchar* _tmp119_;
											gconstpointer _tmp120_;
											GPtrArray* _tmp121_;
											gconstpointer _tmp122_;
											_tmp116_ = uri_counter;
											_tmp117_ = window;
											_tmp118_ = g_ptr_array_index (_tmp117_, (guint) j);
											_tmp119_ = (*((ZeitgeistDbReaderRelatedUri*) _tmp118_)).uri;
											_tmp120_ = g_hash_table_lookup (_tmp116_, _tmp119_);
											_tmp121_ = window;
											_tmp122_ = g_ptr_array_index (_tmp121_, (guint) j);
											(*((ZeitgeistDbReaderRelatedUri*) _tmp120_)).timestamp = (*((ZeitgeistDbReaderRelatedUri*) _tmp122_)).timestamp;
										}
									}
								}
							}
						}
					}
					_g_ptr_array_unref0 (window);
				}
			}
		}
		temp_ruris = NULL;
		values = NULL;
		_tmp123_ = uri_counter;
		_tmp124_ = g_hash_table_get_values (_tmp123_);
		{
			GList* uri_collection = NULL;
			GList* uri_it = NULL;
			uri_collection = _tmp124_;
			for (uri_it = uri_collection; uri_it != NULL; uri_it = uri_it->next) {
				ZeitgeistDbReaderRelatedUri* uri = NULL;
				uri = (ZeitgeistDbReaderRelatedUri*) uri_it->data;
				{
					ZeitgeistDbReaderRelatedUri* _tmp125_;
					ZeitgeistDbReaderRelatedUri* _tmp126_;
					_tmp125_ = uri;
					_tmp126_ = _zeitgeist_db_reader_related_uri_dup0 (_tmp125_);
					values = g_list_append (values, _tmp126_);
				}
			}
			(uri_collection == NULL) ? NULL : (uri_collection = (g_list_free (uri_collection), NULL));
		}
		values = g_list_sort (values, ____lambda8__gcompare_func);
		values = g_list_sort (values, ____lambda9__gcompare_func);
		_tmp127_ = values;
		{
			GList* ruri_collection = NULL;
			GList* ruri_it = NULL;
			ruri_collection = _tmp127_;
			for (ruri_it = ruri_collection; ruri_it != NULL; ruri_it = ruri_it->next) {
				ZeitgeistDbReaderRelatedUri _tmp128_;
				ZeitgeistDbReaderRelatedUri _tmp129_ = {0};
				ZeitgeistDbReaderRelatedUri ruri = {0};
				_tmp128_ = *((ZeitgeistDbReaderRelatedUri*) ruri_it->data);
				zeitgeist_db_reader_related_uri_copy (&_tmp128_, &_tmp129_);
				ruri = _tmp129_;
				{
					GList* _tmp130_;
					_tmp130_ = temp_ruris;
					if (g_list_length (_tmp130_) < max_results) {
						ZeitgeistDbReaderRelatedUri _tmp131_;
						ZeitgeistDbReaderRelatedUri _tmp132_;
						ZeitgeistDbReaderRelatedUri* _tmp133_;
						_tmp131_ = ruri;
						_tmp132_ = _tmp131_;
						_tmp133_ = _zeitgeist_db_reader_related_uri_dup0 (&_tmp132_);
						temp_ruris = g_list_append (temp_ruris, _tmp133_);
					} else {
						zeitgeist_db_reader_related_uri_destroy (&ruri);
						break;
					}
					zeitgeist_db_reader_related_uri_destroy (&ruri);
				}
			}
		}
		if (result_type == ((guint) ZEITGEIST_RELEVANT_RESULT_TYPE_RECENT)) {
			temp_ruris = g_list_sort (temp_ruris, _____lambda10__gcompare_func);
		}
		_tmp134_ = temp_ruris;
		_tmp135_ = g_new0 (gchar*, g_list_length (_tmp134_) + 1);
		results = _tmp135_;
		results_length1 = g_list_length (_tmp134_);
		_results_size_ = results_length1;
		i = 0;
		_tmp136_ = temp_ruris;
		{
			GList* uri_collection = NULL;
			GList* uri_it = NULL;
			uri_collection = _tmp136_;
			for (uri_it = uri_collection; uri_it != NULL; uri_it = uri_it->next) {
				ZeitgeistDbReaderRelatedUri* _tmp137_;
				ZeitgeistDbReaderRelatedUri* uri = NULL;
				_tmp137_ = _zeitgeist_db_reader_related_uri_dup0 ((ZeitgeistDbReaderRelatedUri*) uri_it->data);
				uri = _tmp137_;
				{
					gchar** _tmp138_;
					gint _tmp138__length1;
					ZeitgeistDbReaderRelatedUri* _tmp139_;
					const gchar* _tmp140_;
					gchar* _tmp141_;
					gint _tmp142_;
					_tmp138_ = results;
					_tmp138__length1 = results_length1;
					_tmp139_ = uri;
					_tmp140_ = (*_tmp139_).uri;
					_tmp141_ = g_strdup (_tmp140_);
					_g_free0 (_tmp138_[i]);
					_tmp138_[i] = _tmp141_;
					_tmp142_ = i;
					i = _tmp142_ + 1;
					_zeitgeist_db_reader_related_uri_free0 (uri);
				}
			}
		}
		_tmp143_ = results;
		_tmp143__length1 = results_length1;
		if (result_length1) {
			*result_length1 = _tmp143__length1;
		}
		result = _tmp143_;
		(values == NULL) ? NULL : (values = (_g_list_free__zeitgeist_db_reader_related_uri_free0_ (values), NULL));
		(temp_ruris == NULL) ? NULL : (temp_ruris = (_g_list_free__zeitgeist_db_reader_related_uri_free0_ (temp_ruris), NULL));
		_g_hash_table_unref0 (uri_counter);
		_g_ptr_array_unref0 (temp_related_uris);
		_g_free0 (sql);
		_g_free0 (sql_event_ids);
		_sqlite3_finalize0 (stmt);
		pot = (g_free (pot), NULL);
		_tmp8_ = (g_free (_tmp8_), NULL);
		result_ids = (g_free (result_ids), NULL);
		ids = (g_free (ids), NULL);
		return result;
	} else {
		GError* _tmp144_;
		_tmp144_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_ERROR, "Unsupported RelevantResultType");
		_inner_error0_ = _tmp144_;
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
}

/**
     * Clear all resources Engine is using (close database connection, etc.).
     *
     * After executing this method on an instance, no other function
     * may be called.
     */
static void
zeitgeist_db_reader_real_close (ZeitgeistDbReader* self)
{
	ZeitgeistSQLiteDatabase* _tmp0_;
	_tmp0_ = self->priv->_database;
	zeitgeist_sq_lite_database_close (_tmp0_);
}

void
zeitgeist_db_reader_close (ZeitgeistDbReader* self)
{
	ZeitgeistDbReaderClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = ZEITGEIST_DB_READER_GET_CLASS (self);
	if (_klass_->close) {
		_klass_->close (self);
	}
}

static gchar*
zeitgeist_db_reader_group_and_sort (ZeitgeistDbReader* self,
                                    const gchar* field,
                                    ZeitgeistWhereClause* where,
                                    gboolean* count_asc,
                                    const gchar* aggregation_type)
{
	gchar* aggregation_sql = NULL;
	gchar* _tmp0_;
	gchar* order_sql = NULL;
	gchar* _tmp1_;
	gchar* where_sql = NULL;
	gchar* _tmp2_;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (field != NULL, NULL);
	g_return_val_if_fail (where != NULL, NULL);
	g_return_val_if_fail (aggregation_type != NULL, NULL);
	_tmp0_ = g_strdup ("");
	aggregation_sql = _tmp0_;
	_tmp1_ = g_strdup ("");
	order_sql = _tmp1_;
	_tmp2_ = zeitgeist_where_clause_get_sql_conditions (where);
	where_sql = _tmp2_;
	if (count_asc != NULL) {
		gchar* _tmp3_;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		_tmp3_ = g_strdup_printf (", COUNT(%s) AS num_events", field);
		_g_free0 (aggregation_sql);
		aggregation_sql = _tmp3_;
		if (*count_asc) {
			_tmp4_ = "ASC";
		} else {
			_tmp4_ = "DESC";
		}
		_tmp5_ = g_strdup_printf ("num_events %s,", _tmp4_);
		_g_free0 (order_sql);
		order_sql = _tmp5_;
	}
	if (count_asc != NULL) {
		_tmp6_ = TRUE;
	} else {
		_tmp6_ = !zeitgeist_where_clause_has_non_timestamp_condition (where);
	}
	if (_tmp6_) {
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp7_ = aggregation_sql;
		_tmp8_ = where_sql;
		_tmp9_ = order_sql;
		_tmp10_ = g_strdup_printf ("\n" \
"                SELECT id FROM event\n" \
"                NATURAL JOIN (\n" \
"                    SELECT %s,\n" \
"                    %s(timestamp) AS timestamp\n" \
"                    %s\n" \
"                    FROM event_view WHERE %s\n" \
"                    GROUP BY %s)\n" \
"                GROUP BY %s\n" \
"                ORDER BY %s \n" \
"                ", field, aggregation_type, _tmp7_, _tmp8_, field, field, _tmp9_);
		result = _tmp10_;
		_g_free0 (where_sql);
		_g_free0 (order_sql);
		_g_free0 (aggregation_sql);
		return result;
	}
	_tmp11_ = where_sql;
	_tmp12_ = g_strdup_printf ("\n" \
"            SELECT id, %s(timestamp) AS timestamp\n" \
"                FROM event_view WHERE %s AND %s IS NOT NULL\n" \
"            GROUP BY %s\n" \
"            ORDER BY\n" \
"            ", aggregation_type, _tmp11_, field, field);
	result = _tmp12_;
	_g_free0 (where_sql);
	_g_free0 (order_sql);
	_g_free0 (aggregation_sql);
	return result;
}

ZeitgeistWhereClause*
zeitgeist_db_reader_get_where_clause_from_event_templates (ZeitgeistDbReader* self,
                                                           GPtrArray* templates,
                                                           GError** error)
{
	ZeitgeistWhereClause* where = NULL;
	ZeitgeistWhereClause* _tmp0_;
	GError* _inner_error0_ = NULL;
	ZeitgeistWhereClause* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (templates != NULL, NULL);
	_tmp0_ = zeitgeist_where_clause_new (ZEITGEIST_WHERE_CLAUSE_TYPE_OR, FALSE);
	where = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_;
				gint _tmp4_;
				ZeitgeistEvent* event_template = NULL;
				gconstpointer _tmp5_;
				ZeitgeistEvent* _tmp6_;
				ZeitgeistWhereClause* _tmp7_ = NULL;
				ZeitgeistEvent* _tmp8_;
				ZeitgeistWhereClause* _tmp9_;
				ZeitgeistWhereClause* _tmp10_;
				if (!_tmp1_) {
					gint _tmp2_;
					i = i + 1;
					_tmp2_ = i;
				}
				_tmp1_ = FALSE;
				_tmp3_ = vala_g_ptr_array_get_length (templates);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = g_ptr_array_index (templates, (guint) i);
				_tmp6_ = _g_object_ref0 ((ZeitgeistEvent*) _tmp5_);
				event_template = _tmp6_;
				_tmp8_ = event_template;
				_tmp9_ = zeitgeist_db_reader_get_where_clause_from_event_template (self, _tmp8_, &_inner_error0_);
				_tmp7_ = _tmp9_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_g_object_unref0 (event_template);
						_g_object_unref0 (where);
						return NULL;
					} else {
						_g_object_unref0 (event_template);
						_g_object_unref0 (where);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp10_ = where;
				zeitgeist_where_clause_extend (_tmp10_, _tmp7_);
				_g_object_unref0 (_tmp7_);
				_g_object_unref0 (event_template);
			}
		}
	}
	result = where;
	return result;
}

static ZeitgeistWhereClause*
zeitgeist_db_reader_get_where_clause_from_event_template (ZeitgeistDbReader* self,
                                                          ZeitgeistEvent* template,
                                                          GError** error)
{
	ZeitgeistWhereClause* where = NULL;
	ZeitgeistWhereClause* _tmp0_;
	guint32 _tmp1_;
	guint32 _tmp2_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	const gchar* _tmp42_;
	const gchar* _tmp43_;
	GError* _inner_error0_ = NULL;
	ZeitgeistWhereClause* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (template != NULL, NULL);
	_tmp0_ = zeitgeist_where_clause_new (ZEITGEIST_WHERE_CLAUSE_TYPE_AND, FALSE);
	where = _tmp0_;
	_tmp1_ = zeitgeist_event_get_id (template);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != ((guint32) 0)) {
		ZeitgeistWhereClause* _tmp3_;
		guint32 _tmp4_;
		guint32 _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp3_ = where;
		_tmp4_ = zeitgeist_event_get_id (template);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strdup_printf ("%u", _tmp5_);
		_tmp7_ = _tmp6_;
		zeitgeist_where_clause_add (_tmp3_, "id=?", _tmp7_);
		_g_free0 (_tmp7_);
	}
	_tmp8_ = zeitgeist_event_get_interpretation (template);
	_tmp9_ = _tmp8_;
	if (!zeitgeist_utils_is_empty_string (_tmp9_)) {
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		ZeitgeistWhereClause* subwhere = NULL;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		ZeitgeistSQLiteTableLookup* _tmp14_;
		ZeitgeistWhereClause* _tmp15_;
		ZeitgeistWhereClause* _tmp16_;
		_tmp10_ = zeitgeist_event_get_interpretation (template);
		_tmp11_ = _tmp10_;
		zeitgeist_db_reader_assert_no_wildcard (self, "interpretation", _tmp11_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (where);
				return NULL;
			} else {
				_g_object_unref0 (where);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp12_ = zeitgeist_event_get_interpretation (template);
		_tmp13_ = _tmp12_;
		_tmp14_ = self->interpretations_table;
		_tmp15_ = zeitgeist_db_reader_get_where_clause_for_symbol (self, "interpretation", _tmp13_, _tmp14_, &_inner_error0_);
		subwhere = _tmp15_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (where);
				return NULL;
			} else {
				_g_object_unref0 (where);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp16_ = subwhere;
		if (!zeitgeist_where_clause_is_empty (_tmp16_)) {
			ZeitgeistWhereClause* _tmp17_;
			ZeitgeistWhereClause* _tmp18_;
			_tmp17_ = where;
			_tmp18_ = subwhere;
			zeitgeist_where_clause_extend (_tmp17_, _tmp18_);
		}
		_g_object_unref0 (subwhere);
	}
	_tmp19_ = zeitgeist_event_get_manifestation (template);
	_tmp20_ = _tmp19_;
	if (!zeitgeist_utils_is_empty_string (_tmp20_)) {
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		ZeitgeistWhereClause* subwhere = NULL;
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		ZeitgeistSQLiteTableLookup* _tmp25_;
		ZeitgeistWhereClause* _tmp26_;
		ZeitgeistWhereClause* _tmp27_;
		_tmp21_ = zeitgeist_event_get_interpretation (template);
		_tmp22_ = _tmp21_;
		zeitgeist_db_reader_assert_no_wildcard (self, "manifestation", _tmp22_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (where);
				return NULL;
			} else {
				_g_object_unref0 (where);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp23_ = zeitgeist_event_get_manifestation (template);
		_tmp24_ = _tmp23_;
		_tmp25_ = self->manifestations_table;
		_tmp26_ = zeitgeist_db_reader_get_where_clause_for_symbol (self, "manifestation", _tmp24_, _tmp25_, &_inner_error0_);
		subwhere = _tmp26_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (where);
				return NULL;
			} else {
				_g_object_unref0 (where);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp27_ = subwhere;
		if (!zeitgeist_where_clause_is_empty (_tmp27_)) {
			ZeitgeistWhereClause* _tmp28_;
			ZeitgeistWhereClause* _tmp29_;
			_tmp28_ = where;
			_tmp29_ = subwhere;
			zeitgeist_where_clause_extend (_tmp28_, _tmp29_);
		}
		_g_object_unref0 (subwhere);
	}
	_tmp30_ = zeitgeist_event_get_actor (template);
	_tmp31_ = _tmp30_;
	if (!zeitgeist_utils_is_empty_string (_tmp31_)) {
		gchar* val = NULL;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		gchar* _tmp34_;
		gboolean like = FALSE;
		gboolean _tmp35_;
		gboolean negated = FALSE;
		gboolean _tmp36_;
		_tmp32_ = zeitgeist_event_get_actor (template);
		_tmp33_ = _tmp32_;
		_tmp34_ = g_strdup (_tmp33_);
		val = _tmp34_;
		_tmp35_ = zeitgeist_utils_parse_wildcard (&val);
		like = _tmp35_;
		_tmp36_ = zeitgeist_utils_parse_negation (&val);
		negated = _tmp36_;
		if (like) {
			ZeitgeistWhereClause* _tmp37_;
			const gchar* _tmp38_;
			_tmp37_ = where;
			_tmp38_ = val;
			zeitgeist_where_clause_add_wildcard_condition (_tmp37_, "actor", _tmp38_, negated);
		} else {
			ZeitgeistWhereClause* _tmp39_;
			ZeitgeistSQLiteTableLookup* _tmp40_;
			const gchar* _tmp41_;
			_tmp39_ = where;
			_tmp40_ = self->actors_table;
			_tmp41_ = val;
			zeitgeist_where_clause_add_match_condition (_tmp39_, "actor", zeitgeist_sq_lite_table_lookup_id_try_string (_tmp40_, _tmp41_), negated);
		}
		_g_free0 (val);
	}
	_tmp42_ = zeitgeist_event_get_origin (template);
	_tmp43_ = _tmp42_;
	if (!zeitgeist_utils_is_empty_string (_tmp43_)) {
		gchar* val = NULL;
		const gchar* _tmp44_;
		const gchar* _tmp45_;
		gchar* _tmp46_;
		gboolean like = FALSE;
		gboolean _tmp47_;
		gboolean negated = FALSE;
		gboolean _tmp48_;
		const gchar* _tmp49_;
		_tmp44_ = zeitgeist_event_get_origin (template);
		_tmp45_ = _tmp44_;
		_tmp46_ = g_strdup (_tmp45_);
		val = _tmp46_;
		_tmp47_ = zeitgeist_utils_parse_wildcard (&val);
		like = _tmp47_;
		_tmp48_ = zeitgeist_utils_parse_negation (&val);
		negated = _tmp48_;
		_tmp49_ = val;
		zeitgeist_db_reader_assert_no_noexpand (self, _tmp49_, "origin", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (val);
				_g_object_unref0 (where);
				return NULL;
			} else {
				_g_free0 (val);
				_g_object_unref0 (where);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		if (like) {
			ZeitgeistWhereClause* _tmp50_;
			const gchar* _tmp51_;
			_tmp50_ = where;
			_tmp51_ = val;
			zeitgeist_where_clause_add_wildcard_condition (_tmp50_, "origin", _tmp51_, negated);
		} else {
			ZeitgeistWhereClause* _tmp52_;
			const gchar* _tmp53_;
			_tmp52_ = where;
			_tmp53_ = val;
			zeitgeist_where_clause_add_text_condition_subquery (_tmp52_, "origin", _tmp53_, negated);
		}
		_g_free0 (val);
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp54_ = FALSE;
			_tmp54_ = TRUE;
			while (TRUE) {
				ZeitgeistSubject* subject_template = NULL;
				GPtrArray* _tmp56_;
				GPtrArray* _tmp57_;
				gconstpointer _tmp58_;
				ZeitgeistSubject* _tmp59_;
				ZeitgeistSubject* _tmp60_;
				const gchar* _tmp61_;
				const gchar* _tmp62_;
				ZeitgeistSubject* _tmp73_;
				const gchar* _tmp74_;
				const gchar* _tmp75_;
				ZeitgeistSubject* _tmp87_;
				const gchar* _tmp88_;
				const gchar* _tmp89_;
				ZeitgeistSubject* _tmp102_;
				const gchar* _tmp103_;
				const gchar* _tmp104_;
				ZeitgeistSubject* _tmp116_;
				const gchar* _tmp117_;
				const gchar* _tmp118_;
				ZeitgeistSubject* _tmp130_;
				const gchar* _tmp131_;
				const gchar* _tmp132_;
				ZeitgeistSubject* _tmp137_;
				const gchar* _tmp138_;
				const gchar* _tmp139_;
				ZeitgeistSubject* _tmp151_;
				const gchar* _tmp152_;
				const gchar* _tmp153_;
				ZeitgeistSubject* _tmp165_;
				const gchar* _tmp166_;
				const gchar* _tmp167_;
				if (!_tmp54_) {
					gint _tmp55_;
					i = i + 1;
					_tmp55_ = i;
				}
				_tmp54_ = FALSE;
				if (!(i < zeitgeist_event_num_subjects (template))) {
					break;
				}
				_tmp56_ = zeitgeist_event_get_subjects (template);
				_tmp57_ = _tmp56_;
				_tmp58_ = g_ptr_array_index (_tmp57_, (guint) i);
				_tmp59_ = _g_object_ref0 ((ZeitgeistSubject*) _tmp58_);
				subject_template = _tmp59_;
				_tmp60_ = subject_template;
				_tmp61_ = zeitgeist_subject_get_interpretation (_tmp60_);
				_tmp62_ = _tmp61_;
				if (!zeitgeist_utils_is_empty_string (_tmp62_)) {
					const gchar* _tmp63_;
					const gchar* _tmp64_;
					ZeitgeistWhereClause* subwhere = NULL;
					ZeitgeistSubject* _tmp65_;
					const gchar* _tmp66_;
					const gchar* _tmp67_;
					ZeitgeistSQLiteTableLookup* _tmp68_;
					ZeitgeistWhereClause* _tmp69_;
					ZeitgeistWhereClause* _tmp70_;
					_tmp63_ = zeitgeist_event_get_interpretation (template);
					_tmp64_ = _tmp63_;
					zeitgeist_db_reader_assert_no_wildcard (self, "subject interpretation", _tmp64_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							return NULL;
						} else {
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
					_tmp65_ = subject_template;
					_tmp66_ = zeitgeist_subject_get_interpretation (_tmp65_);
					_tmp67_ = _tmp66_;
					_tmp68_ = self->interpretations_table;
					_tmp69_ = zeitgeist_db_reader_get_where_clause_for_symbol (self, "subj_interpretation", _tmp67_, _tmp68_, &_inner_error0_);
					subwhere = _tmp69_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							return NULL;
						} else {
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
					_tmp70_ = subwhere;
					if (!zeitgeist_where_clause_is_empty (_tmp70_)) {
						ZeitgeistWhereClause* _tmp71_;
						ZeitgeistWhereClause* _tmp72_;
						_tmp71_ = where;
						_tmp72_ = subwhere;
						zeitgeist_where_clause_extend (_tmp71_, _tmp72_);
					}
					_g_object_unref0 (subwhere);
				}
				_tmp73_ = subject_template;
				_tmp74_ = zeitgeist_subject_get_manifestation (_tmp73_);
				_tmp75_ = _tmp74_;
				if (!zeitgeist_utils_is_empty_string (_tmp75_)) {
					ZeitgeistSubject* _tmp76_;
					const gchar* _tmp77_;
					const gchar* _tmp78_;
					ZeitgeistWhereClause* subwhere = NULL;
					ZeitgeistSubject* _tmp79_;
					const gchar* _tmp80_;
					const gchar* _tmp81_;
					ZeitgeistSQLiteTableLookup* _tmp82_;
					ZeitgeistWhereClause* _tmp83_;
					ZeitgeistWhereClause* _tmp84_;
					_tmp76_ = subject_template;
					_tmp77_ = zeitgeist_subject_get_manifestation (_tmp76_);
					_tmp78_ = _tmp77_;
					zeitgeist_db_reader_assert_no_wildcard (self, "subject manifestation", _tmp78_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							return NULL;
						} else {
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
					_tmp79_ = subject_template;
					_tmp80_ = zeitgeist_subject_get_manifestation (_tmp79_);
					_tmp81_ = _tmp80_;
					_tmp82_ = self->manifestations_table;
					_tmp83_ = zeitgeist_db_reader_get_where_clause_for_symbol (self, "subj_manifestation", _tmp81_, _tmp82_, &_inner_error0_);
					subwhere = _tmp83_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							return NULL;
						} else {
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
					_tmp84_ = subwhere;
					if (!zeitgeist_where_clause_is_empty (_tmp84_)) {
						ZeitgeistWhereClause* _tmp85_;
						ZeitgeistWhereClause* _tmp86_;
						_tmp85_ = where;
						_tmp86_ = subwhere;
						zeitgeist_where_clause_extend (_tmp85_, _tmp86_);
					}
					_g_object_unref0 (subwhere);
				}
				_tmp87_ = subject_template;
				_tmp88_ = zeitgeist_subject_get_mimetype (_tmp87_);
				_tmp89_ = _tmp88_;
				if (!zeitgeist_utils_is_empty_string (_tmp89_)) {
					gchar* val = NULL;
					ZeitgeistSubject* _tmp90_;
					const gchar* _tmp91_;
					const gchar* _tmp92_;
					gchar* _tmp93_;
					gboolean like = FALSE;
					gboolean _tmp94_;
					gboolean negated = FALSE;
					gboolean _tmp95_;
					const gchar* _tmp96_;
					_tmp90_ = subject_template;
					_tmp91_ = zeitgeist_subject_get_mimetype (_tmp90_);
					_tmp92_ = _tmp91_;
					_tmp93_ = g_strdup (_tmp92_);
					val = _tmp93_;
					_tmp94_ = zeitgeist_utils_parse_wildcard (&val);
					like = _tmp94_;
					_tmp95_ = zeitgeist_utils_parse_negation (&val);
					negated = _tmp95_;
					_tmp96_ = val;
					zeitgeist_db_reader_assert_no_noexpand (self, _tmp96_, "mime-type", &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_g_free0 (val);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							return NULL;
						} else {
							_g_free0 (val);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
					if (like) {
						ZeitgeistWhereClause* _tmp97_;
						const gchar* _tmp98_;
						_tmp97_ = where;
						_tmp98_ = val;
						zeitgeist_where_clause_add_wildcard_condition (_tmp97_, "subj_mimetype", _tmp98_, negated);
					} else {
						ZeitgeistWhereClause* _tmp99_;
						ZeitgeistSQLiteTableLookup* _tmp100_;
						const gchar* _tmp101_;
						_tmp99_ = where;
						_tmp100_ = self->mimetypes_table;
						_tmp101_ = val;
						zeitgeist_where_clause_add_match_condition (_tmp99_, "subj_mimetype", zeitgeist_sq_lite_table_lookup_id_try_string (_tmp100_, _tmp101_), negated);
					}
					_g_free0 (val);
				}
				_tmp102_ = subject_template;
				_tmp103_ = zeitgeist_subject_get_uri (_tmp102_);
				_tmp104_ = _tmp103_;
				if (!zeitgeist_utils_is_empty_string (_tmp104_)) {
					gchar* val = NULL;
					ZeitgeistSubject* _tmp105_;
					const gchar* _tmp106_;
					const gchar* _tmp107_;
					gchar* _tmp108_;
					gboolean like = FALSE;
					gboolean _tmp109_;
					gboolean negated = FALSE;
					gboolean _tmp110_;
					const gchar* _tmp111_;
					_tmp105_ = subject_template;
					_tmp106_ = zeitgeist_subject_get_uri (_tmp105_);
					_tmp107_ = _tmp106_;
					_tmp108_ = g_strdup (_tmp107_);
					val = _tmp108_;
					_tmp109_ = zeitgeist_utils_parse_wildcard (&val);
					like = _tmp109_;
					_tmp110_ = zeitgeist_utils_parse_negation (&val);
					negated = _tmp110_;
					_tmp111_ = val;
					zeitgeist_db_reader_assert_no_noexpand (self, _tmp111_, "uri", &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_g_free0 (val);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							return NULL;
						} else {
							_g_free0 (val);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
					if (like) {
						ZeitgeistWhereClause* _tmp112_;
						const gchar* _tmp113_;
						_tmp112_ = where;
						_tmp113_ = val;
						zeitgeist_where_clause_add_wildcard_condition (_tmp112_, "subj_id", _tmp113_, negated);
					} else {
						ZeitgeistWhereClause* _tmp114_;
						const gchar* _tmp115_;
						_tmp114_ = where;
						_tmp115_ = val;
						zeitgeist_where_clause_add_text_condition_subquery (_tmp114_, "subj_id", _tmp115_, negated);
					}
					_g_free0 (val);
				}
				_tmp116_ = subject_template;
				_tmp117_ = zeitgeist_subject_get_origin (_tmp116_);
				_tmp118_ = _tmp117_;
				if (!zeitgeist_utils_is_empty_string (_tmp118_)) {
					gchar* val = NULL;
					ZeitgeistSubject* _tmp119_;
					const gchar* _tmp120_;
					const gchar* _tmp121_;
					gchar* _tmp122_;
					gboolean like = FALSE;
					gboolean _tmp123_;
					gboolean negated = FALSE;
					gboolean _tmp124_;
					const gchar* _tmp125_;
					_tmp119_ = subject_template;
					_tmp120_ = zeitgeist_subject_get_origin (_tmp119_);
					_tmp121_ = _tmp120_;
					_tmp122_ = g_strdup (_tmp121_);
					val = _tmp122_;
					_tmp123_ = zeitgeist_utils_parse_wildcard (&val);
					like = _tmp123_;
					_tmp124_ = zeitgeist_utils_parse_negation (&val);
					negated = _tmp124_;
					_tmp125_ = val;
					zeitgeist_db_reader_assert_no_noexpand (self, _tmp125_, "subject origin", &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_g_free0 (val);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							return NULL;
						} else {
							_g_free0 (val);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
					if (like) {
						ZeitgeistWhereClause* _tmp126_;
						const gchar* _tmp127_;
						_tmp126_ = where;
						_tmp127_ = val;
						zeitgeist_where_clause_add_wildcard_condition (_tmp126_, "subj_origin", _tmp127_, negated);
					} else {
						ZeitgeistWhereClause* _tmp128_;
						const gchar* _tmp129_;
						_tmp128_ = where;
						_tmp129_ = val;
						zeitgeist_where_clause_add_text_condition_subquery (_tmp128_, "subj_origin", _tmp129_, negated);
					}
					_g_free0 (val);
				}
				_tmp130_ = subject_template;
				_tmp131_ = zeitgeist_subject_get_text (_tmp130_);
				_tmp132_ = _tmp131_;
				if (!zeitgeist_utils_is_empty_string (_tmp132_)) {
					ZeitgeistWhereClause* _tmp133_;
					ZeitgeistSubject* _tmp134_;
					const gchar* _tmp135_;
					const gchar* _tmp136_;
					_tmp133_ = where;
					_tmp134_ = subject_template;
					_tmp135_ = zeitgeist_subject_get_text (_tmp134_);
					_tmp136_ = _tmp135_;
					zeitgeist_where_clause_add_text_condition_subquery (_tmp133_, "subj_text_id", _tmp136_, FALSE);
				}
				_tmp137_ = subject_template;
				_tmp138_ = zeitgeist_subject_get_current_uri (_tmp137_);
				_tmp139_ = _tmp138_;
				if (!zeitgeist_utils_is_empty_string (_tmp139_)) {
					gchar* val = NULL;
					ZeitgeistSubject* _tmp140_;
					const gchar* _tmp141_;
					const gchar* _tmp142_;
					gchar* _tmp143_;
					gboolean like = FALSE;
					gboolean _tmp144_;
					gboolean negated = FALSE;
					gboolean _tmp145_;
					const gchar* _tmp146_;
					_tmp140_ = subject_template;
					_tmp141_ = zeitgeist_subject_get_current_uri (_tmp140_);
					_tmp142_ = _tmp141_;
					_tmp143_ = g_strdup (_tmp142_);
					val = _tmp143_;
					_tmp144_ = zeitgeist_utils_parse_wildcard (&val);
					like = _tmp144_;
					_tmp145_ = zeitgeist_utils_parse_negation (&val);
					negated = _tmp145_;
					_tmp146_ = val;
					zeitgeist_db_reader_assert_no_noexpand (self, _tmp146_, "current_uri", &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_g_free0 (val);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							return NULL;
						} else {
							_g_free0 (val);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
					if (like) {
						ZeitgeistWhereClause* _tmp147_;
						const gchar* _tmp148_;
						_tmp147_ = where;
						_tmp148_ = val;
						zeitgeist_where_clause_add_wildcard_condition (_tmp147_, "subj_id_current", _tmp148_, negated);
					} else {
						ZeitgeistWhereClause* _tmp149_;
						const gchar* _tmp150_;
						_tmp149_ = where;
						_tmp150_ = val;
						zeitgeist_where_clause_add_text_condition_subquery (_tmp149_, "subj_id_current", _tmp150_, negated);
					}
					_g_free0 (val);
				}
				_tmp151_ = subject_template;
				_tmp152_ = zeitgeist_subject_get_current_origin (_tmp151_);
				_tmp153_ = _tmp152_;
				if (!zeitgeist_utils_is_empty_string (_tmp153_)) {
					gchar* val = NULL;
					ZeitgeistSubject* _tmp154_;
					const gchar* _tmp155_;
					const gchar* _tmp156_;
					gchar* _tmp157_;
					gboolean like = FALSE;
					gboolean _tmp158_;
					gboolean negated = FALSE;
					gboolean _tmp159_;
					const gchar* _tmp160_;
					_tmp154_ = subject_template;
					_tmp155_ = zeitgeist_subject_get_current_origin (_tmp154_);
					_tmp156_ = _tmp155_;
					_tmp157_ = g_strdup (_tmp156_);
					val = _tmp157_;
					_tmp158_ = zeitgeist_utils_parse_wildcard (&val);
					like = _tmp158_;
					_tmp159_ = zeitgeist_utils_parse_negation (&val);
					negated = _tmp159_;
					_tmp160_ = val;
					zeitgeist_db_reader_assert_no_noexpand (self, _tmp160_, "current_origin", &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_g_free0 (val);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							return NULL;
						} else {
							_g_free0 (val);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
					if (like) {
						ZeitgeistWhereClause* _tmp161_;
						const gchar* _tmp162_;
						_tmp161_ = where;
						_tmp162_ = val;
						zeitgeist_where_clause_add_wildcard_condition (_tmp161_, "subj_origin_current", _tmp162_, negated);
					} else {
						ZeitgeistWhereClause* _tmp163_;
						const gchar* _tmp164_;
						_tmp163_ = where;
						_tmp164_ = val;
						zeitgeist_where_clause_add_text_condition_subquery (_tmp163_, "subj_origin_current", _tmp164_, negated);
					}
					_g_free0 (val);
				}
				_tmp165_ = subject_template;
				_tmp166_ = zeitgeist_subject_get_storage (_tmp165_);
				_tmp167_ = _tmp166_;
				if (!zeitgeist_utils_is_empty_string (_tmp167_)) {
					gchar* val = NULL;
					ZeitgeistSubject* _tmp168_;
					const gchar* _tmp169_;
					const gchar* _tmp170_;
					gchar* _tmp171_;
					const gchar* _tmp172_;
					const gchar* _tmp173_;
					const gchar* _tmp174_;
					ZeitgeistWhereClause* _tmp175_;
					const gchar* _tmp176_;
					_tmp168_ = subject_template;
					_tmp169_ = zeitgeist_subject_get_storage (_tmp168_);
					_tmp170_ = _tmp169_;
					_tmp171_ = g_strdup (_tmp170_);
					val = _tmp171_;
					_tmp172_ = val;
					zeitgeist_db_reader_assert_no_negation (self, "subject storage", _tmp172_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_g_free0 (val);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							return NULL;
						} else {
							_g_free0 (val);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
					_tmp173_ = val;
					zeitgeist_db_reader_assert_no_wildcard (self, "subject storage", _tmp173_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_g_free0 (val);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							return NULL;
						} else {
							_g_free0 (val);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
					_tmp174_ = val;
					zeitgeist_db_reader_assert_no_noexpand (self, _tmp174_, "subject storage", &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_g_free0 (val);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							return NULL;
						} else {
							_g_free0 (val);
							_g_object_unref0 (subject_template);
							_g_object_unref0 (where);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
					_tmp175_ = where;
					_tmp176_ = val;
					zeitgeist_where_clause_add_text_condition_subquery (_tmp175_, "subj_storage_id", _tmp176_, FALSE);
					_g_free0 (val);
				}
				_g_object_unref0 (subject_template);
			}
		}
	}
	result = where;
	return result;
}

/**
     * If the value starts with the negation operator, throw an
     * error.
     */
void
zeitgeist_db_reader_assert_no_negation (ZeitgeistDbReader* self,
                                        const gchar* field,
                                        const gchar* val,
                                        GError** error)
{
	gboolean _tmp0_ = FALSE;
	gchar* error_message = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GError* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (field != NULL);
	if (val == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !g_str_has_prefix (val, "!");
	}
	if (_tmp0_) {
		return;
	}
	_tmp1_ = g_strdup_printf ("Field '%s' doesn't support negation", field);
	error_message = _tmp1_;
	_tmp2_ = error_message;
	g_warning ("db-reader.vala:860: %s", _tmp2_);
	_tmp3_ = error_message;
	_tmp4_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_INVALID_ARGUMENT, _tmp3_);
	_inner_error0_ = _tmp4_;
	if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (error_message);
		return;
	} else {
		_g_free0 (error_message);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

/**
     * If the value starts with the negation operator, throw an
     * error.
     */
void
zeitgeist_db_reader_assert_no_noexpand (ZeitgeistDbReader* self,
                                        const gchar* field,
                                        const gchar* val,
                                        GError** error)
{
	gboolean _tmp0_ = FALSE;
	gchar* error_message = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GError* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (field != NULL);
	if (val == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !g_str_has_prefix (val, "+");
	}
	if (_tmp0_) {
		return;
	}
	_tmp1_ = g_strdup_printf ("Field '%s' doesn't support the no-expand operator", field);
	error_message = _tmp1_;
	_tmp2_ = error_message;
	g_warning ("db-reader.vala:876: %s", _tmp2_);
	_tmp3_ = error_message;
	_tmp4_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_INVALID_ARGUMENT, _tmp3_);
	_inner_error0_ = _tmp4_;
	if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (error_message);
		return;
	} else {
		_g_free0 (error_message);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

/**
     * If the value ends with the wildcard character, throw an error.
     */
void
zeitgeist_db_reader_assert_no_wildcard (ZeitgeistDbReader* self,
                                        const gchar* field,
                                        const gchar* val,
                                        GError** error)
{
	gboolean _tmp0_ = FALSE;
	gchar* error_message = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GError* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (field != NULL);
	if (val == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !g_str_has_suffix (val, "*");
	}
	if (_tmp0_) {
		return;
	}
	_tmp1_ = g_strdup_printf ("Field '%s' doesn't support prefix search", field);
	error_message = _tmp1_;
	_tmp2_ = error_message;
	g_warning ("db-reader.vala:891: %s", _tmp2_);
	_tmp3_ = error_message;
	_tmp4_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_INVALID_ARGUMENT, _tmp3_);
	_inner_error0_ = _tmp4_;
	if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (error_message);
		return;
	} else {
		_g_free0 (error_message);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

ZeitgeistWhereClause*
zeitgeist_db_reader_get_where_clause_for_symbol (ZeitgeistDbReader* self,
                                                 const gchar* table_name,
                                                 const gchar* symbol,
                                                 ZeitgeistSQLiteTableLookup* lookup_table,
                                                 GError** error)
{
	gchar* _symbol = NULL;
	gchar* _tmp0_;
	gboolean negated = FALSE;
	gboolean _tmp1_;
	gboolean noexpand = FALSE;
	gboolean _tmp2_;
	GList* symbols = NULL;
	const gchar* _tmp5_;
	ZeitgeistWhereClause* subwhere = NULL;
	ZeitgeistWhereClause* _tmp6_;
	GList* _tmp7_;
	ZeitgeistWhereClause* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (table_name != NULL, NULL);
	g_return_val_if_fail (symbol != NULL, NULL);
	g_return_val_if_fail (lookup_table != NULL, NULL);
	_tmp0_ = g_strdup (symbol);
	_symbol = _tmp0_;
	_tmp1_ = zeitgeist_utils_parse_negation (&_symbol);
	negated = _tmp1_;
	_tmp2_ = zeitgeist_utils_parse_noexpand (&_symbol);
	noexpand = _tmp2_;
	if (noexpand) {
		(symbols == NULL) ? NULL : (symbols = (g_list_free (symbols), NULL));
		symbols = NULL;
	} else {
		const gchar* _tmp3_;
		GList* _tmp4_;
		_tmp3_ = _symbol;
		_tmp4_ = zeitgeist_symbol_get_all_children (_tmp3_);
		(symbols == NULL) ? NULL : (symbols = (g_list_free (symbols), NULL));
		symbols = _tmp4_;
	}
	_tmp5_ = _symbol;
	symbols = g_list_prepend (symbols, _tmp5_);
	_tmp6_ = zeitgeist_where_clause_new (ZEITGEIST_WHERE_CLAUSE_TYPE_OR, negated);
	subwhere = _tmp6_;
	_tmp7_ = symbols;
	if (g_list_length (_tmp7_) == ((guint) 1)) {
		ZeitgeistWhereClause* _tmp8_;
		const gchar* _tmp9_;
		_tmp8_ = subwhere;
		_tmp9_ = _symbol;
		zeitgeist_where_clause_add_match_condition (_tmp8_, table_name, zeitgeist_sq_lite_table_lookup_id_try_string (lookup_table, _tmp9_), FALSE);
	} else {
		gchar* sql = NULL;
		gchar* _tmp10_;
		gchar* sub_sql = NULL;
		gchar* _tmp11_;
		gboolean first = FALSE;
		GList* _tmp12_;
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		gchar* _tmp22_;
		ZeitgeistWhereClause* _tmp23_;
		const gchar* _tmp24_;
		_tmp10_ = g_strdup ("(%s)");
		sql = _tmp10_;
		_tmp11_ = g_strdup ("");
		sub_sql = _tmp11_;
		first = TRUE;
		_tmp12_ = symbols;
		{
			GList* uri_collection = NULL;
			GList* uri_it = NULL;
			uri_collection = _tmp12_;
			for (uri_it = uri_collection; uri_it != NULL; uri_it = uri_it->next) {
				const gchar* uri = NULL;
				uri = (const gchar*) uri_it->data;
				{
					const gchar* _tmp15_;
					const gchar* _tmp16_;
					gchar* _tmp17_;
					gchar* _tmp18_;
					gchar* _tmp19_;
					if (!first) {
						const gchar* _tmp13_;
						gchar* _tmp14_;
						_tmp13_ = sub_sql;
						_tmp14_ = g_strconcat (_tmp13_, " OR ", NULL);
						_g_free0 (sub_sql);
						sub_sql = _tmp14_;
					}
					_tmp15_ = sub_sql;
					_tmp16_ = uri;
					_tmp17_ = g_strdup_printf ("%s = %i ", table_name, zeitgeist_sq_lite_table_lookup_id_try_string (lookup_table, _tmp16_));
					_tmp18_ = _tmp17_;
					_tmp19_ = g_strconcat (_tmp15_, _tmp18_, NULL);
					_g_free0 (sub_sql);
					sub_sql = _tmp19_;
					_g_free0 (_tmp18_);
					first = FALSE;
				}
			}
		}
		_tmp20_ = sql;
		_tmp21_ = sub_sql;
		_tmp22_ = g_strdup_printf (_tmp20_, _tmp21_);
		_g_free0 (sql);
		sql = _tmp22_;
		_tmp23_ = subwhere;
		_tmp24_ = sql;
		zeitgeist_where_clause_add (_tmp23_, _tmp24_, NULL);
		_g_free0 (sub_sql);
		_g_free0 (sql);
	}
	result = subwhere;
	(symbols == NULL) ? NULL : (symbols = (g_list_free (symbols), NULL));
	_g_free0 (_symbol);
	return result;
}

static void
zeitgeist_db_reader_delete_from_cache (ZeitgeistDbReader* self,
                                       const gchar* table,
                                       gint64 rowid)
{
	ZeitgeistSQLiteTableLookup* table_lookup = NULL;
	ZeitgeistSQLiteTableLookup* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (table != NULL);
	if (g_strcmp0 (table, "interpretation") == 0) {
		ZeitgeistSQLiteTableLookup* _tmp0_;
		ZeitgeistSQLiteTableLookup* _tmp1_;
		_tmp0_ = self->interpretations_table;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_g_object_unref0 (table_lookup);
		table_lookup = _tmp1_;
	} else {
		if (g_strcmp0 (table, "manifestation") == 0) {
			ZeitgeistSQLiteTableLookup* _tmp2_;
			ZeitgeistSQLiteTableLookup* _tmp3_;
			_tmp2_ = self->manifestations_table;
			_tmp3_ = _g_object_ref0 (_tmp2_);
			_g_object_unref0 (table_lookup);
			table_lookup = _tmp3_;
		} else {
			if (g_strcmp0 (table, "mimetype") == 0) {
				ZeitgeistSQLiteTableLookup* _tmp4_;
				ZeitgeistSQLiteTableLookup* _tmp5_;
				_tmp4_ = self->mimetypes_table;
				_tmp5_ = _g_object_ref0 (_tmp4_);
				_g_object_unref0 (table_lookup);
				table_lookup = _tmp5_;
			} else {
				if (g_strcmp0 (table, "actor") == 0) {
					ZeitgeistSQLiteTableLookup* _tmp6_;
					ZeitgeistSQLiteTableLookup* _tmp7_;
					_tmp6_ = self->actors_table;
					_tmp7_ = _g_object_ref0 (_tmp6_);
					_g_object_unref0 (table_lookup);
					table_lookup = _tmp7_;
				} else {
					_g_object_unref0 (table_lookup);
					return;
				}
			}
		}
	}
	_tmp8_ = table_lookup;
	zeitgeist_sq_lite_table_lookup_remove (_tmp8_, (gint) rowid);
	_g_object_unref0 (table_lookup);
}

ZeitgeistSQLiteDatabase*
zeitgeist_db_reader_get_database (ZeitgeistDbReader* self)
{
	ZeitgeistSQLiteDatabase* result;
	ZeitgeistSQLiteDatabase* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_database;
	result = _tmp0_;
	return result;
}

static void
zeitgeist_db_reader_set_database (ZeitgeistDbReader* self,
                                  ZeitgeistSQLiteDatabase* value)
{
	ZeitgeistSQLiteDatabase* old_value;
	g_return_if_fail (self != NULL);
	old_value = zeitgeist_db_reader_get_database (self);
	if (old_value != value) {
		ZeitgeistSQLiteDatabase* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_database);
		self->priv->_database = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, zeitgeist_db_reader_properties[ZEITGEIST_DB_READER_DATABASE_PROPERTY]);
	}
}

static void
zeitgeist_db_reader_related_uri_copy (const ZeitgeistDbReaderRelatedUri* self,
                                      ZeitgeistDbReaderRelatedUri* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	(*dest).id = (*self).id;
	(*dest).timestamp = (*self).timestamp;
	_tmp0_ = (*self).uri;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).uri);
	(*dest).uri = _tmp1_;
	(*dest).counter = (*self).counter;
}

static void
zeitgeist_db_reader_related_uri_destroy (ZeitgeistDbReaderRelatedUri* self)
{
	_g_free0 ((*self).uri);
}

static ZeitgeistDbReaderRelatedUri*
zeitgeist_db_reader_related_uri_dup (const ZeitgeistDbReaderRelatedUri* self)
{
	ZeitgeistDbReaderRelatedUri* dup;
	dup = g_new0 (ZeitgeistDbReaderRelatedUri, 1);
	zeitgeist_db_reader_related_uri_copy (self, dup);
	return dup;
}

static void
zeitgeist_db_reader_related_uri_free (ZeitgeistDbReaderRelatedUri* self)
{
	zeitgeist_db_reader_related_uri_destroy (self);
	g_free (self);
}

static GType
zeitgeist_db_reader_related_uri_get_type_once (void)
{
	GType zeitgeist_db_reader_related_uri_type_id;
	zeitgeist_db_reader_related_uri_type_id = g_boxed_type_register_static ("ZeitgeistDbReaderRelatedUri", (GBoxedCopyFunc) zeitgeist_db_reader_related_uri_dup, (GBoxedFreeFunc) zeitgeist_db_reader_related_uri_free);
	return zeitgeist_db_reader_related_uri_type_id;
}

static GType
zeitgeist_db_reader_related_uri_get_type (void)
{
	static volatile gsize zeitgeist_db_reader_related_uri_type_id__once = 0;
	if (g_once_init_enter (&zeitgeist_db_reader_related_uri_type_id__once)) {
		GType zeitgeist_db_reader_related_uri_type_id;
		zeitgeist_db_reader_related_uri_type_id = zeitgeist_db_reader_related_uri_get_type_once ();
		g_once_init_leave (&zeitgeist_db_reader_related_uri_type_id__once, zeitgeist_db_reader_related_uri_type_id);
	}
	return zeitgeist_db_reader_related_uri_type_id__once;
}

static void
_zeitgeist_db_reader_delete_from_cache_zeitgeist_sq_lite_deletion_callback (const gchar* table,
                                                                            gint64 rowid,
                                                                            gpointer self)
{
	zeitgeist_db_reader_delete_from_cache ((ZeitgeistDbReader*) self, table, rowid);
}

static GObject *
zeitgeist_db_reader_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ZeitgeistDbReader * self;
	ZeitgeistSQLiteDatabase* _tmp0_;
	ZeitgeistSQLiteDatabase* _tmp1_;
	sqlite3* _tmp2_;
	ZeitgeistSQLiteDatabase* _tmp21_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (zeitgeist_db_reader_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_DB_READER, ZeitgeistDbReader);
	_tmp0_ = self->priv->_database;
	zeitgeist_sq_lite_database_set_deletion_callback (_tmp0_, _zeitgeist_db_reader_delete_from_cache_zeitgeist_sq_lite_deletion_callback, g_object_ref (self), g_object_unref);
	_tmp1_ = self->priv->_database;
	_tmp2_ = _tmp1_->database;
	self->db = _tmp2_;
	{
		ZeitgeistSQLiteTableLookup* _tmp3_ = NULL;
		ZeitgeistSQLiteDatabase* _tmp4_;
		ZeitgeistSQLiteTableLookup* _tmp5_;
		ZeitgeistSQLiteTableLookup* _tmp6_;
		ZeitgeistSQLiteTableLookup* _tmp7_ = NULL;
		ZeitgeistSQLiteDatabase* _tmp8_;
		ZeitgeistSQLiteTableLookup* _tmp9_;
		ZeitgeistSQLiteTableLookup* _tmp10_;
		ZeitgeistSQLiteTableLookup* _tmp11_ = NULL;
		ZeitgeistSQLiteDatabase* _tmp12_;
		ZeitgeistSQLiteTableLookup* _tmp13_;
		ZeitgeistSQLiteTableLookup* _tmp14_;
		ZeitgeistSQLiteTableLookup* _tmp15_ = NULL;
		ZeitgeistSQLiteDatabase* _tmp16_;
		ZeitgeistSQLiteTableLookup* _tmp17_;
		ZeitgeistSQLiteTableLookup* _tmp18_;
		_tmp4_ = self->priv->_database;
		_tmp5_ = zeitgeist_sq_lite_table_lookup_new (_tmp4_, "interpretation", &_inner_error0_);
		_tmp3_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
				goto __catch0_zeitgeist_engine_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
		}
		_tmp6_ = _tmp3_;
		_tmp3_ = NULL;
		_g_object_unref0 (self->interpretations_table);
		self->interpretations_table = _tmp6_;
		_tmp8_ = self->priv->_database;
		_tmp9_ = zeitgeist_sq_lite_table_lookup_new (_tmp8_, "manifestation", &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp3_);
			if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
				goto __catch0_zeitgeist_engine_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		_g_object_unref0 (self->manifestations_table);
		self->manifestations_table = _tmp10_;
		_tmp12_ = self->priv->_database;
		_tmp13_ = zeitgeist_sq_lite_table_lookup_new (_tmp12_, "mimetype", &_inner_error0_);
		_tmp11_ = _tmp13_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp7_);
			_g_object_unref0 (_tmp3_);
			if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
				goto __catch0_zeitgeist_engine_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
		}
		_tmp14_ = _tmp11_;
		_tmp11_ = NULL;
		_g_object_unref0 (self->mimetypes_table);
		self->mimetypes_table = _tmp14_;
		_tmp16_ = self->priv->_database;
		_tmp17_ = zeitgeist_sq_lite_table_lookup_new (_tmp16_, "actor", &_inner_error0_);
		_tmp15_ = _tmp17_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp11_);
			_g_object_unref0 (_tmp7_);
			_g_object_unref0 (_tmp3_);
			if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
				goto __catch0_zeitgeist_engine_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
		}
		_tmp18_ = _tmp15_;
		_tmp15_ = NULL;
		_g_object_unref0 (self->actors_table);
		self->actors_table = _tmp18_;
		_g_object_unref0 (_tmp15_);
		_g_object_unref0 (_tmp11_);
		_g_object_unref0 (_tmp7_);
		_g_object_unref0 (_tmp3_);
	}
	goto __finally0;
	__catch0_zeitgeist_engine_error:
	{
		GError* err = NULL;
		GError* _tmp19_;
		const gchar* _tmp20_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp19_ = err;
		_tmp20_ = _tmp19_->message;
		g_critical ("db-reader.vala:68: TableLookup initialization failed: %s", _tmp20_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	_tmp21_ = self->priv->_database;
	zeitgeist_sq_lite_database_set_cache_size (_tmp21_, 128);
	return obj;
}

static void
zeitgeist_db_reader_class_init (ZeitgeistDbReaderClass * klass,
                                gpointer klass_data)
{
	zeitgeist_db_reader_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ZeitgeistDbReader_private_offset);
	((ZeitgeistDbReaderClass *) klass)->close = (void (*) (ZeitgeistDbReader*)) zeitgeist_db_reader_real_close;
	G_OBJECT_CLASS (klass)->get_property = _vala_zeitgeist_db_reader_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_zeitgeist_db_reader_set_property;
	G_OBJECT_CLASS (klass)->constructor = zeitgeist_db_reader_constructor;
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_db_reader_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_DB_READER_DATABASE_PROPERTY, zeitgeist_db_reader_properties[ZEITGEIST_DB_READER_DATABASE_PROPERTY] = g_param_spec_object ("database", "database", "database", ZEITGEIST_SQ_LITE_TYPE_DATABASE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
zeitgeist_db_reader_instance_init (ZeitgeistDbReader * self,
                                   gpointer klass)
{
	self->priv = zeitgeist_db_reader_get_instance_private (self);
}

static void
zeitgeist_db_reader_finalize (GObject * obj)
{
	ZeitgeistDbReader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_DB_READER, ZeitgeistDbReader);
	_g_object_unref0 (self->priv->_database);
	_g_object_unref0 (self->interpretations_table);
	_g_object_unref0 (self->manifestations_table);
	_g_object_unref0 (self->mimetypes_table);
	_g_object_unref0 (self->actors_table);
	G_OBJECT_CLASS (zeitgeist_db_reader_parent_class)->finalize (obj);
}

static GType
zeitgeist_db_reader_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistDbReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_db_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistDbReader), 0, (GInstanceInitFunc) zeitgeist_db_reader_instance_init, NULL };
	GType zeitgeist_db_reader_type_id;
	zeitgeist_db_reader_type_id = g_type_register_static (G_TYPE_OBJECT, "ZeitgeistDbReader", &g_define_type_info, 0);
	ZeitgeistDbReader_private_offset = g_type_add_instance_private (zeitgeist_db_reader_type_id, sizeof (ZeitgeistDbReaderPrivate));
	return zeitgeist_db_reader_type_id;
}

GType
zeitgeist_db_reader_get_type (void)
{
	static volatile gsize zeitgeist_db_reader_type_id__once = 0;
	if (g_once_init_enter (&zeitgeist_db_reader_type_id__once)) {
		GType zeitgeist_db_reader_type_id;
		zeitgeist_db_reader_type_id = zeitgeist_db_reader_get_type_once ();
		g_once_init_leave (&zeitgeist_db_reader_type_id__once, zeitgeist_db_reader_type_id);
	}
	return zeitgeist_db_reader_type_id__once;
}

static void
_vala_zeitgeist_db_reader_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	ZeitgeistDbReader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ZEITGEIST_TYPE_DB_READER, ZeitgeistDbReader);
	switch (property_id) {
		case ZEITGEIST_DB_READER_DATABASE_PROPERTY:
		g_value_set_object (value, zeitgeist_db_reader_get_database (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_zeitgeist_db_reader_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	ZeitgeistDbReader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ZEITGEIST_TYPE_DB_READER, ZeitgeistDbReader);
	switch (property_id) {
		case ZEITGEIST_DB_READER_DATABASE_PROPERTY:
		zeitgeist_db_reader_set_database (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

