﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/chime-sdk-media-pipelines/ChimeSDKMediaPipelinesRequest.h>
#include <aws/chime-sdk-media-pipelines/ChimeSDKMediaPipelines_EXPORTS.h>
#include <aws/chime-sdk-media-pipelines/model/MediaPipelineStatusUpdate.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace ChimeSDKMediaPipelines {
namespace Model {

/**
 */
class UpdateMediaInsightsPipelineStatusRequest : public ChimeSDKMediaPipelinesRequest {
 public:
  AWS_CHIMESDKMEDIAPIPELINES_API UpdateMediaInsightsPipelineStatusRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "UpdateMediaInsightsPipelineStatus"; }

  AWS_CHIMESDKMEDIAPIPELINES_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The unique identifier of the resource to be updated. Valid values include the
   * ID and ARN of the media insights pipeline.</p>
   */
  inline const Aws::String& GetIdentifier() const { return m_identifier; }
  inline bool IdentifierHasBeenSet() const { return m_identifierHasBeenSet; }
  template <typename IdentifierT = Aws::String>
  void SetIdentifier(IdentifierT&& value) {
    m_identifierHasBeenSet = true;
    m_identifier = std::forward<IdentifierT>(value);
  }
  template <typename IdentifierT = Aws::String>
  UpdateMediaInsightsPipelineStatusRequest& WithIdentifier(IdentifierT&& value) {
    SetIdentifier(std::forward<IdentifierT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The requested status of the media insights pipeline.</p>
   */
  inline MediaPipelineStatusUpdate GetUpdateStatus() const { return m_updateStatus; }
  inline bool UpdateStatusHasBeenSet() const { return m_updateStatusHasBeenSet; }
  inline void SetUpdateStatus(MediaPipelineStatusUpdate value) {
    m_updateStatusHasBeenSet = true;
    m_updateStatus = value;
  }
  inline UpdateMediaInsightsPipelineStatusRequest& WithUpdateStatus(MediaPipelineStatusUpdate value) {
    SetUpdateStatus(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_identifier;

  MediaPipelineStatusUpdate m_updateStatus{MediaPipelineStatusUpdate::NOT_SET};
  bool m_identifierHasBeenSet = false;
  bool m_updateStatusHasBeenSet = false;
};

}  // namespace Model
}  // namespace ChimeSDKMediaPipelines
}  // namespace Aws
