﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/imagebuilder/Imagebuilder_EXPORTS.h>
#include <aws/imagebuilder/model/InstanceMetadataOptions.h>
#include <aws/imagebuilder/model/Logging.h>
#include <aws/imagebuilder/model/Placement.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace imagebuilder {
namespace Model {

/**
 * <p>Details of the infrastructure configuration.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/InfrastructureConfiguration">AWS
 * API Reference</a></p>
 */
class InfrastructureConfiguration {
 public:
  AWS_IMAGEBUILDER_API InfrastructureConfiguration() = default;
  AWS_IMAGEBUILDER_API InfrastructureConfiguration(Aws::Utils::Json::JsonView jsonValue);
  AWS_IMAGEBUILDER_API InfrastructureConfiguration& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_IMAGEBUILDER_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the infrastructure configuration.</p>
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  inline bool ArnHasBeenSet() const { return m_arnHasBeenSet; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  InfrastructureConfiguration& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the infrastructure configuration.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  InfrastructureConfiguration& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The description of the infrastructure configuration.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  InfrastructureConfiguration& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The instance types of the infrastructure configuration.</p>
   */
  inline const Aws::Vector<Aws::String>& GetInstanceTypes() const { return m_instanceTypes; }
  inline bool InstanceTypesHasBeenSet() const { return m_instanceTypesHasBeenSet; }
  template <typename InstanceTypesT = Aws::Vector<Aws::String>>
  void SetInstanceTypes(InstanceTypesT&& value) {
    m_instanceTypesHasBeenSet = true;
    m_instanceTypes = std::forward<InstanceTypesT>(value);
  }
  template <typename InstanceTypesT = Aws::Vector<Aws::String>>
  InfrastructureConfiguration& WithInstanceTypes(InstanceTypesT&& value) {
    SetInstanceTypes(std::forward<InstanceTypesT>(value));
    return *this;
  }
  template <typename InstanceTypesT = Aws::String>
  InfrastructureConfiguration& AddInstanceTypes(InstanceTypesT&& value) {
    m_instanceTypesHasBeenSet = true;
    m_instanceTypes.emplace_back(std::forward<InstanceTypesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The instance profile of the infrastructure configuration.</p>
   */
  inline const Aws::String& GetInstanceProfileName() const { return m_instanceProfileName; }
  inline bool InstanceProfileNameHasBeenSet() const { return m_instanceProfileNameHasBeenSet; }
  template <typename InstanceProfileNameT = Aws::String>
  void SetInstanceProfileName(InstanceProfileNameT&& value) {
    m_instanceProfileNameHasBeenSet = true;
    m_instanceProfileName = std::forward<InstanceProfileNameT>(value);
  }
  template <typename InstanceProfileNameT = Aws::String>
  InfrastructureConfiguration& WithInstanceProfileName(InstanceProfileNameT&& value) {
    SetInstanceProfileName(std::forward<InstanceProfileNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The security group IDs of the infrastructure configuration.</p>
   */
  inline const Aws::Vector<Aws::String>& GetSecurityGroupIds() const { return m_securityGroupIds; }
  inline bool SecurityGroupIdsHasBeenSet() const { return m_securityGroupIdsHasBeenSet; }
  template <typename SecurityGroupIdsT = Aws::Vector<Aws::String>>
  void SetSecurityGroupIds(SecurityGroupIdsT&& value) {
    m_securityGroupIdsHasBeenSet = true;
    m_securityGroupIds = std::forward<SecurityGroupIdsT>(value);
  }
  template <typename SecurityGroupIdsT = Aws::Vector<Aws::String>>
  InfrastructureConfiguration& WithSecurityGroupIds(SecurityGroupIdsT&& value) {
    SetSecurityGroupIds(std::forward<SecurityGroupIdsT>(value));
    return *this;
  }
  template <typename SecurityGroupIdsT = Aws::String>
  InfrastructureConfiguration& AddSecurityGroupIds(SecurityGroupIdsT&& value) {
    m_securityGroupIdsHasBeenSet = true;
    m_securityGroupIds.emplace_back(std::forward<SecurityGroupIdsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The subnet ID of the infrastructure configuration.</p>
   */
  inline const Aws::String& GetSubnetId() const { return m_subnetId; }
  inline bool SubnetIdHasBeenSet() const { return m_subnetIdHasBeenSet; }
  template <typename SubnetIdT = Aws::String>
  void SetSubnetId(SubnetIdT&& value) {
    m_subnetIdHasBeenSet = true;
    m_subnetId = std::forward<SubnetIdT>(value);
  }
  template <typename SubnetIdT = Aws::String>
  InfrastructureConfiguration& WithSubnetId(SubnetIdT&& value) {
    SetSubnetId(std::forward<SubnetIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The logging configuration of the infrastructure configuration.</p>
   */
  inline const Logging& GetLogging() const { return m_logging; }
  inline bool LoggingHasBeenSet() const { return m_loggingHasBeenSet; }
  template <typename LoggingT = Logging>
  void SetLogging(LoggingT&& value) {
    m_loggingHasBeenSet = true;
    m_logging = std::forward<LoggingT>(value);
  }
  template <typename LoggingT = Logging>
  InfrastructureConfiguration& WithLogging(LoggingT&& value) {
    SetLogging(std::forward<LoggingT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon EC2 key pair of the infrastructure configuration.</p>
   */
  inline const Aws::String& GetKeyPair() const { return m_keyPair; }
  inline bool KeyPairHasBeenSet() const { return m_keyPairHasBeenSet; }
  template <typename KeyPairT = Aws::String>
  void SetKeyPair(KeyPairT&& value) {
    m_keyPairHasBeenSet = true;
    m_keyPair = std::forward<KeyPairT>(value);
  }
  template <typename KeyPairT = Aws::String>
  InfrastructureConfiguration& WithKeyPair(KeyPairT&& value) {
    SetKeyPair(std::forward<KeyPairT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The terminate instance on failure configuration of the infrastructure
   * configuration.</p>
   */
  inline bool GetTerminateInstanceOnFailure() const { return m_terminateInstanceOnFailure; }
  inline bool TerminateInstanceOnFailureHasBeenSet() const { return m_terminateInstanceOnFailureHasBeenSet; }
  inline void SetTerminateInstanceOnFailure(bool value) {
    m_terminateInstanceOnFailureHasBeenSet = true;
    m_terminateInstanceOnFailure = value;
  }
  inline InfrastructureConfiguration& WithTerminateInstanceOnFailure(bool value) {
    SetTerminateInstanceOnFailure(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) for the SNS topic to which we send image build
   * event notifications.</p>  <p>EC2 Image Builder is unable to send
   * notifications to SNS topics that are encrypted using keys from other accounts.
   * The key that is used to encrypt the SNS topic must reside in the account that
   * the Image Builder service runs under.</p>
   */
  inline const Aws::String& GetSnsTopicArn() const { return m_snsTopicArn; }
  inline bool SnsTopicArnHasBeenSet() const { return m_snsTopicArnHasBeenSet; }
  template <typename SnsTopicArnT = Aws::String>
  void SetSnsTopicArn(SnsTopicArnT&& value) {
    m_snsTopicArnHasBeenSet = true;
    m_snsTopicArn = std::forward<SnsTopicArnT>(value);
  }
  template <typename SnsTopicArnT = Aws::String>
  InfrastructureConfiguration& WithSnsTopicArn(SnsTopicArnT&& value) {
    SetSnsTopicArn(std::forward<SnsTopicArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The date on which the infrastructure configuration was created.</p>
   */
  inline const Aws::String& GetDateCreated() const { return m_dateCreated; }
  inline bool DateCreatedHasBeenSet() const { return m_dateCreatedHasBeenSet; }
  template <typename DateCreatedT = Aws::String>
  void SetDateCreated(DateCreatedT&& value) {
    m_dateCreatedHasBeenSet = true;
    m_dateCreated = std::forward<DateCreatedT>(value);
  }
  template <typename DateCreatedT = Aws::String>
  InfrastructureConfiguration& WithDateCreated(DateCreatedT&& value) {
    SetDateCreated(std::forward<DateCreatedT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The date on which the infrastructure configuration was last updated.</p>
   */
  inline const Aws::String& GetDateUpdated() const { return m_dateUpdated; }
  inline bool DateUpdatedHasBeenSet() const { return m_dateUpdatedHasBeenSet; }
  template <typename DateUpdatedT = Aws::String>
  void SetDateUpdated(DateUpdatedT&& value) {
    m_dateUpdatedHasBeenSet = true;
    m_dateUpdated = std::forward<DateUpdatedT>(value);
  }
  template <typename DateUpdatedT = Aws::String>
  InfrastructureConfiguration& WithDateUpdated(DateUpdatedT&& value) {
    SetDateUpdated(std::forward<DateUpdatedT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The tags attached to the resource created by Image Builder.</p>
   */
  inline const Aws::Map<Aws::String, Aws::String>& GetResourceTags() const { return m_resourceTags; }
  inline bool ResourceTagsHasBeenSet() const { return m_resourceTagsHasBeenSet; }
  template <typename ResourceTagsT = Aws::Map<Aws::String, Aws::String>>
  void SetResourceTags(ResourceTagsT&& value) {
    m_resourceTagsHasBeenSet = true;
    m_resourceTags = std::forward<ResourceTagsT>(value);
  }
  template <typename ResourceTagsT = Aws::Map<Aws::String, Aws::String>>
  InfrastructureConfiguration& WithResourceTags(ResourceTagsT&& value) {
    SetResourceTags(std::forward<ResourceTagsT>(value));
    return *this;
  }
  template <typename ResourceTagsKeyT = Aws::String, typename ResourceTagsValueT = Aws::String>
  InfrastructureConfiguration& AddResourceTags(ResourceTagsKeyT&& key, ResourceTagsValueT&& value) {
    m_resourceTagsHasBeenSet = true;
    m_resourceTags.emplace(std::forward<ResourceTagsKeyT>(key), std::forward<ResourceTagsValueT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The instance metadata option settings for the infrastructure
   * configuration.</p>
   */
  inline const InstanceMetadataOptions& GetInstanceMetadataOptions() const { return m_instanceMetadataOptions; }
  inline bool InstanceMetadataOptionsHasBeenSet() const { return m_instanceMetadataOptionsHasBeenSet; }
  template <typename InstanceMetadataOptionsT = InstanceMetadataOptions>
  void SetInstanceMetadataOptions(InstanceMetadataOptionsT&& value) {
    m_instanceMetadataOptionsHasBeenSet = true;
    m_instanceMetadataOptions = std::forward<InstanceMetadataOptionsT>(value);
  }
  template <typename InstanceMetadataOptionsT = InstanceMetadataOptions>
  InfrastructureConfiguration& WithInstanceMetadataOptions(InstanceMetadataOptionsT&& value) {
    SetInstanceMetadataOptions(std::forward<InstanceMetadataOptionsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The tags of the infrastructure configuration.</p>
   */
  inline const Aws::Map<Aws::String, Aws::String>& GetTags() const { return m_tags; }
  inline bool TagsHasBeenSet() const { return m_tagsHasBeenSet; }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  void SetTags(TagsT&& value) {
    m_tagsHasBeenSet = true;
    m_tags = std::forward<TagsT>(value);
  }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  InfrastructureConfiguration& WithTags(TagsT&& value) {
    SetTags(std::forward<TagsT>(value));
    return *this;
  }
  template <typename TagsKeyT = Aws::String, typename TagsValueT = Aws::String>
  InfrastructureConfiguration& AddTags(TagsKeyT&& key, TagsValueT&& value) {
    m_tagsHasBeenSet = true;
    m_tags.emplace(std::forward<TagsKeyT>(key), std::forward<TagsValueT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The instance placement settings that define where the instances that are
   * launched from your image will run.</p>
   */
  inline const Placement& GetPlacement() const { return m_placement; }
  inline bool PlacementHasBeenSet() const { return m_placementHasBeenSet; }
  template <typename PlacementT = Placement>
  void SetPlacement(PlacementT&& value) {
    m_placementHasBeenSet = true;
    m_placement = std::forward<PlacementT>(value);
  }
  template <typename PlacementT = Placement>
  InfrastructureConfiguration& WithPlacement(PlacementT&& value) {
    SetPlacement(std::forward<PlacementT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_arn;

  Aws::String m_name;

  Aws::String m_description;

  Aws::Vector<Aws::String> m_instanceTypes;

  Aws::String m_instanceProfileName;

  Aws::Vector<Aws::String> m_securityGroupIds;

  Aws::String m_subnetId;

  Logging m_logging;

  Aws::String m_keyPair;

  bool m_terminateInstanceOnFailure{false};

  Aws::String m_snsTopicArn;

  Aws::String m_dateCreated;

  Aws::String m_dateUpdated;

  Aws::Map<Aws::String, Aws::String> m_resourceTags;

  InstanceMetadataOptions m_instanceMetadataOptions;

  Aws::Map<Aws::String, Aws::String> m_tags;

  Placement m_placement;
  bool m_arnHasBeenSet = false;
  bool m_nameHasBeenSet = false;
  bool m_descriptionHasBeenSet = false;
  bool m_instanceTypesHasBeenSet = false;
  bool m_instanceProfileNameHasBeenSet = false;
  bool m_securityGroupIdsHasBeenSet = false;
  bool m_subnetIdHasBeenSet = false;
  bool m_loggingHasBeenSet = false;
  bool m_keyPairHasBeenSet = false;
  bool m_terminateInstanceOnFailureHasBeenSet = false;
  bool m_snsTopicArnHasBeenSet = false;
  bool m_dateCreatedHasBeenSet = false;
  bool m_dateUpdatedHasBeenSet = false;
  bool m_resourceTagsHasBeenSet = false;
  bool m_instanceMetadataOptionsHasBeenSet = false;
  bool m_tagsHasBeenSet = false;
  bool m_placementHasBeenSet = false;
};

}  // namespace Model
}  // namespace imagebuilder
}  // namespace Aws
