/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.diagnostics.FirDiagnosticHolder;
import org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ$\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f*\u00020\u00102\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u000e\u0010\u0012\u001a\u0004\u0018\u00010\u0010*\u00020\u0010H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirCommonConstructorDelegationIssuesChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;)V", "findCycle", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirConstructorSymbol;", "knownCyclicConstructors", "getDelegated", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirCommonConstructorDelegationIssuesChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirCommonConstructorDelegationIssuesChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirCommonConstructorDelegationIssuesChecker\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,105:1\n59#2,11:106\n23#2,2:117\n1869#3,2:119\n1869#3,2:122\n22#4:121\n*S KotlinDebug\n*F\n+ 1 FirCommonConstructorDelegationIssuesChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirCommonConstructorDelegationIssuesChecker\n*L\n30#1:106,11\n30#1:117,2\n40#1:119,2\n75#1:122,2\n68#1:121\n*E\n"})
public final class FirCommonConstructorDelegationIssuesChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirCommonConstructorDelegationIssuesChecker INSTANCE = new FirCommonConstructorDelegationIssuesChecker();

    private FirCommonConstructorDelegationIssuesChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirRegularClass declaration) {
        FirConstructorSymbol it;
        Iterator<Object> iterator2;
        block15: {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Iterable $this$lastIsInstanceOrNull$iv = context2.getContainingDeclarations();
            boolean $i$f$lastIsInstanceOrNull = false;
            if ($this$lastIsInstanceOrNull$iv instanceof List) {
                int n2 = ((Collection)$this$lastIsInstanceOrNull$iv).size() + -1;
                if (0 <= n2) {
                    do {
                        int i$iv;
                        Iterator<Object> element$iv;
                        if (!((element$iv = ((List)$this$lastIsInstanceOrNull$iv).get(i$iv = n2--)) instanceof FirRegularClassSymbol)) continue;
                        iterator2 = element$iv;
                        break block15;
                    } while (0 <= n2);
                }
                iterator2 = null;
            } else {
                Iterable $this$firstIsInstanceOrNull$iv$iv = CollectionsKt.reversed((Iterable)$this$lastIsInstanceOrNull$iv);
                boolean $i$f$firstIsInstanceOrNull = false;
                for (Object element$iv$iv : $this$firstIsInstanceOrNull$iv$iv) {
                    if (!(element$iv$iv instanceof FirRegularClassSymbol)) continue;
                    iterator2 = (Iterator<Object>)element$iv$iv;
                    break block15;
                }
                iterator2 = null;
            }
        }
        FirRegularClassSymbol containingClass = (FirRegularClassSymbol)((Object)iterator2);
        if (DeclarationUtilsKt.isEffectivelyExternal(context2, declaration, (FirClassSymbol)containingClass)) {
            return;
        }
        Set cyclicConstructors = new LinkedHashSet();
        boolean hasPrimaryConstructor = false;
        Object $i$f$firstIsInstanceOrNull = CollectionsKt.lastOrNull(context2.getContainingDeclarations());
        boolean isEffectivelyExpect = DeclarationUtilsKt.isEffectivelyExpect(context2, declaration, (FirClassSymbol)($i$f$firstIsInstanceOrNull instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)$i$f$firstIsInstanceOrNull : null));
        Set otherConstructors = new LinkedHashSet();
        Object $this$forEach$iv = org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt.constructors(declaration, context2.getSession());
        boolean $i$f$forEach = false;
        Iterator iterator3 = $this$forEach$iv.iterator();
        while (iterator3.hasNext()) {
            Object element$iv = iterator3.next();
            it = (FirConstructorSymbol)element$iv;
            boolean bl = false;
            if (!it.isPrimary() || FirDeclarationUtilKt.isErrorPrimaryConstructor(it)) {
                ((Collection)otherConstructors).add(it);
                if (INSTANCE.findCycle(it, cyclicConstructors) != null) {
                    Set<FirConstructorSymbol> visited2;
                    boolean bl2 = false;
                    CollectionsKt.addAll((Collection)cyclicConstructors, (Iterable)visited2);
                }
                continue;
            }
            hasPrimaryConstructor = true;
        }
        CollectionsKt.removeAll((Collection)otherConstructors, (Iterable)cyclicConstructors);
        if (hasPrimaryConstructor) {
            for (FirConstructorSymbol it2 : otherConstructors) {
                if (isEffectivelyExpect) continue;
                FirDelegatedConstructorCall firDelegatedConstructorCall = it2.getResolvedDelegatedConstructorCall();
                if (firDelegatedConstructorCall != null ? firDelegatedConstructorCall.isThis() : false) continue;
                DiagnosticContext diagnosticContext2 = context2;
                Object object = it2.getResolvedDelegatedConstructorCall();
                if (object == null || (object = ((FirDelegatedConstructorCall)object).getSource()) == null) {
                    object = it2.getSource();
                }
                KtDiagnosticReportHelpersKt.reportOn$default(diagnosticContext2, reporter, (AbstractKtSourceElement)object, FirErrors.INSTANCE.getPRIMARY_CONSTRUCTOR_DELEGATION_CALL_EXPECTED(), null, 8, null);
            }
        } else {
            for (FirConstructorSymbol it3 : otherConstructors) {
                Object object;
                FirDelegatedConstructorCall firDelegatedConstructorCall = it3.getResolvedDelegatedConstructorCall();
                if (!((firDelegatedConstructorCall != null ? firDelegatedConstructorCall.getCalleeReference() : null) instanceof FirDiagnosticHolder) || !(((object = it3.getResolvedDelegatedConstructorCall()) != null && (object = ((FirDelegatedConstructorCall)object).getSource()) != null ? ((KtSourceElement)object).getKind() : null) instanceof KtFakeSourceElementKind)) continue;
                FirCallableSymbol $this$isExpect$iv = it3;
                boolean $i$f$isExpect = false;
                if ($this$isExpect$iv.getRawStatus().isExpect()) continue;
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)it3.getSource(), FirErrors.INSTANCE.getEXPLICIT_DELEGATION_CALL_REQUIRED(), null, 8, null);
            }
        }
        $this$forEach$iv = cyclicConstructors;
        $i$f$forEach = false;
        iterator3 = $this$forEach$iv.iterator();
        while (iterator3.hasNext()) {
            Object element$iv = iterator3.next();
            it = (FirConstructorSymbol)element$iv;
            boolean bl = false;
            FirDelegatedConstructorCall firDelegatedConstructorCall = it.getResolvedDelegatedConstructorCall();
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)(firDelegatedConstructorCall != null ? firDelegatedConstructorCall.getSource() : null), FirErrors.INSTANCE.getCYCLIC_CONSTRUCTOR_DELEGATION_CALL(), null, 8, null);
        }
    }

    private final Set<FirConstructorSymbol> findCycle(FirConstructorSymbol $this$findCycle, Set<FirConstructorSymbol> knownCyclicConstructors) {
        Object[] objectArray = new FirConstructorSymbol[]{$this$findCycle};
        Set visitedConstructors = SetsKt.mutableSetOf((Object[])objectArray);
        FirConstructorSymbol it = $this$findCycle;
        FirConstructorSymbol delegated = this.getDelegated($this$findCycle);
        while ((!it.isPrimary() || FirDeclarationUtilKt.isErrorPrimaryConstructor(it)) && delegated != null) {
            if (visitedConstructors.contains(delegated) || knownCyclicConstructors.contains(delegated)) {
                return visitedConstructors;
            }
            it = delegated;
            delegated = this.getDelegated(delegated);
            visitedConstructors.add(it);
        }
        return null;
    }

    private final FirConstructorSymbol getDelegated(FirConstructorSymbol $this$getDelegated) {
        FirLazyDeclarationResolverKt.lazyResolveToPhase($this$getDelegated, FirResolvePhase.BODY_RESOLVE);
        FirPureAbstractElement firPureAbstractElement = ((FirConstructor)$this$getDelegated.getFir()).getDelegatedConstructor();
        return firPureAbstractElement != null && (firPureAbstractElement = firPureAbstractElement.getCalleeReference()) != null ? FirReferenceUtilsKt.toResolvedConstructorSymbol((FirReference)firPureAbstractElement, true) : null;
    }
}

