/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.cc.impl;

import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.internal.tasks.TaskDependencyUsageTracker;
import org.gradle.internal.cc.impl.CoupledProjectsListener;
import org.gradle.internal.configuration.problems.ProblemFactory;
import org.gradle.internal.configuration.problems.ProblemsListener;
import org.gradle.internal.configuration.problems.PropertyProblem;
import org.gradle.internal.configuration.problems.StructuredMessage;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u0016\u0010\u0011\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\b\u0010\u0012\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/gradle/internal/cc/impl/ReportingTaskDependencyUsageTracker;", "Lorg/gradle/api/internal/tasks/TaskDependencyUsageTracker;", "referrer", "Lorg/gradle/api/internal/project/ProjectInternal;", "coupledProjectsListener", "Lorg/gradle/internal/cc/impl/CoupledProjectsListener;", "problems", "Lorg/gradle/internal/configuration/problems/ProblemsListener;", "problemFactory", "Lorg/gradle/internal/configuration/problems/ProblemFactory;", "<init>", "(Lorg/gradle/api/internal/project/ProjectInternal;Lorg/gradle/internal/cc/impl/CoupledProjectsListener;Lorg/gradle/internal/configuration/problems/ProblemsListener;Lorg/gradle/internal/configuration/problems/ProblemFactory;)V", "onTaskDependencyUsage", "", "taskDependencies", "", "Lorg/gradle/api/Task;", "checkForCoupledProjects", "reportProjectIsolationProblemOnApiUsage", "configuration-cache"})
@SourceDebugExtension(value={"SMAP\nReportingTaskDependencyUsageTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReportingTaskDependencyUsageTracker.kt\norg/gradle/internal/cc/impl/ReportingTaskDependencyUsageTracker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,61:1\n1869#2,2:62\n*S KotlinDebug\n*F\n+ 1 ReportingTaskDependencyUsageTracker.kt\norg/gradle/internal/cc/impl/ReportingTaskDependencyUsageTracker\n*L\n42#1:62,2\n*E\n"})
public final class ReportingTaskDependencyUsageTracker
implements TaskDependencyUsageTracker {
    @NotNull
    private final ProjectInternal referrer;
    @NotNull
    private final CoupledProjectsListener coupledProjectsListener;
    @NotNull
    private final ProblemsListener problems;
    @NotNull
    private final ProblemFactory problemFactory;

    public ReportingTaskDependencyUsageTracker(@NotNull ProjectInternal referrer, @NotNull CoupledProjectsListener coupledProjectsListener, @NotNull ProblemsListener problems2, @NotNull ProblemFactory problemFactory) {
        Intrinsics.checkNotNullParameter((Object)referrer, (String)"referrer");
        Intrinsics.checkNotNullParameter((Object)coupledProjectsListener, (String)"coupledProjectsListener");
        Intrinsics.checkNotNullParameter((Object)problems2, (String)"problems");
        Intrinsics.checkNotNullParameter((Object)problemFactory, (String)"problemFactory");
        this.referrer = referrer;
        this.coupledProjectsListener = coupledProjectsListener;
        this.problems = problems2;
        this.problemFactory = problemFactory;
    }

    public void onTaskDependencyUsage(@NotNull Set<? extends Task> taskDependencies) {
        Intrinsics.checkNotNullParameter(taskDependencies, (String)"taskDependencies");
        this.checkForCoupledProjects(taskDependencies);
        this.reportProjectIsolationProblemOnApiUsage();
    }

    private final void checkForCoupledProjects(Set<? extends Task> taskDependencies) {
        Iterable $this$forEach$iv = taskDependencies;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Task task = (Task)element$iv;
            boolean bl = false;
            Project project = task.getProject();
            Intrinsics.checkNotNull((Object)project, (String)"null cannot be cast to non-null type org.gradle.api.internal.project.ProjectInternal");
            ProjectInternal otherProject = (ProjectInternal)project;
            ProjectState projectState = this.referrer.getOwner();
            Intrinsics.checkNotNullExpressionValue((Object)projectState, (String)"getOwner(...)");
            ProjectState projectState2 = otherProject.getOwner();
            Intrinsics.checkNotNullExpressionValue((Object)projectState2, (String)"getOwner(...)");
            this.coupledProjectsListener.onProjectReference(projectState, projectState2);
        }
    }

    private final void reportProjectIsolationProblemOnApiUsage() {
        PropertyProblem problem = ProblemFactory.problem$default((ProblemFactory)this.problemFactory, null, arg_0 -> ReportingTaskDependencyUsageTracker.reportProjectIsolationProblemOnApiUsage$lambda$0(this, arg_0), (int)1, null).exception().build();
        this.problems.onProblem(problem);
    }

    private static final Unit reportProjectIsolationProblemOnApiUsage$lambda$0(ReportingTaskDependencyUsageTracker this$0, StructuredMessage.Builder $this$problem) {
        Intrinsics.checkNotNullParameter((Object)$this$problem, (String)"$this$problem");
        $this$problem.text("Project ");
        String string = this$0.referrer.getIdentityPath().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        $this$problem.reference(string);
        $this$problem.text(" cannot access task dependencies directly");
        return Unit.INSTANCE;
    }
}

