/**
 * @template {Node} [Tree=Node]
 * @template {any} [Options=unknown]
 * @param {string | RuleMeta} meta
 * @param {Rule<Tree, Options>} rule
 * @returns {import('unified').Plugin<Array<void> | [Options | [boolean | Label | Severity, (Options | undefined)?]], Tree>}
 */
export function lintRule<
  Tree extends import('unist').Node<
    import('unist').Data
  > = import('unist').Node<import('unist').Data>,
  Options extends unknown = unknown
>(
  meta: string | RuleMeta,
  rule: Rule<Tree, Options>
): import('unified').Plugin<
  void[] | [Options | [boolean | Label | Severity, (Options | undefined)?]],
  Tree,
  Tree
>
export type Node = import('unist').Node
export type VFile = import('vfile').VFile
/**
 * Numeric severity (`0`: `'off'`, `1`: `'on'`, `2`: `'error'`).
 */
export type Severity = 0 | 1 | 2
/**
 * Severity label (`'off'`: `0`, `'on'`: `1`, `'error'`: `2`).
 */
export type Label = 'warn' | 'on' | 'off' | 'error'
/**
 * Parsed severty and options.
 */
export type SeverityTuple = [Severity, ...Array<unknown>]
/**
 * Rule metadata.
 */
export type RuleMeta = {
  /**
   *   Name of the lint rule.
   */
  origin: string
  /**
   * Link to documentation.
   */
  url?: string | null | undefined
}
export type Rule<
  Tree extends import('unist').Node<
    import('unist').Data
  > = import('unist').Node<import('unist').Data>,
  Options extends unknown = unknown
> = (
  tree: Tree,
  file: VFile,
  options: Options
) => Promise<Tree | undefined | void> | Tree | undefined | void
