/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.calculation;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.calculation.AbstractCalculation;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;

final class SizeInRange
extends AbstractCalculation<Boolean>
implements ListEventListener {
    private final EventList source;
    private final int min;
    private final int max;

    public SizeInRange(EventList source, int min, int max) {
        super(new Boolean(source.size() >= min && source.size() <= max));
        if (min > max) {
            throw new IllegalArgumentException("min must be less than max");
        }
        this.source = source;
        this.source.addListEventListener(this);
        this.min = min;
        this.max = max;
    }

    @Override
    public void dispose() {
        this.source.removeListEventListener(this);
    }

    public void listChanged(ListEvent listChanges) {
        Boolean oldValue = (Boolean)this.getValue();
        int size = listChanges.getSourceList().size();
        this.setValue(new Boolean(size >= this.min && size <= this.max));
        Boolean newValue = (Boolean)this.getValue();
        this.fireValueChange(oldValue, newValue);
    }
}

