/*
 * Decompiled with CFR 0.152.
 */
package retrofit2.converter.jackson;

import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import retrofit2.Converter;
import retrofit2.converter.jackson.JacksonStreamingRequestBody;

final class JacksonRequestBodyConverter<T>
implements Converter<T, RequestBody> {
    private final ObjectWriter adapter;
    private final MediaType mediaType;
    private final boolean streaming;

    JacksonRequestBodyConverter(ObjectWriter adapter, MediaType mediaType, boolean streaming) {
        this.adapter = adapter;
        this.mediaType = mediaType;
        this.streaming = streaming;
    }

    public RequestBody convert(T value) throws IOException {
        if (this.streaming) {
            return new JacksonStreamingRequestBody(this.adapter, value, this.mediaType);
        }
        byte[] bytes = this.adapter.writeValueAsBytes(value);
        return RequestBody.create((MediaType)this.mediaType, (byte[])bytes);
    }
}

