/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.store.remote.filecache;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.common.inject.Provider;
import org.opensearch.common.util.io.IOUtils;
import org.opensearch.core.index.Index;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.env.NodeEnvironment;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.shard.ShardPath;
import org.opensearch.index.store.IndexStoreListener;
import org.opensearch.index.store.remote.filecache.FileCache;
import org.opensearch.index.store.remote.utils.FileTypeUtils;

public class FileCacheCleaner
implements IndexStoreListener {
    private static final Logger logger = LogManager.getLogger(FileCacheCleaner.class);
    private final Provider<FileCache> fileCacheProvider;

    public FileCacheCleaner(Provider<FileCache> fileCacheProvider) {
        this.fileCacheProvider = fileCacheProvider;
    }

    @Override
    public void beforeShardPathDeleted(ShardId shardId, IndexSettings indexSettings, NodeEnvironment nodeEnvironment) {
        if (indexSettings.isRemoteSnapshot()) {
            ShardPath shardPath = ShardPath.loadFileCachePath(nodeEnvironment, shardId);
            this.cleanupShardFileCache(shardPath, false, true);
            this.deleteShardFileCacheDirectory(shardPath);
        } else if (indexSettings.isWarmIndex()) {
            try {
                ShardPath shardPath = ShardPath.loadShardPath(logger, nodeEnvironment, shardId, indexSettings.customDataPath());
                if (shardPath != null) {
                    this.cleanupShardFileCache(shardPath, true, false);
                    this.deleteShardFileCacheDirectory(shardPath);
                }
            }
            catch (IOException e) {
                logger.error("failed to delete warm index shard file cache directory", (Throwable)e);
            }
        }
    }

    private void cleanupShardFileCache(ShardPath shardPath, boolean isWarmIndex, boolean isRemoteSnapshot) {
        try {
            Path localStorePath;
            FileCache fc = this.fileCacheProvider.get();
            assert (fc != null);
            if (isWarmIndex) {
                localStorePath = shardPath.getDataPath().resolve(FileTypeUtils.INDICES_FOLDER_IDENTIFIER);
            } else if (isRemoteSnapshot) {
                localStorePath = shardPath.getDataPath().resolve("RemoteLocalStore");
            } else {
                return;
            }
            try (DirectoryStream<Path> ds = Files.newDirectoryStream(localStorePath);){
                for (Path subPath : ds) {
                    fc.remove(subPath.toRealPath(new LinkOption[0]));
                }
            }
        }
        catch (IOException ioe) {
            String operationType = isWarmIndex ? "warm index" : "remote snapshot";
            logger.error(() -> new ParameterizedMessage("Error removing items from cache during {} shard deletion {}", (Object)operationType, (Object)shardPath.getShardId()), (Throwable)ioe);
        }
    }

    private void deleteShardFileCacheDirectory(ShardPath shardPath) {
        Path path = shardPath.getDataPath();
        try {
            if (Files.exists(path, new LinkOption[0])) {
                IOUtils.rm((Path[])new Path[]{path});
            }
        }
        catch (IOException e) {
            logger.error(() -> new ParameterizedMessage("Failed to delete cache path for shard {}", (Object)shardPath.getShardId()), (Throwable)e);
        }
    }

    @Override
    public void beforeIndexPathDeleted(Index index, IndexSettings indexSettings, NodeEnvironment nodeEnvironment) {
        Path indicesPathInCache;
        if (indexSettings.isRemoteSnapshot()) {
            Path indexCachePath = nodeEnvironment.fileCacheNodePath().fileCachePath.resolve(index.getUUID());
            if (Files.exists(indexCachePath, new LinkOption[0])) {
                try {
                    IOUtils.rm((Path[])new Path[]{indexCachePath});
                }
                catch (IOException e) {
                    logger.error(() -> new ParameterizedMessage("Failed to delete cache path for index {}", (Object)index), (Throwable)e);
                }
            }
        } else if (indexSettings.isWarmIndex() && Files.exists(indicesPathInCache = nodeEnvironment.fileCacheNodePath().indicesPath.resolve(index.getUUID()), new LinkOption[0])) {
            try {
                IOUtils.rm((Path[])new Path[]{indicesPathInCache});
            }
            catch (IOException e) {
                logger.error(() -> new ParameterizedMessage("Failed to delete indices path in cache for index {}", (Object)index), (Throwable)e);
            }
        }
    }
}

