/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.mapping;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.mapping.DocValuesPropertyBase;
import org.opensearch.client.opensearch._types.mapping.Property;
import org.opensearch.client.opensearch._types.mapping.PropertyVariant;
import org.opensearch.client.opensearch.indices.NumericFielddata;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class BooleanProperty
extends DocValuesPropertyBase
implements PropertyVariant,
ToCopyableBuilder<Builder, BooleanProperty> {
    @Nullable
    private final Double boost;
    @Nullable
    private final NumericFielddata fielddata;
    @Nullable
    private final Boolean index;
    @Nullable
    private final Boolean nullValue;
    public static final JsonpDeserializer<BooleanProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, BooleanProperty::setupBooleanPropertyDeserializer);

    private BooleanProperty(Builder builder) {
        super(builder);
        this.boost = builder.boost;
        this.fielddata = builder.fielddata;
        this.index = builder.index;
        this.nullValue = builder.nullValue;
    }

    public static BooleanProperty of(Function<Builder, ObjectBuilder<BooleanProperty>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Property.Kind _propertyKind() {
        return Property.Kind.Boolean;
    }

    @Nullable
    public final Double boost() {
        return this.boost;
    }

    @Nullable
    public final NumericFielddata fielddata() {
        return this.fielddata;
    }

    @Nullable
    public final Boolean index() {
        return this.index;
    }

    @Nullable
    public final Boolean nullValue() {
        return this.nullValue;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "boolean");
        super.serializeInternal(generator, mapper);
        if (this.boost != null) {
            generator.writeKey("boost");
            generator.write(this.boost.doubleValue());
        }
        if (this.fielddata != null) {
            generator.writeKey("fielddata");
            this.fielddata.serialize(generator, mapper);
        }
        if (this.index != null) {
            generator.writeKey("index");
            generator.write(this.index.booleanValue());
        }
        if (this.nullValue != null) {
            generator.writeKey("null_value");
            generator.write(this.nullValue.booleanValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupBooleanPropertyDeserializer(ObjectDeserializer<Builder> op) {
        BooleanProperty.setupDocValuesPropertyBaseDeserializer(op);
        op.add(Builder::boost, JsonpDeserializer.doubleDeserializer(), "boost");
        op.add(Builder::fielddata, NumericFielddata._DESERIALIZER, "fielddata");
        op.add(Builder::index, JsonpDeserializer.booleanDeserializer(), "index");
        op.add(Builder::nullValue, JsonpDeserializer.booleanDeserializer(), "null_value");
        op.ignore("type");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.boost);
        result = 31 * result + Objects.hashCode(this.fielddata);
        result = 31 * result + Objects.hashCode(this.index);
        result = 31 * result + Objects.hashCode(this.nullValue);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BooleanProperty other = (BooleanProperty)o;
        return Objects.equals(this.boost, other.boost) && Objects.equals(this.fielddata, other.fielddata) && Objects.equals(this.index, other.index) && Objects.equals(this.nullValue, other.nullValue);
    }

    public static class Builder
    extends DocValuesPropertyBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, BooleanProperty> {
        @Nullable
        private Double boost;
        @Nullable
        private NumericFielddata fielddata;
        @Nullable
        private Boolean index;
        @Nullable
        private Boolean nullValue;

        public Builder() {
        }

        private Builder(BooleanProperty o) {
            super(o);
            this.boost = o.boost;
            this.fielddata = o.fielddata;
            this.index = o.index;
            this.nullValue = o.nullValue;
        }

        private Builder(Builder o) {
            super(o);
            this.boost = o.boost;
            this.fielddata = o.fielddata;
            this.index = o.index;
            this.nullValue = o.nullValue;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder boost(@Nullable Double value) {
            this.boost = value;
            return this;
        }

        @Nonnull
        public final Builder fielddata(@Nullable NumericFielddata value) {
            this.fielddata = value;
            return this;
        }

        @Nonnull
        public final Builder fielddata(Function<NumericFielddata.Builder, ObjectBuilder<NumericFielddata>> fn) {
            return this.fielddata(fn.apply(new NumericFielddata.Builder()).build());
        }

        @Nonnull
        public final Builder index(@Nullable Boolean value) {
            this.index = value;
            return this;
        }

        @Nonnull
        public final Builder nullValue(@Nullable Boolean value) {
            this.nullValue = value;
            return this;
        }

        @Override
        @Nonnull
        public BooleanProperty build() {
            this._checkSingleUse();
            return new BooleanProperty(this);
        }
    }
}

