/*
 * Decompiled with CFR 0.152.
 */
package SearchConfigToInfo_Compile;

import CompoundBeacon_Compile.BeaconPart;
import DynamoDbEncryptionUtil_Compile.__default;
import Wrappers_Compile.Result;
import dafny.DafnySequence;
import dafny.DafnySet;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.Objects;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.Error;

public class PartSet {
    public DafnySequence<? extends BeaconPart> _parts;
    public DafnySet<? extends DafnySequence<? extends Character>> _names;
    public DafnySet<? extends DafnySequence<? extends Character>> _prefixes;
    private static final TypeDescriptor<PartSet> _TYPE = TypeDescriptor.referenceWithInitializer(PartSet.class, () -> PartSet.Default());
    private static final PartSet theDefault = PartSet.create((DafnySequence<? extends BeaconPart>)DafnySequence.empty(BeaconPart._typeDescriptor()), (DafnySet<? extends DafnySequence<? extends Character>>)DafnySet.empty(), (DafnySet<? extends DafnySequence<? extends Character>>)DafnySet.empty());

    public PartSet(DafnySequence<? extends BeaconPart> parts, DafnySet<? extends DafnySequence<? extends Character>> names, DafnySet<? extends DafnySequence<? extends Character>> prefixes) {
        this._parts = parts;
        this._names = names;
        this._prefixes = prefixes;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        PartSet o = (PartSet)other;
        return Objects.equals(this._parts, o._parts) && Objects.equals(this._names, o._names) && Objects.equals(this._prefixes, o._prefixes);
    }

    public int hashCode() {
        long hash = 5381L;
        hash = (hash << 5) + hash + 0L;
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._parts);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._names);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._prefixes);
        return (int)hash;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("SearchConfigToInfo.PartSet.PartSet");
        s.append("(");
        s.append(Helpers.toString(this._parts));
        s.append(", ");
        s.append(Helpers.toString(this._names));
        s.append(", ");
        s.append(Helpers.toString(this._prefixes));
        s.append(")");
        return s.toString();
    }

    public static TypeDescriptor<PartSet> _typeDescriptor() {
        return _TYPE;
    }

    public static PartSet Default() {
        return theDefault;
    }

    public static PartSet create(DafnySequence<? extends BeaconPart> parts, DafnySet<? extends DafnySequence<? extends Character>> names, DafnySet<? extends DafnySequence<? extends Character>> prefixes) {
        return new PartSet(parts, names, prefixes);
    }

    public static PartSet create_PartSet(DafnySequence<? extends BeaconPart> parts, DafnySet<? extends DafnySequence<? extends Character>> names, DafnySet<? extends DafnySequence<? extends Character>> prefixes) {
        return PartSet.create(parts, names, prefixes);
    }

    public boolean is_PartSet() {
        return true;
    }

    public DafnySequence<? extends BeaconPart> dtor_parts() {
        return this._parts;
    }

    public DafnySet<? extends DafnySequence<? extends Character>> dtor_names() {
        return this._names;
    }

    public DafnySet<? extends DafnySequence<? extends Character>> dtor_prefixes() {
        return this._prefixes;
    }

    public Result<PartSet, Error> add(BeaconPart part, DafnySequence<? extends Character> name) {
        if (this.dtor_names().contains(part.getName())) {
            return Result.create_Failure(PartSet._typeDescriptor(), Error._typeDescriptor(), (Object)__default.E((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Duplicate part name "), part.getName()), (DafnySequence)DafnySequence.asString((String)" in ")), name), (DafnySequence)DafnySequence.asString((String)"."))));
        }
        if (this.dtor_prefixes().contains(part.getPrefix())) {
            return Result.create_Failure(PartSet._typeDescriptor(), Error._typeDescriptor(), (Object)__default.E((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Duplicate prefix "), part.getPrefix()), (DafnySequence)DafnySequence.asString((String)" in ")), name), (DafnySequence)DafnySequence.asString((String)"."))));
        }
        return Result.create_Success(PartSet._typeDescriptor(), Error._typeDescriptor(), (Object)PartSet.create((DafnySequence<? extends BeaconPart>)DafnySequence.concatenate(this.dtor_parts(), (DafnySequence)DafnySequence.of(BeaconPart._typeDescriptor(), (Object[])new BeaconPart[]{part})), (DafnySet<? extends DafnySequence<? extends Character>>)DafnySet.union(this.dtor_names(), (DafnySet)DafnySet.of((Object[])new DafnySequence[]{part.getName()})), (DafnySet<? extends DafnySequence<? extends Character>>)DafnySet.union(this.dtor_prefixes(), (DafnySet)DafnySet.of((Object[])new DafnySequence[]{part.getPrefix()}))));
    }

    public DafnySequence<? extends Character> GetSetAsString(DafnySet<? extends DafnySequence<? extends Character>> strings) {
        DafnySequence _0_names = SortedSets.__default.SetToOrderedSequence2((TypeDescriptor)TypeDescriptor.CHAR, strings, __default::CharLess);
        return StandardLibrary_Compile.__default.Join((TypeDescriptor)TypeDescriptor.CHAR, (DafnySequence)_0_names, (DafnySequence)DafnySequence.asString((String)", "));
    }

    public Result<PartSet, Error> combine(PartSet other, DafnySequence<? extends Character> name, DafnySequence<? extends Character> otherName) {
        if (BigInteger.valueOf(DafnySet.intersection(this.dtor_names(), other.dtor_names()).size()).signum() != 0) {
            DafnySequence<? extends Character> _0_tags = this.GetSetAsString((DafnySet<? extends DafnySequence<? extends Character>>)DafnySet.intersection(this.dtor_names(), other.dtor_names()));
            return Result.create_Failure(PartSet._typeDescriptor(), Error._typeDescriptor(), (Object)__default.E((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Duplicate part name(s) "), _0_tags), (DafnySequence)DafnySequence.asString((String)" between ")), name), (DafnySequence)DafnySequence.asString((String)" and ")), otherName), (DafnySequence)DafnySequence.asString((String)"."))));
        }
        if (BigInteger.valueOf(DafnySet.intersection(this.dtor_prefixes(), other.dtor_prefixes()).size()).signum() != 0) {
            DafnySequence<? extends Character> _1_tags = this.GetSetAsString((DafnySet<? extends DafnySequence<? extends Character>>)DafnySet.intersection(this.dtor_prefixes(), other.dtor_prefixes()));
            return Result.create_Failure(PartSet._typeDescriptor(), Error._typeDescriptor(), (Object)__default.E((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Duplicate prefix(es) "), _1_tags), (DafnySequence)DafnySequence.asString((String)" between ")), name), (DafnySequence)DafnySequence.asString((String)" and ")), otherName), (DafnySequence)DafnySequence.asString((String)"."))));
        }
        return Result.create_Success(PartSet._typeDescriptor(), Error._typeDescriptor(), (Object)PartSet.create((DafnySequence<? extends BeaconPart>)DafnySequence.concatenate(this.dtor_parts(), other.dtor_parts()), (DafnySet<? extends DafnySequence<? extends Character>>)DafnySet.union(this.dtor_names(), other.dtor_names()), (DafnySet<? extends DafnySequence<? extends Character>>)DafnySet.union(this.dtor_prefixes(), other.dtor_prefixes())));
    }
}

