// Copyright (C) 2016 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR GPL-3.0-only WITH Qt-GPL-exception-1.0

#ifndef ABSTRACTFORMWINDOWCURSOR_H
#define ABSTRACTFORMWINDOWCURSOR_H

#include <QtDesigner/sdk_global.h>

QT_BEGIN_NAMESPACE

class QDesignerFormWindowInterface;
class QWidget;
class QVariant;
class QString;

class QDESIGNER_SDK_EXPORT QDesignerFormWindowCursorInterface
{
public:
    Q_DISABLE_COPY_MOVE(QDesignerFormWindowCursorInterface)

    enum MoveOperation
    {
        NoMove,

        Start,
        End,
        Next,
        Prev,
        Left,
        Right,
        Up,
        Down
    };

    enum MoveMode
    {
        MoveAnchor,
        KeepAnchor
    };

    QDesignerFormWindowCursorInterface() = default;
    virtual ~QDesignerFormWindowCursorInterface() = default;

    virtual QDesignerFormWindowInterface *formWindow() const = 0;

    virtual bool movePosition(MoveOperation op, MoveMode mode = MoveAnchor) = 0;

    virtual int position() const = 0;
    virtual void setPosition(int pos, MoveMode mode = MoveAnchor) = 0;

    virtual QWidget *current() const = 0;

    virtual int widgetCount() const = 0;
    virtual QWidget *widget(int index) const = 0;

    virtual bool hasSelection() const = 0;
    virtual int selectedWidgetCount() const = 0;
    virtual QWidget *selectedWidget(int index) const = 0;

    virtual void setProperty(const QString &name, const QVariant &value) = 0;
    virtual void setWidgetProperty(QWidget *widget, const QString &name, const QVariant &value) = 0;
    virtual void resetWidgetProperty(QWidget *widget, const QString &name) = 0;

    bool isWidgetSelected(QWidget *widget) const;
};

QT_END_NAMESPACE

#endif // ABSTRACTFORMWINDOWCURSOR_H
