/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.controls;

import org.dbgl.gui.controls.ControlBuilder;
import org.dbgl.gui.controls.DarkTheme;
import org.dbgl.service.TextService;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class Composite_ {
    private Composite_() {
    }

    public static Builder on(Composite composite) {
        return new Builder(composite);
    }

    public static class Builder
    extends ControlBuilder<Builder> {
        private Layout layout_;
        private String text_;

        public Builder(Composite composite) {
            super(composite, 0, 1, 128, false, false);
        }

        public Builder layout(Layout layout) {
            this.layout_ = layout;
            return this;
        }

        public Builder innerLayout(int numColumns) {
            GridLayout layout = new GridLayout(numColumns, false);
            layout.horizontalSpacing = numColumns == 1 ? 0 : 4;
            layout.verticalSpacing = numColumns == 1 ? 0 : 4;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            this.layout_ = layout;
            return this;
        }

        public Builder vertSpacing() {
            ((GridLayout)this.layout_).verticalSpacing = 4;
            return this;
        }

        public Builder tab(String key) {
            this.text_ = TextService.getInstance().get(key);
            return this;
        }

        public Composite build() {
            Composite composite = new Composite(this.composite_, this.style_);
            if (DarkTheme.forced()) {
                composite.setBackground(this.composite_.getBackground());
            }
            composite.setLayoutData(this.layoutData());
            composite.setLayout(this.layout_);
            if (this.text_ != null) {
                CTabItem tabItem = new CTabItem((CTabFolder)this.composite_, this.style_);
                tabItem.setText("   " + this.text_ + "   ");
                tabItem.setControl(composite);
                ((CTabFolder)this.composite_).setSelection(0);
            }
            return composite;
        }
    }
}

