/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.dialog;

import java.util.stream.Stream;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.gui.abstractdialog.SizeControlledTabbedDialog;
import org.dbgl.gui.controls.Chain;
import org.dbgl.gui.controls.Label_;
import org.dbgl.gui.controls.Mess_;
import org.dbgl.gui.controls.Text_;
import org.dbgl.model.aggregate.Profile;
import org.dbgl.model.conf.Configuration;
import org.dbgl.model.entity.SharedConf;
import org.dbgl.util.StringRelatedUtils;
import org.dbgl.util.SystemUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class ShareConfDialog
extends SizeControlledTabbedDialog<Object> {
    private SharedConf sharedConf_;

    public ShareConfDialog(Shell parent, String gameTitle, String gameYear, Profile profile) {
        super(parent, "shareconfdialog");
        this.sharedConf_ = new SharedConf("", "", gameTitle, "", gameYear, profile.getConfigurationForSharing().toString(null), profile.getCombinedConfiguration().toString(null), "", profile.getDosboxVersion().getTitle(), profile.getDosboxVersion().getVersion());
    }

    @Override
    protected String getDialogTitle() {
        return this.text_.get("dialog.confsharing.title");
    }

    @Override
    protected void onShellCreated() {
        Composite composite = this.createTabWithComposite("dialog.confsharing.tab.info", 3);
        final Text author = Chain.on(composite).lbl(l -> l.key("dialog.confsharing.author")).txt(t -> (Text_.Builder)t.horSpan(2)).text();
        final Text gameTitle = Chain.on(composite).lbl(l -> l.key("dialog.confsharing.gametitle")).txt(t -> (Text_.Builder)t.horSpan(2)).text();
        final Text gameVersion = Chain.on(composite).lbl(l -> l.key("dialog.confsharing.gameversion")).txt(t -> (Text_.Builder)t.horSpan(2)).text();
        final Text gameYear = Chain.on(composite).lbl(l -> l.key("dialog.confsharing.gameyear")).txt(t -> (Text_.Builder)t.horSpan(2)).text();
        Label_.on(composite).key("dialog.confsharing.explanation").build();
        final Tree incrConf = ShareConfDialog.createTree(composite);
        incrConf.setLayoutData(new GridData(4, 4, false, true));
        final Text explanation = Text_.on(composite).multi().wrap().build();
        final Text notes = Chain.on(composite).lbl(l -> l.key("dialog.confsharing.notes")).txt(t -> (Text_.Builder)t.multi().wrap().horSpan(2)).text();
        this.createOkCancelButtons(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                if (!ShareConfDialog.this.isValid(author, gameTitle, gameYear, explanation)) {
                    return;
                }
                try {
                    ShareConfDialog.this.sharedConf_.setAuthor(author.getText());
                    ShareConfDialog.this.sharedConf_.setGameTitle(gameTitle.getText());
                    ShareConfDialog.this.sharedConf_.setGameVersion(gameVersion.getText());
                    ShareConfDialog.this.sharedConf_.setGameYear(gameYear.getText());
                    ShareConfDialog.this.sharedConf_.setIncrConf(ShareConfDialog.extractConfFromTree(incrConf));
                    ShareConfDialog.this.sharedConf_.setExplanation(explanation.getText());
                    ShareConfDialog.this.sharedConf_.setNotes(notes.getText());
                    Client client = ClientBuilder.newClient();
                    SharedConf result = client.target(ShareConfDialog.this.settings_.getValue("confsharing", "endpoint")).path("/submissions").request().post(Entity.entity(ShareConfDialog.this.sharedConf_, "application/xml"), SharedConf.class);
                    Mess_.on(ShareConfDialog.this.shell_).key("dialog.confsharing.confirmation", result.getGameTitle()).display();
                    client.close();
                }
                catch (Exception e) {
                    Mess_.on(ShareConfDialog.this.shell_).key("dialog.confsharing.error.submit", StringRelatedUtils.toString(e)).exception(e).fatal();
                }
                ShareConfDialog.this.settings_.setValue("confsharing", "author", author.getText());
                ShareConfDialog.this.shell_.close();
            }
        });
        author.setText(StringUtils.defaultString(this.settings_.getValue("confsharing", "author")));
        gameTitle.setText(this.sharedConf_.getGameTitle());
        gameYear.setText(this.sharedConf_.getGameYear());
        ShareConfDialog.fillStringIntoTree(this.sharedConf_.getIncrConf(), incrConf);
        if (StringUtils.isBlank(this.sharedConf_.getIncrConf())) {
            explanation.setText("N/A");
        }
        if (StringUtils.isBlank(gameTitle.getText())) {
            gameTitle.setFocus();
        } else if (StringUtils.isBlank(gameYear.getText())) {
            gameYear.setFocus();
        } else if (StringUtils.isBlank(explanation.getText())) {
            explanation.setFocus();
        } else {
            notes.setFocus();
        }
    }

    private boolean isValid(Text author, Text gameTitle, Text gameYear, Text explanation) {
        Mess_.Builder mess = Mess_.on(this.shell_);
        if (StringUtils.isBlank(author.getText())) {
            mess.key("dialog.confsharing.required.author").bind(author);
        }
        if (StringUtils.isBlank(gameTitle.getText())) {
            mess.key("dialog.confsharing.required.gametitle").bind(gameTitle);
        }
        if (StringUtils.isBlank(gameYear.getText())) {
            mess.key("dialog.confsharing.required.gameyear").bind(gameYear);
        }
        if (StringUtils.isBlank(explanation.getText())) {
            mess.key("dialog.confsharing.required.explanation").bind(explanation);
        }
        return mess.valid();
    }

    private static void fillStringIntoTree(String conf, Tree tree) {
        String[] lines = StringUtils.split(conf, SystemUtils.EOLN);
        TreeItem sectionItem = null;
        for (String s : lines) {
            if (s.startsWith("[")) {
                sectionItem = new TreeItem(tree, 0);
                sectionItem.setText(s);
                sectionItem.setChecked(true);
                continue;
            }
            TreeItem node = new TreeItem(sectionItem, 0);
            node.setText(s);
            node.setChecked(true);
        }
        for (TreeItem item : tree.getItems()) {
            item.setExpanded(true);
        }
        tree.addListener(13, event -> {
            if (event.detail == 32) {
                TreeItem tItem = (TreeItem)event.item;
                if (tItem.getParentItem() == null) {
                    tItem.setGrayed(false);
                    for (TreeItem item : tItem.getItems()) {
                        item.setChecked(tItem.getChecked());
                    }
                } else {
                    TreeItem parent;
                    long checkedCount = Stream.of((parent = tItem.getParentItem()).getItems()).filter(TreeItem::getChecked).count();
                    parent.setChecked(checkedCount > 0L);
                    parent.setGrayed(checkedCount > 0L && checkedCount < (long)parent.getItemCount());
                }
            }
        });
    }

    private static String extractConfFromTree(Tree tree) {
        Configuration conf = new Configuration();
        for (TreeItem sectionItem : tree.getItems()) {
            if (!sectionItem.getChecked()) continue;
            for (TreeItem node : sectionItem.getItems()) {
                if (!node.getChecked()) continue;
                String[] v = StringUtils.split(node.getText(), '=');
                conf.setValue(StringUtils.substring(sectionItem.getText(), 1, -1), v[0], v[1]);
            }
        }
        return conf.toString(null);
    }
}

