/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.service;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class CustomEncodingResourceControl
extends ResourceBundle.Control {
    private String encoding_;

    public CustomEncodingResourceControl(String encoding) {
        this.encoding_ = encoding;
    }

    @Override
    public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
        String resourceName = this.toResourceName(this.toBundleName(baseName, locale), "properties");
        if (reload) {
            URLConnection connection;
            URL url = loader.getResource(resourceName);
            if (url != null && (connection = url.openConnection()) != null) {
                connection.setUseCaches(false);
                try (InputStream stream = connection.getInputStream();){
                    PropertyResourceBundle propertyResourceBundle = new PropertyResourceBundle(new InputStreamReader(stream, this.encoding_));
                    return propertyResourceBundle;
                }
            }
        } else {
            try (InputStream stream = loader.getResourceAsStream(resourceName);){
                PropertyResourceBundle propertyResourceBundle = new PropertyResourceBundle(new InputStreamReader(stream, this.encoding_));
                return propertyResourceBundle;
            }
        }
        return null;
    }
}

