/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util.fat;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.dbgl.util.fat.BlockDevice;

class Sector {
    private final BlockDevice device_;
    protected final long offset_;
    protected final ByteBuffer buffer_;

    protected Sector(BlockDevice device, long offset, int size) {
        this.device_ = device;
        this.offset_ = offset;
        this.buffer_ = ByteBuffer.allocate(size);
        this.buffer_.order(ByteOrder.LITTLE_ENDIAN);
    }

    protected void read() throws IOException {
        ((Buffer)this.buffer_).rewind();
        ((Buffer)this.buffer_).limit(this.buffer_.capacity());
        this.device_.read(this.offset_, this.buffer_);
    }

    public BlockDevice getDevice() {
        return this.device_;
    }

    protected int get8(int offset) {
        return this.buffer_.get(offset) & 0xFF;
    }

    protected int get16(int offset) {
        return this.buffer_.getShort(offset) & 0xFFFF;
    }

    protected long get32(int offset) {
        return this.buffer_.getInt(offset);
    }
}

