"use strict";
exports.id = 1239;
exports.ids = [1239];
exports.modules = {

/***/ 1239:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Component)
/* harmony export */ });
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _components_widgets_queue_queueEntry__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6813);
/* harmony import */ var components_services_widget_container__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(8581);
/* harmony import */ var components_services_widget_block__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(403);
/* harmony import */ var utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(4582);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_5__]);
utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_5__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];










function getProgress(sizeLeft, size) {
  return sizeLeft === 0 ? 100 : (1 - sizeLeft / size) * 100;
}

function Component({
  service
}) {
  const {
    t
  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_0__.useTranslation)();
  const {
    widget
  } = service;
  const {
    data: moviesData,
    error: moviesError
  } = (0,utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z)(widget, "movie");
  const {
    data: queuedData,
    error: queuedError
  } = (0,utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z)(widget, "queue/status");
  const {
    data: queueDetailsData,
    error: queueDetailsError
  } = (0,utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z)(widget, "queue/details");
  const formatDownloadState = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(downloadState => {
    switch (downloadState) {
      case "importPending":
        return "import pending";

      case "failedPending":
        return "failed pending";

      default:
        return downloadState;
    }
  }, []);

  if (moviesError || queuedError || queueDetailsError) {
    const finalError = moviesError ?? queuedError ?? queueDetailsError;
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(components_services_widget_container__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
      service: service,
      error: finalError
    });
  }

  if (!moviesData || !queuedData || !queueDetailsData) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(components_services_widget_container__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
      service: service,
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
        label: "radarr.wanted"
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
        label: "radarr.missing"
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
        label: "radarr.queued"
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
        label: "radarr.movies"
      })]
    });
  }

  const enableQueue = widget?.enableQueue && Array.isArray(queueDetailsData) && queueDetailsData.length > 0;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(components_services_widget_container__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
      service: service,
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
        label: "radarr.wanted",
        value: t("common.number", {
          value: moviesData.wanted
        })
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
        label: "radarr.missing",
        value: t("common.number", {
          value: moviesData.missing
        })
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
        label: "radarr.queued",
        value: t("common.number", {
          value: queuedData.totalCount
        })
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
        label: "radarr.movies",
        value: t("common.number", {
          value: moviesData.have
        })
      })]
    }), enableQueue && queueDetailsData.map(queueEntry => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(_components_widgets_queue_queueEntry__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
      progress: getProgress(queueEntry.sizeLeft, queueEntry.size),
      timeLeft: queueEntry.timeLeft,
      title: moviesData.all.find(entry => entry.id === queueEntry.movieId)?.title ?? t("radarr.unknown"),
      activity: formatDownloadState(queueEntry.trackedDownloadState)
    }, `${queueEntry.movieId}-${queueEntry.sizeLeft}`))]
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;