"use strict";
exports.id = 1281;
exports.ids = [1281];
exports.modules = {

/***/ 1281:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Version)
/* harmony export */ });
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5941);
/* harmony import */ var compare_versions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(7795);
/* harmony import */ var compare_versions__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(compare_versions__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_icons_md__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(4041);
/* harmony import */ var react_icons_md__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_icons_md__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([swr__WEBPACK_IMPORTED_MODULE_1__]);
swr__WEBPACK_IMPORTED_MODULE_1__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];







function Version() {
  const {
    t,
    i18n
  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_0__.useTranslation)();
  const buildTime = process.env.NEXT_PUBLIC_BUILDTIME?.length ? process.env.NEXT_PUBLIC_BUILDTIME : new Date().toISOString();
  const revision = process.env.NEXT_PUBLIC_REVISION?.length ? process.env.NEXT_PUBLIC_REVISION : "dev";
  const version = process.env.NEXT_PUBLIC_VERSION?.length ? process.env.NEXT_PUBLIC_VERSION : "dev";
  const {
    data: releaseData
  } = (0,swr__WEBPACK_IMPORTED_MODULE_1__["default"])("/api/releases"); // use Intl.DateTimeFormat to format the date

  const formatDate = date => {
    const options = {
      year: "numeric",
      month: "short",
      day: "numeric"
    };
    return new Intl.DateTimeFormat(i18n.language, options).format(new Date(date));
  };

  const latestRelease = releaseData?.[0];
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
    id: "version",
    className: "flex flex-row items-center",
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx("span", {
      className: "text-xs text-theme-500 dark:text-theme-400",
      children: version === "main" || version === "dev" || version === "nightly" ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.Fragment, {
        children: [version, " (", revision.substring(0, 7), ", ", formatDate(buildTime), ")"]
      }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("a", {
        href: `https://github.com/gethomepage/homepage/releases/tag/${version}`,
        target: "_blank",
        rel: "noopener noreferrer",
        className: "ml-2 text-xs text-theme-500 dark:text-theme-400 flex flex-row items-center",
        children: [version, " (", revision.substring(0, 7), ", ", formatDate(buildTime), ")"]
      })
    }), version === "main" || version === "dev" || version === "nightly" ? null : releaseData && latestRelease && (0,compare_versions__WEBPACK_IMPORTED_MODULE_2__.compareVersions)(latestRelease.tag_name, version) > 0 && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("a", {
      href: latestRelease.html_url,
      target: "_blank",
      rel: "noopener noreferrer",
      className: "ml-2 text-xs text-theme-500 dark:text-theme-400 flex flex-row items-center",
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(react_icons_md__WEBPACK_IMPORTED_MODULE_3__.MdNewReleases, {
        className: "mr-1"
      }), " ", t("Update Available")]
    })]
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;