"use strict";
exports.id = 2225;
exports.ids = [2225];
exports.modules = {

/***/ 2225:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Integration)
/* harmony export */ });
/* harmony import */ var luxon__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2353);
/* harmony import */ var cal_parser__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(3985);
/* harmony import */ var cal_parser__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(cal_parser__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(1377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var rrule__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(6871);
/* harmony import */ var rrule__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(rrule__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(4582);
/* harmony import */ var _components_services_widget_error__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(8659);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([luxon__WEBPACK_IMPORTED_MODULE_0__, _utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_5__]);
([luxon__WEBPACK_IMPORTED_MODULE_0__, _utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_5__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }









function Integration({
  config,
  params,
  setEvents,
  hideErrors
}) {
  const {
    t
  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_3__.useTranslation)();
  const {
    data: icalData,
    error: icalError
  } = (0,_utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z)(config, config.name, {
    refreshInterval: 300000 // 5 minutes

  });
  (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
    let parsedIcal;

    if (!icalError && icalData && !icalData.error) {
      parsedIcal = (0,cal_parser__WEBPACK_IMPORTED_MODULE_1__.parseString)(icalData.data);

      if (parsedIcal.events.length === 0) {
        icalData.error = {
          message: `'${config.name}': ${t("calendar.noEventsFound")}`
        };
      }
    }

    const startDate = luxon__WEBPACK_IMPORTED_MODULE_0__.DateTime.fromISO(params.start);
    const endDate = luxon__WEBPACK_IMPORTED_MODULE_0__.DateTime.fromISO(params.end);

    if (icalError || !parsedIcal || !startDate.isValid || !endDate.isValid) {
      return;
    }

    const eventsToAdd = {};
    const events = parsedIcal?.getEventsBetweenDates(startDate.toJSDate(), endDate.toJSDate());
    events?.forEach(event => {
      let title = `${event?.summary?.value}`;

      if (config?.params?.showName) {
        title = `${config.name}: ${title}`;
      }

      const eventToAdd = (date, i, type) => {
        const duration = event.dtend.value - event.dtstart.value;
        const days = duration / (1000 * 60 * 60 * 24);

        for (let j = 0; j < days; j += 1) {
          eventsToAdd[`${event?.uid?.value}${i}${j}${type}`] = {
            title,
            date: luxon__WEBPACK_IMPORTED_MODULE_0__.DateTime.fromJSDate(date).plus({
              days: j
            }),
            color: config?.color ?? "zinc",
            isCompleted: luxon__WEBPACK_IMPORTED_MODULE_0__.DateTime.fromJSDate(date) < luxon__WEBPACK_IMPORTED_MODULE_0__.DateTime.now(),
            additional: event.location?.value,
            type: "ical"
          };
        }
      };

      if (event?.recurrenceRule?.options) {
        const rule = new rrule__WEBPACK_IMPORTED_MODULE_4__.RRule(event.recurrenceRule.options);
        const recurringEvents = rule.between(startDate.toJSDate(), endDate.toJSDate());
        recurringEvents.forEach((date, i) => eventToAdd(date, i, "recurring"));
        return;
      }

      event.matchingDates.forEach((date, i) => eventToAdd(date, i, "single"));
    });
    setEvents(prevEvents => _objectSpread(_objectSpread({}, prevEvents), eventsToAdd));
  }, [icalData, icalError, config, params, setEvents, t]);
  const error = icalError ?? icalData?.error;
  return error && !hideErrors && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_components_services_widget_error__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
    error: {
      message: `${config.type}: ${error.message ?? error}`
    }
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;