"use strict";
exports.id = 6007;
exports.ids = [6007];
exports.modules = {

/***/ 6007:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Widget)
/* harmony export */ });
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5941);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_icons_fa__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6290);
/* harmony import */ var react_icons_fa__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_icons_fa__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_icons_fi__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(2750);
/* harmony import */ var react_icons_fi__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_icons_fi__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(1377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(9003);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _widget_error__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(1299);
/* harmony import */ var _widget_resource__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(3980);
/* harmony import */ var _widget_resources__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(4534);
/* harmony import */ var _widget_widget_label__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(6850);
/* harmony import */ var utils_contexts_settings__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(9317);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([swr__WEBPACK_IMPORTED_MODULE_0__]);
swr__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }














const cpuSensorLabels = ["cpu_thermal", "Core", "Tctl"];

function convertToFahrenheit(t) {
  return t * 9 / 5 + 32;
}

function Widget({
  options
}) {
  const {
    t,
    i18n
  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_4__.useTranslation)();
  const {
    settings
  } = (0,react__WEBPACK_IMPORTED_MODULE_1__.useContext)(utils_contexts_settings__WEBPACK_IMPORTED_MODULE_10__/* .SettingsContext */ .J);
  const {
    data,
    error
  } = (0,swr__WEBPACK_IMPORTED_MODULE_0__["default"])(`/api/widgets/glances?${new URLSearchParams(_objectSpread({
    lang: i18n.language
  }, options)).toString()}`, {
    refreshInterval: 1500
  });

  if (error || data?.error) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_widget_error__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
      options: options
    });
  }

  if (!data) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)(_widget_resources__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z, {
      options: options,
      additionalClassNames: "information-widget-glances",
      children: [options.cpu !== false && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_widget_resource__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
        icon: react_icons_fi__WEBPACK_IMPORTED_MODULE_3__.FiCpu,
        label: t("glances.wait"),
        percentage: "0"
      }), options.mem !== false && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_widget_resource__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
        icon: react_icons_fa__WEBPACK_IMPORTED_MODULE_2__.FaMemory,
        label: t("glances.wait"),
        percentage: "0"
      }), options.cputemp && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_widget_resource__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
        icon: react_icons_fa__WEBPACK_IMPORTED_MODULE_2__.FaThermometerHalf,
        label: t("glances.wait"),
        percentage: "0"
      }), options.disk && !Array.isArray(options.disk) && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_widget_resource__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
        icon: react_icons_fi__WEBPACK_IMPORTED_MODULE_3__.FiHardDrive,
        label: t("glances.wait"),
        percentage: "0"
      }, options.disk), options.disk && Array.isArray(options.disk) && options.disk.map(disk => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_widget_resource__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
        icon: react_icons_fi__WEBPACK_IMPORTED_MODULE_3__.FiHardDrive,
        label: t("glances.wait"),
        percentage: "0"
      }, `disk_${disk}`)), options.uptime && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_widget_resource__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
        icon: react_icons_fa__WEBPACK_IMPORTED_MODULE_2__.FaRegClock,
        label: t("glances.wait"),
        percentage: "0"
      }), options.label && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_widget_widget_label__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .Z, {
        label: options.label
      })]
    });
  }

  const unit = options.units === "imperial" ? "fahrenheit" : "celsius";
  let mainTemp = 0;
  let maxTemp = 80;
  const cpuSensors = data.sensors?.filter(s => cpuSensorLabels.some(label => s.label.startsWith(label)) && s.type === "temperature_core");

  if (options.cputemp && cpuSensors) {
    try {
      mainTemp = cpuSensors.reduce((acc, s) => acc + s.value, 0) / cpuSensors.length;
      maxTemp = Math.max(cpuSensors.reduce((acc, s) => acc + (s.warning > 0 ? s.warning : 0), 0) / cpuSensors.length, maxTemp);

      if (unit === "fahrenheit") {
        mainTemp = convertToFahrenheit(mainTemp);
        maxTemp = convertToFahrenheit(maxTemp);
      }
    } catch (e) {// cpu sensor retrieval failed
    }
  }

  const tempPercent = Math.round(mainTemp / maxTemp * 100);
  let disks = [];

  if (options.disk) {
    disks = Array.isArray(options.disk) ? options.disk.map(disk => data.fs.find(d => d.mnt_point === disk)).filter(d => d) : [data.fs.find(d => d.mnt_point === options.disk)].filter(d => d);
  }

  const addedClasses = classnames__WEBPACK_IMPORTED_MODULE_5___default()("information-widget-glances", {
    expanded: options.expanded
  });
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)(_widget_resources__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z, {
    options: options,
    target: settings.target ?? "_blank",
    additionalClassNames: addedClasses,
    children: [options.cpu !== false && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_widget_resource__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
      icon: react_icons_fi__WEBPACK_IMPORTED_MODULE_3__.FiCpu,
      value: t("common.number", {
        value: data.cpu.total,
        style: "unit",
        unit: "percent",
        maximumFractionDigits: 0
      }),
      label: t("glances.cpu"),
      expandedValue: t("common.number", {
        value: data.load.min15,
        style: "unit",
        unit: "percent",
        maximumFractionDigits: 0
      }),
      expandedLabel: t("glances.load"),
      percentage: data.cpu.total,
      expanded: options.expanded
    }), options.mem !== false && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_widget_resource__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
      icon: react_icons_fa__WEBPACK_IMPORTED_MODULE_2__.FaMemory,
      value: t("common.bytes", {
        value: data.mem.free,
        maximumFractionDigits: 1,
        binary: true
      }),
      label: t("glances.free"),
      expandedValue: t("common.bytes", {
        value: data.mem.total,
        maximumFractionDigits: 1,
        binary: true
      }),
      expandedLabel: t("glances.total"),
      percentage: data.mem.percent,
      expanded: options.expanded
    }), disks.map(disk => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_widget_resource__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
      icon: react_icons_fi__WEBPACK_IMPORTED_MODULE_3__.FiHardDrive,
      value: t("common.bytes", {
        value: disk.free
      }),
      label: t("glances.free"),
      expandedValue: t("common.bytes", {
        value: disk.size
      }),
      expandedLabel: t("glances.total"),
      percentage: disk.percent,
      expanded: options.expanded
    }, `disk_${disk.mnt_point ?? disk.device_name}`)), options.cputemp && mainTemp > 0 && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_widget_resource__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
      icon: react_icons_fa__WEBPACK_IMPORTED_MODULE_2__.FaThermometerHalf,
      value: t("common.number", {
        value: mainTemp,
        maximumFractionDigits: 1,
        style: "unit",
        unit
      }),
      label: t("glances.temp"),
      expandedValue: t("common.number", {
        value: maxTemp,
        maximumFractionDigits: 1,
        style: "unit",
        unit
      }),
      expandedLabel: t("glances.warn"),
      percentage: tempPercent,
      expanded: options.expanded
    }), options.uptime && data.uptime && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_widget_resource__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
      icon: react_icons_fa__WEBPACK_IMPORTED_MODULE_2__.FaRegClock,
      value: data.uptime.replace(" days,", t("glances.days")).replace(/:\d\d:\d\d$/g, t("glances.hours")),
      label: t("glances.uptime"),
      percentage: Math.round(new Date().getSeconds() / 60 * 100).toString()
    }), options.label && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_widget_widget_label__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .Z, {
      label: options.label
    })]
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 4534:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {


// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ Resources)
});

// EXTERNAL MODULE: external "classnames"
var external_classnames_ = __webpack_require__(9003);
var external_classnames_default = /*#__PURE__*/__webpack_require__.n(external_classnames_);
// EXTERNAL MODULE: ./src/components/widgets/widget/container.jsx
var container = __webpack_require__(4843);
// EXTERNAL MODULE: external "react/jsx-runtime"
var jsx_runtime_ = __webpack_require__(997);
;// CONCATENATED MODULE: ./src/components/widgets/widget/container_link.jsx


function ContainerLink({
  children = [],
  options,
  additionalClassNames = "",
  target
}) {
  return /*#__PURE__*/(0,jsx_runtime_.jsxs)("a", {
    href: options.url,
    target: target,
    className: `${(0,container/* getAllClasses */.Ld)(options, additionalClassNames)} information-widget-link`,
    children: [(0,container/* getInnerBlock */.w_)(children), (0,container/* getBottomBlock */.TS)(children)]
  });
}
// EXTERNAL MODULE: ./src/components/widgets/widget/resource.jsx
var resource = __webpack_require__(3980);
// EXTERNAL MODULE: ./src/components/widgets/widget/raw.jsx
var raw = __webpack_require__(1464);
// EXTERNAL MODULE: ./src/components/widgets/widget/widget_label.jsx
var widget_label = __webpack_require__(6850);
;// CONCATENATED MODULE: ./src/components/widgets/widget/resources.jsx







function Resources({
  options,
  children,
  target,
  additionalClassNames
}) {
  const widgetParts = [].concat(...children);
  const addedClassNames = external_classnames_default()("information-widget-resources", additionalClassNames);
  return /*#__PURE__*/jsx_runtime_.jsx(ContainerLink, {
    options: options,
    target: target,
    additionalClassNames: addedClassNames,
    children: /*#__PURE__*/(0,jsx_runtime_.jsxs)(raw/* default */.Z, {
      children: [/*#__PURE__*/jsx_runtime_.jsx("div", {
        className: "flex flex-row self-center flex-wrap justify-between",
        children: widgetParts.filter(child => child && child.type === resource/* default */.Z)
      }), widgetParts.filter(child => child && child.type === widget_label/* default */.Z)]
    })
  });
}

/***/ }),

/***/ 6850:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ WidgetLabel)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

function WidgetLabel({
  label = ""
}) {
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
    className: "information-widget-label pt-1 text-center text-theme-800 dark:text-theme-200 text-xs",
    children: label
  });
}

/***/ })

};
;