"use strict";
exports.id = 66;
exports.ids = [66];
exports.modules = {

/***/ 66:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Component)
/* harmony export */ });
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_icons_bs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(567);
/* harmony import */ var react_icons_bs__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_icons_bs__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_icons_md__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4041);
/* harmony import */ var react_icons_md__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_icons_md__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var components_services_widget_container__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(8581);
/* harmony import */ var utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(4582);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_4__]);
utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_4__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];
/* eslint-disable camelcase */









function millisecondsToTime(milliseconds) {
  const seconds = Math.floor(milliseconds / 1000 % 60);
  const minutes = Math.floor(milliseconds / (1000 * 60) % 60);
  const hours = Math.floor(milliseconds / (1000 * 60 * 60) % 24);
  return {
    hours,
    minutes,
    seconds
  };
}

function millisecondsToString(milliseconds) {
  const {
    hours,
    minutes,
    seconds
  } = millisecondsToTime(milliseconds);
  const parts = [];

  if (hours > 0) {
    parts.push(hours);
  }

  parts.push(minutes);
  parts.push(seconds);
  return parts.map(part => part.toString().padStart(2, "0")).join(":");
}

function SingleSessionEntry({
  session
}) {
  const {
    full_title,
    duration,
    view_offset,
    progress_percent,
    state,
    video_decision,
    audio_decision
  } = session;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
      className: "text-theme-700 dark:text-theme-200 relative h-5 w-full rounded-md bg-theme-200/50 dark:bg-theme-900/20 mt-1 flex",
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("div", {
        className: "text-xs z-10 self-center ml-2 relative w-full h-4 grow mr-2",
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("div", {
          className: "absolute w-full whitespace-nowrap text-ellipsis overflow-hidden",
          children: full_title
        })
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
        className: "self-center text-xs flex justify-end mr-1.5 pl-1",
        children: [video_decision === "direct play" && audio_decision === "direct play" && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(react_icons_md__WEBPACK_IMPORTED_MODULE_2__.MdSmartDisplay, {
          className: "opacity-50"
        }), video_decision === "copy" && audio_decision === "copy" && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(react_icons_md__WEBPACK_IMPORTED_MODULE_2__.MdOutlineSmartDisplay, {
          className: "opacity-50"
        }), video_decision !== "copy" && video_decision !== "direct play" && (audio_decision !== "copy" || audio_decision !== "direct play") && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(react_icons_bs__WEBPACK_IMPORTED_MODULE_1__.BsFillCpuFill, {
          className: "opacity-50"
        }), (video_decision === "copy" || video_decision === "direct play") && audio_decision !== "copy" && audio_decision !== "direct play" && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(react_icons_bs__WEBPACK_IMPORTED_MODULE_1__.BsCpu, {
          className: "opacity-50"
        })]
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
      className: "text-theme-700 dark:text-theme-200 relative h-5 w-full rounded-md bg-theme-200/50 dark:bg-theme-900/20 mt-1 flex",
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("div", {
        className: "absolute h-5 rounded-md bg-theme-200 dark:bg-theme-900/40 z-0",
        style: {
          width: `${progress_percent}%`
        }
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
        className: "text-xs z-10 self-center ml-1",
        children: [state === "paused" && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(react_icons_bs__WEBPACK_IMPORTED_MODULE_1__.BsPauseFill, {
          className: "inline-block w-4 h-4 cursor-pointer -mt-[1px] mr-1 opacity-80"
        }), state !== "paused" && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(react_icons_bs__WEBPACK_IMPORTED_MODULE_1__.BsFillPlayFill, {
          className: "inline-block w-4 h-4 cursor-pointer -mt-[1px] mr-1 opacity-80"
        })]
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("div", {
        className: "grow "
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
        className: "self-center text-xs flex justify-end mr-2 z-10",
        children: [millisecondsToString(view_offset), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("span", {
          className: "mx-0.5 text-[8px]",
          children: "/"
        }), millisecondsToString(duration)]
      })]
    })]
  });
}

function SessionEntry({
  session
}) {
  const {
    full_title,
    view_offset,
    progress_percent,
    state,
    video_decision,
    audio_decision
  } = session;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
    className: "text-theme-700 dark:text-theme-200 relative h-5 w-full rounded-md bg-theme-200/50 dark:bg-theme-900/20 mt-1 flex",
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("div", {
      className: "absolute h-5 rounded-md bg-theme-200 dark:bg-theme-900/40 z-0",
      style: {
        width: `${progress_percent}%`
      }
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
      className: "text-xs z-10 self-center ml-1",
      children: [state === "paused" && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(react_icons_bs__WEBPACK_IMPORTED_MODULE_1__.BsPauseFill, {
        className: "inline-block w-4 h-4 cursor-pointer -mt-[1px] mr-1 opacity-80"
      }), state !== "paused" && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(react_icons_bs__WEBPACK_IMPORTED_MODULE_1__.BsFillPlayFill, {
        className: "inline-block w-4 h-4 cursor-pointer -mt-[1px] mr-1 opacity-80"
      })]
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("div", {
      className: "text-xs z-10 self-center ml-2 relative w-full h-4 grow mr-2",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("div", {
        className: "absolute w-full whitespace-nowrap text-ellipsis overflow-hidden",
        children: full_title
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
      className: "self-center text-xs flex justify-end mr-1.5 pl-1 z-10",
      children: [video_decision === "direct play" && audio_decision === "direct play" && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(react_icons_md__WEBPACK_IMPORTED_MODULE_2__.MdSmartDisplay, {
        className: "opacity-50"
      }), video_decision === "copy" && audio_decision === "copy" && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(react_icons_md__WEBPACK_IMPORTED_MODULE_2__.MdOutlineSmartDisplay, {
        className: "opacity-50"
      }), video_decision !== "copy" && video_decision !== "direct play" && (audio_decision !== "copy" || audio_decision !== "direct play") && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(react_icons_bs__WEBPACK_IMPORTED_MODULE_1__.BsFillCpuFill, {
        className: "opacity-50"
      }), (video_decision === "copy" || video_decision === "direct play") && audio_decision !== "copy" && audio_decision !== "direct play" && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(react_icons_bs__WEBPACK_IMPORTED_MODULE_1__.BsCpu, {
        className: "opacity-50"
      })]
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("div", {
      className: "self-center text-xs flex justify-end mr-2 z-10",
      children: millisecondsToString(view_offset)
    })]
  });
}

function Component({
  service
}) {
  const {
    t
  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_0__.useTranslation)();
  const {
    widget
  } = service;
  const {
    data: activityData,
    error: activityError
  } = (0,utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z)(widget, "get_activity", {
    refreshInterval: 5000
  });

  if (activityError || activityData && Object.keys(activityData.response.data).length === 0) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(components_services_widget_container__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
      service: service,
      error: activityError ?? {
        message: t("tautulli.plex_connection_error")
      }
    });
  }

  if (!activityData) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
      className: "flex flex-col pb-1 mx-1",
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("div", {
        className: "text-theme-700 dark:text-theme-200 text-xs relative h-5 w-full rounded-md bg-theme-200/50 dark:bg-theme-900/20 mt-1",
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("span", {
          className: "absolute left-2 text-xs mt-[2px]",
          children: "-"
        })
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("div", {
        className: "text-theme-700 dark:text-theme-200 text-xs relative h-5 w-full rounded-md bg-theme-200/50 dark:bg-theme-900/20 mt-1",
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("span", {
          className: "absolute left-2 text-xs mt-[2px]",
          children: "-"
        })
      })]
    });
  }

  const playing = activityData.response.data.sessions.sort((a, b) => {
    if (a.view_offset > b.view_offset) {
      return 1;
    }

    if (a.view_offset < b.view_offset) {
      return -1;
    }

    return 0;
  });

  if (playing.length === 0) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
      className: "flex flex-col pb-1 mx-1",
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("div", {
        className: "text-theme-700 dark:text-theme-200 text-xs relative h-5 w-full rounded-md bg-theme-200/50 dark:bg-theme-900/20 mt-1",
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("span", {
          className: "absolute left-2 text-xs mt-[2px]",
          children: t("tautulli.no_active")
        })
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("div", {
        className: "text-theme-700 dark:text-theme-200 text-xs relative h-5 w-full rounded-md bg-theme-200/50 dark:bg-theme-900/20 mt-1",
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("span", {
          className: "absolute left-2 text-xs mt-[2px]",
          children: "-"
        })
      })]
    });
  }

  if (playing.length === 1) {
    const session = playing[0];
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("div", {
      className: "flex flex-col pb-1 mx-1",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(SingleSessionEntry, {
        session: session
      })
    });
  }

  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("div", {
    className: "flex flex-col pb-1 mx-1",
    children: playing.map(session => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(SessionEntry, {
      session: session
    }, session.Id))
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;