"use strict";
exports.id = 7429;
exports.ids = [7429];
exports.modules = {

/***/ 7429:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Component)
/* harmony export */ });
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var components_services_widget_container__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8581);
/* harmony import */ var components_services_widget_block__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(403);
/* harmony import */ var utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(4582);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_3__]);
utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_3__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];






function Component({
  service
}) {
  const {
    t
  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_0__.useTranslation)();
  const {
    widget
  } = service;
  const {
    data: torrentData,
    error: torrentError
  } = (0,utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z)(widget, "torrents/info");

  if (torrentError) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_container__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
      service: service,
      error: torrentError
    });
  }

  if (!torrentData) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)(components_services_widget_container__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
      service: service,
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
        label: "qbittorrent.leech"
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
        label: "qbittorrent.download"
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
        label: "qbittorrent.seed"
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
        label: "qbittorrent.upload"
      })]
    });
  }

  let rateDl = 0;
  let rateUl = 0;
  let completed = 0;

  for (let i = 0; i < torrentData.length; i += 1) {
    const torrent = torrentData[i];
    rateDl += torrent.dlspeed;
    rateUl += torrent.upspeed;

    if (torrent.progress === 1) {
      completed += 1;
    }
  }

  const leech = torrentData.length - completed;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)(components_services_widget_container__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
    service: service,
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
      label: "qbittorrent.leech",
      value: t("common.number", {
        value: leech
      })
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
      label: "qbittorrent.download",
      value: t("common.bibyterate", {
        value: rateDl,
        decimals: 1
      })
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
      label: "qbittorrent.seed",
      value: t("common.number", {
        value: completed
      })
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
      label: "qbittorrent.upload",
      value: t("common.bibyterate", {
        value: rateUl,
        decimals: 1
      })
    })]
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;