"use strict";
exports.id = 7517;
exports.ids = [7517];
exports.modules = {

/***/ 7517:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Widget)
/* harmony export */ });
/* harmony import */ var react_icons_bi__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6652);
/* harmony import */ var react_icons_bi__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_icons_bi__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_icons_md__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4041);
/* harmony import */ var react_icons_md__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_icons_md__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_icons_si__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(764);
/* harmony import */ var react_icons_si__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_icons_si__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _widget_error__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(1299);
/* harmony import */ var _widget_container__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(4843);
/* harmony import */ var _widget_raw__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(1464);
/* harmony import */ var _widget_widget_icon__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(6254);
/* harmony import */ var _widget_primary_text__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(8312);
/* harmony import */ var utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(4582);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_8__]);
utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_8__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];












function Widget({
  options
}) {
  const {
    t
  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_2__.useTranslation)(); // eslint-disable-next-line no-param-reassign

  options.type = "unifi_console";
  const {
    data: statsData,
    error: statsError
  } = (0,utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z)(options, "stat/sites", {
    index: options.index
  });

  if (statsError) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx(_widget_error__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
      options: options
    });
  }

  const defaultSite = options.site ? statsData?.data.find(s => s.desc === options.site) : statsData?.data?.find(s => s.name === "default");

  if (!defaultSite) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)(_widget_container__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .ZP, {
      options: options,
      additionalClassNames: "information-widget-unifi-console",
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx(_widget_primary_text__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
        children: t("unifi.wait")
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx(_widget_widget_icon__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
        icon: react_icons_si__WEBPACK_IMPORTED_MODULE_3__.SiUbiquiti
      })]
    });
  }

  const wan = defaultSite.health.find(h => h.subsystem === "wan");
  const lan = defaultSite.health.find(h => h.subsystem === "lan");
  const wlan = defaultSite.health.find(h => h.subsystem === "wlan");
  [wan, lan, wlan].forEach(s => {
    s.up = s.status === "ok"; // eslint-disable-line no-param-reassign

    s.show = s.status !== "unknown"; // eslint-disable-line no-param-reassign
  });
  const name = wan.gw_name ?? defaultSite.desc;
  const uptime = wan["gw_system-stats"] ? wan["gw_system-stats"].uptime : null;
  const dataEmpty = !(wan.show || lan.show || wlan.show || uptime);
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx(_widget_container__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .ZP, {
    options: options,
    additionalClassNames: "information-widget-unifi-console",
    children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx(_widget_raw__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .Z, {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
        className: "flex-none flex flex-row items-center mr-3 py-1.5",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
          className: "flex flex-col",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
            className: "flex flex-row ml-3 mb-0.5",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx(react_icons_si__WEBPACK_IMPORTED_MODULE_3__.SiUbiquiti, {
              className: "text-theme-800 dark:text-theme-200 w-3 h-3 mr-1"
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx("div", {
              className: "text-theme-800 dark:text-theme-200 text-xs font-bold flex flex-row justify-between",
              children: name
            })]
          }), dataEmpty && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx("div", {
            className: "flex flex-row ml-3 text-[8px] justify-between",
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx("div", {
              className: "flex flex-row items-center justify-end",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
                className: "flex flex-row",
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx(react_icons_bi__WEBPACK_IMPORTED_MODULE_0__.BiError, {
                  className: "w-4 h-4 text-theme-800 dark:text-theme-200"
                }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx("span", {
                  className: "text-theme-800 dark:text-theme-200 text-xs",
                  children: t("unifi.empty_data")
                })]
              })
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
            className: "flex flex-row ml-3 text-[10px] justify-between",
            children: [uptime && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
              className: "flex flex-row",
              title: t("unifi.uptime"),
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx("div", {
                className: "pr-0.5 text-theme-800 dark:text-theme-200",
                children: t("common.number", {
                  value: uptime / 86400,
                  maximumFractionDigits: 1
                })
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx("div", {
                className: "pr-1 text-theme-800 dark:text-theme-200",
                children: t("unifi.days")
              })]
            }), wan.show && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
              className: "flex flex-row",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx("div", {
                className: "pr-1 text-theme-800 dark:text-theme-200",
                children: t("unifi.wan")
              }), wan.up ? /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx(react_icons_bi__WEBPACK_IMPORTED_MODULE_0__.BiCheckCircle, {
                className: "text-theme-800 dark:text-theme-200 h-4 w-3"
              }) : /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx(react_icons_bi__WEBPACK_IMPORTED_MODULE_0__.BiXCircle, {
                className: "text-theme-800 dark:text-theme-200 h-4 w-3"
              })]
            }), !wan.show && !lan.show && wlan.show && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
              className: "flex flex-row",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx("div", {
                className: "pr-1 text-theme-800 dark:text-theme-200",
                children: t("unifi.wlan")
              }), wlan.up ? /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx(react_icons_bi__WEBPACK_IMPORTED_MODULE_0__.BiCheckCircle, {
                className: "text-theme-800 dark:text-theme-200 h-4 w-3"
              }) : /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx(react_icons_bi__WEBPACK_IMPORTED_MODULE_0__.BiXCircle, {
                className: "text-theme-800 dark:text-theme-200 h-4 w-3"
              })]
            }), !wan.show && !wlan.show && lan.show && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
              className: "flex flex-row",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx("div", {
                className: "pr-1 text-theme-800 dark:text-theme-200",
                children: t("unifi.lan")
              }), lan.up ? /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx(react_icons_bi__WEBPACK_IMPORTED_MODULE_0__.BiCheckCircle, {
                className: "text-theme-800 dark:text-theme-200 h-4 w-3"
              }) : /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx(react_icons_bi__WEBPACK_IMPORTED_MODULE_0__.BiXCircle, {
                className: "text-theme-800 dark:text-theme-200 h-4 w-3"
              })]
            })]
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
          className: "flex flex-col",
          children: [wlan.show && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
            className: "flex flex-row ml-3 py-0.5",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx(react_icons_bi__WEBPACK_IMPORTED_MODULE_0__.BiWifi, {
              className: "text-theme-800 dark:text-theme-200 w-4 h-4 mr-1"
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx("div", {
              className: "text-theme-800 dark:text-theme-200 text-xs flex flex-row justify-between",
              title: t("unifi.users"),
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx("div", {
                className: "pr-0.5",
                children: t("common.number", {
                  value: wlan.num_user,
                  maximumFractionDigits: 0
                })
              })
            })]
          }), lan.show && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
            className: "flex flex-row ml-3 pb-0.5",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx(react_icons_md__WEBPACK_IMPORTED_MODULE_1__.MdSettingsEthernet, {
              className: "text-theme-800 dark:text-theme-200 w-4 h-4 mr-1"
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx("div", {
              className: "text-theme-800 dark:text-theme-200 text-xs flex flex-row justify-between",
              title: t("unifi.users"),
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx("div", {
                className: "pr-0.5",
                children: t("common.number", {
                  value: lan.num_user,
                  maximumFractionDigits: 0
                })
              })
            })]
          }), (wlan.show && !lan.show || !wlan.show && lan.show) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsxs)("div", {
            className: "flex flex-row ml-3 py-0.5",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx(react_icons_bi__WEBPACK_IMPORTED_MODULE_0__.BiNetworkChart, {
              className: "text-theme-800 dark:text-theme-200 w-4 h-4 mr-1"
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx("div", {
              className: "text-theme-800 dark:text-theme-200 text-xs flex flex-row justify-between",
              title: t("unifi.devices"),
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_9__.jsx("div", {
                className: "pr-0.5",
                children: t("common.number", {
                  value: wlan.show ? wlan.num_adopted : lan.num_adopted,
                  maximumFractionDigits: 0
                })
              })
            })]
          })]
        })]
      })
    })
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 1299:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ Error)
/* harmony export */ });
/* harmony import */ var react_i18next__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9709);
/* harmony import */ var react_i18next__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_i18next__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_icons_bi__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6652);
/* harmony import */ var react_icons_bi__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_icons_bi__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _container__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4843);
/* harmony import */ var _primary_text__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(8312);
/* harmony import */ var _widget_icon__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(6254);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__);







function Error({
  options
}) {
  const {
    t
  } = (0,react_i18next__WEBPACK_IMPORTED_MODULE_0__.useTranslation)();
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)(_container__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .ZP, {
    options: options,
    additionalClassNames: "information-widget-error",
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_primary_text__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
      children: t("widget.api_error")
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_widget_icon__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
      icon: react_icons_bi__WEBPACK_IMPORTED_MODULE_1__.BiError,
      size: "l"
    })]
  });
}

/***/ })

};
;