"use strict";
exports.id = 7704;
exports.ids = [7704];
exports.modules = {

/***/ 7704:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Bh": () => (/* binding */ getPrivateWidgetOptions),
/* harmony export */   "qz": () => (/* binding */ cleanWidgetGroups),
/* harmony export */   "uN": () => (/* binding */ widgetsFromConfig)
/* harmony export */ });
/* harmony import */ var fs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7147);
/* harmony import */ var fs__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(fs__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var path__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(1017);
/* harmony import */ var path__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(path__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var js_yaml__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(626);
/* harmony import */ var utils_config_config__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(5732);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([js_yaml__WEBPACK_IMPORTED_MODULE_2__, utils_config_config__WEBPACK_IMPORTED_MODULE_3__]);
([js_yaml__WEBPACK_IMPORTED_MODULE_2__, utils_config_config__WEBPACK_IMPORTED_MODULE_3__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }





async function widgetsFromConfig() {
  (0,utils_config_config__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .ZP)("widgets.yaml");
  const widgetsYaml = path__WEBPACK_IMPORTED_MODULE_1___default().join(utils_config_config__WEBPACK_IMPORTED_MODULE_3__/* .CONF_DIR */ .Fn, "widgets.yaml");
  const rawFileContents = await fs__WEBPACK_IMPORTED_MODULE_0__.promises.readFile(widgetsYaml, "utf8");
  const fileContents = (0,utils_config_config__WEBPACK_IMPORTED_MODULE_3__/* .substituteEnvironmentVars */ .AI)(rawFileContents);
  const widgets = js_yaml__WEBPACK_IMPORTED_MODULE_2__["default"].load(fileContents);
  if (!widgets) return []; // map easy to write YAML objects into easy to consume JS arrays

  const widgetsArray = widgets.map((group, index) => ({
    type: Object.keys(group)[0],
    options: _objectSpread({
      index
    }, group[Object.keys(group)[0]])
  }));
  return widgetsArray;
}
async function cleanWidgetGroups(widgets) {
  return widgets.map((widget, index) => {
    const sanitizedOptions = widget.options;
    const optionKeys = Object.keys(sanitizedOptions); // delete private options from the sanitized options

    ["username", "password", "key"].forEach(pO => {
      if (optionKeys.includes(pO)) {
        delete sanitizedOptions[pO];
      }
    }); // delete url from the sanitized options if the widget is not a search or glances widgeth

    if (widget.type !== "search" && widget.type !== "glances" && optionKeys.includes("url")) {
      delete sanitizedOptions.url;
    }

    return {
      type: widget.type,
      options: _objectSpread({
        index
      }, sanitizedOptions)
    };
  });
}
async function getPrivateWidgetOptions(type, widgetIndex) {
  const widgets = await widgetsFromConfig();
  const privateOptions = widgets.map(widget => {
    const {
      index,
      url,
      username,
      password,
      key
    } = widget.options;
    return {
      type: widget.type,
      options: {
        index,
        url,
        username,
        password,
        key
      }
    };
  });
  return type !== undefined && widgetIndex !== undefined ? privateOptions.find(o => o.type === type && o.options.index === parseInt(widgetIndex, 10))?.options : privateOptions;
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;