"use strict";
exports.id = 7765;
exports.ids = [7765];
exports.modules = {

/***/ 201:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ getKubeConfig)
/* harmony export */ });
/* harmony import */ var path__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1017);
/* harmony import */ var path__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(path__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var fs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7147);
/* harmony import */ var fs__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(fs__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var js_yaml__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(626);
/* harmony import */ var _kubernetes_client_node__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(276);
/* harmony import */ var _kubernetes_client_node__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_kubernetes_client_node__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var utils_config_config__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(5732);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([js_yaml__WEBPACK_IMPORTED_MODULE_2__, utils_config_config__WEBPACK_IMPORTED_MODULE_4__]);
([js_yaml__WEBPACK_IMPORTED_MODULE_2__, utils_config_config__WEBPACK_IMPORTED_MODULE_4__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);





function getKubeConfig() {
  (0,utils_config_config__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .ZP)("kubernetes.yaml");
  const configFile = path__WEBPACK_IMPORTED_MODULE_0___default().join(utils_config_config__WEBPACK_IMPORTED_MODULE_4__/* .CONF_DIR */ .Fn, "kubernetes.yaml");
  const rawConfigData = (0,fs__WEBPACK_IMPORTED_MODULE_1__.readFileSync)(configFile, "utf8");
  const configData = (0,utils_config_config__WEBPACK_IMPORTED_MODULE_4__/* .substituteEnvironmentVars */ .AI)(rawConfigData);
  const config = js_yaml__WEBPACK_IMPORTED_MODULE_2__["default"].load(configData);
  const kc = new _kubernetes_client_node__WEBPACK_IMPORTED_MODULE_3__.KubeConfig();

  switch (config?.mode) {
    case "cluster":
      kc.loadFromCluster();
      break;

    case "default":
      kc.loadFromDefault();
      break;

    case "disabled":
    default:
      return null;
  }

  return kc;
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 7765:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FM": () => (/* binding */ getServiceItem),
/* harmony export */   "ZP": () => (/* binding */ getServiceWidget),
/* harmony export */   "ah": () => (/* binding */ servicesFromConfig),
/* harmony export */   "gr": () => (/* binding */ cleanServiceGroups),
/* harmony export */   "iP": () => (/* binding */ servicesFromKubernetes),
/* harmony export */   "kr": () => (/* binding */ servicesFromDocker)
/* harmony export */ });
/* unused harmony export checkCRD */
/* harmony import */ var fs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7147);
/* harmony import */ var fs__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(fs__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var path__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(1017);
/* harmony import */ var path__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(path__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var js_yaml__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(626);
/* harmony import */ var dockerode__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(4856);
/* harmony import */ var dockerode__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(dockerode__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _kubernetes_client_node__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(276);
/* harmony import */ var _kubernetes_client_node__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_kubernetes_client_node__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var utils_logger__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(2330);
/* harmony import */ var utils_config_config__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(5732);
/* harmony import */ var utils_config_docker__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(2156);
/* harmony import */ var utils_config_kubernetes__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(201);
/* harmony import */ var utils_config_shvl__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(384);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([js_yaml__WEBPACK_IMPORTED_MODULE_2__, utils_logger__WEBPACK_IMPORTED_MODULE_5__, utils_config_config__WEBPACK_IMPORTED_MODULE_6__, utils_config_docker__WEBPACK_IMPORTED_MODULE_7__, utils_config_kubernetes__WEBPACK_IMPORTED_MODULE_8__]);
([js_yaml__WEBPACK_IMPORTED_MODULE_2__, utils_logger__WEBPACK_IMPORTED_MODULE_5__, utils_config_config__WEBPACK_IMPORTED_MODULE_6__, utils_config_docker__WEBPACK_IMPORTED_MODULE_7__, utils_config_kubernetes__WEBPACK_IMPORTED_MODULE_8__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
const _excluded = ["name", "group"],
      _excluded2 = ["name", "group"];

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }











const logger = (0,utils_logger__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z)("service-helpers");
async function servicesFromConfig() {
  (0,utils_config_config__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .ZP)("services.yaml");
  const servicesYaml = path__WEBPACK_IMPORTED_MODULE_1___default().join(utils_config_config__WEBPACK_IMPORTED_MODULE_6__/* .CONF_DIR */ .Fn, "services.yaml");
  const rawFileContents = await fs__WEBPACK_IMPORTED_MODULE_0__.promises.readFile(servicesYaml, "utf8");
  const fileContents = (0,utils_config_config__WEBPACK_IMPORTED_MODULE_6__/* .substituteEnvironmentVars */ .AI)(rawFileContents);
  const services = js_yaml__WEBPACK_IMPORTED_MODULE_2__["default"].load(fileContents);

  if (!services) {
    return [];
  } // map easy to write YAML objects into easy to consume JS arrays


  const servicesArray = services.map(servicesGroup => ({
    name: Object.keys(servicesGroup)[0],
    services: servicesGroup[Object.keys(servicesGroup)[0]].map(entries => _objectSpread(_objectSpread({
      name: Object.keys(entries)[0]
    }, entries[Object.keys(entries)[0]]), {}, {
      type: "service"
    }))
  })); // add default weight to services based on their position in the configuration

  servicesArray.forEach((group, groupIndex) => {
    group.services.forEach((service, serviceIndex) => {
      if (!service.weight) {
        servicesArray[groupIndex].services[serviceIndex].weight = (serviceIndex + 1) * 100;
      }
    });
  });
  return servicesArray;
}
async function servicesFromDocker() {
  (0,utils_config_config__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .ZP)("docker.yaml");
  const dockerYaml = path__WEBPACK_IMPORTED_MODULE_1___default().join(utils_config_config__WEBPACK_IMPORTED_MODULE_6__/* .CONF_DIR */ .Fn, "docker.yaml");
  const rawDockerFileContents = await fs__WEBPACK_IMPORTED_MODULE_0__.promises.readFile(dockerYaml, "utf8");
  const dockerFileContents = (0,utils_config_config__WEBPACK_IMPORTED_MODULE_6__/* .substituteEnvironmentVars */ .AI)(rawDockerFileContents);
  const servers = js_yaml__WEBPACK_IMPORTED_MODULE_2__["default"].load(dockerFileContents);

  if (!servers) {
    return [];
  }

  const {
    instanceName
  } = (0,utils_config_config__WEBPACK_IMPORTED_MODULE_6__/* .getSettings */ .Gw)();
  const serviceServers = await Promise.all(Object.keys(servers).map(async serverName => {
    try {
      const isSwarm = !!servers[serverName].swarm;
      const docker = new (dockerode__WEBPACK_IMPORTED_MODULE_3___default())((0,utils_config_docker__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z)(serverName).conn);
      const listProperties = {
        all: true
      };
      const containers = await (isSwarm ? docker.listServices(listProperties) : docker.listContainers(listProperties)); // bad docker connections can result in a <Buffer ...> object?
      // in any case, this ensures the result is the expected array

      if (!Array.isArray(containers)) {
        return [];
      }

      const discovered = containers.map(container => {
        let constructedService = null;
        const containerLabels = isSwarm ? utils_config_shvl__WEBPACK_IMPORTED_MODULE_9__/* .get */ .U(container, "Spec.Labels") : container.Labels;
        const containerName = isSwarm ? utils_config_shvl__WEBPACK_IMPORTED_MODULE_9__/* .get */ .U(container, "Spec.Name") : container.Names[0];
        Object.keys(containerLabels).forEach(label => {
          if (label.startsWith("homepage.")) {
            let value = label.replace("homepage.", "");

            if (instanceName && value.startsWith(`instance.${instanceName}.`)) {
              value = value.replace(`instance.${instanceName}.`, "");
            } else if (value.startsWith("instance.")) {
              return;
            }

            if (!constructedService) {
              constructedService = {
                container: containerName.replace(/^\//, ""),
                server: serverName,
                type: "service"
              };
            }

            utils_config_shvl__WEBPACK_IMPORTED_MODULE_9__/* .set */ .t(constructedService, value, (0,utils_config_config__WEBPACK_IMPORTED_MODULE_6__/* .substituteEnvironmentVars */ .AI)(containerLabels[label]));
          }
        });

        if (!constructedService.name || !constructedService.group) {
          logger.error(`Error constructing service using homepage labels for container '${containerName.replace(/^\//, "")}'. Ensure required labels are present.`);
          return null;
        }

        return constructedService;
      });
      return {
        server: serverName,
        services: discovered.filter(filteredService => filteredService)
      };
    } catch (e) {
      // a server failed, but others may succeed
      return {
        server: serverName,
        services: []
      };
    }
  }));
  const mappedServiceGroups = [];
  serviceServers.forEach(server => {
    server.services.forEach(serverService => {
      let serverGroup = mappedServiceGroups.find(searchedGroup => searchedGroup.name === serverService.group);

      if (!serverGroup) {
        mappedServiceGroups.push({
          name: serverService.group,
          services: []
        });
        serverGroup = mappedServiceGroups[mappedServiceGroups.length - 1];
      }

      const {
        name: serviceName,
        group: serverServiceGroup
      } = serverService,
            pushedService = _objectWithoutProperties(serverService, _excluded);

      const result = _objectSpread({
        name: serviceName
      }, pushedService);

      serverGroup.services.push(result);
    });
  });
  return mappedServiceGroups;
}

function getUrlFromIngress(ingress) {
  const urlHost = ingress.spec.rules[0].host;
  const urlPath = ingress.spec.rules[0].http.paths[0].path;
  const urlSchema = ingress.spec.tls ? "https" : "http";
  return `${urlSchema}://${urlHost}${urlPath}`;
}

async function checkCRD(kc, name) {
  const apiExtensions = kc.makeApiClient(_kubernetes_client_node__WEBPACK_IMPORTED_MODULE_4__.ApiextensionsV1Api);
  const exist = await apiExtensions.readCustomResourceDefinitionStatus(name).then(() => true).catch(async error => {
    if (error.statusCode === 403) {
      logger.error("Error checking if CRD %s exists. Make sure to add the following permission to your RBAC: %d %s %s", name, error.statusCode, error.body.message);
    }

    return false;
  });
  return exist;
}
async function servicesFromKubernetes() {
  const ANNOTATION_BASE = "gethomepage.dev";
  const ANNOTATION_WIDGET_BASE = `${ANNOTATION_BASE}/widget.`;
  const {
    instanceName
  } = (0,utils_config_config__WEBPACK_IMPORTED_MODULE_6__/* .getSettings */ .Gw)();
  (0,utils_config_config__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .ZP)("kubernetes.yaml");

  try {
    const kc = (0,utils_config_kubernetes__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z)();

    if (!kc) {
      return [];
    }

    const networking = kc.makeApiClient(_kubernetes_client_node__WEBPACK_IMPORTED_MODULE_4__.NetworkingV1Api);
    const crd = kc.makeApiClient(_kubernetes_client_node__WEBPACK_IMPORTED_MODULE_4__.CustomObjectsApi);
    const ingressList = await networking.listIngressForAllNamespaces(null, null, null, null).then(response => response.body).catch(error => {
      logger.error("Error getting ingresses: %d %s %s", error.statusCode, error.body, error.response);
      return null;
    });
    const traefikContainoExists = await checkCRD(kc, "ingressroutes.traefik.containo.us");
    const traefikExists = await checkCRD(kc, "ingressroutes.traefik.io");
    const traefikIngressListContaino = await crd.listClusterCustomObject("traefik.containo.us", "v1alpha1", "ingressroutes").then(response => response.body).catch(async error => {
      if (traefikContainoExists) {
        logger.error("Error getting traefik ingresses from traefik.containo.us: %d %s %s", error.statusCode, error.body, error.response);
      }

      return [];
    });
    const traefikIngressListIo = await crd.listClusterCustomObject("traefik.io", "v1alpha1", "ingressroutes").then(response => response.body).catch(async error => {
      if (traefikExists) {
        logger.error("Error getting traefik ingresses from traefik.io: %d %s %s", error.statusCode, error.body, error.response);
      }

      return [];
    });
    const traefikIngressList = [...(traefikIngressListContaino?.items ?? []), ...(traefikIngressListIo?.items ?? [])];

    if (traefikIngressList.length > 0) {
      const traefikServices = traefikIngressList.filter(ingress => ingress.metadata.annotations && ingress.metadata.annotations[`${ANNOTATION_BASE}/href`]);
      ingressList.items.push(...traefikServices);
    }

    if (!ingressList) {
      return [];
    }

    const services = ingressList.items.filter(ingress => ingress.metadata.annotations && ingress.metadata.annotations[`${ANNOTATION_BASE}/enabled`] === "true" && (!ingress.metadata.annotations[`${ANNOTATION_BASE}/instance`] || ingress.metadata.annotations[`${ANNOTATION_BASE}/instance`] === instanceName)).map(ingress => {
      let constructedService = {
        app: ingress.metadata.annotations[`${ANNOTATION_BASE}/app`] || ingress.metadata.name,
        namespace: ingress.metadata.namespace,
        href: ingress.metadata.annotations[`${ANNOTATION_BASE}/href`] || getUrlFromIngress(ingress),
        name: ingress.metadata.annotations[`${ANNOTATION_BASE}/name`] || ingress.metadata.name,
        group: ingress.metadata.annotations[`${ANNOTATION_BASE}/group`] || "Kubernetes",
        weight: ingress.metadata.annotations[`${ANNOTATION_BASE}/weight`] || "0",
        icon: ingress.metadata.annotations[`${ANNOTATION_BASE}/icon`] || "",
        description: ingress.metadata.annotations[`${ANNOTATION_BASE}/description`] || "",
        external: false,
        type: "service"
      };

      if (ingress.metadata.annotations[`${ANNOTATION_BASE}/external`]) {
        constructedService.external = String(ingress.metadata.annotations[`${ANNOTATION_BASE}/external`]).toLowerCase() === "true";
      }

      if (ingress.metadata.annotations[`${ANNOTATION_BASE}/pod-selector`] !== undefined) {
        constructedService.podSelector = ingress.metadata.annotations[`${ANNOTATION_BASE}/pod-selector`];
      }

      if (ingress.metadata.annotations[`${ANNOTATION_BASE}/ping`]) {
        constructedService.ping = ingress.metadata.annotations[`${ANNOTATION_BASE}/ping`];
      }

      if (ingress.metadata.annotations[`${ANNOTATION_BASE}/siteMonitor`]) {
        constructedService.siteMonitor = ingress.metadata.annotations[`${ANNOTATION_BASE}/siteMonitor`];
      }

      if (ingress.metadata.annotations[`${ANNOTATION_BASE}/statusStyle`]) {
        constructedService.statusStyle = ingress.metadata.annotations[`${ANNOTATION_BASE}/statusStyle`];
      }

      Object.keys(ingress.metadata.annotations).forEach(annotation => {
        if (annotation.startsWith(ANNOTATION_WIDGET_BASE)) {
          utils_config_shvl__WEBPACK_IMPORTED_MODULE_9__/* .set */ .t(constructedService, annotation.replace(`${ANNOTATION_BASE}/`, ""), ingress.metadata.annotations[annotation]);
        }
      });

      try {
        constructedService = JSON.parse((0,utils_config_config__WEBPACK_IMPORTED_MODULE_6__/* .substituteEnvironmentVars */ .AI)(JSON.stringify(constructedService)));
      } catch (e) {
        logger.error("Error attempting k8s environment variable substitution.");
      }

      return constructedService;
    });
    const mappedServiceGroups = [];
    services.forEach(serverService => {
      let serverGroup = mappedServiceGroups.find(searchedGroup => searchedGroup.name === serverService.group);

      if (!serverGroup) {
        mappedServiceGroups.push({
          name: serverService.group,
          services: []
        });
        serverGroup = mappedServiceGroups[mappedServiceGroups.length - 1];
      }

      const {
        name: serviceName,
        group: serverServiceGroup
      } = serverService,
            pushedService = _objectWithoutProperties(serverService, _excluded2);

      const result = _objectSpread({
        name: serviceName
      }, pushedService);

      serverGroup.services.push(result);
    });
    return mappedServiceGroups;
  } catch (e) {
    logger.error(e);
    throw e;
  }
}
function cleanServiceGroups(groups) {
  return groups.map(serviceGroup => ({
    name: serviceGroup.name,
    services: serviceGroup.services.map(service => {
      const cleanedService = _objectSpread({}, service);

      if (cleanedService.showStats !== undefined) cleanedService.showStats = JSON.parse(cleanedService.showStats);

      if (typeof service.weight === "string") {
        const weight = parseInt(service.weight, 10);

        if (Number.isNaN(weight)) {
          cleanedService.weight = 0;
        } else {
          cleanedService.weight = weight;
        }
      }

      if (typeof cleanedService.weight !== "number") {
        cleanedService.weight = 0;
      }

      if (cleanedService.widget) {
        // whitelisted set of keys to pass to the frontend
        // alphabetical, grouped by widget(s)
        const {
          // all widgets
          fields,
          hideErrors,
          type,
          // azuredevops
          repositoryId,
          userEmail,
          // calendar
          firstDayInWeek,
          integrations,
          maxEvents,
          showTime,
          previousDays,
          view,
          // coinmarketcap
          currency,
          defaultinterval,
          slugs,
          symbols,
          // customapi
          mappings,
          // diskstation
          volume,
          // docker
          container,
          server,
          // emby, jellyfin
          enableBlocks,
          enableNowPlaying,
          // glances
          chart,
          metric,
          pointsLimit,
          // glances, customapi, iframe
          refreshInterval,
          // iframe
          allowFullscreen,
          allowPolicy,
          allowScrolling,
          classes,
          loadingStrategy,
          referrerPolicy,
          src,
          // kopia
          snapshotHost,
          snapshotPath,
          // kubernetes
          app,
          namespace,
          podSelector,
          // mjpeg
          fit,
          stream,
          // openmediavault
          method,
          // opnsense, pfsense
          wan,
          // proxmox
          node,
          // sonarr, radarr
          enableQueue,
          // unifi
          site
        } = cleanedService.widget;
        let fieldsList = fields;

        if (typeof fields === "string") {
          try {
            JSON.parse(fields);
          } catch (e) {
            logger.error("Invalid fields list detected in config for service '%s'", service.name);
            fieldsList = null;
          }
        }

        cleanedService.widget = {
          type,
          fields: fieldsList || null,
          hide_errors: hideErrors || false,
          service_name: service.name,
          service_group: serviceGroup.name
        };

        if (type === "azuredevops") {
          if (userEmail) cleanedService.widget.userEmail = userEmail;
          if (repositoryId) cleanedService.widget.repositoryId = repositoryId;
        }

        if (type === "coinmarketcap") {
          if (currency) cleanedService.widget.currency = currency;
          if (symbols) cleanedService.widget.symbols = symbols;
          if (slugs) cleanedService.widget.slugs = slugs;
          if (defaultinterval) cleanedService.widget.defaultinterval = defaultinterval;
        }

        if (type === "docker") {
          if (server) cleanedService.widget.server = server;
          if (container) cleanedService.widget.container = container;
        }

        if (type === "unifi") {
          if (site) cleanedService.widget.site = site;
        }

        if (type === "proxmox") {
          if (node) cleanedService.widget.node = node;
        }

        if (type === "kubernetes") {
          if (namespace) cleanedService.widget.namespace = namespace;
          if (app) cleanedService.widget.app = app;
          if (podSelector) cleanedService.widget.podSelector = podSelector;
        }

        if (type === "iframe") {
          if (src) cleanedService.widget.src = src;
          if (classes) cleanedService.widget.classes = classes;
          if (referrerPolicy) cleanedService.widget.referrerPolicy = referrerPolicy;
          if (allowPolicy) cleanedService.widget.allowPolicy = allowPolicy;
          if (allowFullscreen) cleanedService.widget.allowFullscreen = allowFullscreen;
          if (loadingStrategy) cleanedService.widget.loadingStrategy = loadingStrategy;
          if (allowScrolling) cleanedService.widget.allowScrolling = allowScrolling;
          if (refreshInterval) cleanedService.widget.refreshInterval = refreshInterval;
        }

        if (["opnsense", "pfsense"].includes(type)) {
          if (wan) cleanedService.widget.wan = wan;
        }

        if (["emby", "jellyfin"].includes(type)) {
          if (enableBlocks !== undefined) cleanedService.widget.enableBlocks = JSON.parse(enableBlocks);
          if (enableNowPlaying !== undefined) cleanedService.widget.enableNowPlaying = JSON.parse(enableNowPlaying);
        }

        if (["sonarr", "radarr"].includes(type)) {
          if (enableQueue !== undefined) cleanedService.widget.enableQueue = JSON.parse(enableQueue);
        }

        if (["diskstation", "qnap"].includes(type)) {
          if (volume) cleanedService.widget.volume = volume;
        }

        if (type === "kopia") {
          if (snapshotHost) cleanedService.widget.snapshotHost = snapshotHost;
          if (snapshotPath) cleanedService.widget.snapshotPath = snapshotPath;
        }

        if (type === "glances") {
          if (metric) cleanedService.widget.metric = metric;

          if (chart !== undefined) {
            cleanedService.widget.chart = chart;
          } else {
            cleanedService.widget.chart = true;
          }

          if (refreshInterval) cleanedService.widget.refreshInterval = refreshInterval;
          if (pointsLimit) cleanedService.widget.pointsLimit = pointsLimit;
        }

        if (type === "mjpeg") {
          if (stream) cleanedService.widget.stream = stream;
          if (fit) cleanedService.widget.fit = fit;
        }

        if (type === "openmediavault") {
          if (method) cleanedService.widget.method = method;
        }

        if (type === "customapi") {
          if (mappings) cleanedService.widget.mappings = mappings;
          if (refreshInterval) cleanedService.widget.refreshInterval = refreshInterval;
        }

        if (type === "calendar") {
          if (integrations) cleanedService.widget.integrations = integrations;
          if (firstDayInWeek) cleanedService.widget.firstDayInWeek = firstDayInWeek;
          if (view) cleanedService.widget.view = view;
          if (maxEvents) cleanedService.widget.maxEvents = maxEvents;
          if (previousDays) cleanedService.widget.previousDays = previousDays;
          if (showTime) cleanedService.widget.showTime = showTime;
        }
      }

      return cleanedService;
    })
  }));
}
async function getServiceItem(group, service) {
  const configuredServices = await servicesFromConfig();
  const serviceGroup = configuredServices.find(g => g.name === group);

  if (serviceGroup) {
    const serviceEntry = serviceGroup.services.find(s => s.name === service);
    if (serviceEntry) return serviceEntry;
  }

  const discoveredServices = await servicesFromDocker();
  const dockerServiceGroup = discoveredServices.find(g => g.name === group);

  if (dockerServiceGroup) {
    const dockerServiceEntry = dockerServiceGroup.services.find(s => s.name === service);
    if (dockerServiceEntry) return dockerServiceEntry;
  }

  const kubernetesServices = await servicesFromKubernetes();
  const kubernetesServiceGroup = kubernetesServices.find(g => g.name === group);

  if (kubernetesServiceGroup) {
    const kubernetesServiceEntry = kubernetesServiceGroup.services.find(s => s.name === service);
    if (kubernetesServiceEntry) return kubernetesServiceEntry;
  }

  return false;
}
async function getServiceWidget(group, service) {
  const serviceItem = await getServiceItem(group, service);

  if (serviceItem) {
    const {
      widget
    } = serviceItem;
    return widget;
  }

  return false;
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 384:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "U": () => (/* binding */ get),
/* harmony export */   "t": () => (/* binding */ set)
/* harmony export */ });
/* eslint-disable */

/*
Code primarely based on shvl repository: https://github.com/robinvdvleuten/shvl

MIT License

Copyright (c) Robin van der Vleuten <robin@webstronauts.co>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
*/
function get(object, path, def) {
  // Split the path into keys and reduce the object to the target value
  return (object = path.split(/[.[\]]+/).reduce(function (obj, p) {
    // Check each nested object to see if the key exists
    return obj && obj[p] !== undefined ? obj[p] : undefined;
  }, object)) === undefined ? // If the final value is undefined, return the default value
  def : object; // Otherwise, return the value found
}
function set(obj, path, val) {
  // Split the path into keys and filter out any empty strings
  const keys = path.split(/[.[\]]+/).filter(Boolean); // Pop the last key to set the value later

  const lastKey = keys.pop(); // Prevent setting dangerous keys like __proto__

  if (/^(__proto__|constructor|prototype)$/.test(lastKey)) return obj; // Reduce the object to the nested object where we want to set the value

  keys.reduce((acc, key, i) => {
    // Again, block dangerous keys
    if (/^(__proto__|constructor|prototype)$/.test(key)) return {}; // Check if next key is an array index

    const isIndex = /^\d+$/.test(keys[i + 1]); // If current key doesn't exist, initialise it as an array or object

    acc[key] = Array.isArray(acc[key]) ? acc[key] : isIndex ? [] : acc[key] || {}; // Return nested object for next iteration

    return acc[key];
  }, obj)[lastKey] = val; // Finally set the value

  return obj;
}

/***/ })

};
;