"use strict";
(() => {
var exports = {};
exports.id = 2255;
exports.ids = [2255];
exports.modules = {

/***/ 276:
/***/ ((module) => {

module.exports = require("@kubernetes/client-node");

/***/ }),

/***/ 4856:
/***/ ((module) => {

module.exports = require("dockerode");

/***/ }),

/***/ 6953:
/***/ ((module) => {

module.exports = require("follow-redirects");

/***/ }),

/***/ 2108:
/***/ ((module) => {

module.exports = require("memory-cache");

/***/ }),

/***/ 7976:
/***/ ((module) => {

module.exports = require("tough-cookie");

/***/ }),

/***/ 7773:
/***/ ((module) => {

module.exports = require("winston");

/***/ }),

/***/ 626:
/***/ ((module) => {

module.exports = import("js-yaml");;

/***/ }),

/***/ 7147:
/***/ ((module) => {

module.exports = require("fs");

/***/ }),

/***/ 7261:
/***/ ((module) => {

module.exports = require("node:util");

/***/ }),

/***/ 5628:
/***/ ((module) => {

module.exports = require("node:zlib");

/***/ }),

/***/ 1017:
/***/ ((module) => {

module.exports = require("path");

/***/ }),

/***/ 4074:
/***/ ((module) => {

module.exports = require("perf_hooks");

/***/ }),

/***/ 886:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ handler)
/* harmony export */ });
/* harmony import */ var perf_hooks__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4074);
/* harmony import */ var perf_hooks__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(perf_hooks__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7765);
/* harmony import */ var utils_logger__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(2330);
/* harmony import */ var utils_proxy_http__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(8562);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__, utils_logger__WEBPACK_IMPORTED_MODULE_2__, utils_proxy_http__WEBPACK_IMPORTED_MODULE_3__]);
([utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__, utils_logger__WEBPACK_IMPORTED_MODULE_2__, utils_proxy_http__WEBPACK_IMPORTED_MODULE_3__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);




const logger = (0,utils_logger__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z)("siteMonitor");
async function handler(req, res) {
  const {
    group,
    service
  } = req.query;
  const serviceItem = await (0,utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_1__/* .getServiceItem */ .FM)(group, service);

  if (!serviceItem) {
    logger.debug(`No service item found for group ${group} named ${service}`);
    return res.status(400).send({
      error: "Unable to find service, see log for details."
    });
  }

  const {
    siteMonitor: monitorURL
  } = serviceItem;

  if (!monitorURL) {
    logger.debug("No http monitor URL specified");
    return res.status(400).send({
      error: "No http monitor URL given"
    });
  }

  try {
    let startTime = perf_hooks__WEBPACK_IMPORTED_MODULE_0__.performance.now();
    let [status] = await (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_3__/* .httpProxy */ .hC)(monitorURL, {
      method: "HEAD"
    });
    let endTime = perf_hooks__WEBPACK_IMPORTED_MODULE_0__.performance.now();

    if (status > 403) {
      // try one more time as a GET in case HEAD is rejected for whatever reason
      startTime = perf_hooks__WEBPACK_IMPORTED_MODULE_0__.performance.now();
      [status] = await (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_3__/* .httpProxy */ .hC)(monitorURL);
      endTime = perf_hooks__WEBPACK_IMPORTED_MODULE_0__.performance.now();
    }

    return res.status(200).json({
      status,
      latency: endTime - startTime
    });
  } catch (e) {
    logger.debug("Error attempting http monitor: %s", e);
    return res.status(400).send({
      error: "Error attempting http monitor, see logs."
    });
  }
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;

// load runtime
var __webpack_require__ = require("../../webpack-api-runtime.js");
__webpack_require__.C(exports);
var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
var __webpack_exports__ = __webpack_require__.X(0, [5732,2330,2156,7765,8562], () => (__webpack_exec__(886)));
module.exports = __webpack_exports__;

})();