"use strict";
(() => {
var exports = {};
exports.id = 9820;
exports.ids = [9820];
exports.modules = {

/***/ 6953:
/***/ ((module) => {

module.exports = require("follow-redirects");

/***/ }),

/***/ 2108:
/***/ ((module) => {

module.exports = require("memory-cache");

/***/ }),

/***/ 7976:
/***/ ((module) => {

module.exports = require("tough-cookie");

/***/ }),

/***/ 7773:
/***/ ((module) => {

module.exports = require("winston");

/***/ }),

/***/ 626:
/***/ ((module) => {

module.exports = import("js-yaml");;

/***/ }),

/***/ 7147:
/***/ ((module) => {

module.exports = require("fs");

/***/ }),

/***/ 7261:
/***/ ((module) => {

module.exports = require("node:util");

/***/ }),

/***/ 5628:
/***/ ((module) => {

module.exports = require("node:zlib");

/***/ }),

/***/ 1017:
/***/ ((module) => {

module.exports = require("path");

/***/ }),

/***/ 8942:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ handler)
/* harmony export */ });
/* harmony import */ var utils_proxy_http__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8562);
/* harmony import */ var utils_logger__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2330);
/* harmony import */ var utils_config_widget_helpers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(7704);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_http__WEBPACK_IMPORTED_MODULE_0__, utils_logger__WEBPACK_IMPORTED_MODULE_1__, utils_config_widget_helpers__WEBPACK_IMPORTED_MODULE_2__]);
([utils_proxy_http__WEBPACK_IMPORTED_MODULE_0__, utils_logger__WEBPACK_IMPORTED_MODULE_1__, utils_config_widget_helpers__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);



const logger = (0,utils_logger__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z)("glances");

async function retrieveFromGlancesAPI(privateWidgetOptions, endpoint) {
  let errorMessage;
  const url = privateWidgetOptions?.url;

  if (!url) {
    errorMessage = "Missing Glances URL";
    logger.error(errorMessage);
    throw new Error(errorMessage);
  }

  const apiUrl = `${url}/api/3/${endpoint}`;
  const headers = {
    "Accept-Encoding": "application/json"
  };

  if (privateWidgetOptions.username && privateWidgetOptions.password) {
    headers.Authorization = `Basic ${Buffer.from(`${privateWidgetOptions.username}:${privateWidgetOptions.password}`).toString("base64")}`;
  }

  const params = {
    method: "GET",
    headers
  };
  const [status,, data] = await (0,utils_proxy_http__WEBPACK_IMPORTED_MODULE_0__/* .httpProxy */ .hC)(apiUrl, params);

  if (status === 401) {
    errorMessage = `Authorization failure getting data from glances API. Data: ${data.toString()}`;
    logger.error(errorMessage);
    throw new Error(errorMessage);
  }

  if (status !== 200) {
    errorMessage = `HTTP ${status} getting data from glances API. Data: ${data.toString()}`;
    logger.error(errorMessage);
    throw new Error(errorMessage);
  }

  return JSON.parse(Buffer.from(data).toString());
}

async function handler(req, res) {
  const {
    index,
    cputemp: includeCpuTemp,
    uptime: includeUptime,
    disk: includeDisks
  } = req.query;
  const privateWidgetOptions = await (0,utils_config_widget_helpers__WEBPACK_IMPORTED_MODULE_2__/* .getPrivateWidgetOptions */ .Bh)("glances", index);

  try {
    const cpuData = await retrieveFromGlancesAPI(privateWidgetOptions, "cpu");
    const loadData = await retrieveFromGlancesAPI(privateWidgetOptions, "load");
    const memoryData = await retrieveFromGlancesAPI(privateWidgetOptions, "mem");
    const data = {
      cpu: cpuData,
      load: loadData,
      mem: memoryData
    }; // Disabled by default, dont call unless needed

    if (includeUptime) {
      data.uptime = await retrieveFromGlancesAPI(privateWidgetOptions, "uptime");
    }

    if (includeCpuTemp) {
      data.sensors = await retrieveFromGlancesAPI(privateWidgetOptions, "sensors");
    }

    if (includeDisks) {
      data.fs = await retrieveFromGlancesAPI(privateWidgetOptions, "fs");
    }

    return res.status(200).send(data);
  } catch (e) {
    return res.status(400).json({
      error: e.message
    });
  }
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;

// load runtime
var __webpack_require__ = require("../../../webpack-api-runtime.js");
__webpack_require__.C(exports);
var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
var __webpack_exports__ = __webpack_require__.X(0, [5732,2330,7704,8562], () => (__webpack_exec__(8942)));
module.exports = __webpack_exports__;

})();