"use strict";
(() => {
var exports = {};
exports.id = 4555;
exports.ids = [4555];
exports.modules = {

/***/ 2108:
/***/ ((module) => {

module.exports = require("memory-cache");

/***/ }),

/***/ 1516:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ handler)
/* harmony export */ });
/* harmony import */ var utils_proxy_cached_fetch__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6378);

async function handler(req, res) {
  const {
    latitude,
    longitude,
    units,
    cache,
    timezone
  } = req.query;
  const degrees = units === "imperial" ? "fahrenheit" : "celsius";
  const timezeone = timezone ?? "auto";
  const apiUrl = `https://api.open-meteo.com/v1/forecast?latitude=${latitude}&longitude=${longitude}&daily=sunrise,sunset&current_weather=true&temperature_unit=${degrees}&timezone=${timezeone}`;
  return res.send(await (0,utils_proxy_cached_fetch__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z)(apiUrl, cache));
}

/***/ }),

/***/ 6378:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ cachedFetch)
/* harmony export */ });
/* harmony import */ var memory_cache__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2108);
/* harmony import */ var memory_cache__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(memory_cache__WEBPACK_IMPORTED_MODULE_0__);

const defaultDuration = 5;
async function cachedFetch(url, duration) {
  const cached = memory_cache__WEBPACK_IMPORTED_MODULE_0___default().get(url); // eslint-disable-next-line no-param-reassign

  duration = duration || defaultDuration;

  if (cached) {
    return cached;
  }

  const data = await fetch(url).then(res => res.json());
  memory_cache__WEBPACK_IMPORTED_MODULE_0___default().put(url, data, duration * 1000 * 60);
  return data;
}

/***/ })

};
;

// load runtime
var __webpack_require__ = require("../../../webpack-api-runtime.js");
__webpack_require__.C(exports);
var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
var __webpack_exports__ = (__webpack_exec__(1516));
module.exports = __webpack_exports__;

})();