"use strict";
(() => {
var exports = {};
exports.id = 5405;
exports.ids = [5405];
exports.modules = {

/***/ 6426:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ BookmarksGroup)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(9003);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _headlessui_react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1185);
/* harmony import */ var react_icons_md__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(4041);
/* harmony import */ var react_icons_md__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_icons_md__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var components_errorboundry__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(9193);
/* harmony import */ var components_bookmarks_list__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(7512);
/* harmony import */ var components_resolvedicon__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(8904);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_headlessui_react__WEBPACK_IMPORTED_MODULE_2__]);
_headlessui_react__WEBPACK_IMPORTED_MODULE_2__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];










function BookmarksGroup({
  bookmarks,
  layout,
  disableCollapse
}) {
  const panel = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)();
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_1___default()("bookmark-group", layout?.style === "row" ? "basis-full" : "basis-full md:basis-1/4 lg:basis-1/5 xl:basis-1/6", layout?.header === false ? "flex-1 px-1 -my-1" : "flex-1 p-1"),
    children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_2__.Disclosure, {
      defaultOpen: true,
      children: ({
        open
      }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.Fragment, {
        children: [layout?.header !== false && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(_headlessui_react__WEBPACK_IMPORTED_MODULE_2__.Disclosure.Button, {
          disabled: disableCollapse,
          className: "flex w-full select-none items-center group",
          children: [layout?.icon && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx("div", {
            className: "flex-shrink-0 mr-2 w-7 h-7 bookmark-group-icon",
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(components_resolvedicon__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
              icon: layout.icon
            })
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx("h2", {
            className: "text-theme-800 dark:text-theme-300 text-xl font-medium bookmark-group-name",
            children: bookmarks.name
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(react_icons_md__WEBPACK_IMPORTED_MODULE_3__.MdKeyboardArrowDown, {
            className: classnames__WEBPACK_IMPORTED_MODULE_1___default()(disableCollapse ? "hidden" : "", "transition-all opacity-0 group-hover:opacity-100 ml-auto text-theme-800 dark:text-theme-300 text-xl", open ? "" : "rotate-180")
          })]
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_2__.Transition // Otherwise the transition group does display: none and cancels animation
        , {
          className: "!block",
          unmount: false,
          beforeLeave: () => {
            panel.current.style.height = `${panel.current.scrollHeight}px`;
            setTimeout(() => {
              panel.current.style.height = `0`;
            }, 1);
          },
          beforeEnter: () => {
            panel.current.style.height = `0px`;
            setTimeout(() => {
              panel.current.style.height = `${panel.current.scrollHeight}px`;
            }, 1);
          },
          children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_2__.Disclosure.Panel, {
            className: "transition-all overflow-hidden duration-300 ease-out",
            ref: panel,
            static: true,
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(components_errorboundry__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(components_bookmarks_list__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
                bookmarks: bookmarks.bookmarks,
                layout: layout
              })
            })
          })
        })]
      })
    })
  }, bookmarks.name);
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 7512:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {


// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ List)
});

// EXTERNAL MODULE: external "classnames"
var external_classnames_ = __webpack_require__(9003);
var external_classnames_default = /*#__PURE__*/__webpack_require__.n(external_classnames_);
// EXTERNAL MODULE: ./src/utils/layout/columns.js
var columns = __webpack_require__(9565);
// EXTERNAL MODULE: external "react"
var external_react_ = __webpack_require__(6689);
// EXTERNAL MODULE: ./src/utils/contexts/settings.jsx
var contexts_settings = __webpack_require__(9317);
// EXTERNAL MODULE: ./src/components/resolvedicon.jsx
var resolvedicon = __webpack_require__(8904);
// EXTERNAL MODULE: external "react/jsx-runtime"
var jsx_runtime_ = __webpack_require__(997);
;// CONCATENATED MODULE: ./src/components/bookmarks/item.jsx






function Item({
  bookmark
}) {
  const description = bookmark.description ?? new URL(bookmark.href).hostname;
  const {
    settings
  } = (0,external_react_.useContext)(contexts_settings/* SettingsContext */.J);
  return /*#__PURE__*/jsx_runtime_.jsx("li", {
    id: bookmark.id,
    className: "bookmark",
    "data-name": bookmark.name,
    children: /*#__PURE__*/jsx_runtime_.jsx("a", {
      href: bookmark.href,
      title: bookmark.name,
      target: bookmark.target ?? settings.target ?? "_blank",
      className: external_classnames_default()(settings.cardBlur !== undefined && `backdrop-blur${settings.cardBlur.length ? "-" : ""}${settings.cardBlur}`, "block w-full text-left cursor-pointer transition-all h-15 mb-3 rounded-md font-medium text-theme-700 dark:text-theme-200 dark:hover:text-theme-300 shadow-md shadow-theme-900/10 dark:shadow-theme-900/20 bg-theme-100/20 hover:bg-theme-300/20 dark:bg-white/5 dark:hover:bg-white/10"),
      children: /*#__PURE__*/(0,jsx_runtime_.jsxs)("div", {
        className: "flex",
        children: [/*#__PURE__*/(0,jsx_runtime_.jsxs)("div", {
          className: "flex-shrink-0 flex items-center justify-center w-11 bg-theme-500/10 dark:bg-theme-900/50 text-theme-700 hover:text-theme-700 dark:text-theme-200 text-sm font-medium rounded-l-md bookmark-icon",
          children: [bookmark.icon && /*#__PURE__*/jsx_runtime_.jsx("div", {
            className: "flex-shrink-0 w-5 h-5",
            children: /*#__PURE__*/jsx_runtime_.jsx(resolvedicon/* default */.Z, {
              icon: bookmark.icon,
              alt: bookmark.abbr
            })
          }), !bookmark.icon && bookmark.abbr]
        }), /*#__PURE__*/(0,jsx_runtime_.jsxs)("div", {
          className: "flex-1 flex items-center justify-between rounded-r-md bookmark-text",
          children: [/*#__PURE__*/jsx_runtime_.jsx("div", {
            className: "flex-1 grow pl-3 py-2 text-xs bookmark-name",
            children: bookmark.name
          }), /*#__PURE__*/jsx_runtime_.jsx("div", {
            className: "px-2 py-2 truncate text-theme-500 dark:text-theme-300 text-xs bookmark-description",
            children: description
          })]
        })]
      })
    })
  }, bookmark.name);
}
;// CONCATENATED MODULE: ./src/components/bookmarks/list.jsx




function List({
  bookmarks,
  layout
}) {
  return /*#__PURE__*/jsx_runtime_.jsx("ul", {
    className: external_classnames_default()(layout?.style === "row" ? `grid ${columns/* columnMap */.Q[layout?.columns]} gap-x-2` : "flex flex-col", "mt-3 bookmark-list"),
    children: bookmarks.map(bookmark => /*#__PURE__*/jsx_runtime_.jsx(Item, {
      bookmark: bookmark
    }, `${bookmark.name}-${bookmark.href}`))
  });
}

/***/ }),

/***/ 9193:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ ErrorBoundary)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__);



class ErrorBoundary extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
  constructor(props) {
    super(props);
    this.state = {
      error: null,
      errorInfo: null
    };
  }

  componentDidCatch(error, errorInfo) {
    // Catch errors in any components below and re-render with error message
    this.setState({
      error,
      errorInfo
    }); // You can also log error messages to an error reporting service here
    // eslint-disable-next-line no-console

    console.error(error, errorInfo);
  }

  render() {
    const {
      error,
      errorInfo
    } = this.state;

    if (errorInfo) {
      // Error path
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
        className: "inline-block text-sm bg-rose-100 text-rose-900 dark:bg-rose-900 dark:text-rose-100 rounded-md p-2 m-1",
        children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx("div", {
          className: "font-medium mb-1",
          children: "Something went wrong."
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("details", {
          className: "text-xs font-mono whitespace-pre",
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx("summary", {
            children: error && error.toString()
          }), errorInfo.componentStack]
        })]
      });
    } // Normally, just render children


    const {
      children
    } = this.props;
    return children;
  }

}

/***/ }),

/***/ 540:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ FileContent)
/* harmony export */ });
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5941);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([swr__WEBPACK_IMPORTED_MODULE_0__]);
swr__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

function FileContent({
  path,
  loadingValue,
  errorValue,
  emptyValue = ""
}) {
  const fetcher = url => fetch(url).then(res => res.text());

  const {
    data,
    error,
    isLoading
  } = (0,swr__WEBPACK_IMPORTED_MODULE_0__["default"])(`/api/config/${path}`, fetcher);
  if (error) return errorValue;
  if (isLoading) return loadingValue;
  return data || emptyValue;
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 2298:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ QuickLaunch)
/* harmony export */ });
/* harmony import */ var react_i18next__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9709);
/* harmony import */ var react_i18next__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_i18next__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(9003);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _resolvedicon__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(8904);
/* harmony import */ var utils_contexts_settings__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(9317);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__);







function QuickLaunch({
  servicesAndBookmarks,
  searchString,
  setSearchString,
  isOpen,
  close,
  searchProvider
}) {
  const {
    t
  } = (0,react_i18next__WEBPACK_IMPORTED_MODULE_0__.useTranslation)();
  const {
    settings
  } = (0,react__WEBPACK_IMPORTED_MODULE_1__.useContext)(utils_contexts_settings__WEBPACK_IMPORTED_MODULE_4__/* .SettingsContext */ .J);
  const {
    searchDescriptions,
    hideVisitURL
  } = settings?.quicklaunch ? settings.quicklaunch : {
    searchDescriptions: false,
    hideVisitURL: false
  };
  const searchField = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)();
  const {
    0: results,
    1: setResults
  } = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)([]);
  const {
    0: currentItemIndex,
    1: setCurrentItemIndex
  } = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(null);
  const {
    0: url,
    1: setUrl
  } = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(null);

  function openCurrentItem(newWindow) {
    const result = results[currentItemIndex];
    window.open(result.href, newWindow ? "_blank" : result.target ?? settings.target ?? "_blank", "noreferrer");
  }

  const closeAndReset = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(() => {
    close(false);
    setTimeout(() => {
      setSearchString("");
      setCurrentItemIndex(null);
    }, 200); // delay a little for animations
  }, [close, setSearchString, setCurrentItemIndex]);

  function handleSearchChange(event) {
    const rawSearchString = event.target.value.toLowerCase();

    try {
      if (!/.+[.:].+/g.test(rawSearchString)) throw new Error(); // basic test for probably a url

      let urlString = rawSearchString;
      if (urlString.indexOf("http") !== 0) urlString = `https://${rawSearchString}`;
      setUrl(new URL(urlString)); // basic validation
    } catch (e) {
      setUrl(null);
    }

    setSearchString(rawSearchString);
  }

  function handleSearchKeyDown(event) {
    if (!isOpen) return;

    if (event.key === "Escape") {
      closeAndReset();
      event.preventDefault();
    } else if (event.key === "Enter" && results.length) {
      closeAndReset();
      openCurrentItem(event.metaKey);
    } else if (event.key === "ArrowDown" && results[currentItemIndex + 1]) {
      setCurrentItemIndex(currentItemIndex + 1);
      event.preventDefault();
    } else if (event.key === "ArrowUp" && currentItemIndex > 0) {
      setCurrentItemIndex(currentItemIndex - 1);
      event.preventDefault();
    }
  }

  function handleItemHover(event) {
    setCurrentItemIndex(parseInt(event.target?.dataset?.index, 10));
  }

  function handleItemClick(event) {
    closeAndReset();
    openCurrentItem(event.metaKey);
  }

  function handleItemKeyDown(event) {
    if (!isOpen) return; // native button handles other keys

    if (event.key === "Escape") {
      closeAndReset();
      event.preventDefault();
    }
  }

  (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    if (searchString.length === 0) setResults([]);else {
      let newResults = servicesAndBookmarks.filter(r => {
        const nameMatch = r.name.toLowerCase().includes(searchString);
        let descriptionMatch;

        if (searchDescriptions) {
          descriptionMatch = r.description?.toLowerCase().includes(searchString);
          r.priority = nameMatch ? 2 * +nameMatch : +descriptionMatch; // eslint-disable-line no-param-reassign
        }

        return nameMatch || descriptionMatch;
      });

      if (searchDescriptions) {
        newResults = newResults.sort((a, b) => b.priority - a.priority);
      }

      if (searchProvider) {
        newResults.push({
          href: searchProvider.url + encodeURIComponent(searchString),
          name: `${searchProvider.name ?? t("quicklaunch.custom")} ${t("quicklaunch.search")} `,
          type: "search"
        });
      }

      if (!hideVisitURL && url) {
        newResults.unshift({
          href: url.toString(),
          name: `${t("quicklaunch.visit")} URL`,
          type: "url"
        });
      }

      setResults(newResults);

      if (newResults.length) {
        setCurrentItemIndex(0);
      }
    }
  }, [searchString, servicesAndBookmarks, searchDescriptions, hideVisitURL, searchProvider, url, t]);
  const {
    0: hidden,
    1: setHidden
  } = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(true);
  (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    function handleBackdropClick(event) {
      if (event.target?.tagName === "DIV") closeAndReset();
    }

    if (isOpen) {
      searchField.current.focus();
      document.body.addEventListener("click", handleBackdropClick);
      setHidden(false);
    } else {
      document.body.removeEventListener("click", handleBackdropClick);
      searchField.current.blur();
      setTimeout(() => {
        setHidden(true);
      }, 300); // disable on close
    }
  }, [isOpen, closeAndReset]);

  function highlightText(text) {
    const parts = text.split(new RegExp(`(${searchString})`, "gi"));
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("span", {
      children: parts.map((part, i) => part.toLowerCase() === searchString.toLowerCase() ?
      /*#__PURE__*/
      // eslint-disable-next-line react/no-array-index-key
      react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("span", {
        className: "bg-theme-300/10",
        children: part
      }, `${searchString}_${i}`) : part)
    });
  }

  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_2___default()("relative z-40 ease-in-out duration-300 transition-opacity", hidden && !isOpen && "hidden", !hidden && isOpen && "opacity-100", !isOpen && "opacity-0"),
    role: "dialog",
    "aria-modal": "true",
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("div", {
      className: "fixed inset-0 bg-gray-500 bg-opacity-50"
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("div", {
      className: "fixed inset-0 z-20 overflow-y-auto",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("div", {
        className: "flex min-h-full min-w-full items-start justify-center text-center",
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("dialog", {
          className: "mt-[10%] min-w-[80%] max-w-[90%] md:min-w-[40%] rounded-md p-0 block font-medium text-theme-700 dark:text-theme-200 dark:hover:text-theme-300 shadow-md shadow-theme-900/10 dark:shadow-theme-900/20 bg-theme-50 dark:bg-theme-800",
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("input", {
            placeholder: "Search",
            className: classnames__WEBPACK_IMPORTED_MODULE_2___default()(results.length > 0 && "rounded-t-md", results.length === 0 && "rounded-md", "w-full p-4 m-0 border-0 border-b border-slate-700 focus:border-slate-700 focus:outline-0 focus:ring-0 text-sm md:text-xl text-theme-700 dark:text-theme-200 bg-theme-60 dark:bg-theme-800"),
            type: "text",
            autoCorrect: "false",
            ref: searchField,
            value: searchString,
            onChange: handleSearchChange,
            onKeyDown: handleSearchKeyDown
          }), results.length > 0 && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("ul", {
            className: "max-h-[60vh] overflow-y-auto m-2",
            children: results.map((r, i) => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("li", {
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("button", {
                type: "button",
                "data-index": i,
                onMouseEnter: handleItemHover,
                onClick: handleItemClick,
                onKeyDown: handleItemKeyDown,
                className: classnames__WEBPACK_IMPORTED_MODULE_2___default()("flex flex-row w-full items-center justify-between rounded-md text-sm md:text-xl py-2 px-4 cursor-pointer text-theme-700 dark:text-theme-200", i === currentItemIndex && "bg-theme-300/50 dark:bg-theme-700/50"),
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
                  className: "flex flex-row items-center mr-4 pointer-events-none",
                  children: [(r.icon || r.abbr) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
                    className: "w-5 text-xs mr-4",
                    children: [r.icon && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_resolvedicon__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
                      icon: r.icon
                    }), r.abbr && r.abbr]
                  }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
                    className: "flex flex-col md:flex-row text-left items-baseline mr-4 pointer-events-none",
                    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("span", {
                      className: "mr-4",
                      children: r.name
                    }), r.description && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("span", {
                      className: "text-xs text-theme-600 text-light",
                      children: searchDescriptions && r.priority < 2 ? highlightText(r.description) : r.description
                    })]
                  })]
                }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("div", {
                  className: "text-xs text-theme-600 font-bold pointer-events-none",
                  children: t(`quicklaunch.${r.type ? r.type.toLowerCase() : "bookmark"}`)
                })]
              })
            }, r.container ?? r.app ?? `${r.name}-${r.href}`))
          })]
        })
      })
    })]
  });
}

/***/ }),

/***/ 8904:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ ResolvedIcon)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var next_future_image__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(1608);
/* harmony import */ var next_future_image__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(next_future_image__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var utils_contexts_settings__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(9317);
/* harmony import */ var utils_contexts_theme__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(7894);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__);





const iconSetURLs = {
  mdi: "https://cdn.jsdelivr.net/npm/@mdi/svg@latest/svg/",
  si: "https://cdn.jsdelivr.net/npm/simple-icons@latest/icons/"
};
function ResolvedIcon({
  icon,
  width = 32,
  height = 32,
  alt = "logo"
}) {
  const {
    settings
  } = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(utils_contexts_settings__WEBPACK_IMPORTED_MODULE_2__/* .SettingsContext */ .J);
  const {
    theme
  } = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(utils_contexts_theme__WEBPACK_IMPORTED_MODULE_3__/* .ThemeContext */ .N); // direct or relative URLs

  if (icon.startsWith("http") || icon.startsWith("/")) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx((next_future_image__WEBPACK_IMPORTED_MODULE_1___default()), {
      src: `${icon}`,
      width: width,
      height: height,
      style: {
        width,
        height,
        objectFit: "contain",
        maxHeight: "100%",
        maxWidth: "100%"
      },
      alt: alt
    });
  } // check mdi- or si- prefixed icons


  const prefix = icon.split("-")[0];

  if (prefix in iconSetURLs) {
    // default to theme setting
    let iconName = icon.replace(`${prefix}-`, "").replace(".svg", "");
    let iconColor = settings.iconStyle === "theme" ? `rgb(var(--color-${theme === "dark" ? 300 : 900}) / var(--tw-text-opacity, 1))` : "linear-gradient(180deg, rgb(var(--color-logo-start)), rgb(var(--color-logo-stop)))"; // use custom hex color if provided

    const colorMatches = icon.match(/[#][a-f0-9][a-f0-9][a-f0-9][a-f0-9][a-f0-9][a-f0-9]$/i);

    if (colorMatches?.length) {
      iconName = icon.replace(`${prefix}-`, "").replace(".svg", "").replace(`-${colorMatches[0]}`, "");
      iconColor = `${colorMatches[0]}`;
    }

    const iconSource = `${iconSetURLs[prefix]}${iconName}.svg`;
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx("div", {
      style: {
        width,
        height,
        maxWidth: "100%",
        maxHeight: "100%",
        background: `${iconColor}`,
        mask: `url(${iconSource}) no-repeat center / contain`,
        WebkitMask: `url(${iconSource}) no-repeat center / contain`
      }
    });
  } // fallback to dashboard-icons


  if (icon.endsWith(".svg")) {
    const iconName = icon.replace(".svg", "");
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx((next_future_image__WEBPACK_IMPORTED_MODULE_1___default()), {
      src: `https://cdn.jsdelivr.net/gh/walkxcode/dashboard-icons/svg/${iconName}.svg`,
      width: width,
      height: height,
      style: {
        width,
        height,
        objectFit: "contain",
        maxHeight: "100%",
        maxWidth: "100%"
      },
      alt: alt
    });
  }

  const iconName = icon.replace(".png", "");
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx((next_future_image__WEBPACK_IMPORTED_MODULE_1___default()), {
    src: `https://cdn.jsdelivr.net/gh/walkxcode/dashboard-icons/png/${iconName}.png`,
    width: width,
    height: height,
    style: {
      width,
      height,
      objectFit: "contain",
      maxHeight: "100%",
      maxWidth: "100%"
    },
    alt: alt
  });
}

/***/ }),

/***/ 5412:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ ServicesGroup)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(9003);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _headlessui_react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1185);
/* harmony import */ var react_icons_md__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(4041);
/* harmony import */ var react_icons_md__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_icons_md__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var components_services_list__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(648);
/* harmony import */ var components_resolvedicon__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(8904);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_headlessui_react__WEBPACK_IMPORTED_MODULE_2__, components_services_list__WEBPACK_IMPORTED_MODULE_4__]);
([_headlessui_react__WEBPACK_IMPORTED_MODULE_2__, components_services_list__WEBPACK_IMPORTED_MODULE_4__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);









function ServicesGroup({
  group,
  services,
  layout,
  fiveColumns,
  disableCollapse,
  useEqualHeights
}) {
  const panel = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)();
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_1___default()("services-group", layout?.style === "row" ? "basis-full" : "basis-full md:basis-1/2 lg:basis-1/3 xl:basis-1/4", layout?.style !== "row" && fiveColumns ? "3xl:basis-1/5" : "", layout?.header === false ? "flex-1 px-1 -my-1" : "flex-1 p-1"),
    children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_2__.Disclosure, {
      defaultOpen: true,
      children: ({
        open
      }) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.Fragment, {
        children: [layout?.header !== false && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(_headlessui_react__WEBPACK_IMPORTED_MODULE_2__.Disclosure.Button, {
          disabled: disableCollapse,
          className: "flex w-full select-none items-center group",
          children: [layout?.icon && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("div", {
            className: "flex-shrink-0 mr-2 w-7 h-7 service-group-icon",
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(components_resolvedicon__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
              icon: layout.icon
            })
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("h2", {
            className: "flex text-theme-800 dark:text-theme-300 text-xl font-medium service-group-name",
            children: services.name
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(react_icons_md__WEBPACK_IMPORTED_MODULE_3__.MdKeyboardArrowDown, {
            className: classnames__WEBPACK_IMPORTED_MODULE_1___default()(disableCollapse ? "hidden" : "", "transition-all opacity-0 group-hover:opacity-100 ml-auto text-theme-800 dark:text-theme-300 text-xl", open ? "" : "rotate-180")
          })]
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_2__.Transition // Otherwise the transition group does display: none and cancels animation
        , {
          className: "!block",
          unmount: false,
          beforeLeave: () => {
            panel.current.style.height = `${panel.current.scrollHeight}px`;
            setTimeout(() => {
              panel.current.style.height = `0`;
            }, 1);
          },
          beforeEnter: () => {
            panel.current.style.height = `0px`;
            setTimeout(() => {
              panel.current.style.height = `${panel.current.scrollHeight}px`;
            }, 1);
            setTimeout(() => {
              panel.current.style.height = "auto";
            }, 150); // animation is 150ms
          },
          children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_2__.Disclosure.Panel, {
            className: "transition-all overflow-hidden duration-300 ease-out",
            ref: panel,
            static: true,
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(components_services_list__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
              group: group,
              services: services.services,
              layout: layout,
              useEqualHeights: useEqualHeights
            })
          })
        })]
      })
    })
  }, services.name);
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 5663:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ Item)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9003);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _status__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4015);
/* harmony import */ var _widget__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(4903);
/* harmony import */ var _ping__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(5213);
/* harmony import */ var _site_monitor__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(8819);
/* harmony import */ var _kubernetes_status__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(2542);
/* harmony import */ var widgets_docker_component__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(2613);
/* harmony import */ var widgets_kubernetes_component__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(5889);
/* harmony import */ var utils_contexts_settings__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(9317);
/* harmony import */ var components_resolvedicon__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(8904);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_status__WEBPACK_IMPORTED_MODULE_2__, _ping__WEBPACK_IMPORTED_MODULE_4__, _site_monitor__WEBPACK_IMPORTED_MODULE_5__, _kubernetes_status__WEBPACK_IMPORTED_MODULE_6__, widgets_docker_component__WEBPACK_IMPORTED_MODULE_7__, widgets_kubernetes_component__WEBPACK_IMPORTED_MODULE_8__]);
([_status__WEBPACK_IMPORTED_MODULE_2__, _ping__WEBPACK_IMPORTED_MODULE_4__, _site_monitor__WEBPACK_IMPORTED_MODULE_5__, _kubernetes_status__WEBPACK_IMPORTED_MODULE_6__, widgets_docker_component__WEBPACK_IMPORTED_MODULE_7__, widgets_kubernetes_component__WEBPACK_IMPORTED_MODULE_8__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);













function Item({
  service,
  group,
  useEqualHeights
}) {
  const hasLink = service.href && service.href !== "#";
  const {
    settings
  } = (0,react__WEBPACK_IMPORTED_MODULE_1__.useContext)(utils_contexts_settings__WEBPACK_IMPORTED_MODULE_9__/* .SettingsContext */ .J);
  const showStats = service.showStats === false ? false : settings.showStats;
  const statusStyle = service.statusStyle !== undefined ? service.statusStyle : settings.statusStyle;
  const {
    0: statsOpen,
    1: setStatsOpen
  } = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(service.showStats);
  const {
    0: statsClosing,
    1: setStatsClosing
  } = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(false); // set stats to closed after 300ms

  const closeStats = () => {
    if (statsOpen) {
      setStatsClosing(true);
      setTimeout(() => {
        setStatsOpen(false);
        setStatsClosing(false);
      }, 300);
    }
  };

  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("li", {
    id: service.id,
    className: "service",
    "data-name": service.name || "",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
      className: classnames__WEBPACK_IMPORTED_MODULE_0___default()(settings.cardBlur !== undefined && `backdrop-blur${settings.cardBlur.length ? "-" : ""}${settings.cardBlur}`, hasLink && "cursor-pointer", useEqualHeights && "h-[calc(100%-0.5rem)]", "transition-all mb-2 p-1 rounded-md font-medium text-theme-700 dark:text-theme-200 dark:hover:text-theme-300 shadow-md shadow-theme-900/10 dark:shadow-theme-900/20 bg-theme-100/20 hover:bg-theme-300/20 dark:bg-white/5 dark:hover:bg-white/10 relative overflow-clip service-card"),
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
        className: "flex select-none z-0 service-title",
        children: [service.icon && (hasLink ? /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("a", {
          href: service.href,
          target: service.target ?? settings.target ?? "_blank",
          rel: "noreferrer",
          className: "flex-shrink-0 flex items-center justify-center w-12 service-icon",
          children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(components_resolvedicon__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .Z, {
            icon: service.icon
          })
        }) : /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
          className: "flex-shrink-0 flex items-center justify-center w-12 service-icon",
          children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(components_resolvedicon__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .Z, {
            icon: service.icon
          })
        })), hasLink ? /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("a", {
          href: service.href,
          target: service.target ?? settings.target ?? "_blank",
          rel: "noreferrer",
          className: "flex-1 flex items-center justify-between rounded-r-md service-title-text",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
            className: "flex-1 px-2 py-2 text-sm text-left z-10 service-name",
            children: [service.name, /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("p", {
              className: "text-theme-500 dark:text-theme-300 text-xs font-light service-description",
              children: service.description
            })]
          })
        }) : /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
          className: "flex-1 flex items-center justify-between rounded-r-md service-title-text",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
            className: "flex-1 px-2 py-2 text-sm text-left z-10 service-name",
            children: [service.name, /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("p", {
              className: "text-theme-500 dark:text-theme-300 text-xs font-light service-description",
              children: service.description
            })]
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
          className: `absolute top-0 right-0 flex flex-row justify-end ${statusStyle === "dot" ? "gap-0" : "gap-2 mr-2"} z-30 service-tags`,
          children: [service.ping && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
            className: "flex-shrink-0 flex items-center justify-center service-tag service-ping",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_ping__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
              group: group,
              service: service.name,
              style: statusStyle
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("span", {
              className: "sr-only",
              children: "Ping status"
            })]
          }), service.siteMonitor && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
            className: "flex-shrink-0 flex items-center justify-center service-tag service-site-monitor",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_site_monitor__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
              group: group,
              service: service.name,
              style: statusStyle
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("span", {
              className: "sr-only",
              children: "Site monitor status"
            })]
          }), service.container && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("button", {
            type: "button",
            onClick: () => statsOpen ? closeStats() : setStatsOpen(true),
            className: "flex-shrink-0 flex items-center justify-center cursor-pointer service-tag service-container-stats",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_status__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
              service: service,
              style: statusStyle
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("span", {
              className: "sr-only",
              children: "View container stats"
            })]
          }), service.app && !service.external && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("button", {
            type: "button",
            onClick: () => statsOpen ? closeStats() : setStatsOpen(true),
            className: "flex-shrink-0 flex items-center justify-center cursor-pointer service-tag service-app",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_kubernetes_status__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
              service: service,
              style: statusStyle
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("span", {
              className: "sr-only",
              children: "View container stats"
            })]
          })]
        })]
      }), service.container && service.server && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
        className: classnames__WEBPACK_IMPORTED_MODULE_0___default()(showStats || statsOpen && !statsClosing ? "max-h-[110px] opacity-100" : " max-h-[0] opacity-0", "w-full overflow-hidden transition-all duration-300 ease-in-out service-stats"),
        children: (showStats || statsOpen) && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(widgets_docker_component__WEBPACK_IMPORTED_MODULE_7__["default"], {
          service: {
            widget: {
              container: service.container,
              server: service.server
            }
          }
        })
      }), service.app && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
        className: classnames__WEBPACK_IMPORTED_MODULE_0___default()(showStats || statsOpen && !statsClosing ? "max-h-[55px] opacity-100" : " max-h-[0] opacity-0", "w-full overflow-hidden transition-all duration-300 ease-in-out service-stats"),
        children: (showStats || statsOpen) && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(widgets_kubernetes_component__WEBPACK_IMPORTED_MODULE_8__["default"], {
          service: {
            widget: {
              namespace: service.namespace,
              app: service.app,
              podSelector: service.podSelector
            }
          }
        })
      }), service.widget && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_widget__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
        service: service
      })]
    })
  }, service.name);
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 2542:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ KubernetesStatus)
/* harmony export */ });
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5941);
/* harmony import */ var i18next__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2021);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([swr__WEBPACK_IMPORTED_MODULE_0__, i18next__WEBPACK_IMPORTED_MODULE_1__]);
([swr__WEBPACK_IMPORTED_MODULE_0__, i18next__WEBPACK_IMPORTED_MODULE_1__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);



function KubernetesStatus({
  service,
  style
}) {
  const podSelectorString = service.podSelector !== undefined ? `podSelector=${service.podSelector}` : "";
  const {
    data,
    error
  } = (0,swr__WEBPACK_IMPORTED_MODULE_0__["default"])(`/api/kubernetes/status/${service.namespace}/${service.app}?${podSelectorString}`);
  let statusLabel = (0,i18next__WEBPACK_IMPORTED_MODULE_1__.t)("docker.unknown");
  let statusTitle = "";
  let backgroundClass = "px-1.5 py-0.5 bg-theme-500/10 dark:bg-theme-900/50";
  let colorClass = "text-black/20 dark:text-white/40 opacity-20";

  if (error) {
    statusTitle = (0,i18next__WEBPACK_IMPORTED_MODULE_1__.t)("docker.error");
    statusLabel = statusTitle;
    colorClass = "text-rose-500/80";
  } else if (data) {
    if (data.status === "running") {
      statusTitle = data.health ?? data.status;
      statusLabel = statusTitle;
      colorClass = "text-emerald-500/80";
    }

    if (data.status === "not found" || data.status === "down" || data.status === "partial") {
      statusTitle = data.status;
      statusLabel = statusTitle;
      colorClass = "text-orange-400/50 dark:text-orange-400/80";
    }
  }

  if (style === "dot") {
    colorClass = colorClass.replace(/text-/g, "bg-").replace(/\/\d\d/g, "");
    backgroundClass = "p-4 hover:bg-theme-500/10 dark:hover:bg-theme-900/20";
  }

  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx("div", {
    className: `w-auto text-center overflow-hidden ${backgroundClass} rounded-b-[3px] k8s-status`,
    title: statusTitle,
    children: style !== "dot" ? /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx("div", {
      className: `text-[8px] font-bold ${colorClass} uppercase`,
      children: statusLabel
    }) : /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx("div", {
      className: `rounded-full h-3 w-3 ${colorClass}`
    })
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 648:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ List)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9003);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _utils_layout_columns__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(9565);
/* harmony import */ var components_services_item__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5663);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([components_services_item__WEBPACK_IMPORTED_MODULE_1__]);
components_services_item__WEBPACK_IMPORTED_MODULE_1__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];




function List({
  group,
  services,
  layout,
  useEqualHeights
}) {
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx("ul", {
    className: classnames__WEBPACK_IMPORTED_MODULE_0___default()(layout?.style === "row" ? `grid ${_utils_layout_columns__WEBPACK_IMPORTED_MODULE_3__/* .columnMap */ .Q[layout?.columns]} gap-x-2` : "flex flex-col", "mt-3 services-list"),
    children: services.map(service => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx(components_services_item__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
      service: service,
      group: group,
      useEqualHeights: layout?.useEqualHeights ?? useEqualHeights
    }, service.container ?? service.app ?? service.name))
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 5213:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ Ping)
/* harmony export */ });
/* harmony import */ var react_i18next__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9709);
/* harmony import */ var react_i18next__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_i18next__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5941);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([swr__WEBPACK_IMPORTED_MODULE_1__]);
swr__WEBPACK_IMPORTED_MODULE_1__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];




function Ping({
  group,
  service,
  style
}) {
  const {
    t
  } = (0,react_i18next__WEBPACK_IMPORTED_MODULE_0__.useTranslation)();
  const {
    data,
    error
  } = (0,swr__WEBPACK_IMPORTED_MODULE_1__["default"])(`/api/ping?${new URLSearchParams({
    group,
    service
  }).toString()}`, {
    refreshInterval: 30000
  });
  let colorClass = "text-black/20 dark:text-white/40 opacity-20";
  let backgroundClass = "bg-theme-500/10 dark:bg-theme-900/50 px-1.5 py-0.5";
  let statusTitle = t("ping.ping");
  let statusText = "";

  if (error) {
    colorClass = "text-rose-500";
    statusText = t("ping.error");
    statusTitle += ` ${t("ping.error")}`;
  } else if (!data) {
    statusText = t("ping.ping");
    statusTitle += ` ${t("ping.not_available")}`;
  } else if (!data.alive) {
    colorClass = "text-rose-500/80";
    statusTitle += ` ${t("ping.down")}`;
    statusText = t("ping.down");
  } else if (data.alive) {
    const ping = t("common.ms", {
      value: data.time,
      style: "unit",
      unit: "millisecond",
      maximumFractionDigits: 0
    });
    statusTitle += ` ${t("ping.up")} (${ping})`;
    colorClass = "text-emerald-500/80";

    if (style === "basic") {
      statusText = t("ping.up");
    } else {
      statusText = ping;
      colorClass += " lowercase";
    }
  }

  if (style === "dot") {
    backgroundClass = "p-4";
    colorClass = colorClass.replace(/text-/g, "bg-").replace(/\/\d\d/g, "");
  }

  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
    className: `w-auto text-center rounded-b-[3px] overflow-hidden ping-status ${backgroundClass}`,
    title: statusTitle,
    children: [style !== "dot" && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx("div", {
      className: `font-bold uppercase text-[8px] ${colorClass}`,
      children: statusText
    }), style === "dot" && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx("div", {
      className: `rounded-full h-3 w-3 ${colorClass}`
    })]
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 8819:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ SiteMonitor)
/* harmony export */ });
/* harmony import */ var react_i18next__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9709);
/* harmony import */ var react_i18next__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_i18next__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5941);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([swr__WEBPACK_IMPORTED_MODULE_1__]);
swr__WEBPACK_IMPORTED_MODULE_1__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];




function SiteMonitor({
  group,
  service,
  style
}) {
  const {
    t
  } = (0,react_i18next__WEBPACK_IMPORTED_MODULE_0__.useTranslation)();
  const {
    data,
    error
  } = (0,swr__WEBPACK_IMPORTED_MODULE_1__["default"])(`/api/siteMonitor?${new URLSearchParams({
    group,
    service
  }).toString()}`, {
    refreshInterval: 30000
  });
  let colorClass = "text-black/20 dark:text-white/40 opacity-20";
  let backgroundClass = "bg-theme-500/10 dark:bg-theme-900/50 px-1.5 py-0.5";
  let statusTitle = t("siteMonitor.http_status");
  let statusText = "";

  if (error) {
    colorClass = "text-rose-500";
    statusText = t("siteMonitor.error");
    statusTitle += ` ${t("siteMonitor.error")}`;
  } else if (!data) {
    statusText = t("siteMonitor.response");
    statusTitle += ` ${t("siteMonitor.not_available")}`;
  } else if (data.status > 403) {
    colorClass = "text-rose-500/80";
    statusTitle += ` ${data.status}`;

    if (style === "basic") {
      statusText = t("siteMonitor.down");
    } else {
      statusText = data.status;
    }
  } else if (data) {
    const responseTime = t("common.ms", {
      value: data.latency,
      style: "unit",
      unit: "millisecond",
      maximumFractionDigits: 0
    });
    statusTitle += ` ${data.status} (${responseTime})`;
    colorClass = "text-emerald-500/80";

    if (style === "basic") {
      statusText = t("siteMonitor.up");
    } else {
      statusText = responseTime;
      colorClass += " lowercase";
    }
  }

  if (style === "dot") {
    backgroundClass = "p-4";
    colorClass = colorClass.replace(/text-/g, "bg-").replace(/\/\d\d/g, "");
  }

  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
    className: `w-auto text-center rounded-b-[3px] overflow-hidden site-monitor-status ${backgroundClass}`,
    title: statusTitle,
    children: [style !== "dot" && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx("div", {
      className: `font-bold uppercase text-[8px] ${colorClass}`,
      children: statusText
    }), style === "dot" && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx("div", {
      className: `rounded-full h-3 w-3 ${colorClass}`
    })]
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 4015:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ Status)
/* harmony export */ });
/* harmony import */ var react_i18next__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9709);
/* harmony import */ var react_i18next__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_i18next__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5941);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([swr__WEBPACK_IMPORTED_MODULE_1__]);
swr__WEBPACK_IMPORTED_MODULE_1__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];



function Status({
  service,
  style
}) {
  const {
    t
  } = (0,react_i18next__WEBPACK_IMPORTED_MODULE_0__.useTranslation)();
  const {
    data,
    error
  } = (0,swr__WEBPACK_IMPORTED_MODULE_1__["default"])(`/api/docker/status/${service.container}/${service.server || ""}`);
  let statusLabel = t("docker.unknown");
  let statusTitle = "";
  let backgroundClass = "px-1.5 py-0.5 bg-theme-500/10 dark:bg-theme-900/50";
  let colorClass = "text-black/20 dark:text-white/40 ";

  if (error) {
    statusTitle = t("docker.error");
    colorClass = "text-rose-500/80";
  } else if (data) {
    if (data.status?.includes("running")) {
      if (data.health === "starting") {
        statusTitle = t("docker.starting");
        colorClass = "text-blue-500/80";
      }

      if (data.health === "unhealthy") {
        statusTitle = t("docker.unhealthy");
        colorClass = "text-orange-400/50 dark:text-orange-400/80";
      }

      if (!data.health) {
        statusLabel = data.status.replace("running", t("docker.running"));
      } else {
        statusLabel = data.health === "healthy" ? t("docker.healthy") : data.health;
      }

      statusTitle = statusLabel;
      colorClass = "text-emerald-500/80";
    }

    if (data.status === "not found" || data.status === "exited" || data.status?.startsWith("partial")) {
      if (data.status === "not found") statusLabel = t("docker.not_found");else if (data.status === "exited") statusLabel = t("docker.exited");else statusLabel = data.status.replace("partial", t("docker.partial"));
      colorClass = "text-orange-400/50 dark:text-orange-400/80";
    }
  }

  if (style === "dot") {
    colorClass = colorClass.replace(/text-/g, "bg-").replace(/\/\d\d/g, "");
    backgroundClass = "p-4 hover:bg-theme-500/10 dark:hover:bg-theme-900/20";
    statusTitle = statusLabel;
  }

  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx("div", {
    className: `w-auto text-center overflow-hidden ${backgroundClass} rounded-b-[3px] docker-status`,
    title: statusTitle,
    children: style !== "dot" ? /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx("div", {
      className: `text-[8px] font-bold ${colorClass} uppercase`,
      children: statusLabel
    }) : /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx("div", {
      className: `rounded-full h-3 w-3 ${colorClass}`
    })
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 4903:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {


// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ Widget)
});

// EXTERNAL MODULE: external "next-i18next"
var external_next_i18next_ = __webpack_require__(1377);
// EXTERNAL MODULE: ./src/components/errorboundry.jsx
var errorboundry = __webpack_require__(9193);
// EXTERNAL MODULE: ./node_modules/next/dynamic.js
var dynamic = __webpack_require__(5152);
var dynamic_default = /*#__PURE__*/__webpack_require__.n(dynamic);
;// CONCATENATED MODULE: ./src/widgets/components.js

const components = {
  adguard: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(9367)]).then(__webpack_require__.bind(__webpack_require__, 9367)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./adguard/component"]
    }
  }),
  atsumeru: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(6260)]).then(__webpack_require__.bind(__webpack_require__, 6260)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./atsumeru/component"]
    }
  }),
  audiobookshelf: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(7334)]).then(__webpack_require__.bind(__webpack_require__, 7334)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./audiobookshelf/component"]
    }
  }),
  authentik: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(3747)]).then(__webpack_require__.bind(__webpack_require__, 3747)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./authentik/component"]
    }
  }),
  autobrr: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(8239)]).then(__webpack_require__.bind(__webpack_require__, 8239)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./autobrr/component"]
    }
  }),
  azuredevops: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(4830)]).then(__webpack_require__.bind(__webpack_require__, 4830)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./azuredevops/component"]
    }
  }),
  bazarr: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(2122)]).then(__webpack_require__.bind(__webpack_require__, 700)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./bazarr/component"]
    }
  }),
  caddy: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(1027)]).then(__webpack_require__.bind(__webpack_require__, 1027)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./caddy/component"]
    }
  }),
  calendar: dynamic_default()(() => __webpack_require__.e(/* import() */ 2300).then(__webpack_require__.bind(__webpack_require__, 2300)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./calendar/component"]
    }
  }),
  calibreweb: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(3608)]).then(__webpack_require__.bind(__webpack_require__, 3608)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./calibreweb/component"]
    }
  }),
  changedetectionio: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(9996)]).then(__webpack_require__.bind(__webpack_require__, 9996)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./changedetectionio/component"]
    }
  }),
  channelsdvrserver: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(8853)]).then(__webpack_require__.bind(__webpack_require__, 8853)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./channelsdvrserver/component"]
    }
  }),
  cloudflared: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(6752)]).then(__webpack_require__.bind(__webpack_require__, 6752)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./cloudflared/component"]
    }
  }),
  coinmarketcap: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(8648)]).then(__webpack_require__.bind(__webpack_require__, 8648)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./coinmarketcap/component"]
    }
  }),
  iframe: dynamic_default()(() => __webpack_require__.e(/* import() */ 9068).then(__webpack_require__.bind(__webpack_require__, 9068)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./iframe/component"]
    }
  }),
  customapi: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(3902)]).then(__webpack_require__.bind(__webpack_require__, 3902)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./customapi/component"]
    }
  }),
  deluge: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(2654)]).then(__webpack_require__.bind(__webpack_require__, 2654)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./deluge/component"]
    }
  }),
  diskstation: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(527)]).then(__webpack_require__.bind(__webpack_require__, 527)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./diskstation/component"]
    }
  }),
  downloadstation: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(2825)]).then(__webpack_require__.bind(__webpack_require__, 2825)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./downloadstation/component"]
    }
  }),
  docker: dynamic_default()(() => Promise.resolve(/* import() */).then(__webpack_require__.bind(__webpack_require__, 2613)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./docker/component"]
    }
  }),
  kubernetes: dynamic_default()(() => Promise.resolve(/* import() */).then(__webpack_require__.bind(__webpack_require__, 5889)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./kubernetes/component"]
    }
  }),
  emby: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(7613)]).then(__webpack_require__.bind(__webpack_require__, 7613)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./emby/component"]
    }
  }),
  evcc: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(782)]).then(__webpack_require__.bind(__webpack_require__, 782)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./evcc/component"]
    }
  }),
  fileflows: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(2978)]).then(__webpack_require__.bind(__webpack_require__, 2978)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./fileflows/component"]
    }
  }),
  flood: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(2559)]).then(__webpack_require__.bind(__webpack_require__, 2559)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./flood/component"]
    }
  }),
  freshrss: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(2180)]).then(__webpack_require__.bind(__webpack_require__, 2180)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./freshrss/component"]
    }
  }),
  fritzbox: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(6922)]).then(__webpack_require__.bind(__webpack_require__, 6922)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./fritzbox/component"]
    }
  }),
  gamedig: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(9218)]).then(__webpack_require__.bind(__webpack_require__, 9218)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./gamedig/component"]
    }
  }),
  ghostfolio: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(1965)]).then(__webpack_require__.bind(__webpack_require__, 1965)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./ghostfolio/component"]
    }
  }),
  glances: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(3341)]).then(__webpack_require__.bind(__webpack_require__, 3341)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./glances/component"]
    }
  }),
  gluetun: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(6496)]).then(__webpack_require__.bind(__webpack_require__, 6496)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./gluetun/component"]
    }
  }),
  gotify: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(914)]).then(__webpack_require__.bind(__webpack_require__, 914)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./gotify/component"]
    }
  }),
  grafana: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(816)]).then(__webpack_require__.bind(__webpack_require__, 816)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./grafana/component"]
    }
  }),
  hdhomerun: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(1713)]).then(__webpack_require__.bind(__webpack_require__, 1713)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./hdhomerun/component"]
    }
  }),
  peanut: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(9918)]).then(__webpack_require__.bind(__webpack_require__, 9918)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./peanut/component"]
    }
  }),
  homeassistant: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(3285)]).then(__webpack_require__.bind(__webpack_require__, 3285)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./homeassistant/component"]
    }
  }),
  homebridge: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(4238)]).then(__webpack_require__.bind(__webpack_require__, 4238)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./homebridge/component"]
    }
  }),
  healthchecks: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(2241), __webpack_require__.e(6736)]).then(__webpack_require__.bind(__webpack_require__, 6736)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./healthchecks/component"]
    }
  }),
  immich: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(8322)]).then(__webpack_require__.bind(__webpack_require__, 8322)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./immich/component"]
    }
  }),
  jackett: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(3530)]).then(__webpack_require__.bind(__webpack_require__, 3530)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./jackett/component"]
    }
  }),
  jdownloader: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(7649)]).then(__webpack_require__.bind(__webpack_require__, 7649)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./jdownloader/component"]
    }
  }),
  jellyfin: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(7613)]).then(__webpack_require__.bind(__webpack_require__, 7613)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./emby/component"]
    }
  }),
  jellyseerr: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(3602)]).then(__webpack_require__.bind(__webpack_require__, 3602)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./jellyseerr/component"]
    }
  }),
  kavita: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(6294)]).then(__webpack_require__.bind(__webpack_require__, 6294)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./kavita/component"]
    }
  }),
  komga: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(556)]).then(__webpack_require__.bind(__webpack_require__, 556)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./komga/component"]
    }
  }),
  kopia: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(4950)]).then(__webpack_require__.bind(__webpack_require__, 4950)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./kopia/component"]
    }
  }),
  lidarr: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(7997)]).then(__webpack_require__.bind(__webpack_require__, 7997)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./lidarr/component"]
    }
  }),
  mastodon: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(4109)]).then(__webpack_require__.bind(__webpack_require__, 4109)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./mastodon/component"]
    }
  }),
  mealie: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(4922)]).then(__webpack_require__.bind(__webpack_require__, 4922)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./mealie/component"]
    }
  }),
  medusa: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(8752)]).then(__webpack_require__.bind(__webpack_require__, 8752)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./medusa/component"]
    }
  }),
  minecraft: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(680)]).then(__webpack_require__.bind(__webpack_require__, 680)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./minecraft/component"]
    }
  }),
  miniflux: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(3730)]).then(__webpack_require__.bind(__webpack_require__, 3730)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./miniflux/component"]
    }
  }),
  mikrotik: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(2903)]).then(__webpack_require__.bind(__webpack_require__, 2903)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./mikrotik/component"]
    }
  }),
  mjpeg: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(5675), __webpack_require__.e(7908)]).then(__webpack_require__.bind(__webpack_require__, 7908)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./mjpeg/component"]
    }
  }),
  moonraker: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(1749)]).then(__webpack_require__.bind(__webpack_require__, 1749)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./moonraker/component"]
    }
  }),
  mylar: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(2425)]).then(__webpack_require__.bind(__webpack_require__, 2425)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./mylar/component"]
    }
  }),
  navidrome: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(3668)]).then(__webpack_require__.bind(__webpack_require__, 3668)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./navidrome/component"]
    }
  }),
  nextcloud: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(4136)]).then(__webpack_require__.bind(__webpack_require__, 4136)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./nextcloud/component"]
    }
  }),
  nextdns: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(2719)]).then(__webpack_require__.bind(__webpack_require__, 2719)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./nextdns/component"]
    }
  }),
  npm: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(8691)]).then(__webpack_require__.bind(__webpack_require__, 8691)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./npm/component"]
    }
  }),
  nzbget: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(3901)]).then(__webpack_require__.bind(__webpack_require__, 3901)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./nzbget/component"]
    }
  }),
  octoprint: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(9723)]).then(__webpack_require__.bind(__webpack_require__, 9723)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./octoprint/component"]
    }
  }),
  omada: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(9114)]).then(__webpack_require__.bind(__webpack_require__, 9114)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./omada/component"]
    }
  }),
  ombi: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(4703)]).then(__webpack_require__.bind(__webpack_require__, 4703)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./ombi/component"]
    }
  }),
  opendtu: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(5849)]).then(__webpack_require__.bind(__webpack_require__, 5849)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./opendtu/component"]
    }
  }),
  opnsense: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(2541)]).then(__webpack_require__.bind(__webpack_require__, 2541)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./opnsense/component"]
    }
  }),
  overseerr: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(8315)]).then(__webpack_require__.bind(__webpack_require__, 8315)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./overseerr/component"]
    }
  }),
  openmediavault: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(8194)]).then(__webpack_require__.bind(__webpack_require__, 8194)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./openmediavault/component"]
    }
  }),
  paperlessngx: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(9323)]).then(__webpack_require__.bind(__webpack_require__, 9323)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./paperlessngx/component"]
    }
  }),
  pfsense: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(5623)]).then(__webpack_require__.bind(__webpack_require__, 5623)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./pfsense/component"]
    }
  }),
  photoprism: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(7277)]).then(__webpack_require__.bind(__webpack_require__, 7277)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./photoprism/component"]
    }
  }),
  proxmoxbackupserver: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(568)]).then(__webpack_require__.bind(__webpack_require__, 568)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./proxmoxbackupserver/component"]
    }
  }),
  pialert: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(134)]).then(__webpack_require__.bind(__webpack_require__, 134)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./pialert/component"]
    }
  }),
  pihole: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(9031)]).then(__webpack_require__.bind(__webpack_require__, 9031)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./pihole/component"]
    }
  }),
  plex: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(7571)]).then(__webpack_require__.bind(__webpack_require__, 7571)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./plex/component"]
    }
  }),
  portainer: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(4552)]).then(__webpack_require__.bind(__webpack_require__, 4552)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./portainer/component"]
    }
  }),
  prometheus: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(9811)]).then(__webpack_require__.bind(__webpack_require__, 9811)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./prometheus/component"]
    }
  }),
  prowlarr: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(9514)]).then(__webpack_require__.bind(__webpack_require__, 9514)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./prowlarr/component"]
    }
  }),
  proxmox: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(2844)]).then(__webpack_require__.bind(__webpack_require__, 2844)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./proxmox/component"]
    }
  }),
  pterodactyl: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(9273)]).then(__webpack_require__.bind(__webpack_require__, 9273)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./pterodactyl/component"]
    }
  }),
  pyload: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(6930)]).then(__webpack_require__.bind(__webpack_require__, 6930)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./pyload/component"]
    }
  }),
  qbittorrent: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(7429)]).then(__webpack_require__.bind(__webpack_require__, 7429)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./qbittorrent/component"]
    }
  }),
  qnap: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(1490)]).then(__webpack_require__.bind(__webpack_require__, 1490)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./qnap/component"]
    }
  }),
  radarr: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(6813), __webpack_require__.e(1239)]).then(__webpack_require__.bind(__webpack_require__, 1239)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./radarr/component"]
    }
  }),
  readarr: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(3652)]).then(__webpack_require__.bind(__webpack_require__, 3652)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./readarr/component"]
    }
  }),
  rutorrent: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(3689)]).then(__webpack_require__.bind(__webpack_require__, 3689)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./rutorrent/component"]
    }
  }),
  sabnzbd: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(9319)]).then(__webpack_require__.bind(__webpack_require__, 9319)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./sabnzbd/component"]
    }
  }),
  scrutiny: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(5818)]).then(__webpack_require__.bind(__webpack_require__, 5818)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./scrutiny/component"]
    }
  }),
  sonarr: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(6813), __webpack_require__.e(116)]).then(__webpack_require__.bind(__webpack_require__, 116)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./sonarr/component"]
    }
  }),
  speedtest: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(2451)]).then(__webpack_require__.bind(__webpack_require__, 2451)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./speedtest/component"]
    }
  }),
  strelaysrv: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(2571)]).then(__webpack_require__.bind(__webpack_require__, 2571)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./strelaysrv/component"]
    }
  }),
  tailscale: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(1686)]).then(__webpack_require__.bind(__webpack_require__, 1686)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./tailscale/component"]
    }
  }),
  tautulli: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(66)]).then(__webpack_require__.bind(__webpack_require__, 66)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./tautulli/component"]
    }
  }),
  tdarr: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(5318)]).then(__webpack_require__.bind(__webpack_require__, 5318)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./tdarr/component"]
    }
  }),
  traefik: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(3296)]).then(__webpack_require__.bind(__webpack_require__, 3296)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./traefik/component"]
    }
  }),
  transmission: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(8442)]).then(__webpack_require__.bind(__webpack_require__, 8442)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./transmission/component"]
    }
  }),
  tubearchivist: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(4310)]).then(__webpack_require__.bind(__webpack_require__, 4310)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./tubearchivist/component"]
    }
  }),
  truenas: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(4734)]).then(__webpack_require__.bind(__webpack_require__, 4734)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./truenas/component"]
    }
  }),
  unifi: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(8977)]).then(__webpack_require__.bind(__webpack_require__, 8977)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./unifi/component"]
    }
  }),
  unmanic: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(7288)]).then(__webpack_require__.bind(__webpack_require__, 7288)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./unmanic/component"]
    }
  }),
  uptimekuma: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(9384)]).then(__webpack_require__.bind(__webpack_require__, 9384)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./uptimekuma/component"]
    }
  }),
  uptimerobot: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(4713)]).then(__webpack_require__.bind(__webpack_require__, 4713)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./uptimerobot/component"]
    }
  }),
  urbackup: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(3813)]).then(__webpack_require__.bind(__webpack_require__, 3813)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./urbackup/component"]
    }
  }),
  watchtower: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(1695)]).then(__webpack_require__.bind(__webpack_require__, 1695)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./watchtower/component"]
    }
  }),
  whatsupdocker: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(1118)]).then(__webpack_require__.bind(__webpack_require__, 1118)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./whatsupdocker/component"]
    }
  }),
  xteve: dynamic_default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(1178)]).then(__webpack_require__.bind(__webpack_require__, 1178)), {
    loadableGenerated: {
      modules: ["../widgets/components.js -> " + "./xteve/component"]
    }
  })
};
/* harmony default export */ const widgets_components = (components);
// EXTERNAL MODULE: external "react/jsx-runtime"
var jsx_runtime_ = __webpack_require__(997);
;// CONCATENATED MODULE: ./src/components/services/widget.jsx




function Widget({
  service
}) {
  const {
    t
  } = (0,external_next_i18next_.useTranslation)("common");
  const ServiceWidget = widgets_components[service.widget.type];

  if (ServiceWidget) {
    return /*#__PURE__*/jsx_runtime_.jsx(errorboundry/* default */.Z, {
      children: /*#__PURE__*/jsx_runtime_.jsx(ServiceWidget, {
        service: service
      })
    });
  }

  return /*#__PURE__*/jsx_runtime_.jsx("div", {
    className: "bg-theme-200/50 dark:bg-theme-900/20 rounded m-1 flex-1 flex flex-col items-center justify-center p-1 service-missing",
    children: /*#__PURE__*/jsx_runtime_.jsx("div", {
      className: "font-thin text-sm",
      children: t("widget.missing_type", {
        type: service.widget.type
      })
    })
  });
}

/***/ }),

/***/ 403:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ Block)
/* harmony export */ });
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(9003);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);




function Block({
  value,
  label
}) {
  const {
    t
  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_0__.useTranslation)();
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_1___default()("bg-theme-200/50 dark:bg-theme-900/20 rounded m-1 flex-1 flex flex-col items-center justify-center text-center p-1", value === undefined ? "animate-pulse" : "", "service-block"),
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx("div", {
      className: "font-thin text-sm",
      children: value === undefined || value === null ? "-" : value
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx("div", {
      className: "font-bold text-xs uppercase",
      children: t(label)
    })]
  });
}

/***/ }),

/***/ 8581:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ Container)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _error__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8659);
/* harmony import */ var utils_contexts_settings__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(9317);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);




function Container({
  error = false,
  children,
  service
}) {
  const {
    settings
  } = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(utils_contexts_settings__WEBPACK_IMPORTED_MODULE_2__/* .SettingsContext */ .J);

  if (error) {
    if (settings.hideErrors || service.widget.hide_errors) {
      return null;
    }

    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx(_error__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
      service: service,
      error: error
    });
  }

  const childrenArray = Array.isArray(children) ? children : [children];
  let visibleChildren = childrenArray;
  let fields = service?.widget?.fields;
  if (typeof fields === "string") fields = JSON.parse(service.widget.fields);
  const type = service?.widget?.type;

  if (fields && type) {
    // if the field contains a "." then it most likely contains a common loc value
    // logic now allows a fields array that can look like:
    // fields: [ "resources.cpu", "resources.mem", "field"]
    // or even
    // fields: [ "resources.cpu", "widget_type.field" ]
    visibleChildren = childrenArray?.filter(child => fields.some(field => {
      let fullField = field;

      if (!field.includes(".")) {
        fullField = `${type}.${field}`;
      }

      return fullField === child?.props?.label;
    }));
  }

  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx("div", {
    className: "relative flex flex-row w-full service-container",
    children: visibleChildren
  });
}

/***/ }),

/***/ 8659:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ Error)
/* harmony export */ });
/* harmony import */ var react_i18next__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9709);
/* harmony import */ var react_i18next__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_i18next__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_icons_io5__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(9989);
/* harmony import */ var react_icons_io5__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_icons_io5__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);





function displayError(error) {
  return JSON.stringify(error[1] ? error[1] : error, null, 4);
}

function displayData(data) {
  return data.type === "Buffer" ? Buffer.from(data).toString() : JSON.stringify(data, 4);
}

function Error({
  error
}) {
  const {
    t
  } = (0,react_i18next__WEBPACK_IMPORTED_MODULE_0__.useTranslation)();

  if (error?.data?.error) {
    error = error.data.error; // eslint-disable-line no-param-reassign
  }

  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("details", {
    className: "px-1 pb-1",
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx("summary", {
      className: "block text-center mt-1 mb-0 mx-auto p-3 rounded bg-rose-900/80 hover:bg-rose-900/95 text-theme-900 cursor-pointer",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
        className: "flex items-center justify-center text-xs font-bold",
        children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx(react_icons_io5__WEBPACK_IMPORTED_MODULE_1__.IoAlertCircle, {
          className: "mr-1 w-5 h-5"
        }), t("widget.api_error"), " ", error.message && t("widget.information")]
      })
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx("div", {
      className: "bg-white dark:bg-theme-200/50 mt-2 rounded text-rose-900 text-xs font-mono whitespace-pre-wrap break-all",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("ul", {
        className: "p-4",
        children: [error.message && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("li", {
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("span", {
            className: "text-black",
            children: [t("widget.api_error"), ":"]
          }), " ", error.message]
        }), error.url && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("li", {
          className: "mt-2",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("span", {
            className: "text-black",
            children: [t("widget.url"), ":"]
          }), " ", error.url]
        }), error.rawError && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("li", {
          className: "mt-2",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("span", {
            className: "text-black",
            children: [t("widget.raw_error"), ":"]
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx("div", {
            className: "ml-2",
            children: displayError(error.rawError)
          })]
        }), error.data && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("li", {
          className: "mt-2",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("span", {
            className: "text-black",
            children: [t("widget.response_data"), ":"]
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx("div", {
            className: "ml-2",
            children: displayData(error.data)
          })]
        })]
      })
    })]
  });
}

/***/ }),

/***/ 4838:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ Tab),
/* harmony export */   "l": () => (/* binding */ slugify)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(9003);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var utils_contexts_tab__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(42);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);




function slugify(tabName) {
  return tabName !== undefined ? encodeURIComponent(tabName.toString().replace(/\s+/g, "-").toLowerCase()) : "";
}
function Tab({
  tab
}) {
  const {
    activeTab,
    setActiveTab
  } = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(utils_contexts_tab__WEBPACK_IMPORTED_MODULE_2__/* .TabContext */ .q);
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx("li", {
    role: "presentation",
    className: classnames__WEBPACK_IMPORTED_MODULE_1___default()("text-theme-700 dark:text-theme-200 relative h-10 w-full rounded-md flex"),
    children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx("button", {
      id: `${tab}-tab`,
      type: "button",
      role: "tab",
      "aria-controls": `#${tab}`,
      "aria-selected": activeTab === slugify(tab) ? "true" : "false",
      className: classnames__WEBPACK_IMPORTED_MODULE_1___default()("w-full rounded-md m-1", activeTab === slugify(tab) ? "bg-theme-300/20 dark:bg-white/10" : "hover:bg-theme-100/20 dark:hover:bg-white/5"),
      onClick: () => {
        setActiveTab(slugify(tab));
        window.location.hash = `#${slugify(tab)}`;
      },
      children: tab
    })
  }, tab);
}

/***/ }),

/***/ 7578:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ Revalidate)
/* harmony export */ });
/* harmony import */ var react_icons_md__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4041);
/* harmony import */ var react_icons_md__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_icons_md__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__);


function Revalidate() {
  const revalidate = () => {
    fetch("/api/revalidate").then(res => {
      if (res.ok) {
        window.location.reload();
      }
    });
  };

  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx("div", {
    id: "revalidate",
    className: "rounded-full flex align-middle self-center mr-3",
    children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx(react_icons_md__WEBPACK_IMPORTED_MODULE_0__.MdRefresh, {
      onClick: () => revalidate(),
      className: "text-theme-800 dark:text-theme-200 w-6 h-6 cursor-pointer"
    })
  });
}

/***/ }),

/***/ 8874:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Search),
/* harmony export */   "getStoredProvider": () => (/* binding */ getStoredProvider),
/* harmony export */   "searchProviders": () => (/* binding */ searchProviders)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(1377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_icons_fi__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(2750);
/* harmony import */ var react_icons_fi__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_icons_fi__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_icons_si__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(764);
/* harmony import */ var react_icons_si__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_icons_si__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _headlessui_react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(1185);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(9003);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _widget_container_form__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(5445);
/* harmony import */ var _widget_raw__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(1464);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_headlessui_react__WEBPACK_IMPORTED_MODULE_4__]);
_headlessui_react__WEBPACK_IMPORTED_MODULE_4__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];










const searchProviders = {
  google: {
    name: "Google",
    url: "https://www.google.com/search?q=",
    icon: react_icons_si__WEBPACK_IMPORTED_MODULE_3__.SiGoogle
  },
  duckduckgo: {
    name: "DuckDuckGo",
    url: "https://duckduckgo.com/?q=",
    icon: react_icons_si__WEBPACK_IMPORTED_MODULE_3__.SiDuckduckgo
  },
  bing: {
    name: "Bing",
    url: "https://www.bing.com/search?q=",
    icon: react_icons_si__WEBPACK_IMPORTED_MODULE_3__.SiMicrosoftbing
  },
  baidu: {
    name: "Baidu",
    url: "https://www.baidu.com/s?wd=",
    icon: react_icons_si__WEBPACK_IMPORTED_MODULE_3__.SiBaidu
  },
  brave: {
    name: "Brave",
    url: "https://search.brave.com/search?q=",
    icon: react_icons_si__WEBPACK_IMPORTED_MODULE_3__.SiBrave
  },
  custom: {
    name: "Custom",
    url: false,
    icon: react_icons_fi__WEBPACK_IMPORTED_MODULE_2__.FiSearch
  }
};

function getAvailableProviderIds(options) {
  if (options.provider && Array.isArray(options.provider)) {
    return Object.keys(searchProviders).filter(value => options.provider.includes(value));
  }

  if (options.provider && searchProviders[options.provider]) {
    return [options.provider];
  }

  return null;
}

const localStorageKey = "search-name";
function getStoredProvider() {
  if (false) {}

  return null;
}
function Search({
  options
}) {
  const {
    t
  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_1__.useTranslation)();
  const availableProviderIds = getAvailableProviderIds(options);
  const {
    0: query,
    1: setQuery
  } = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)("");
  const {
    0: selectedProvider,
    1: setSelectedProvider
  } = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(searchProviders[availableProviderIds[0] ?? searchProviders.google]);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    const storedProvider = getStoredProvider();
    let storedProviderKey = null;
    storedProviderKey = Object.keys(searchProviders).find(pkey => searchProviders[pkey] === storedProvider);

    if (storedProvider && availableProviderIds.includes(storedProviderKey)) {
      setSelectedProvider(storedProvider);
    }
  }, [availableProviderIds]);
  const submitCallback = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(event => {
    const q = encodeURIComponent(query);
    const {
      url
    } = selectedProvider;

    if (url) {
      window.open(`${url}${q}`, options.target || "_blank");
    } else {
      window.open(`${options.url}${q}`, options.target || "_blank");
    }

    event.preventDefault();
    event.target.reset();
    setQuery("");
  }, [options.target, options.url, query, selectedProvider]);

  if (!availableProviderIds) {
    return null;
  }

  const onChangeProvider = provider => {
    setSelectedProvider(provider);
    localStorage.setItem(localStorageKey, provider.name);
  };

  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_widget_container_form__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
    options: options,
    callback: submitCallback,
    additionalClassNames: "grow information-widget-search",
    children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_widget_raw__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z, {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
        className: "flex-col relative h-8 my-4 min-w-fit",
        children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx("div", {
          className: "flex absolute inset-y-0 left-0 items-center pl-3 pointer-events-none w-full text-theme-800 dark:text-white"
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx("input", {
          type: "text",
          className: " overflow-hidden w-full h-full rounded-md text-xs text-theme-900 dark:text-white placeholder-theme-900 dark:placeholder-white/80 bg-white/50 dark:bg-white/10 focus:ring-theme-500 dark:focus:ring-white/50 focus:border-theme-500 dark:focus:border-white/50 border border-theme-300 dark:border-theme-200/50",
          placeholder: t("search.placeholder"),
          onChange: s => setQuery(s.currentTarget.value),
          required: true,
          autoCapitalize: "off",
          autoCorrect: "off",
          autoComplete: "off" // eslint-disable-next-line jsx-a11y/no-autofocus
          ,
          autoFocus: options.focus
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(_headlessui_react__WEBPACK_IMPORTED_MODULE_4__.Listbox, {
          as: "div",
          value: selectedProvider,
          onChange: onChangeProvider,
          className: "relative text-left",
          disabled: availableProviderIds?.length === 1,
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx("div", {
            children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(_headlessui_react__WEBPACK_IMPORTED_MODULE_4__.Listbox.Button, {
              className: " absolute right-0.5 bottom-0.5 rounded-r-md px-4 py-2 border-1 text-white font-medium text-sm bg-theme-600/40 dark:bg-white/10 focus:ring-theme-500 dark:focus:ring-white/50",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(selectedProvider.icon, {
                className: "text-white w-3 h-3"
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx("span", {
                className: "sr-only",
                children: t("search.search")
              })]
            })
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_4__.Transition, {
            as: react__WEBPACK_IMPORTED_MODULE_0__.Fragment,
            enter: "transition ease-out duration-100",
            enterFrom: "transform opacity-0 scale-95",
            enterTo: "transform opacity-100 scale-100",
            leave: "transition ease-in duration-75",
            leaveFrom: "transform opacity-100 scale-100",
            leaveTo: "transform opacity-0 scale-95",
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_4__.Listbox.Options, {
              className: "absolute right-0 z-10 mt-1 origin-top-right rounded-md bg-theme-100 dark:bg-theme-600 shadow-lg ring-1 ring-black ring-opacity-5 focus:outline-none",
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx("div", {
                className: "flex flex-col",
                children: availableProviderIds.map(providerId => {
                  const p = searchProviders[providerId];
                  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_4__.Listbox.Option, {
                    value: p,
                    as: react__WEBPACK_IMPORTED_MODULE_0__.Fragment,
                    children: ({
                      active
                    }) => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx("li", {
                      className: classnames__WEBPACK_IMPORTED_MODULE_5___default()("rounded-md cursor-pointer", active ? "bg-theme-600/10 dark:bg-white/10 dark:text-gray-900" : "dark:text-gray-100"),
                      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(p.icon, {
                        className: "h-4 w-4 mx-4 my-2"
                      })
                    })
                  }, providerId);
                })
              })
            })
          })]
        })]
      })
    })
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 555:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ Widget)
/* harmony export */ });
/* harmony import */ var next_dynamic__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5152);
/* harmony import */ var next_dynamic__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(next_dynamic__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var components_errorboundry__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(9193);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }





const widgetMappings = {
  weatherapi: next_dynamic__WEBPACK_IMPORTED_MODULE_0___default()(() => Promise.all(/* import() */[__webpack_require__.e(4070), __webpack_require__.e(7)]).then(__webpack_require__.bind(__webpack_require__, 7)), {
    loadableGenerated: {
      modules: ["../components/widgets/widget.jsx -> " + "components/widgets/weather/weather"]
    }
  }),
  openweathermap: next_dynamic__WEBPACK_IMPORTED_MODULE_0___default()(() => Promise.all(/* import() */[__webpack_require__.e(4070), __webpack_require__.e(1791)]).then(__webpack_require__.bind(__webpack_require__, 1791)), {
    loadableGenerated: {
      modules: ["../components/widgets/widget.jsx -> " + "components/widgets/openweathermap/weather"]
    }
  }),
  resources: next_dynamic__WEBPACK_IMPORTED_MODULE_0___default()(() => Promise.all(/* import() */[__webpack_require__.e(169), __webpack_require__.e(3980), __webpack_require__.e(8546)]).then(__webpack_require__.bind(__webpack_require__, 8546)), {
    loadableGenerated: {
      modules: ["../components/widgets/widget.jsx -> " + "components/widgets/resources/resources"]
    }
  }),
  search: next_dynamic__WEBPACK_IMPORTED_MODULE_0___default()(() => Promise.resolve(/* import() */).then(__webpack_require__.bind(__webpack_require__, 8874)), {
    loadableGenerated: {
      modules: ["../components/widgets/widget.jsx -> " + "components/widgets/search/search"]
    }
  }),
  greeting: next_dynamic__WEBPACK_IMPORTED_MODULE_0___default()(() => __webpack_require__.e(/* import() */ 1590).then(__webpack_require__.bind(__webpack_require__, 1590)), {
    loadableGenerated: {
      modules: ["../components/widgets/widget.jsx -> " + "components/widgets/greeting/greeting"]
    }
  }),
  datetime: next_dynamic__WEBPACK_IMPORTED_MODULE_0___default()(() => __webpack_require__.e(/* import() */ 2767).then(__webpack_require__.bind(__webpack_require__, 2767)), {
    loadableGenerated: {
      modules: ["../components/widgets/widget.jsx -> " + "components/widgets/datetime/datetime"]
    }
  }),
  logo: next_dynamic__WEBPACK_IMPORTED_MODULE_0___default()(() => __webpack_require__.e(/* import() */ 6776).then(__webpack_require__.bind(__webpack_require__, 6776)), {
    ssr: false,
    loadableGenerated: {
      modules: ["../components/widgets/widget.jsx -> " + "components/widgets/logo/logo"]
    }
  }),
  unifi_console: next_dynamic__WEBPACK_IMPORTED_MODULE_0___default()(() => Promise.all(/* import() */[__webpack_require__.e(4582), __webpack_require__.e(7517)]).then(__webpack_require__.bind(__webpack_require__, 7517)), {
    loadableGenerated: {
      modules: ["../components/widgets/widget.jsx -> " + "components/widgets/unifi_console/unifi_console"]
    }
  }),
  glances: next_dynamic__WEBPACK_IMPORTED_MODULE_0___default()(() => Promise.all(/* import() */[__webpack_require__.e(169), __webpack_require__.e(3980), __webpack_require__.e(6007)]).then(__webpack_require__.bind(__webpack_require__, 6007)), {
    loadableGenerated: {
      modules: ["../components/widgets/widget.jsx -> " + "components/widgets/glances/glances"]
    }
  }),
  openmeteo: next_dynamic__WEBPACK_IMPORTED_MODULE_0___default()(() => Promise.all(/* import() */[__webpack_require__.e(4070), __webpack_require__.e(7817)]).then(__webpack_require__.bind(__webpack_require__, 7817)), {
    loadableGenerated: {
      modules: ["../components/widgets/widget.jsx -> " + "components/widgets/openmeteo/openmeteo"]
    }
  }),
  longhorn: next_dynamic__WEBPACK_IMPORTED_MODULE_0___default()(() => Promise.all(/* import() */[__webpack_require__.e(169), __webpack_require__.e(3980), __webpack_require__.e(5595)]).then(__webpack_require__.bind(__webpack_require__, 5595)), {
    loadableGenerated: {
      modules: ["../components/widgets/widget.jsx -> " + "components/widgets/longhorn/longhorn"]
    }
  }),
  kubernetes: next_dynamic__WEBPACK_IMPORTED_MODULE_0___default()(() => Promise.all(/* import() */[__webpack_require__.e(169), __webpack_require__.e(864)]).then(__webpack_require__.bind(__webpack_require__, 864)), {
    loadableGenerated: {
      modules: ["../components/widgets/widget.jsx -> " + "components/widgets/kubernetes/kubernetes"]
    }
  })
};
function Widget({
  widget,
  style
}) {
  const InfoWidget = widgetMappings[widget.type];

  if (InfoWidget) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx(components_errorboundry__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx(InfoWidget, {
        options: _objectSpread(_objectSpread({}, widget.options), {}, {
          style
        })
      })
    });
  }

  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
    className: "flex-none flex flex-row items-center justify-center",
    children: ["Missing ", /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx("strong", {
      children: widget.type
    })]
  });
}

/***/ }),

/***/ 4843:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Ld": () => (/* binding */ getAllClasses),
/* harmony export */   "TS": () => (/* binding */ getBottomBlock),
/* harmony export */   "ZP": () => (/* binding */ Container),
/* harmony export */   "w_": () => (/* binding */ getInnerBlock)
/* harmony export */ });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9003);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _widget_icon__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6254);
/* harmony import */ var _primary_text__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(8312);
/* harmony import */ var _secondary_text__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(7508);
/* harmony import */ var _raw__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(1464);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__);







function getAllClasses(options, additionalClassNames = "") {
  if (options?.style?.header === "boxedWidgets") {
    if (options?.style?.cardBlur !== undefined) {
      // eslint-disable-next-line no-param-reassign
      additionalClassNames = [additionalClassNames, `backdrop-blur${options.style.cardBlur.length ? "-" : ""}${options.style.cardBlur}`].join(" ");
    }

    return classnames__WEBPACK_IMPORTED_MODULE_0___default()("flex flex-col justify-center ml-2 mr-2", "mt-2 m:mb-0 rounded-md shadow-md shadow-theme-900/10 dark:shadow-theme-900/20 bg-theme-100/20 dark:bg-white/5 p-2 pl-3 pr-3", additionalClassNames);
  }

  let widgetAlignedClasses = "flex flex-col max-w:full sm:basis-auto self-center grow-0 flex-wrap";

  if (options?.style?.isRightAligned) {
    widgetAlignedClasses = "flex flex-col justify-center first:ml-auto ml-2 mr-2 ";
  }

  return classnames__WEBPACK_IMPORTED_MODULE_0___default()(widgetAlignedClasses, additionalClassNames);
}
function getInnerBlock(children) {
  // children won't be an array if it's Raw component
  return Array.isArray(children) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
    className: "flex flex-row items-center justify-end widget-inner",
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx("div", {
      className: "flex flex-col items-center widget-inner-icon",
      children: children.find(child => child.type === _widget_icon__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z)
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
      className: "flex flex-col ml-3 text-left widget-inner-text",
      children: [children.find(child => child.type === _primary_text__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z), children.find(child => child.type === _secondary_text__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z)]
    })]
  });
}
function getBottomBlock(children) {
  if (children.type !== _raw__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z) {
    return children.find(child => child.type === _raw__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z) || [];
  }

  return [children];
}
function Container({
  children = [],
  options,
  additionalClassNames = ""
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
    className: getAllClasses(options, `${additionalClassNames} widget-container`),
    children: [getInnerBlock(children), getBottomBlock(children)]
  });
}

/***/ }),

/***/ 5445:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ ContainerForm)
/* harmony export */ });
/* harmony import */ var _container__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4843);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__);


function ContainerForm({
  children = [],
  options,
  additionalClassNames = "",
  callback
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("form", {
    type: "button",
    onSubmit: callback,
    className: `${(0,_container__WEBPACK_IMPORTED_MODULE_0__/* .getAllClasses */ .Ld)(options, additionalClassNames)} information-widget-form`,
    children: [(0,_container__WEBPACK_IMPORTED_MODULE_0__/* .getInnerBlock */ .w_)(children), (0,_container__WEBPACK_IMPORTED_MODULE_0__/* .getBottomBlock */ .TS)(children)]
  });
}

/***/ }),

/***/ 8312:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ PrimaryText)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

function PrimaryText({
  children
}) {
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
    className: "primary-text text-theme-800 dark:text-theme-200 text-sm",
    children: children
  });
}

/***/ }),

/***/ 1464:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ Raw)
/* harmony export */ });
function Raw({
  children
}) {
  if (children.type === Raw) {
    return [children];
  }

  return children;
}

/***/ }),

/***/ 7508:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ SecondaryText)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

function SecondaryText({
  children
}) {
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
    className: "secondary-text text-theme-800 dark:text-theme-200 text-xs",
    children: children
  });
}

/***/ }),

/***/ 6254:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ WidgetIcon)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

function WidgetIcon({
  icon,
  size = "s",
  pulse = false
}) {
  const Icon = icon;
  let additionalClasses = "information-widget-icon text-theme-800 dark:text-theme-200 ";

  switch (size) {
    case "m":
      additionalClasses += "w-6 h-6 ";
      break;

    case "l":
      additionalClasses += "w-8 h-8 ";
      break;

    case "xl":
      additionalClasses += "w-10 h-10 ";
      break;

    default:
      additionalClasses += "w-5 h-5 ";
  }

  if (pulse) {
    additionalClasses += "animate-pulse ";
  }

  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(Icon, {
    className: additionalClasses
  });
}

/***/ }),

/***/ 6243:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Wrapper),
/* harmony export */   "getStaticProps": () => (/* binding */ getStaticProps)
/* harmony export */ });
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5941);
/* harmony import */ var next_head__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(968);
/* harmony import */ var next_head__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(next_head__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var next_dynamic__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5152);
/* harmony import */ var next_dynamic__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(next_dynamic__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(9003);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(1377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(6689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var react_icons_bi__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(6652);
/* harmony import */ var react_icons_bi__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react_icons_bi__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var next_i18next_serverSideTranslations__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(5460);
/* harmony import */ var next_i18next_serverSideTranslations__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(next_i18next_serverSideTranslations__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(1853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var components_tab__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(4838);
/* harmony import */ var components_filecontent__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(540);
/* harmony import */ var components_services_group__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(5412);
/* harmony import */ var components_bookmarks_group__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(6426);
/* harmony import */ var components_widgets_widget__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(555);
/* harmony import */ var components_toggles_revalidate__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(7578);
/* harmony import */ var utils_logger__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(8204);
/* harmony import */ var utils_hooks_window_focus__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(5826);
/* harmony import */ var utils_config_config__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(9365);
/* harmony import */ var utils_contexts_color__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(2112);
/* harmony import */ var utils_contexts_theme__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(7894);
/* harmony import */ var utils_contexts_settings__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(9317);
/* harmony import */ var utils_contexts_tab__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(42);
/* harmony import */ var utils_config_api_response__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(3093);
/* harmony import */ var components_errorboundry__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(9193);
/* harmony import */ var utils_styles_themes__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(8726);
/* harmony import */ var components_quicklaunch__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(2298);
/* harmony import */ var components_widgets_search_search__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(8874);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([swr__WEBPACK_IMPORTED_MODULE_0__, components_filecontent__WEBPACK_IMPORTED_MODULE_10__, components_services_group__WEBPACK_IMPORTED_MODULE_11__, components_bookmarks_group__WEBPACK_IMPORTED_MODULE_12__, utils_logger__WEBPACK_IMPORTED_MODULE_15__, utils_config_config__WEBPACK_IMPORTED_MODULE_17__, utils_config_api_response__WEBPACK_IMPORTED_MODULE_22__, components_widgets_search_search__WEBPACK_IMPORTED_MODULE_26__]);
([swr__WEBPACK_IMPORTED_MODULE_0__, components_filecontent__WEBPACK_IMPORTED_MODULE_10__, components_services_group__WEBPACK_IMPORTED_MODULE_11__, components_bookmarks_group__WEBPACK_IMPORTED_MODULE_12__, utils_logger__WEBPACK_IMPORTED_MODULE_15__, utils_config_config__WEBPACK_IMPORTED_MODULE_17__, utils_config_api_response__WEBPACK_IMPORTED_MODULE_22__, components_widgets_search_search__WEBPACK_IMPORTED_MODULE_26__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
const _excluded = ["providers"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/* eslint-disable react/no-array-index-key */






























const ThemeToggle = next_dynamic__WEBPACK_IMPORTED_MODULE_2___default()(() => __webpack_require__.e(/* import() */ 8085).then(__webpack_require__.bind(__webpack_require__, 8085)), {
  ssr: false,
  loadableGenerated: {
    modules: ["index.jsx -> " + "components/toggles/theme"]
  }
});
const ColorToggle = next_dynamic__WEBPACK_IMPORTED_MODULE_2___default()(() => __webpack_require__.e(/* import() */ 8642).then(__webpack_require__.bind(__webpack_require__, 8642)), {
  ssr: false,
  loadableGenerated: {
    modules: ["index.jsx -> " + "components/toggles/color"]
  }
});
const Version = next_dynamic__WEBPACK_IMPORTED_MODULE_2___default()(() => __webpack_require__.e(/* import() */ 1281).then(__webpack_require__.bind(__webpack_require__, 1281)), {
  ssr: false,
  loadableGenerated: {
    modules: ["index.jsx -> " + "components/version"]
  }
});
const rightAlignedWidgets = ["weatherapi", "openweathermap", "weather", "openmeteo", "search", "datetime"];
async function getStaticProps() {
  let logger;

  try {
    logger = (0,utils_logger__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Z)("index");

    const _getSettings = (0,utils_config_config__WEBPACK_IMPORTED_MODULE_17__/* .getSettings */ .Gw)(),
          {
      providers
    } = _getSettings,
          settings = _objectWithoutProperties(_getSettings, _excluded);

    const services = await (0,utils_config_api_response__WEBPACK_IMPORTED_MODULE_22__/* .servicesResponse */ .bh)();
    const bookmarks = await (0,utils_config_api_response__WEBPACK_IMPORTED_MODULE_22__/* .bookmarksResponse */ .IY)();
    const widgets = await (0,utils_config_api_response__WEBPACK_IMPORTED_MODULE_22__/* .widgetsResponse */ .a5)();
    return {
      props: _objectSpread({
        initialSettings: settings,
        fallback: {
          "/api/services": services,
          "/api/bookmarks": bookmarks,
          "/api/widgets": widgets,
          "/api/hash": false
        }
      }, await (0,next_i18next_serverSideTranslations__WEBPACK_IMPORTED_MODULE_7__.serverSideTranslations)(settings.language ?? "en"))
    };
  } catch (e) {
    if (logger) {
      logger.error(e);
    }

    return {
      props: _objectSpread({
        initialSettings: {},
        fallback: {
          "/api/services": [],
          "/api/bookmarks": [],
          "/api/widgets": [],
          "/api/hash": false
        }
      }, await (0,next_i18next_serverSideTranslations__WEBPACK_IMPORTED_MODULE_7__.serverSideTranslations)("en"))
    };
  }
}

function Index({
  initialSettings,
  fallback
}) {
  const windowFocused = (0,utils_hooks_window_focus__WEBPACK_IMPORTED_MODULE_16__/* ["default"] */ .Z)();
  const {
    0: stale,
    1: setStale
  } = (0,react__WEBPACK_IMPORTED_MODULE_5__.useState)(false);
  const {
    data: errorsData
  } = (0,swr__WEBPACK_IMPORTED_MODULE_0__["default"])("/api/validate");
  const {
    data: hashData,
    mutate: mutateHash
  } = (0,swr__WEBPACK_IMPORTED_MODULE_0__["default"])("/api/hash");
  (0,react__WEBPACK_IMPORTED_MODULE_5__.useEffect)(() => {
    if (windowFocused) {
      mutateHash();
    }
  }, [windowFocused, mutateHash]);
  (0,react__WEBPACK_IMPORTED_MODULE_5__.useEffect)(() => {
    if (hashData) {
      if (false) {}
    }
  }, [hashData]);

  if (stale) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("div", {
      className: "flex items-center justify-center h-screen",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("div", {
        className: "w-24 h-24 border-2 border-theme-400 border-solid rounded-full animate-spin border-t-transparent"
      })
    });
  }

  if (errorsData && errorsData.length > 0) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("div", {
      className: "w-full h-screen container m-auto justify-center p-10 pointer-events-none",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("div", {
        className: "flex flex-col",
        children: errorsData.map((error, i) => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsxs)("div", {
          className: "basis-1/2 bg-theme-500 dark:bg-theme-600 text-theme-600 dark:text-theme-300 m-2 rounded-md font-mono shadow-md border-4 border-transparent",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsxs)("div", {
            className: "bg-amber-200 text-amber-800 dark:text-amber-200 dark:bg-amber-800 p-2 rounded-md font-bold",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(react_icons_bi__WEBPACK_IMPORTED_MODULE_6__.BiError, {
              className: "float-right w-6 h-6"
            }), error.config]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsxs)("div", {
            className: "p-2 text-theme-100 dark:text-theme-200",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("pre", {
              className: "opacity-50 font-bold pb-2",
              children: error.reason
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("pre", {
              className: "text-sm",
              children: error.mark.snippet
            })]
          })]
        }, i))
      })
    });
  }

  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(swr__WEBPACK_IMPORTED_MODULE_0__.SWRConfig, {
    value: {
      fallback,
      fetcher: (resource, init) => fetch(resource, init).then(res => res.json())
    },
    children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(components_errorboundry__WEBPACK_IMPORTED_MODULE_23__/* ["default"] */ .Z, {
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(Home, {
        initialSettings: initialSettings
      })
    })
  });
}

const headerStyles = {
  boxed: "m-6 mb-0 sm:m-9 sm:mb-0 rounded-md shadow-md shadow-theme-900/10 dark:shadow-theme-900/20 bg-theme-100/20 dark:bg-white/5 p-3",
  underlined: "m-6 mb-0 sm:m-9 sm:mb-1 border-b-2 pb-4 border-theme-800 dark:border-theme-200/50",
  clean: "m-6 mb-0 sm:m-9 sm:mb-0",
  boxedWidgets: "m-6 mb-0 sm:m-9 sm:mb-0 sm:mt-1"
};

function Home({
  initialSettings
}) {
  const {
    i18n
  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_4__.useTranslation)();
  const {
    theme,
    setTheme
  } = (0,react__WEBPACK_IMPORTED_MODULE_5__.useContext)(utils_contexts_theme__WEBPACK_IMPORTED_MODULE_19__/* .ThemeContext */ .N);
  const {
    color,
    setColor
  } = (0,react__WEBPACK_IMPORTED_MODULE_5__.useContext)(utils_contexts_color__WEBPACK_IMPORTED_MODULE_18__/* .ColorContext */ .d);
  const {
    settings,
    setSettings
  } = (0,react__WEBPACK_IMPORTED_MODULE_5__.useContext)(utils_contexts_settings__WEBPACK_IMPORTED_MODULE_20__/* .SettingsContext */ .J);
  const {
    activeTab,
    setActiveTab
  } = (0,react__WEBPACK_IMPORTED_MODULE_5__.useContext)(utils_contexts_tab__WEBPACK_IMPORTED_MODULE_21__/* .TabContext */ .q);
  const {
    asPath
  } = (0,next_router__WEBPACK_IMPORTED_MODULE_8__.useRouter)();
  (0,react__WEBPACK_IMPORTED_MODULE_5__.useEffect)(() => {
    setSettings(initialSettings);
  }, [initialSettings, setSettings]);
  const {
    data: services
  } = (0,swr__WEBPACK_IMPORTED_MODULE_0__["default"])("/api/services");
  const {
    data: bookmarks
  } = (0,swr__WEBPACK_IMPORTED_MODULE_0__["default"])("/api/bookmarks");
  const {
    data: widgets
  } = (0,swr__WEBPACK_IMPORTED_MODULE_0__["default"])("/api/widgets");
  const servicesAndBookmarks = [...services.map(sg => sg.services).flat(), ...bookmarks.map(bg => bg.bookmarks).flat()].filter(i => i?.href);
  (0,react__WEBPACK_IMPORTED_MODULE_5__.useEffect)(() => {
    if (settings.language) {
      i18n.changeLanguage(settings.language);
    }

    if (settings.theme && theme !== settings.theme) {
      setTheme(settings.theme);
    }

    if (settings.color && color !== settings.color) {
      setColor(settings.color);
    }
  }, [i18n, settings, color, setColor, theme, setTheme]);
  const {
    0: searching,
    1: setSearching
  } = (0,react__WEBPACK_IMPORTED_MODULE_5__.useState)(false);
  const {
    0: searchString,
    1: setSearchString
  } = (0,react__WEBPACK_IMPORTED_MODULE_5__.useState)("");
  let searchProvider = null;
  const searchWidget = Object.values(widgets).find(w => w.type === "search");

  if (searchWidget) {
    if (Array.isArray(searchWidget.options?.provider)) {
      // if search provider is a list, try to retrieve from localstorage, fall back to the first
      searchProvider = (0,components_widgets_search_search__WEBPACK_IMPORTED_MODULE_26__.getStoredProvider)() ?? components_widgets_search_search__WEBPACK_IMPORTED_MODULE_26__.searchProviders[searchWidget.options.provider[0]];
    } else if (searchWidget.options?.provider === "custom") {
      searchProvider = {
        url: searchWidget.options.url
      };
    } else {
      searchProvider = components_widgets_search_search__WEBPACK_IMPORTED_MODULE_26__.searchProviders[searchWidget.options?.provider];
    }
  }

  const headerStyle = settings?.headerStyle || "underlined";
  (0,react__WEBPACK_IMPORTED_MODULE_5__.useEffect)(() => {
    function handleKeyDown(e) {
      if (e.target.tagName === "BODY" || e.target.id === "inner_wrapper") {
        if (e.key.length === 1 && e.key.match(/(\w|\s)/g) && !(e.altKey || e.ctrlKey || e.metaKey || e.shiftKey) || e.key === "v" && (e.ctrlKey || e.metaKey)) {
          setSearching(true);
        } else if (e.key === "Escape") {
          setSearchString("");
          setSearching(false);
        }
      }
    }

    document.addEventListener("keydown", handleKeyDown);
    return function cleanup() {
      document.removeEventListener("keydown", handleKeyDown);
    };
  });
  const tabs = (0,react__WEBPACK_IMPORTED_MODULE_5__.useMemo)(() => [...new Set(Object.keys(settings.layout ?? {}).map(groupName => settings.layout[groupName]?.tab?.toString()).filter(group => group))], [settings.layout]);
  (0,react__WEBPACK_IMPORTED_MODULE_5__.useEffect)(() => {
    if (!activeTab) {
      const initialTab = decodeURI(asPath.substring(asPath.indexOf("#") + 1));
      setActiveTab(initialTab === "/" ? (0,components_tab__WEBPACK_IMPORTED_MODULE_9__/* .slugify */ .l)(tabs["0"]) : initialTab);
    }
  });
  const servicesAndBookmarksGroups = (0,react__WEBPACK_IMPORTED_MODULE_5__.useMemo)(() => {
    const tabGroupFilter = g => g && [activeTab, ""].includes((0,components_tab__WEBPACK_IMPORTED_MODULE_9__/* .slugify */ .l)(settings.layout?.[g.name]?.tab));

    const undefinedGroupFilter = g => settings.layout?.[g.name] === undefined;

    const layoutGroups = Object.keys(settings.layout ?? {}).map(groupName => services?.find(g => g.name === groupName) ?? bookmarks?.find(b => b.name === groupName)).filter(tabGroupFilter);

    if (!settings.layout && JSON.stringify(settings.layout) !== JSON.stringify(initialSettings.layout)) {
      // wait for settings to populate (if different from initial settings), otherwise all the widgets will be requested initially even if we are on a single tab
      return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("div", {});
    }

    const serviceGroups = services?.filter(tabGroupFilter).filter(undefinedGroupFilter);
    const bookmarkGroups = bookmarks.filter(tabGroupFilter).filter(undefinedGroupFilter);
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.Fragment, {
      children: [tabs.length > 0 && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("div", {
        id: "tabs",
        className: "m-6 sm:m-9 sm:mt-4 sm:mb-0",
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("ul", {
          className: classnames__WEBPACK_IMPORTED_MODULE_3___default()("sm:flex rounded-md bg-theme-100/20 dark:bg-white/5", settings.cardBlur !== undefined && `backdrop-blur${settings.cardBlur.length ? "-" : ""}${settings.cardBlur}`),
          id: "myTab",
          "data-tabs-toggle": "#myTabContent",
          role: "tablist",
          children: tabs.map(tab => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(components_tab__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .Z, {
            tab: tab
          }, tab))
        })
      }, "tabs"), layoutGroups.length > 0 && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("div", {
        id: "layout-groups",
        className: "flex flex-wrap m-4 sm:m-8 sm:mt-4 items-start mb-2",
        children: layoutGroups.map(group => group.services ? /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(components_services_group__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .Z, {
          group: group.name,
          services: group,
          layout: settings.layout?.[group.name],
          fiveColumns: settings.fiveColumns,
          disableCollapse: settings.disableCollapse,
          useEqualHeights: settings.useEqualHeights
        }, group.name) : /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(components_bookmarks_group__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Z, {
          bookmarks: group,
          layout: settings.layout?.[group.name],
          disableCollapse: settings.disableCollapse
        }, group.name))
      }, "layoutGroups"), serviceGroups?.length > 0 && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("div", {
        id: "services",
        className: "flex flex-wrap m-4 sm:m-8 sm:mt-4 items-start mb-2",
        children: serviceGroups.map(group => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(components_services_group__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .Z, {
          group: group.name,
          services: group,
          layout: settings.layout?.[group.name],
          fiveColumns: settings.fiveColumns,
          disableCollapse: settings.disableCollapse
        }, group.name))
      }, "services"), bookmarkGroups?.length > 0 && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("div", {
        id: "bookmarks",
        className: "flex flex-wrap m-4 sm:m-8 sm:mt-4 items-start mb-2",
        children: bookmarkGroups.map(group => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(components_bookmarks_group__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Z, {
          bookmarks: group,
          layout: settings.layout?.[group.name],
          disableCollapse: settings.disableCollapse
        }, group.name))
      }, "bookmarks")]
    });
  }, [tabs, activeTab, services, bookmarks, settings.layout, settings.fiveColumns, settings.disableCollapse, settings.useEqualHeights, settings.cardBlur, initialSettings.layout]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsxs)((next_head__WEBPACK_IMPORTED_MODULE_1___default()), {
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("title", {
        children: settings.title || "Homepage"
      }), settings.base && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("base", {
        href: settings.base
      }), settings.favicon ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.Fragment, {
        children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("link", {
          rel: "icon",
          href: settings.favicon
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("link", {
          rel: "apple-touch-icon",
          sizes: "180x180",
          href: settings.favicon
        })]
      }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.Fragment, {
        children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("link", {
          rel: "apple-touch-icon",
          sizes: "180x180",
          href: "/apple-touch-icon.png?v=4"
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("link", {
          rel: "shortcut icon",
          href: "/homepage.ico"
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("link", {
          rel: "icon",
          type: "image/png",
          sizes: "32x32",
          href: "/favicon-32x32.png?v=4"
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("link", {
          rel: "icon",
          type: "image/png",
          sizes: "16x16",
          href: "/favicon-16x16.png?v=4"
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("link", {
          rel: "mask-icon",
          href: "/safari-pinned-tab.svg?v=4",
          color: "#1e9cd7"
        })]
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("meta", {
        name: "msapplication-TileColor",
        content: utils_styles_themes__WEBPACK_IMPORTED_MODULE_24__/* ["default"] */ .Z[settings.color || "slate"][settings.theme || "dark"]
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("meta", {
        name: "theme-color",
        content: utils_styles_themes__WEBPACK_IMPORTED_MODULE_24__/* ["default"] */ .Z[settings.color || "slate"][settings.theme || "dark"]
      })]
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("link", {
      rel: "preload",
      href: "/api/config/custom.css",
      as: "fetch",
      crossOrigin: "anonymous"
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("style", {
      "data-name": "custom.css",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(components_filecontent__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .Z, {
        path: "custom.css",
        loadingValue: "/* Loading custom CSS... */",
        errorValue: "/* Failed to load custom CSS... */",
        emptyValue: "/* No custom CSS */"
      })
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("link", {
      rel: "preload",
      href: "/api/config/custom.js",
      as: "fetch",
      crossOrigin: "anonymous"
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("script", {
      "data-name": "custom.js",
      src: "/api/config/custom.js",
      async: true
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsxs)("div", {
      className: "relative container m-auto flex flex-col justify-start z-10 h-full",
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(components_quicklaunch__WEBPACK_IMPORTED_MODULE_25__/* ["default"] */ .Z, {
        servicesAndBookmarks: servicesAndBookmarks,
        searchString: searchString,
        setSearchString: setSearchString,
        isOpen: searching,
        close: setSearching,
        searchProvider: settings.quicklaunch?.hideInternetSearch ? null : searchProvider
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("div", {
        id: "information-widgets",
        className: classnames__WEBPACK_IMPORTED_MODULE_3___default()("flex flex-row flex-wrap justify-between", headerStyles[headerStyle], settings.cardBlur !== undefined && headerStyle === "boxed" && `backdrop-blur${settings.cardBlur.length ? "-" : ""}${settings.cardBlur}`),
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("div", {
          id: "widgets-wrap",
          style: {
            width: "calc(100% + 1rem)"
          },
          className: classnames__WEBPACK_IMPORTED_MODULE_3___default()("flex flex-row w-full flex-wrap justify-between -ml-2 -mr-2"),
          children: widgets && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.Fragment, {
            children: [widgets.filter(widget => !rightAlignedWidgets.includes(widget.type)).map((widget, i) => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(components_widgets_widget__WEBPACK_IMPORTED_MODULE_13__/* ["default"] */ .Z, {
              widget: widget,
              style: {
                header: headerStyle,
                isRightAligned: false,
                cardBlur: settings.cardBlur
              }
            }, i)), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("div", {
              id: "information-widgets-right",
              className: classnames__WEBPACK_IMPORTED_MODULE_3___default()("m-auto flex flex-wrap grow sm:basis-auto justify-between md:justify-end", headerStyle === "boxedWidgets" ? "sm:ml-4" : "sm:ml-2"),
              children: widgets.filter(widget => rightAlignedWidgets.includes(widget.type)).map((widget, i) => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(components_widgets_widget__WEBPACK_IMPORTED_MODULE_13__/* ["default"] */ .Z, {
                widget: widget,
                style: {
                  header: headerStyle,
                  isRightAligned: true,
                  cardBlur: settings.cardBlur
                }
              }, i))
            })]
          })
        })
      }), servicesAndBookmarksGroups, /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsxs)("div", {
        id: "footer",
        className: "flex flex-col mt-auto p-8 w-full",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsxs)("div", {
          id: "style",
          className: "flex w-full justify-end",
          children: [!settings?.color && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(ColorToggle, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(components_toggles_revalidate__WEBPACK_IMPORTED_MODULE_14__/* ["default"] */ .Z, {}), !settings.theme && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(ThemeToggle, {})]
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("div", {
          id: "version",
          className: "flex mt-4 w-full justify-end",
          children: !settings.hideVersion && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(Version, {})
        })]
      })]
    })]
  });
}

function Wrapper({
  initialSettings,
  fallback
}) {
  const wrappedStyle = {};
  let backgroundBlur = false;
  let backgroundSaturate = false;
  let backgroundBrightness = false;

  if (initialSettings && initialSettings.background) {
    let opacity = initialSettings.backgroundOpacity ?? 1;
    let backgroundImage = initialSettings.background;

    if (typeof initialSettings.background === "object") {
      backgroundImage = initialSettings.background.image;
      backgroundBlur = initialSettings.background.blur !== undefined;
      backgroundSaturate = initialSettings.background.saturate !== undefined;
      backgroundBrightness = initialSettings.background.brightness !== undefined;
      if (initialSettings.background.opacity !== undefined) opacity = initialSettings.background.opacity / 100;
    }

    const opacityValue = 1 - opacity;
    wrappedStyle.backgroundImage = `
      linear-gradient(
        rgb(var(--bg-color) / ${opacityValue}),
        rgb(var(--bg-color) / ${opacityValue})
      ),
      url('${backgroundImage}')`;
    wrappedStyle.backgroundPosition = "center";
    wrappedStyle.backgroundSize = "cover";
  }

  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("div", {
    id: "page_wrapper",
    className: classnames__WEBPACK_IMPORTED_MODULE_3___default()("relative", initialSettings.theme && initialSettings.theme, initialSettings.color && `theme-${initialSettings.color}`),
    children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("div", {
      id: "page_container",
      className: "fixed overflow-auto w-full h-full bg-theme-50 dark:bg-theme-800 transition-all",
      style: wrappedStyle,
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx("div", {
        id: "inner_wrapper",
        tabIndex: "-1",
        className: classnames__WEBPACK_IMPORTED_MODULE_3___default()("fixed overflow-auto w-full h-full", backgroundBlur && `backdrop-blur${initialSettings.background.blur.length ? "-" : ""}${initialSettings.background.blur}`, backgroundSaturate && `backdrop-saturate-${initialSettings.background.saturate}`, backgroundBrightness && `backdrop-brightness-${initialSettings.background.brightness}`),
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_27__.jsx(Index, {
          initialSettings: initialSettings,
          fallback: fallback
        })
      })
    })
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 3093:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "IY": () => (/* binding */ bookmarksResponse),
/* harmony export */   "a5": () => (/* binding */ widgetsResponse),
/* harmony export */   "bh": () => (/* binding */ servicesResponse)
/* harmony export */ });
/* harmony import */ var fs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7147);
/* harmony import */ var fs__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(fs__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var path__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(1017);
/* harmony import */ var path__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(path__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var js_yaml__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(626);
/* harmony import */ var utils_config_config__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(9365);
/* harmony import */ var utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(7771);
/* harmony import */ var utils_config_widget_helpers__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(1581);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([js_yaml__WEBPACK_IMPORTED_MODULE_2__, utils_config_config__WEBPACK_IMPORTED_MODULE_3__, utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_4__, utils_config_widget_helpers__WEBPACK_IMPORTED_MODULE_5__]);
([js_yaml__WEBPACK_IMPORTED_MODULE_2__, utils_config_config__WEBPACK_IMPORTED_MODULE_3__, utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_4__, utils_config_widget_helpers__WEBPACK_IMPORTED_MODULE_5__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/* eslint-disable no-console */






/**
 * Compares services by weight then by name.
 */

function compareServices(service1, service2) {
  const comp = service1.weight - service2.weight;

  if (comp !== 0) {
    return comp;
  }

  return service1.name.localeCompare(service2.name);
}

async function bookmarksResponse() {
  (0,utils_config_config__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .ZP)("bookmarks.yaml");
  const bookmarksYaml = path__WEBPACK_IMPORTED_MODULE_1___default().join(utils_config_config__WEBPACK_IMPORTED_MODULE_3__/* .CONF_DIR */ .Fn, "bookmarks.yaml");
  const rawFileContents = await fs__WEBPACK_IMPORTED_MODULE_0__.promises.readFile(bookmarksYaml, "utf8");
  const fileContents = (0,utils_config_config__WEBPACK_IMPORTED_MODULE_3__/* .substituteEnvironmentVars */ .AI)(rawFileContents);
  const bookmarks = js_yaml__WEBPACK_IMPORTED_MODULE_2__["default"].load(fileContents);
  if (!bookmarks) return [];
  let initialSettings;

  try {
    initialSettings = await (0,utils_config_config__WEBPACK_IMPORTED_MODULE_3__/* .getSettings */ .Gw)();
  } catch (e) {
    console.error("Failed to load settings.yaml, please check for errors");
    if (e) console.error(e.toString());
    initialSettings = {};
  } // map easy to write YAML objects into easy to consume JS arrays


  const bookmarksArray = bookmarks.map(group => ({
    name: Object.keys(group)[0],
    bookmarks: group[Object.keys(group)[0]].map(entries => _objectSpread({
      name: Object.keys(entries)[0]
    }, entries[Object.keys(entries)[0]][0]))
  }));
  const sortedGroups = [];
  const unsortedGroups = [];
  const definedLayouts = initialSettings.layout ? Object.keys(initialSettings.layout) : null;
  bookmarksArray.forEach(group => {
    if (definedLayouts) {
      const layoutIndex = definedLayouts.findIndex(layout => layout === group.name);
      if (layoutIndex > -1) sortedGroups[layoutIndex] = group;else unsortedGroups.push(group);
    } else {
      unsortedGroups.push(group);
    }
  });
  return [...sortedGroups.filter(g => g), ...unsortedGroups];
}
async function widgetsResponse() {
  let configuredWidgets;

  try {
    configuredWidgets = (0,utils_config_widget_helpers__WEBPACK_IMPORTED_MODULE_5__/* .cleanWidgetGroups */ .qz)(await (0,utils_config_widget_helpers__WEBPACK_IMPORTED_MODULE_5__/* .widgetsFromConfig */ .uN)());
  } catch (e) {
    console.error("Failed to load widgets, please check widgets.yaml for errors or remove example entries.");
    if (e) console.error(e);
    configuredWidgets = [];
  }

  return configuredWidgets;
}
async function servicesResponse() {
  let discoveredDockerServices;
  let discoveredKubernetesServices;
  let configuredServices;
  let initialSettings;

  try {
    discoveredDockerServices = (0,utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_4__/* .cleanServiceGroups */ .gr)(await (0,utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_4__/* .servicesFromDocker */ .kr)());

    if (discoveredDockerServices?.length === 0) {
      console.debug("No containers were found with homepage labels.");
    }
  } catch (e) {
    console.error("Failed to discover services, please check docker.yaml for errors or remove example entries.");
    if (e) console.error(e.toString());
    discoveredDockerServices = [];
  }

  try {
    discoveredKubernetesServices = (0,utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_4__/* .cleanServiceGroups */ .gr)(await (0,utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_4__/* .servicesFromKubernetes */ .iP)());
  } catch (e) {
    console.error("Failed to discover services, please check kubernetes.yaml for errors or remove example entries.");
    if (e) console.error(e.toString());
    discoveredKubernetesServices = [];
  }

  try {
    configuredServices = (0,utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_4__/* .cleanServiceGroups */ .gr)(await (0,utils_config_service_helpers__WEBPACK_IMPORTED_MODULE_4__/* .servicesFromConfig */ .ah)());
  } catch (e) {
    console.error("Failed to load services.yaml, please check for errors");
    if (e) console.error(e.toString());
    configuredServices = [];
  }

  try {
    initialSettings = await (0,utils_config_config__WEBPACK_IMPORTED_MODULE_3__/* .getSettings */ .Gw)();
  } catch (e) {
    console.error("Failed to load settings.yaml, please check for errors");
    if (e) console.error(e.toString());
    initialSettings = {};
  }

  const mergedGroupsNames = [...new Set([discoveredDockerServices.map(group => group.name), discoveredKubernetesServices.map(group => group.name), configuredServices.map(group => group.name)].flat())];
  const sortedGroups = [];
  const unsortedGroups = [];
  const definedLayouts = initialSettings.layout ? Object.keys(initialSettings.layout) : null;
  mergedGroupsNames.forEach(groupName => {
    const discoveredDockerGroup = discoveredDockerServices.find(group => group.name === groupName) || {
      services: []
    };
    const discoveredKubernetesGroup = discoveredKubernetesServices.find(group => group.name === groupName) || {
      services: []
    };
    const configuredGroup = configuredServices.find(group => group.name === groupName) || {
      services: []
    };
    const mergedGroup = {
      name: groupName,
      services: [...discoveredDockerGroup.services, ...discoveredKubernetesGroup.services, ...configuredGroup.services].filter(service => service).sort(compareServices)
    };

    if (definedLayouts) {
      const layoutIndex = definedLayouts.findIndex(layout => layout === mergedGroup.name);
      if (layoutIndex > -1) sortedGroups[layoutIndex] = mergedGroup;else unsortedGroups.push(mergedGroup);
    } else {
      unsortedGroups.push(mergedGroup);
    }
  });
  return [...sortedGroups.filter(g => g), ...unsortedGroups];
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 7307:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ getDockerArguments)
/* harmony export */ });
/* harmony import */ var path__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1017);
/* harmony import */ var path__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(path__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var fs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7147);
/* harmony import */ var fs__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(fs__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var js_yaml__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(626);
/* harmony import */ var utils_config_config__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(9365);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([js_yaml__WEBPACK_IMPORTED_MODULE_2__, utils_config_config__WEBPACK_IMPORTED_MODULE_3__]);
([js_yaml__WEBPACK_IMPORTED_MODULE_2__, utils_config_config__WEBPACK_IMPORTED_MODULE_3__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);




function getDockerArguments(server) {
  (0,utils_config_config__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .ZP)("docker.yaml");
  const configFile = path__WEBPACK_IMPORTED_MODULE_0___default().join(utils_config_config__WEBPACK_IMPORTED_MODULE_3__/* .CONF_DIR */ .Fn, "docker.yaml");
  const rawConfigData = (0,fs__WEBPACK_IMPORTED_MODULE_1__.readFileSync)(configFile, "utf8");
  const configData = (0,utils_config_config__WEBPACK_IMPORTED_MODULE_3__/* .substituteEnvironmentVars */ .AI)(rawConfigData);
  const servers = js_yaml__WEBPACK_IMPORTED_MODULE_2__["default"].load(configData);

  if (!server) {
    if (process.platform !== "win32" && process.platform !== "darwin") {
      return {
        socketPath: "/var/run/docker.sock"
      };
    }

    return {
      host: "127.0.0.1"
    };
  }

  if (servers[server]) {
    if (servers[server].socket) {
      return {
        conn: {
          socketPath: servers[server].socket
        },
        swarm: !!servers[server].swarm
      };
    }

    if (servers[server].host) {
      const res = {
        conn: {
          host: servers[server].host
        },
        swarm: !!servers[server].swarm
      };

      if (servers[server].port) {
        res.conn.port = servers[server].port;
      }

      if (servers[server].tls) {
        res.conn.ca = (0,fs__WEBPACK_IMPORTED_MODULE_1__.readFileSync)(path__WEBPACK_IMPORTED_MODULE_0___default().join(utils_config_config__WEBPACK_IMPORTED_MODULE_3__/* .CONF_DIR */ .Fn, servers[server].tls.caFile));
        res.conn.cert = (0,fs__WEBPACK_IMPORTED_MODULE_1__.readFileSync)(path__WEBPACK_IMPORTED_MODULE_0___default().join(utils_config_config__WEBPACK_IMPORTED_MODULE_3__/* .CONF_DIR */ .Fn, servers[server].tls.certFile));
        res.conn.key = (0,fs__WEBPACK_IMPORTED_MODULE_1__.readFileSync)(path__WEBPACK_IMPORTED_MODULE_0___default().join(utils_config_config__WEBPACK_IMPORTED_MODULE_3__/* .CONF_DIR */ .Fn, servers[server].tls.keyFile));
      }

      return res;
    }

    return servers[server];
  }

  return null;
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 9598:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ getKubeConfig)
/* harmony export */ });
/* harmony import */ var path__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1017);
/* harmony import */ var path__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(path__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var fs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7147);
/* harmony import */ var fs__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(fs__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var js_yaml__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(626);
/* harmony import */ var _kubernetes_client_node__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(276);
/* harmony import */ var _kubernetes_client_node__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_kubernetes_client_node__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var utils_config_config__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(9365);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([js_yaml__WEBPACK_IMPORTED_MODULE_2__, utils_config_config__WEBPACK_IMPORTED_MODULE_4__]);
([js_yaml__WEBPACK_IMPORTED_MODULE_2__, utils_config_config__WEBPACK_IMPORTED_MODULE_4__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);





function getKubeConfig() {
  (0,utils_config_config__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .ZP)("kubernetes.yaml");
  const configFile = path__WEBPACK_IMPORTED_MODULE_0___default().join(utils_config_config__WEBPACK_IMPORTED_MODULE_4__/* .CONF_DIR */ .Fn, "kubernetes.yaml");
  const rawConfigData = (0,fs__WEBPACK_IMPORTED_MODULE_1__.readFileSync)(configFile, "utf8");
  const configData = (0,utils_config_config__WEBPACK_IMPORTED_MODULE_4__/* .substituteEnvironmentVars */ .AI)(rawConfigData);
  const config = js_yaml__WEBPACK_IMPORTED_MODULE_2__["default"].load(configData);
  const kc = new _kubernetes_client_node__WEBPACK_IMPORTED_MODULE_3__.KubeConfig();

  switch (config?.mode) {
    case "cluster":
      kc.loadFromCluster();
      break;

    case "default":
      kc.loadFromDefault();
      break;

    case "disabled":
    default:
      return null;
  }

  return kc;
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 7771:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ah": () => (/* binding */ servicesFromConfig),
/* harmony export */   "gr": () => (/* binding */ cleanServiceGroups),
/* harmony export */   "iP": () => (/* binding */ servicesFromKubernetes),
/* harmony export */   "kr": () => (/* binding */ servicesFromDocker)
/* harmony export */ });
/* unused harmony exports checkCRD, getServiceItem, default */
/* harmony import */ var fs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7147);
/* harmony import */ var fs__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(fs__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var path__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(1017);
/* harmony import */ var path__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(path__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var js_yaml__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(626);
/* harmony import */ var dockerode__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(4856);
/* harmony import */ var dockerode__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(dockerode__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _kubernetes_client_node__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(276);
/* harmony import */ var _kubernetes_client_node__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_kubernetes_client_node__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var utils_logger__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(8204);
/* harmony import */ var utils_config_config__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(9365);
/* harmony import */ var utils_config_docker__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(7307);
/* harmony import */ var utils_config_kubernetes__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(9598);
/* harmony import */ var utils_config_shvl__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(9958);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([js_yaml__WEBPACK_IMPORTED_MODULE_2__, utils_logger__WEBPACK_IMPORTED_MODULE_5__, utils_config_config__WEBPACK_IMPORTED_MODULE_6__, utils_config_docker__WEBPACK_IMPORTED_MODULE_7__, utils_config_kubernetes__WEBPACK_IMPORTED_MODULE_8__]);
([js_yaml__WEBPACK_IMPORTED_MODULE_2__, utils_logger__WEBPACK_IMPORTED_MODULE_5__, utils_config_config__WEBPACK_IMPORTED_MODULE_6__, utils_config_docker__WEBPACK_IMPORTED_MODULE_7__, utils_config_kubernetes__WEBPACK_IMPORTED_MODULE_8__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
const _excluded = ["name", "group"],
      _excluded2 = ["name", "group"];

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }











const logger = (0,utils_logger__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z)("service-helpers");
async function servicesFromConfig() {
  (0,utils_config_config__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .ZP)("services.yaml");
  const servicesYaml = path__WEBPACK_IMPORTED_MODULE_1___default().join(utils_config_config__WEBPACK_IMPORTED_MODULE_6__/* .CONF_DIR */ .Fn, "services.yaml");
  const rawFileContents = await fs__WEBPACK_IMPORTED_MODULE_0__.promises.readFile(servicesYaml, "utf8");
  const fileContents = (0,utils_config_config__WEBPACK_IMPORTED_MODULE_6__/* .substituteEnvironmentVars */ .AI)(rawFileContents);
  const services = js_yaml__WEBPACK_IMPORTED_MODULE_2__["default"].load(fileContents);

  if (!services) {
    return [];
  } // map easy to write YAML objects into easy to consume JS arrays


  const servicesArray = services.map(servicesGroup => ({
    name: Object.keys(servicesGroup)[0],
    services: servicesGroup[Object.keys(servicesGroup)[0]].map(entries => _objectSpread(_objectSpread({
      name: Object.keys(entries)[0]
    }, entries[Object.keys(entries)[0]]), {}, {
      type: "service"
    }))
  })); // add default weight to services based on their position in the configuration

  servicesArray.forEach((group, groupIndex) => {
    group.services.forEach((service, serviceIndex) => {
      if (!service.weight) {
        servicesArray[groupIndex].services[serviceIndex].weight = (serviceIndex + 1) * 100;
      }
    });
  });
  return servicesArray;
}
async function servicesFromDocker() {
  (0,utils_config_config__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .ZP)("docker.yaml");
  const dockerYaml = path__WEBPACK_IMPORTED_MODULE_1___default().join(utils_config_config__WEBPACK_IMPORTED_MODULE_6__/* .CONF_DIR */ .Fn, "docker.yaml");
  const rawDockerFileContents = await fs__WEBPACK_IMPORTED_MODULE_0__.promises.readFile(dockerYaml, "utf8");
  const dockerFileContents = (0,utils_config_config__WEBPACK_IMPORTED_MODULE_6__/* .substituteEnvironmentVars */ .AI)(rawDockerFileContents);
  const servers = js_yaml__WEBPACK_IMPORTED_MODULE_2__["default"].load(dockerFileContents);

  if (!servers) {
    return [];
  }

  const {
    instanceName
  } = (0,utils_config_config__WEBPACK_IMPORTED_MODULE_6__/* .getSettings */ .Gw)();
  const serviceServers = await Promise.all(Object.keys(servers).map(async serverName => {
    try {
      const isSwarm = !!servers[serverName].swarm;
      const docker = new (dockerode__WEBPACK_IMPORTED_MODULE_3___default())((0,utils_config_docker__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z)(serverName).conn);
      const listProperties = {
        all: true
      };
      const containers = await (isSwarm ? docker.listServices(listProperties) : docker.listContainers(listProperties)); // bad docker connections can result in a <Buffer ...> object?
      // in any case, this ensures the result is the expected array

      if (!Array.isArray(containers)) {
        return [];
      }

      const discovered = containers.map(container => {
        let constructedService = null;
        const containerLabels = isSwarm ? utils_config_shvl__WEBPACK_IMPORTED_MODULE_9__/* .get */ .U(container, "Spec.Labels") : container.Labels;
        const containerName = isSwarm ? utils_config_shvl__WEBPACK_IMPORTED_MODULE_9__/* .get */ .U(container, "Spec.Name") : container.Names[0];
        Object.keys(containerLabels).forEach(label => {
          if (label.startsWith("homepage.")) {
            let value = label.replace("homepage.", "");

            if (instanceName && value.startsWith(`instance.${instanceName}.`)) {
              value = value.replace(`instance.${instanceName}.`, "");
            } else if (value.startsWith("instance.")) {
              return;
            }

            if (!constructedService) {
              constructedService = {
                container: containerName.replace(/^\//, ""),
                server: serverName,
                type: "service"
              };
            }

            utils_config_shvl__WEBPACK_IMPORTED_MODULE_9__/* .set */ .t(constructedService, value, (0,utils_config_config__WEBPACK_IMPORTED_MODULE_6__/* .substituteEnvironmentVars */ .AI)(containerLabels[label]));
          }
        });

        if (!constructedService.name || !constructedService.group) {
          logger.error(`Error constructing service using homepage labels for container '${containerName.replace(/^\//, "")}'. Ensure required labels are present.`);
          return null;
        }

        return constructedService;
      });
      return {
        server: serverName,
        services: discovered.filter(filteredService => filteredService)
      };
    } catch (e) {
      // a server failed, but others may succeed
      return {
        server: serverName,
        services: []
      };
    }
  }));
  const mappedServiceGroups = [];
  serviceServers.forEach(server => {
    server.services.forEach(serverService => {
      let serverGroup = mappedServiceGroups.find(searchedGroup => searchedGroup.name === serverService.group);

      if (!serverGroup) {
        mappedServiceGroups.push({
          name: serverService.group,
          services: []
        });
        serverGroup = mappedServiceGroups[mappedServiceGroups.length - 1];
      }

      const {
        name: serviceName,
        group: serverServiceGroup
      } = serverService,
            pushedService = _objectWithoutProperties(serverService, _excluded);

      const result = _objectSpread({
        name: serviceName
      }, pushedService);

      serverGroup.services.push(result);
    });
  });
  return mappedServiceGroups;
}

function getUrlFromIngress(ingress) {
  const urlHost = ingress.spec.rules[0].host;
  const urlPath = ingress.spec.rules[0].http.paths[0].path;
  const urlSchema = ingress.spec.tls ? "https" : "http";
  return `${urlSchema}://${urlHost}${urlPath}`;
}

async function checkCRD(kc, name) {
  const apiExtensions = kc.makeApiClient(_kubernetes_client_node__WEBPACK_IMPORTED_MODULE_4__.ApiextensionsV1Api);
  const exist = await apiExtensions.readCustomResourceDefinitionStatus(name).then(() => true).catch(async error => {
    if (error.statusCode === 403) {
      logger.error("Error checking if CRD %s exists. Make sure to add the following permission to your RBAC: %d %s %s", name, error.statusCode, error.body.message);
    }

    return false;
  });
  return exist;
}
async function servicesFromKubernetes() {
  const ANNOTATION_BASE = "gethomepage.dev";
  const ANNOTATION_WIDGET_BASE = `${ANNOTATION_BASE}/widget.`;
  const {
    instanceName
  } = (0,utils_config_config__WEBPACK_IMPORTED_MODULE_6__/* .getSettings */ .Gw)();
  (0,utils_config_config__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .ZP)("kubernetes.yaml");

  try {
    const kc = (0,utils_config_kubernetes__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z)();

    if (!kc) {
      return [];
    }

    const networking = kc.makeApiClient(_kubernetes_client_node__WEBPACK_IMPORTED_MODULE_4__.NetworkingV1Api);
    const crd = kc.makeApiClient(_kubernetes_client_node__WEBPACK_IMPORTED_MODULE_4__.CustomObjectsApi);
    const ingressList = await networking.listIngressForAllNamespaces(null, null, null, null).then(response => response.body).catch(error => {
      logger.error("Error getting ingresses: %d %s %s", error.statusCode, error.body, error.response);
      return null;
    });
    const traefikContainoExists = await checkCRD(kc, "ingressroutes.traefik.containo.us");
    const traefikExists = await checkCRD(kc, "ingressroutes.traefik.io");
    const traefikIngressListContaino = await crd.listClusterCustomObject("traefik.containo.us", "v1alpha1", "ingressroutes").then(response => response.body).catch(async error => {
      if (traefikContainoExists) {
        logger.error("Error getting traefik ingresses from traefik.containo.us: %d %s %s", error.statusCode, error.body, error.response);
      }

      return [];
    });
    const traefikIngressListIo = await crd.listClusterCustomObject("traefik.io", "v1alpha1", "ingressroutes").then(response => response.body).catch(async error => {
      if (traefikExists) {
        logger.error("Error getting traefik ingresses from traefik.io: %d %s %s", error.statusCode, error.body, error.response);
      }

      return [];
    });
    const traefikIngressList = [...(traefikIngressListContaino?.items ?? []), ...(traefikIngressListIo?.items ?? [])];

    if (traefikIngressList.length > 0) {
      const traefikServices = traefikIngressList.filter(ingress => ingress.metadata.annotations && ingress.metadata.annotations[`${ANNOTATION_BASE}/href`]);
      ingressList.items.push(...traefikServices);
    }

    if (!ingressList) {
      return [];
    }

    const services = ingressList.items.filter(ingress => ingress.metadata.annotations && ingress.metadata.annotations[`${ANNOTATION_BASE}/enabled`] === "true" && (!ingress.metadata.annotations[`${ANNOTATION_BASE}/instance`] || ingress.metadata.annotations[`${ANNOTATION_BASE}/instance`] === instanceName)).map(ingress => {
      let constructedService = {
        app: ingress.metadata.annotations[`${ANNOTATION_BASE}/app`] || ingress.metadata.name,
        namespace: ingress.metadata.namespace,
        href: ingress.metadata.annotations[`${ANNOTATION_BASE}/href`] || getUrlFromIngress(ingress),
        name: ingress.metadata.annotations[`${ANNOTATION_BASE}/name`] || ingress.metadata.name,
        group: ingress.metadata.annotations[`${ANNOTATION_BASE}/group`] || "Kubernetes",
        weight: ingress.metadata.annotations[`${ANNOTATION_BASE}/weight`] || "0",
        icon: ingress.metadata.annotations[`${ANNOTATION_BASE}/icon`] || "",
        description: ingress.metadata.annotations[`${ANNOTATION_BASE}/description`] || "",
        external: false,
        type: "service"
      };

      if (ingress.metadata.annotations[`${ANNOTATION_BASE}/external`]) {
        constructedService.external = String(ingress.metadata.annotations[`${ANNOTATION_BASE}/external`]).toLowerCase() === "true";
      }

      if (ingress.metadata.annotations[`${ANNOTATION_BASE}/pod-selector`] !== undefined) {
        constructedService.podSelector = ingress.metadata.annotations[`${ANNOTATION_BASE}/pod-selector`];
      }

      if (ingress.metadata.annotations[`${ANNOTATION_BASE}/ping`]) {
        constructedService.ping = ingress.metadata.annotations[`${ANNOTATION_BASE}/ping`];
      }

      if (ingress.metadata.annotations[`${ANNOTATION_BASE}/siteMonitor`]) {
        constructedService.siteMonitor = ingress.metadata.annotations[`${ANNOTATION_BASE}/siteMonitor`];
      }

      if (ingress.metadata.annotations[`${ANNOTATION_BASE}/statusStyle`]) {
        constructedService.statusStyle = ingress.metadata.annotations[`${ANNOTATION_BASE}/statusStyle`];
      }

      Object.keys(ingress.metadata.annotations).forEach(annotation => {
        if (annotation.startsWith(ANNOTATION_WIDGET_BASE)) {
          utils_config_shvl__WEBPACK_IMPORTED_MODULE_9__/* .set */ .t(constructedService, annotation.replace(`${ANNOTATION_BASE}/`, ""), ingress.metadata.annotations[annotation]);
        }
      });

      try {
        constructedService = JSON.parse((0,utils_config_config__WEBPACK_IMPORTED_MODULE_6__/* .substituteEnvironmentVars */ .AI)(JSON.stringify(constructedService)));
      } catch (e) {
        logger.error("Error attempting k8s environment variable substitution.");
      }

      return constructedService;
    });
    const mappedServiceGroups = [];
    services.forEach(serverService => {
      let serverGroup = mappedServiceGroups.find(searchedGroup => searchedGroup.name === serverService.group);

      if (!serverGroup) {
        mappedServiceGroups.push({
          name: serverService.group,
          services: []
        });
        serverGroup = mappedServiceGroups[mappedServiceGroups.length - 1];
      }

      const {
        name: serviceName,
        group: serverServiceGroup
      } = serverService,
            pushedService = _objectWithoutProperties(serverService, _excluded2);

      const result = _objectSpread({
        name: serviceName
      }, pushedService);

      serverGroup.services.push(result);
    });
    return mappedServiceGroups;
  } catch (e) {
    logger.error(e);
    throw e;
  }
}
function cleanServiceGroups(groups) {
  return groups.map(serviceGroup => ({
    name: serviceGroup.name,
    services: serviceGroup.services.map(service => {
      const cleanedService = _objectSpread({}, service);

      if (cleanedService.showStats !== undefined) cleanedService.showStats = JSON.parse(cleanedService.showStats);

      if (typeof service.weight === "string") {
        const weight = parseInt(service.weight, 10);

        if (Number.isNaN(weight)) {
          cleanedService.weight = 0;
        } else {
          cleanedService.weight = weight;
        }
      }

      if (typeof cleanedService.weight !== "number") {
        cleanedService.weight = 0;
      }

      if (cleanedService.widget) {
        // whitelisted set of keys to pass to the frontend
        // alphabetical, grouped by widget(s)
        const {
          // all widgets
          fields,
          hideErrors,
          type,
          // azuredevops
          repositoryId,
          userEmail,
          // calendar
          firstDayInWeek,
          integrations,
          maxEvents,
          showTime,
          previousDays,
          view,
          // coinmarketcap
          currency,
          defaultinterval,
          slugs,
          symbols,
          // customapi
          mappings,
          // diskstation
          volume,
          // docker
          container,
          server,
          // emby, jellyfin
          enableBlocks,
          enableNowPlaying,
          // glances
          chart,
          metric,
          pointsLimit,
          // glances, customapi, iframe
          refreshInterval,
          // iframe
          allowFullscreen,
          allowPolicy,
          allowScrolling,
          classes,
          loadingStrategy,
          referrerPolicy,
          src,
          // kopia
          snapshotHost,
          snapshotPath,
          // kubernetes
          app,
          namespace,
          podSelector,
          // mjpeg
          fit,
          stream,
          // openmediavault
          method,
          // opnsense, pfsense
          wan,
          // proxmox
          node,
          // sonarr, radarr
          enableQueue,
          // unifi
          site
        } = cleanedService.widget;
        let fieldsList = fields;

        if (typeof fields === "string") {
          try {
            JSON.parse(fields);
          } catch (e) {
            logger.error("Invalid fields list detected in config for service '%s'", service.name);
            fieldsList = null;
          }
        }

        cleanedService.widget = {
          type,
          fields: fieldsList || null,
          hide_errors: hideErrors || false,
          service_name: service.name,
          service_group: serviceGroup.name
        };

        if (type === "azuredevops") {
          if (userEmail) cleanedService.widget.userEmail = userEmail;
          if (repositoryId) cleanedService.widget.repositoryId = repositoryId;
        }

        if (type === "coinmarketcap") {
          if (currency) cleanedService.widget.currency = currency;
          if (symbols) cleanedService.widget.symbols = symbols;
          if (slugs) cleanedService.widget.slugs = slugs;
          if (defaultinterval) cleanedService.widget.defaultinterval = defaultinterval;
        }

        if (type === "docker") {
          if (server) cleanedService.widget.server = server;
          if (container) cleanedService.widget.container = container;
        }

        if (type === "unifi") {
          if (site) cleanedService.widget.site = site;
        }

        if (type === "proxmox") {
          if (node) cleanedService.widget.node = node;
        }

        if (type === "kubernetes") {
          if (namespace) cleanedService.widget.namespace = namespace;
          if (app) cleanedService.widget.app = app;
          if (podSelector) cleanedService.widget.podSelector = podSelector;
        }

        if (type === "iframe") {
          if (src) cleanedService.widget.src = src;
          if (classes) cleanedService.widget.classes = classes;
          if (referrerPolicy) cleanedService.widget.referrerPolicy = referrerPolicy;
          if (allowPolicy) cleanedService.widget.allowPolicy = allowPolicy;
          if (allowFullscreen) cleanedService.widget.allowFullscreen = allowFullscreen;
          if (loadingStrategy) cleanedService.widget.loadingStrategy = loadingStrategy;
          if (allowScrolling) cleanedService.widget.allowScrolling = allowScrolling;
          if (refreshInterval) cleanedService.widget.refreshInterval = refreshInterval;
        }

        if (["opnsense", "pfsense"].includes(type)) {
          if (wan) cleanedService.widget.wan = wan;
        }

        if (["emby", "jellyfin"].includes(type)) {
          if (enableBlocks !== undefined) cleanedService.widget.enableBlocks = JSON.parse(enableBlocks);
          if (enableNowPlaying !== undefined) cleanedService.widget.enableNowPlaying = JSON.parse(enableNowPlaying);
        }

        if (["sonarr", "radarr"].includes(type)) {
          if (enableQueue !== undefined) cleanedService.widget.enableQueue = JSON.parse(enableQueue);
        }

        if (["diskstation", "qnap"].includes(type)) {
          if (volume) cleanedService.widget.volume = volume;
        }

        if (type === "kopia") {
          if (snapshotHost) cleanedService.widget.snapshotHost = snapshotHost;
          if (snapshotPath) cleanedService.widget.snapshotPath = snapshotPath;
        }

        if (type === "glances") {
          if (metric) cleanedService.widget.metric = metric;

          if (chart !== undefined) {
            cleanedService.widget.chart = chart;
          } else {
            cleanedService.widget.chart = true;
          }

          if (refreshInterval) cleanedService.widget.refreshInterval = refreshInterval;
          if (pointsLimit) cleanedService.widget.pointsLimit = pointsLimit;
        }

        if (type === "mjpeg") {
          if (stream) cleanedService.widget.stream = stream;
          if (fit) cleanedService.widget.fit = fit;
        }

        if (type === "openmediavault") {
          if (method) cleanedService.widget.method = method;
        }

        if (type === "customapi") {
          if (mappings) cleanedService.widget.mappings = mappings;
          if (refreshInterval) cleanedService.widget.refreshInterval = refreshInterval;
        }

        if (type === "calendar") {
          if (integrations) cleanedService.widget.integrations = integrations;
          if (firstDayInWeek) cleanedService.widget.firstDayInWeek = firstDayInWeek;
          if (view) cleanedService.widget.view = view;
          if (maxEvents) cleanedService.widget.maxEvents = maxEvents;
          if (previousDays) cleanedService.widget.previousDays = previousDays;
          if (showTime) cleanedService.widget.showTime = showTime;
        }
      }

      return cleanedService;
    })
  }));
}
async function getServiceItem(group, service) {
  const configuredServices = await servicesFromConfig();
  const serviceGroup = configuredServices.find(g => g.name === group);

  if (serviceGroup) {
    const serviceEntry = serviceGroup.services.find(s => s.name === service);
    if (serviceEntry) return serviceEntry;
  }

  const discoveredServices = await servicesFromDocker();
  const dockerServiceGroup = discoveredServices.find(g => g.name === group);

  if (dockerServiceGroup) {
    const dockerServiceEntry = dockerServiceGroup.services.find(s => s.name === service);
    if (dockerServiceEntry) return dockerServiceEntry;
  }

  const kubernetesServices = await servicesFromKubernetes();
  const kubernetesServiceGroup = kubernetesServices.find(g => g.name === group);

  if (kubernetesServiceGroup) {
    const kubernetesServiceEntry = kubernetesServiceGroup.services.find(s => s.name === service);
    if (kubernetesServiceEntry) return kubernetesServiceEntry;
  }

  return false;
}
async function getServiceWidget(group, service) {
  const serviceItem = await getServiceItem(group, service);

  if (serviceItem) {
    const {
      widget
    } = serviceItem;
    return widget;
  }

  return false;
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 9958:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "U": () => (/* binding */ get),
/* harmony export */   "t": () => (/* binding */ set)
/* harmony export */ });
/* eslint-disable */

/*
Code primarely based on shvl repository: https://github.com/robinvdvleuten/shvl

MIT License

Copyright (c) Robin van der Vleuten <robin@webstronauts.co>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
*/
function get(object, path, def) {
  // Split the path into keys and reduce the object to the target value
  return (object = path.split(/[.[\]]+/).reduce(function (obj, p) {
    // Check each nested object to see if the key exists
    return obj && obj[p] !== undefined ? obj[p] : undefined;
  }, object)) === undefined ? // If the final value is undefined, return the default value
  def : object; // Otherwise, return the value found
}
function set(obj, path, val) {
  // Split the path into keys and filter out any empty strings
  const keys = path.split(/[.[\]]+/).filter(Boolean); // Pop the last key to set the value later

  const lastKey = keys.pop(); // Prevent setting dangerous keys like __proto__

  if (/^(__proto__|constructor|prototype)$/.test(lastKey)) return obj; // Reduce the object to the nested object where we want to set the value

  keys.reduce((acc, key, i) => {
    // Again, block dangerous keys
    if (/^(__proto__|constructor|prototype)$/.test(key)) return {}; // Check if next key is an array index

    const isIndex = /^\d+$/.test(keys[i + 1]); // If current key doesn't exist, initialise it as an array or object

    acc[key] = Array.isArray(acc[key]) ? acc[key] : isIndex ? [] : acc[key] || {}; // Return nested object for next iteration

    return acc[key];
  }, obj)[lastKey] = val; // Finally set the value

  return obj;
}

/***/ }),

/***/ 1581:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "qz": () => (/* binding */ cleanWidgetGroups),
/* harmony export */   "uN": () => (/* binding */ widgetsFromConfig)
/* harmony export */ });
/* unused harmony export getPrivateWidgetOptions */
/* harmony import */ var fs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7147);
/* harmony import */ var fs__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(fs__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var path__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(1017);
/* harmony import */ var path__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(path__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var js_yaml__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(626);
/* harmony import */ var utils_config_config__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(9365);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([js_yaml__WEBPACK_IMPORTED_MODULE_2__, utils_config_config__WEBPACK_IMPORTED_MODULE_3__]);
([js_yaml__WEBPACK_IMPORTED_MODULE_2__, utils_config_config__WEBPACK_IMPORTED_MODULE_3__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }





async function widgetsFromConfig() {
  (0,utils_config_config__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .ZP)("widgets.yaml");
  const widgetsYaml = path__WEBPACK_IMPORTED_MODULE_1___default().join(utils_config_config__WEBPACK_IMPORTED_MODULE_3__/* .CONF_DIR */ .Fn, "widgets.yaml");
  const rawFileContents = await fs__WEBPACK_IMPORTED_MODULE_0__.promises.readFile(widgetsYaml, "utf8");
  const fileContents = (0,utils_config_config__WEBPACK_IMPORTED_MODULE_3__/* .substituteEnvironmentVars */ .AI)(rawFileContents);
  const widgets = js_yaml__WEBPACK_IMPORTED_MODULE_2__["default"].load(fileContents);
  if (!widgets) return []; // map easy to write YAML objects into easy to consume JS arrays

  const widgetsArray = widgets.map((group, index) => ({
    type: Object.keys(group)[0],
    options: _objectSpread({
      index
    }, group[Object.keys(group)[0]])
  }));
  return widgetsArray;
}
async function cleanWidgetGroups(widgets) {
  return widgets.map((widget, index) => {
    const sanitizedOptions = widget.options;
    const optionKeys = Object.keys(sanitizedOptions); // delete private options from the sanitized options

    ["username", "password", "key"].forEach(pO => {
      if (optionKeys.includes(pO)) {
        delete sanitizedOptions[pO];
      }
    }); // delete url from the sanitized options if the widget is not a search or glances widgeth

    if (widget.type !== "search" && widget.type !== "glances" && optionKeys.includes("url")) {
      delete sanitizedOptions.url;
    }

    return {
      type: widget.type,
      options: _objectSpread({
        index
      }, sanitizedOptions)
    };
  });
}
async function getPrivateWidgetOptions(type, widgetIndex) {
  const widgets = await widgetsFromConfig();
  const privateOptions = widgets.map(widget => {
    const {
      index,
      url,
      username,
      password,
      key
    } = widget.options;
    return {
      type: widget.type,
      options: {
        index,
        url,
        username,
        password,
        key
      }
    };
  });
  return type !== undefined && widgetIndex !== undefined ? privateOptions.find(o => o.type === type && o.options.index === parseInt(widgetIndex, 10))?.options : privateOptions;
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 5826:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


const hasFocus = () => typeof document !== "undefined" && document.hasFocus();

const useWindowFocus = () => {
  const {
    0: focused,
    1: setFocused
  } = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(hasFocus);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    setFocused(hasFocus());

    const onFocus = () => setFocused(true);

    const onBlur = () => setFocused(false);

    window.addEventListener("focus", onFocus);
    window.addEventListener("blur", onBlur);
    return () => {
      window.removeEventListener("focus", onFocus);
      window.removeEventListener("blur", onBlur);
    };
  }, []);
  return focused;
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useWindowFocus);

/***/ }),

/***/ 9565:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Q": () => (/* binding */ columnMap)
/* harmony export */ });
// eslint-disable-next-line import/prefer-default-export
const columnMap = ["grid-cols-1 md:grid-cols-1 lg:grid-cols-1", "grid-cols-1 md:grid-cols-1 lg:grid-cols-1", "grid-cols-1 md:grid-cols-2 lg:grid-cols-2", "grid-cols-1 md:grid-cols-2 lg:grid-cols-3", "grid-cols-1 md:grid-cols-2 lg:grid-cols-4", "grid-cols-1 md:grid-cols-2 lg:grid-cols-5", "grid-cols-1 md:grid-cols-2 lg:grid-cols-6", "grid-cols-1 md:grid-cols-2 lg:grid-cols-7", "grid-cols-1 md:grid-cols-2 lg:grid-cols-8"];

/***/ }),

/***/ 8204:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ createLogger)
/* harmony export */ });
/* harmony import */ var node_util__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7261);
/* harmony import */ var node_util__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(node_util__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var winston__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7773);
/* harmony import */ var winston__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(winston__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var utils_config_config__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(9365);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_config_config__WEBPACK_IMPORTED_MODULE_2__]);
utils_config_config__WEBPACK_IMPORTED_MODULE_2__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];
/* eslint-disable no-console */



let winstonLogger;

function init() {
  (0,utils_config_config__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .ZP)("settings.yaml");
  const settings = (0,utils_config_config__WEBPACK_IMPORTED_MODULE_2__/* .getSettings */ .Gw)();
  const logpath = settings.logpath || utils_config_config__WEBPACK_IMPORTED_MODULE_2__/* .CONF_DIR */ .Fn;

  function combineMessageAndSplat() {
    return {
      // eslint-disable-next-line no-unused-vars
      transform: (info, opts) => {
        // combine message and args if any
        // eslint-disable-next-line no-param-reassign
        info.message = (0,node_util__WEBPACK_IMPORTED_MODULE_0__.format)(info.message, ...(info[Symbol.for("splat")] || []));
        return info;
      }
    };
  }

  function messageFormatter(logInfo) {
    if (logInfo.label) {
      if (logInfo.stack) {
        return `[${logInfo.timestamp}] ${logInfo.level}: <${logInfo.label}> ${logInfo.stack}`;
      }

      return `[${logInfo.timestamp}] ${logInfo.level}: <${logInfo.label}> ${logInfo.message}`;
    }

    if (logInfo.stack) {
      return `[${logInfo.timestamp}] ${logInfo.level}: ${logInfo.stack}`;
    }

    return `[${logInfo.timestamp}] ${logInfo.level}: ${logInfo.message}`;
  }

  winstonLogger = winston__WEBPACK_IMPORTED_MODULE_1___default().createLogger({
    level: process.env.LOG_LEVEL || "info",
    transports: [new (winston__WEBPACK_IMPORTED_MODULE_1___default().transports.Console)({
      format: winston__WEBPACK_IMPORTED_MODULE_1___default().format.combine(winston__WEBPACK_IMPORTED_MODULE_1___default().format.errors({
        stack: true
      }), combineMessageAndSplat(), winston__WEBPACK_IMPORTED_MODULE_1___default().format.timestamp(), winston__WEBPACK_IMPORTED_MODULE_1___default().format.colorize(), winston__WEBPACK_IMPORTED_MODULE_1___default().format.printf(messageFormatter)),
      handleExceptions: true,
      handleRejections: true
    }), new (winston__WEBPACK_IMPORTED_MODULE_1___default().transports.File)({
      format: winston__WEBPACK_IMPORTED_MODULE_1___default().format.combine(winston__WEBPACK_IMPORTED_MODULE_1___default().format.errors({
        stack: true
      }), combineMessageAndSplat(), winston__WEBPACK_IMPORTED_MODULE_1___default().format.timestamp(), winston__WEBPACK_IMPORTED_MODULE_1___default().format.printf(messageFormatter)),
      filename: `${logpath}/logs/homepage.log`,
      handleExceptions: true,
      handleRejections: true
    })]
  }); // patch the console log mechanism to use our logger

  const consoleMethods = ["log", "debug", "info", "warn", "error"];
  consoleMethods.forEach(method => {
    // workaround for https://github.com/winstonjs/winston/issues/1591
    switch (method) {
      case "log":
        console[method] = winstonLogger.info.bind(winstonLogger);
        break;

      default:
        console[method] = winstonLogger[method].bind(winstonLogger);
        break;
    }
  });
}

const loggers = {};
function createLogger(label) {
  if (!winstonLogger) {
    init();
  }

  if (!loggers[label]) {
    loggers[label] = winstonLogger.child({
      label
    });
  }

  return loggers[label];
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 2613:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Component)
/* harmony export */ });
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5941);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(1377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _stats_helpers__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(6817);
/* harmony import */ var components_services_widget_container__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(8581);
/* harmony import */ var components_services_widget_block__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(403);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([swr__WEBPACK_IMPORTED_MODULE_0__]);
swr__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];








function Component({
  service
}) {
  const {
    t
  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_1__.useTranslation)();
  const {
    widget
  } = service;
  const {
    data: statusData,
    error: statusError
  } = (0,swr__WEBPACK_IMPORTED_MODULE_0__["default"])(`/api/docker/status/${widget.container}/${widget.server || ""}`);
  const {
    data: statsData,
    error: statsError
  } = (0,swr__WEBPACK_IMPORTED_MODULE_0__["default"])(`/api/docker/stats/${widget.container}/${widget.server || ""}`);

  if (statsError || statsData?.error || statusError || statusData?.error) {
    const finalError = statsError ?? statsData?.error ?? statusError ?? statusData?.error;
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_container__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
      service: service,
      error: finalError
    });
  }

  if (statusData && !(statusData.status.includes("running") || statusData.status.includes("partial"))) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_container__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
        label: t("widget.status"),
        value: t("docker.offline")
      })
    });
  }

  if (!statsData || !statusData) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)(components_services_widget_container__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
      service: service,
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
        label: "docker.cpu"
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
        label: "docker.mem"
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
        label: "docker.rx"
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
        label: "docker.tx"
      })]
    });
  }

  const {
    rxBytes,
    txBytes
  } = (0,_stats_helpers__WEBPACK_IMPORTED_MODULE_5__/* .calculateThroughput */ .zJ)(statsData.stats);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)(components_services_widget_container__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
    service: service,
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
      label: "docker.cpu",
      value: t("common.percent", {
        value: (0,_stats_helpers__WEBPACK_IMPORTED_MODULE_5__/* .calculateCPUPercent */ .Az)(statsData.stats)
      })
    }), statsData.stats.memory_stats.usage && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
      label: "docker.mem",
      value: t("common.bytes", {
        value: (0,_stats_helpers__WEBPACK_IMPORTED_MODULE_5__/* .calculateUsedMemory */ .AC)(statsData.stats)
      })
    }), statsData.stats.networks && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.Fragment, {
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
        label: "docker.rx",
        value: t("common.bytes", {
          value: rxBytes
        })
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
        label: "docker.tx",
        value: t("common.bytes", {
          value: txBytes
        })
      })]
    })]
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 6817:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AC": () => (/* binding */ calculateUsedMemory),
/* harmony export */   "Az": () => (/* binding */ calculateCPUPercent),
/* harmony export */   "zJ": () => (/* binding */ calculateThroughput)
/* harmony export */ });
function calculateCPUPercent(stats) {
  let cpuPercent = 0.0;
  const cpuDelta = stats.cpu_stats.cpu_usage.total_usage - stats.precpu_stats.cpu_usage.total_usage;
  const systemDelta = stats.cpu_stats.system_cpu_usage - stats.precpu_stats.system_cpu_usage;

  if (systemDelta > 0.0 && cpuDelta > 0.0) {
    cpuPercent = cpuDelta / systemDelta * stats.cpu_stats.online_cpus * 100.0;
  }

  return Math.round(cpuPercent * 10) / 10;
}
function calculateUsedMemory(stats) {
  // see https://github.com/docker/cli/blob/dcc161076861177b5eef6cb321722520db3184e7/cli/command/container/stats_helpers.go#L239
  return stats.memory_stats.usage - (stats.memory_stats.total_inactive_file ?? stats.memory_stats.stats?.inactive_file ?? 0);
}
function calculateThroughput(stats) {
  let rxBytes = 0;
  let txBytes = 0;

  if (stats.networks?.network) {
    rxBytes = stats.networks?.network.rx_bytes;
    txBytes = stats.networks?.network.tx_bytes;
  } else if (stats.networks && Array.isArray(Object.values(stats.networks))) {
    Object.values(stats.networks).forEach(containerInterface => {
      rxBytes += containerInterface.rx_bytes;
      txBytes += containerInterface.tx_bytes;
    });
  }

  return {
    rxBytes,
    txBytes
  };
}

/***/ }),

/***/ 5889:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Component)
/* harmony export */ });
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5941);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(1377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var components_services_widget_container__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(8581);
/* harmony import */ var components_services_widget_block__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(403);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([swr__WEBPACK_IMPORTED_MODULE_0__]);
swr__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];






function Component({
  service
}) {
  const {
    t
  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_1__.useTranslation)();
  const {
    widget
  } = service;
  const podSelectorString = widget.podSelector !== undefined ? `podSelector=${widget.podSelector}` : "";
  const {
    data: statusData,
    error: statusError
  } = (0,swr__WEBPACK_IMPORTED_MODULE_0__["default"])(`/api/kubernetes/status/${widget.namespace}/${widget.app}?${podSelectorString}`);
  const {
    data: statsData,
    error: statsError
  } = (0,swr__WEBPACK_IMPORTED_MODULE_0__["default"])(`/api/kubernetes/stats/${widget.namespace}/${widget.app}?${podSelectorString}`);

  if (statsError || statusError) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_container__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
      service: service,
      error: statsError ?? statusError
    });
  }

  if (statusData && !(statusData.status.includes("running") || statusData.status.includes("partial"))) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_container__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
        label: t("widget.status"),
        value: t("docker.offline")
      })
    });
  }

  if (!statsData || !statusData) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)(components_services_widget_container__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
      service: service,
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
        label: "docker.cpu"
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
        label: "docker.mem"
      })]
    });
  }

  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)(components_services_widget_container__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
    service: service,
    children: [statsData.stats.cpuLimit && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
      label: "docker.cpu",
      value: t("common.percent", {
        value: statsData.stats.cpuUsage
      })
    }) || /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
      label: "docker.cpu",
      value: t("common.number", {
        value: statsData.stats.cpu,
        maximumFractionDigits: 4
      })
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
      label: "docker.mem",
      value: t("common.bytes", {
        value: statsData.stats.mem
      })
    })]
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 276:
/***/ ((module) => {

module.exports = require("@kubernetes/client-node");

/***/ }),

/***/ 3985:
/***/ ((module) => {

module.exports = require("cal-parser");

/***/ }),

/***/ 9003:
/***/ ((module) => {

module.exports = require("classnames");

/***/ }),

/***/ 7795:
/***/ ((module) => {

module.exports = require("compare-versions");

/***/ }),

/***/ 4856:
/***/ ((module) => {

module.exports = require("dockerode");

/***/ }),

/***/ 2108:
/***/ ((module) => {

module.exports = require("memory-cache");

/***/ }),

/***/ 1377:
/***/ ((module) => {

module.exports = require("next-i18next");

/***/ }),

/***/ 5460:
/***/ ((module) => {

module.exports = require("next-i18next/serverSideTranslations");

/***/ }),

/***/ 4957:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/head.js");

/***/ }),

/***/ 4486:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/image-blur-svg.js");

/***/ }),

/***/ 744:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/image-config-context.js");

/***/ }),

/***/ 5843:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/image-config.js");

/***/ }),

/***/ 5832:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/loadable.js");

/***/ }),

/***/ 8854:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/parse-path.js");

/***/ }),

/***/ 3297:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/remove-trailing-slash.js");

/***/ }),

/***/ 9232:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/utils.js");

/***/ }),

/***/ 968:
/***/ ((module) => {

module.exports = require("next/head");

/***/ }),

/***/ 1853:
/***/ ((module) => {

module.exports = require("next/router");

/***/ }),

/***/ 6689:
/***/ ((module) => {

module.exports = require("react");

/***/ }),

/***/ 9709:
/***/ ((module) => {

module.exports = require("react-i18next");

/***/ }),

/***/ 6652:
/***/ ((module) => {

module.exports = require("react-icons/bi");

/***/ }),

/***/ 567:
/***/ ((module) => {

module.exports = require("react-icons/bs");

/***/ }),

/***/ 6290:
/***/ ((module) => {

module.exports = require("react-icons/fa");

/***/ }),

/***/ 2750:
/***/ ((module) => {

module.exports = require("react-icons/fi");

/***/ }),

/***/ 4751:
/***/ ((module) => {

module.exports = require("react-icons/io");

/***/ }),

/***/ 9989:
/***/ ((module) => {

module.exports = require("react-icons/io5");

/***/ }),

/***/ 4041:
/***/ ((module) => {

module.exports = require("react-icons/md");

/***/ }),

/***/ 764:
/***/ ((module) => {

module.exports = require("react-icons/si");

/***/ }),

/***/ 5744:
/***/ ((module) => {

module.exports = require("react-icons/wi");

/***/ }),

/***/ 997:
/***/ ((module) => {

module.exports = require("react/jsx-runtime");

/***/ }),

/***/ 3655:
/***/ ((module) => {

module.exports = require("recharts");

/***/ }),

/***/ 6871:
/***/ ((module) => {

module.exports = require("rrule");

/***/ }),

/***/ 7773:
/***/ ((module) => {

module.exports = require("winston");

/***/ }),

/***/ 1185:
/***/ ((module) => {

module.exports = import("@headlessui/react");;

/***/ }),

/***/ 2021:
/***/ ((module) => {

module.exports = import("i18next");;

/***/ }),

/***/ 626:
/***/ ((module) => {

module.exports = import("js-yaml");;

/***/ }),

/***/ 2353:
/***/ ((module) => {

module.exports = import("luxon");;

/***/ }),

/***/ 5941:
/***/ ((module) => {

module.exports = import("swr");;

/***/ }),

/***/ 7147:
/***/ ((module) => {

module.exports = require("fs");

/***/ }),

/***/ 7261:
/***/ ((module) => {

module.exports = require("node:util");

/***/ }),

/***/ 1017:
/***/ ((module) => {

module.exports = require("path");

/***/ })

};
;

// load runtime
var __webpack_require__ = require("../webpack-runtime.js");
__webpack_require__.C(exports);
var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
var __webpack_exports__ = __webpack_require__.X(0, [4573,7068,8622], () => (__webpack_exec__(6243)));
module.exports = __webpack_exports__;

})();