"use strict";
exports.id = 2156;
exports.ids = [2156];
exports.modules = {

/***/ 2156:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ getDockerArguments)
/* harmony export */ });
/* harmony import */ var path__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1017);
/* harmony import */ var path__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(path__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var fs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7147);
/* harmony import */ var fs__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(fs__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var js_yaml__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(626);
/* harmony import */ var utils_config_config__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(5732);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([js_yaml__WEBPACK_IMPORTED_MODULE_2__, utils_config_config__WEBPACK_IMPORTED_MODULE_3__]);
([js_yaml__WEBPACK_IMPORTED_MODULE_2__, utils_config_config__WEBPACK_IMPORTED_MODULE_3__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);




function getDockerArguments(server) {
  (0,utils_config_config__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .ZP)("docker.yaml");
  const configFile = path__WEBPACK_IMPORTED_MODULE_0___default().join(utils_config_config__WEBPACK_IMPORTED_MODULE_3__/* .CONF_DIR */ .Fn, "docker.yaml");
  const rawConfigData = (0,fs__WEBPACK_IMPORTED_MODULE_1__.readFileSync)(configFile, "utf8");
  const configData = (0,utils_config_config__WEBPACK_IMPORTED_MODULE_3__/* .substituteEnvironmentVars */ .AI)(rawConfigData);
  const servers = js_yaml__WEBPACK_IMPORTED_MODULE_2__["default"].load(configData);

  if (!server) {
    if (process.platform !== "win32" && process.platform !== "darwin") {
      return {
        socketPath: "/var/run/docker.sock"
      };
    }

    return {
      host: "127.0.0.1"
    };
  }

  if (servers[server]) {
    if (servers[server].socket) {
      return {
        conn: {
          socketPath: servers[server].socket
        },
        swarm: !!servers[server].swarm
      };
    }

    if (servers[server].host) {
      const res = {
        conn: {
          host: servers[server].host
        },
        swarm: !!servers[server].swarm
      };

      if (servers[server].port) {
        res.conn.port = servers[server].port;
      }

      if (servers[server].tls) {
        res.conn.ca = (0,fs__WEBPACK_IMPORTED_MODULE_1__.readFileSync)(path__WEBPACK_IMPORTED_MODULE_0___default().join(utils_config_config__WEBPACK_IMPORTED_MODULE_3__/* .CONF_DIR */ .Fn, servers[server].tls.caFile));
        res.conn.cert = (0,fs__WEBPACK_IMPORTED_MODULE_1__.readFileSync)(path__WEBPACK_IMPORTED_MODULE_0___default().join(utils_config_config__WEBPACK_IMPORTED_MODULE_3__/* .CONF_DIR */ .Fn, servers[server].tls.certFile));
        res.conn.key = (0,fs__WEBPACK_IMPORTED_MODULE_1__.readFileSync)(path__WEBPACK_IMPORTED_MODULE_0___default().join(utils_config_config__WEBPACK_IMPORTED_MODULE_3__/* .CONF_DIR */ .Fn, servers[server].tls.keyFile));
      }

      return res;
    }

    return servers[server];
  }

  return null;
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;