"use strict";
exports.id = 2378;
exports.ids = [2378];
exports.modules = {

/***/ 2378:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Integration)
/* harmony export */ });
/* harmony import */ var luxon__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2353);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(4582);
/* harmony import */ var _components_services_widget_error__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(8659);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([luxon__WEBPACK_IMPORTED_MODULE_0__, _utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_3__]);
([luxon__WEBPACK_IMPORTED_MODULE_0__, _utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_3__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }







function Integration({
  config,
  params,
  setEvents,
  hideErrors = false
}) {
  const {
    t
  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_2__.useTranslation)();
  const {
    data: radarrData,
    error: radarrError
  } = (0,_utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z)(config, "calendar", _objectSpread(_objectSpread({}, params), config?.params ?? {}));
  (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    if (!radarrData || radarrError) {
      return;
    }

    const eventsToAdd = {};
    radarrData?.forEach(event => {
      const cinemaTitle = `${event.title} - ${t("calendar.inCinemas")}`;
      const physicalTitle = `${event.title} - ${t("calendar.physicalRelease")}`;
      const digitalTitle = `${event.title} - ${t("calendar.digitalRelease")}`;

      if (event.inCinemas) {
        eventsToAdd[cinemaTitle] = {
          title: cinemaTitle,
          date: luxon__WEBPACK_IMPORTED_MODULE_0__.DateTime.fromISO(event.inCinemas),
          color: config?.color ?? "amber",
          isCompleted: event.hasFile,
          additional: ""
        };
      }

      if (event.physicalRelease) {
        eventsToAdd[physicalTitle] = {
          title: physicalTitle,
          date: luxon__WEBPACK_IMPORTED_MODULE_0__.DateTime.fromISO(event.physicalRelease),
          color: config?.color ?? "cyan",
          isCompleted: event.hasFile,
          additional: ""
        };
      }

      if (event.digitalRelease) {
        eventsToAdd[digitalTitle] = {
          title: digitalTitle,
          date: luxon__WEBPACK_IMPORTED_MODULE_0__.DateTime.fromISO(event.digitalRelease),
          color: config?.color ?? "emerald",
          isCompleted: event.hasFile,
          additional: ""
        };
      }
    });
    setEvents(prevEvents => _objectSpread(_objectSpread({}, prevEvents), eventsToAdd));
  }, [radarrData, radarrError, config, setEvents, t]);
  const error = radarrError ?? radarrData?.error;
  return error && !hideErrors && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_components_services_widget_error__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
    error: {
      message: `${config.type}: ${error.message ?? error}`
    }
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;