"use strict";
exports.id = 3668;
exports.ids = [3668];
exports.modules = {

/***/ 3668:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Component)
/* harmony export */ });
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var components_services_widget_container__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8581);
/* harmony import */ var utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4582);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_2__]);
utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_2__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];





function SinglePlayingEntry({
  entry
}) {
  const {
    username,
    artist,
    title,
    album
  } = entry;
  let fullTitle = title;
  if (artist) fullTitle = `${artist} - ${title}`;
  if (album) fullTitle += ` — ${album}`;
  if (username) fullTitle += ` (${username})`;
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx("div", {
    className: "text-theme-700 dark:text-theme-200 relative h-5 w-full rounded-md bg-theme-200/50 dark:bg-theme-900/20 mt-1 flex",
    children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx("div", {
      className: "text-xs z-10 self-center ml-2 relative w-full h-4 grow mr-2",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx("div", {
        className: "absolute w-full whitespace-nowrap text-ellipsis overflow-hidden",
        children: fullTitle
      })
    })
  });
}

function Component({
  service
}) {
  const {
    t
  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_0__.useTranslation)();
  const {
    widget
  } = service;
  const {
    data: navidromeData,
    error: navidromeError
  } = (0,utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z)(widget, "getNowPlaying");

  if (navidromeError || navidromeData?.["subsonic-response"]?.error) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx(components_services_widget_container__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
      service: service,
      error: navidromeError ?? navidromeData?.["subsonic-response"]?.error
    });
  }

  if (!navidromeData) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx(SinglePlayingEntry, {
      entry: {
        title: t("navidrome.please_wait")
      }
    });
  }

  const {
    nowPlaying
  } = navidromeData["subsonic-response"];

  if (!nowPlaying.entry) {
    // nothing playing
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx(SinglePlayingEntry, {
      entry: {
        title: t("navidrome.nothing_streaming")
      }
    });
  }

  const nowPlayingEntries = Object.values(nowPlaying.entry);
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx("div", {
    className: "flex flex-col pb-1 mx-1",
    children: nowPlayingEntries.map(entry => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx(SinglePlayingEntry, {
      entry: entry
    }, entry.id))
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;