"use strict";
exports.id = 5595;
exports.ids = [5595];
exports.modules = {

/***/ 5595:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Longhorn)
/* harmony export */ });
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5941);
/* harmony import */ var _widget_error__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(1299);
/* harmony import */ var _widget_container__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4843);
/* harmony import */ var _widget_raw__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(1464);
/* harmony import */ var _node__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(7464);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([swr__WEBPACK_IMPORTED_MODULE_0__]);
swr__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];






function Longhorn({
  options
}) {
  const {
    expanded,
    total,
    labels,
    include,
    nodes
  } = options;
  const {
    data,
    error
  } = (0,swr__WEBPACK_IMPORTED_MODULE_0__["default"])(`/api/widgets/longhorn`, {
    refreshInterval: 1500
  });

  if (error || data?.error) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(_widget_error__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
      options: options
    });
  }

  if (!data) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(_widget_container__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .ZP, {
      options: options,
      additionalClassNames: "infomation-widget-longhorn",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(_widget_raw__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx("div", {
          className: "flex flex-row self-center flex-wrap justify-between"
        })
      })
    });
  }

  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(_widget_container__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .ZP, {
    options: options,
    additionalClassNames: "infomation-widget-longhorn",
    children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(_widget_raw__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx("div", {
        className: "flex flex-row self-center flex-wrap justify-between",
        children: data.nodes.filter(node => {
          if (node.id === "total" && total) {
            return true;
          }

          if (!nodes) {
            return false;
          }

          if (include && !include.includes(node.id)) {
            return false;
          }

          return true;
        }).map(node => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx("div", {
          children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(_node__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
            data: {
              node
            },
            expanded: expanded,
            labels: labels
          })
        }, node.id))
      })
    })
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 7464:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ Node)
/* harmony export */ });
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_icons_fa__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6290);
/* harmony import */ var react_icons_fa__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_icons_fa__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _widget_resource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(3980);
/* harmony import */ var _widget_widget_label__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(6850);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__);





function Node({
  data,
  expanded,
  labels
}) {
  const {
    t
  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_0__.useTranslation)();
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(_widget_resource__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
    additionalClassNames: "information-widget-longhorn-node",
    icon: react_icons_fa__WEBPACK_IMPORTED_MODULE_1__.FaThermometerHalf,
    value: t("common.bytes", {
      value: data.node.available
    }),
    label: t("resources.free"),
    expandedValue: t("common.bytes", {
      value: data.node.maximum
    }),
    expandedLabel: t("resources.total"),
    percentage: Math.round((data.node.maximum - data.node.available) / data.node.maximum * 100),
    expanded: expanded,
    children: labels && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(_widget_widget_label__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
      label: data.node.id
    })
  });
}

/***/ }),

/***/ 6850:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ WidgetLabel)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

function WidgetLabel({
  label = ""
}) {
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
    className: "information-widget-label pt-1 text-center text-theme-800 dark:text-theme-200 text-xs",
    children: label
  });
}

/***/ })

};
;