"use strict";
exports.id = 5732;
exports.ids = [5732];
exports.modules = {

/***/ 5732:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AI": () => (/* binding */ substituteEnvironmentVars),
/* harmony export */   "Fn": () => (/* binding */ CONF_DIR),
/* harmony export */   "Gw": () => (/* binding */ getSettings),
/* harmony export */   "ZP": () => (/* binding */ checkAndCopyConfig)
/* harmony export */ });
/* harmony import */ var path__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1017);
/* harmony import */ var path__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(path__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var fs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7147);
/* harmony import */ var fs__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(fs__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var memory_cache__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(2108);
/* harmony import */ var memory_cache__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(memory_cache__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var js_yaml__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(626);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([js_yaml__WEBPACK_IMPORTED_MODULE_3__]);
js_yaml__WEBPACK_IMPORTED_MODULE_3__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/* eslint-disable no-console */




const cacheKey = "homepageEnvironmentVariables";
const homepageVarPrefix = "HOMEPAGE_VAR_";
const homepageFilePrefix = "HOMEPAGE_FILE_";
const CONF_DIR = process.env.HOMEPAGE_CONFIG_DIR ? process.env.HOMEPAGE_CONFIG_DIR : (0,path__WEBPACK_IMPORTED_MODULE_0__.join)(process.cwd(), "config");
function checkAndCopyConfig(config) {
  if (!(0,fs__WEBPACK_IMPORTED_MODULE_1__.existsSync)(CONF_DIR)) {
    (0,fs__WEBPACK_IMPORTED_MODULE_1__.mkdirSync)(CONF_DIR, {
      recursive: true
    });
  }

  const configYaml = (0,path__WEBPACK_IMPORTED_MODULE_0__.join)(CONF_DIR, config);

  if (!(0,fs__WEBPACK_IMPORTED_MODULE_1__.existsSync)(configYaml)) {
    const configSkeleton = (0,path__WEBPACK_IMPORTED_MODULE_0__.join)(process.cwd(), "src", "skeleton", config);

    try {
      (0,fs__WEBPACK_IMPORTED_MODULE_1__.copyFileSync)(configSkeleton, configYaml);
      console.info("%s was copied to the config folder", config);
    } catch (err) {
      console.error("error copying config", err);
      throw err;
    }

    return true;
  }

  try {
    js_yaml__WEBPACK_IMPORTED_MODULE_3__["default"].load((0,fs__WEBPACK_IMPORTED_MODULE_1__.readFileSync)(configYaml, "utf8"));
    return true;
  } catch (e) {
    return _objectSpread(_objectSpread({}, e), {}, {
      config
    });
  }
}

function getCachedEnvironmentVars() {
  let cachedVars = memory_cache__WEBPACK_IMPORTED_MODULE_2___default().get(cacheKey);

  if (!cachedVars) {
    // initialize cache
    cachedVars = Object.entries(process.env).filter(([key]) => key.includes(homepageVarPrefix) || key.includes(homepageFilePrefix));
    memory_cache__WEBPACK_IMPORTED_MODULE_2___default().put(cacheKey, cachedVars);
  }

  return cachedVars;
}

function substituteEnvironmentVars(str) {
  let result = str;

  if (result.includes("{{")) {
    // crude check if we have vars to replace
    const cachedVars = getCachedEnvironmentVars();
    cachedVars.forEach(([key, value]) => {
      if (key.startsWith(homepageVarPrefix)) {
        result = result.replaceAll(`{{${key}}}`, value);
      } else if (key.startsWith(homepageFilePrefix)) {
        const filename = value;
        const fileContents = (0,fs__WEBPACK_IMPORTED_MODULE_1__.readFileSync)(filename, "utf8");
        result = result.replaceAll(`{{${key}}}`, fileContents);
      }
    });
  }

  return result;
}
function getSettings() {
  checkAndCopyConfig("settings.yaml");
  const settingsYaml = (0,path__WEBPACK_IMPORTED_MODULE_0__.join)(CONF_DIR, "settings.yaml");
  const rawFileContents = (0,fs__WEBPACK_IMPORTED_MODULE_1__.readFileSync)(settingsYaml, "utf8");
  const fileContents = substituteEnvironmentVars(rawFileContents);
  const initialSettings = js_yaml__WEBPACK_IMPORTED_MODULE_3__["default"].load(fileContents) ?? {};

  if (initialSettings.layout) {
    // support yaml list but old spec was object so convert to that
    // see https://github.com/gethomepage/homepage/issues/1546
    if (Array.isArray(initialSettings.layout)) {
      const layoutItems = initialSettings.layout;
      initialSettings.layout = {};
      layoutItems.forEach(i => {
        const name = Object.keys(i)[0];
        initialSettings.layout[name] = i[name];
      });
    }
  }

  return initialSettings;
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;