"use strict";
exports.id = 5818;
exports.ids = [5818];
exports.modules = {

/***/ 5818:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Component)
/* harmony export */ });
/* harmony import */ var components_services_widget_container__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8581);
/* harmony import */ var components_services_widget_block__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(403);
/* harmony import */ var utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4582);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_2__]);
utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_2__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];


 // @see https://github.com/AnalogJ/scrutiny/blob/d8d56f77f9e868127c4849dac74d65512db658e8/webapp/frontend/src/app/shared/device-status.pipe.ts



const DeviceStatus = {
  passed: 0,
  failed_smart: 1,
  failed_scrutiny: 2,
  failed_both: 3,

  isFailed(s) {
    return s > this.passed && s <= this.failed_both;
  },

  isUnknown(s) {
    return s < this.passed || s > this.failed_both;
  }

}; // @see https://github.com/AnalogJ/scrutiny/blob/d8d56f77f9e868127c4849dac74d65512db658e8/webapp/frontend/src/app/core/config/app.config.ts

const DeviceStatusThreshold = {
  smart: 1,
  scrutiny: 2,
  both: 3
};
function Component({
  service
}) {
  const {
    widget
  } = service;
  const {
    data: scrutinySettings,
    error: scrutinySettingsError
  } = (0,utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z)(widget, "settings");
  const {
    data: scrutinyData,
    error: scrutinyError
  } = (0,utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z)(widget, "summary");

  if (scrutinyError || scrutinySettingsError) {
    const finalError = scrutinyError ?? scrutinySettingsError;
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx(components_services_widget_container__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
      service: service,
      error: finalError
    });
  }

  if (!scrutinyData || !scrutinySettings) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(components_services_widget_container__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
      service: service,
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
        label: "scrutiny.passed"
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
        label: "scrutiny.failed"
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
        label: "scrutiny.unknown"
      })]
    });
  }

  const deviceIds = Object.values(scrutinyData.data.summary);
  const statusThreshold = scrutinySettings.settings.metrics.status_threshold;
  const failed = deviceIds.filter(deviceId => DeviceStatus.isFailed(deviceId.device.device_status) && statusThreshold === DeviceStatusThreshold.both || [statusThreshold, DeviceStatus.failed_both].includes(deviceId.device.device_status))?.length || 0;
  const unknown = deviceIds.filter(deviceId => DeviceStatus.isUnknown(deviceId.device.device_status))?.length || 0;
  const passed = deviceIds.length - (failed + unknown);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)(components_services_widget_container__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
    service: service,
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
      label: "scrutiny.passed",
      value: passed
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
      label: "scrutiny.failed",
      value: failed
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
      label: "scrutiny.unknown",
      value: unknown
    })]
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;