"use strict";
exports.id = 8546;
exports.ids = [8546];
exports.modules = {

/***/ 2607:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ Cpu)
/* harmony export */ });
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5941);
/* harmony import */ var react_icons_fi__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2750);
/* harmony import */ var react_icons_fi__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_icons_fi__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _widget_resource__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(3980);
/* harmony import */ var _widget_error__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(1299);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([swr__WEBPACK_IMPORTED_MODULE_0__]);
swr__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];






function Cpu({
  expanded,
  refresh = 1500
}) {
  const {
    t
  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_2__.useTranslation)();
  const {
    data,
    error
  } = (0,swr__WEBPACK_IMPORTED_MODULE_0__["default"])(`/api/widgets/resources?type=cpu`, {
    refreshInterval: refresh
  });

  if (error || data?.error) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_widget_error__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {});
  }

  if (!data) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_widget_resource__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
      icon: react_icons_fi__WEBPACK_IMPORTED_MODULE_1__.FiCpu,
      value: "-",
      label: t("resources.cpu"),
      expandedValue: "-",
      expandedLabel: t("resources.load"),
      percentage: "0",
      expanded: expanded
    });
  }

  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_widget_resource__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
    icon: react_icons_fi__WEBPACK_IMPORTED_MODULE_1__.FiCpu,
    value: t("common.number", {
      value: data.cpu.usage,
      style: "unit",
      unit: "percent",
      maximumFractionDigits: 0
    }),
    label: t("resources.cpu"),
    expandedValue: t("common.number", {
      value: data.cpu.load,
      maximumFractionDigits: 2
    }),
    expandedLabel: t("resources.load"),
    percentage: data.cpu.usage,
    expanded: expanded
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 9498:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ CpuTemp)
/* harmony export */ });
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5941);
/* harmony import */ var react_icons_fa__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6290);
/* harmony import */ var react_icons_fa__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_icons_fa__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _widget_resource__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(3980);
/* harmony import */ var _widget_error__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(1299);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([swr__WEBPACK_IMPORTED_MODULE_0__]);
swr__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];







function convertToFahrenheit(t) {
  return t * 9 / 5 + 32;
}

function CpuTemp({
  expanded,
  units,
  refresh = 1500
}) {
  const {
    t
  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_2__.useTranslation)();
  const {
    data,
    error
  } = (0,swr__WEBPACK_IMPORTED_MODULE_0__["default"])(`/api/widgets/resources?type=cputemp`, {
    refreshInterval: refresh
  });

  if (error || data?.error) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_widget_error__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {});
  }

  if (!data || !data.cputemp) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_widget_resource__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
      icon: react_icons_fa__WEBPACK_IMPORTED_MODULE_1__.FaThermometerHalf,
      value: "-",
      label: t("resources.temp"),
      expandedValue: "-",
      expandedLabel: t("resources.max"),
      expanded: expanded
    });
  }

  let mainTemp = data.cputemp.main;

  if (data.cputemp.cores?.length) {
    mainTemp = data.cputemp.cores.reduce((a, b) => a + b) / data.cputemp.cores.length;
  }

  const unit = units === "imperial" ? "fahrenheit" : "celsius";
  mainTemp = unit === "celsius" ? mainTemp : convertToFahrenheit(mainTemp);
  const maxTemp = unit === "celsius" ? data.cputemp.max : convertToFahrenheit(data.cputemp.max);
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_widget_resource__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
    icon: react_icons_fa__WEBPACK_IMPORTED_MODULE_1__.FaThermometerHalf,
    value: t("common.number", {
      value: mainTemp,
      maximumFractionDigits: 1,
      style: "unit",
      unit
    }),
    label: t("resources.temp"),
    expandedValue: t("common.number", {
      value: maxTemp,
      maximumFractionDigits: 1,
      style: "unit",
      unit
    }),
    expandedLabel: t("resources.max"),
    percentage: Math.round(mainTemp / maxTemp * 100),
    expanded: expanded
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 5433:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ Disk)
/* harmony export */ });
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5941);
/* harmony import */ var react_icons_fi__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2750);
/* harmony import */ var react_icons_fi__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_icons_fi__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _widget_resource__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(3980);
/* harmony import */ var _widget_error__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(1299);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([swr__WEBPACK_IMPORTED_MODULE_0__]);
swr__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];






function Disk({
  options,
  expanded,
  refresh = 1500
}) {
  const {
    t
  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_2__.useTranslation)();
  const {
    data,
    error
  } = (0,swr__WEBPACK_IMPORTED_MODULE_0__["default"])(`/api/widgets/resources?type=disk&target=${options.disk}`, {
    refreshInterval: refresh
  });

  if (error || data?.error) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_widget_error__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
      options: options
    });
  }

  if (!data || !data.drive) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_widget_resource__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
      icon: react_icons_fi__WEBPACK_IMPORTED_MODULE_1__.FiHardDrive,
      value: "-",
      label: t("resources.free"),
      expandedValue: "-",
      expandedLabel: t("resources.total"),
      expanded: expanded,
      percentage: "0"
    });
  } // data.drive.used not accurate?


  const percent = Math.round((data.drive.size - data.drive.available) / data.drive.size * 100);
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_widget_resource__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
    icon: react_icons_fi__WEBPACK_IMPORTED_MODULE_1__.FiHardDrive,
    value: t("common.bytes", {
      value: data.drive.available
    }),
    label: t("resources.free"),
    expandedValue: t("common.bytes", {
      value: data.drive.size
    }),
    expandedLabel: t("resources.total"),
    percentage: percent,
    expanded: expanded
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 3542:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ Memory)
/* harmony export */ });
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5941);
/* harmony import */ var react_icons_fa__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6290);
/* harmony import */ var react_icons_fa__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_icons_fa__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _widget_resource__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(3980);
/* harmony import */ var _widget_error__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(1299);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([swr__WEBPACK_IMPORTED_MODULE_0__]);
swr__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];






function Memory({
  expanded,
  refresh = 1500
}) {
  const {
    t
  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_2__.useTranslation)();
  const {
    data,
    error
  } = (0,swr__WEBPACK_IMPORTED_MODULE_0__["default"])(`/api/widgets/resources?type=memory`, {
    refreshInterval: refresh
  });

  if (error || data?.error) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_widget_error__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {});
  }

  if (!data) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_widget_resource__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
      icon: react_icons_fa__WEBPACK_IMPORTED_MODULE_1__.FaMemory,
      value: "-",
      label: t("resources.free"),
      expandedValue: "-",
      expandedLabel: t("resources.total"),
      expanded: expanded,
      percentage: "0"
    });
  }

  const percent = Math.round(data.memory.active / data.memory.total * 100);
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_widget_resource__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
    icon: react_icons_fa__WEBPACK_IMPORTED_MODULE_1__.FaMemory,
    value: t("common.bytes", {
      value: data.memory.available,
      maximumFractionDigits: 1,
      binary: true
    }),
    label: t("resources.free"),
    expandedValue: t("common.bytes", {
      value: data.memory.total,
      maximumFractionDigits: 1,
      binary: true
    }),
    expandedLabel: t("resources.total"),
    percentage: percent,
    expanded: expanded
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 8546:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Resources)
/* harmony export */ });
/* harmony import */ var _widget_container__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4843);
/* harmony import */ var _widget_raw__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(1464);
/* harmony import */ var _disk__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5433);
/* harmony import */ var _cpu__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(2607);
/* harmony import */ var _memory__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(3542);
/* harmony import */ var _cputemp__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(9498);
/* harmony import */ var _uptime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(3308);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_disk__WEBPACK_IMPORTED_MODULE_1__, _cpu__WEBPACK_IMPORTED_MODULE_2__, _memory__WEBPACK_IMPORTED_MODULE_3__, _cputemp__WEBPACK_IMPORTED_MODULE_4__, _uptime__WEBPACK_IMPORTED_MODULE_5__]);
([_disk__WEBPACK_IMPORTED_MODULE_1__, _cpu__WEBPACK_IMPORTED_MODULE_2__, _memory__WEBPACK_IMPORTED_MODULE_3__, _cputemp__WEBPACK_IMPORTED_MODULE_4__, _uptime__WEBPACK_IMPORTED_MODULE_5__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);









function Resources({
  options
}) {
  const {
    expanded,
    units
  } = options;
  let {
    refresh
  } = options;
  if (!refresh) refresh = 1500;
  refresh = Math.max(refresh, 1000);
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(_widget_container__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .ZP, {
    options: options,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(_widget_raw__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("div", {
        className: "flex flex-row self-center flex-wrap justify-between",
        children: [options.cpu && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(_cpu__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
          expanded: expanded,
          refresh: refresh
        }), options.memory && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(_memory__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
          expanded: expanded,
          refresh: refresh
        }), Array.isArray(options.disk) ? options.disk.map(disk => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(_disk__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
          options: {
            disk
          },
          expanded: expanded,
          refresh: refresh
        }, disk)) : options.disk && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(_disk__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
          options: options,
          expanded: expanded,
          refresh: refresh
        }), options.cputemp && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(_cputemp__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
          expanded: expanded,
          units: units,
          refresh: refresh
        }), options.uptime && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(_uptime__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
          refresh: refresh
        })]
      }), options.label && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("div", {
        className: "ml-6 pt-1 text-center text-theme-800 dark:text-theme-200 text-xs",
        children: options.label
      })]
    })
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 3308:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ Uptime)
/* harmony export */ });
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5941);
/* harmony import */ var react_icons_fa__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6290);
/* harmony import */ var react_icons_fa__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_icons_fa__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _widget_resource__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(3980);
/* harmony import */ var _widget_error__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(1299);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([swr__WEBPACK_IMPORTED_MODULE_0__]);
swr__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];






function Uptime({
  refresh = 1500
}) {
  const {
    t
  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_2__.useTranslation)();
  const {
    data,
    error
  } = (0,swr__WEBPACK_IMPORTED_MODULE_0__["default"])(`/api/widgets/resources?type=uptime`, {
    refreshInterval: refresh
  });

  if (error || data?.error) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_widget_error__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {});
  }

  if (!data) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_widget_resource__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
      icon: react_icons_fa__WEBPACK_IMPORTED_MODULE_1__.FaRegClock,
      value: "-",
      label: t("resources.uptime"),
      percentage: "0"
    });
  }

  const percent = Math.round(new Date().getSeconds() / 60 * 100).toString();
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_widget_resource__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
    icon: react_icons_fa__WEBPACK_IMPORTED_MODULE_1__.FaRegClock,
    value: t("common.uptime", {
      value: data.uptime
    }),
    label: t("resources.uptime"),
    percentage: percent
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;