"use strict";
exports.id = 8648;
exports.ids = [8648];
exports.modules = {

/***/ 9236:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ Dropdown)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _headlessui_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(1185);
/* harmony import */ var react_icons_bi__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6652);
/* harmony import */ var react_icons_bi__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_icons_bi__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(9003);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_headlessui_react__WEBPACK_IMPORTED_MODULE_1__]);
_headlessui_react__WEBPACK_IMPORTED_MODULE_1__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];






function Dropdown({
  options,
  value,
  setValue
}) {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)(_headlessui_react__WEBPACK_IMPORTED_MODULE_1__.Menu, {
    as: "div",
    className: "relative inline-block text-left",
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx("div", {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)(_headlessui_react__WEBPACK_IMPORTED_MODULE_1__.Menu.Button, {
        className: "text-xs inline-flex w-full items-center rounded bg-theme-200/50 dark:bg-theme-900/20 px-3 py-1.5",
        children: [options.find(option => option.value === value).label, /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(react_icons_bi__WEBPACK_IMPORTED_MODULE_2__.BiCog, {
          className: "-mr-1 ml-2 h-4 w-4",
          "aria-hidden": "true"
        })]
      })
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_1__.Transition, {
      as: react__WEBPACK_IMPORTED_MODULE_0__.Fragment,
      enter: "transition ease-out duration-100",
      enterFrom: "transform opacity-0 scale-95",
      enterTo: "transform opacity-100 scale-100",
      leave: "transition ease-in duration-75",
      leaveFrom: "transform opacity-100 scale-100",
      leaveTo: "transform opacity-0 scale-95",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_1__.Menu.Items, {
        className: "absolute right-0 z-10 mt-2 w-56 origin-top-right rounded-md bg-theme-200/50 dark:bg-theme-900/50 backdrop-blur shadow-md focus:outline-none text-theme-700 dark:text-theme-200",
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx("div", {
          className: "py-1",
          children: options.map(option => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_1__.Menu.Item, {
            as: react__WEBPACK_IMPORTED_MODULE_0__.Fragment,
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx("button", {
              onClick: () => {
                setValue(option.value);
              },
              type: "button",
              className: classnames__WEBPACK_IMPORTED_MODULE_3___default()(value === option.value ? "bg-theme-300/40 dark:bg-theme-900/40" : "", "w-full block px-3 py-1.5 text-sm hover:bg-theme-300/70 hover:dark:bg-theme-900/70 text-left"),
              children: option.label
            })
          }, option.value))
        })
      })
    })]
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 8648:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Component)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(1377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(9003);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var components_services_widget_container__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(8581);
/* harmony import */ var components_services_widget_block__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(403);
/* harmony import */ var components_services_dropdown__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(9236);
/* harmony import */ var utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(4582);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([components_services_dropdown__WEBPACK_IMPORTED_MODULE_5__, utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_6__]);
([components_services_dropdown__WEBPACK_IMPORTED_MODULE_5__, utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_6__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);









function Component({
  service
}) {
  const {
    t
  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_1__.useTranslation)();
  const dateRangeOptions = [{
    label: t("coinmarketcap.1hour"),
    value: "1h"
  }, {
    label: t("coinmarketcap.1day"),
    value: "24h"
  }, {
    label: t("coinmarketcap.7days"),
    value: "7d"
  }, {
    label: t("coinmarketcap.30days"),
    value: "30d"
  }];
  const {
    widget
  } = service;
  const {
    symbols
  } = widget;
  const {
    slugs
  } = widget;
  const currencyCode = widget.currency ?? "USD";
  const interval = widget.defaultinterval ?? dateRangeOptions[0].value;
  const {
    0: dateRange,
    1: setDateRange
  } = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(interval);
  const params = {
    convert: `${currencyCode}`
  }; // slugs >> symbols, not both

  if (slugs?.length) {
    params.slug = slugs.join(",");
  } else if (symbols?.length) {
    params.symbol = symbols.join(",");
  }

  const {
    data: statsData,
    error: statsError
  } = (0,utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z)(widget, "v1/cryptocurrency/quotes/latest", params);

  if (!symbols && !slugs || symbols?.length === 0 && slugs?.length === 0) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(components_services_widget_container__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
      service: service,
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
        value: t("coinmarketcap.configure")
      })
    });
  }

  if (statsError) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(components_services_widget_container__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
      service: service,
      error: statsError
    });
  }

  if (!statsData || !dateRange) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(components_services_widget_container__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
      service: service,
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
        value: t("coinmarketcap.configure")
      })
    });
  }

  const {
    data
  } = statsData;
  const validCryptos = Object.values(data).filter(crypto => crypto.quote[currencyCode][`percent_change_${dateRange}`] !== null);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)(components_services_widget_container__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
    service: service,
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx("div", {
      className: classnames__WEBPACK_IMPORTED_MODULE_2___default()(service.description ? "-top-10" : "-top-8", "absolute right-1"),
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(components_services_dropdown__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
        options: dateRangeOptions,
        value: dateRange,
        setValue: setDateRange
      })
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx("div", {
      className: "flex flex-col w-full",
      children: validCryptos.map(crypto => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
        className: "bg-theme-200/50 dark:bg-theme-900/20 rounded m-1 flex-1 flex flex-row items-center justify-between p-1 text-xs",
        children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx("div", {
          className: "font-thin pl-2",
          children: crypto.name
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
          className: "flex flex-row text-right",
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx("div", {
            className: "font-bold mr-2",
            children: t("common.number", {
              value: crypto.quote[currencyCode].price,
              style: "currency",
              currency: currencyCode
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
            className: `font-bold w-10 mr-2 ${crypto.quote[currencyCode][`percent_change_${dateRange}`] > 0 ? "text-emerald-300" : "text-rose-300"}`,
            children: [crypto.quote[currencyCode][`percent_change_${dateRange}`].toFixed(2), "%"]
          })]
        })]
      }, crypto.id))
    })]
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;