"use strict";
exports.id = 9068;
exports.ids = [9068];
exports.modules = {

/***/ 9068:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Component)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(9003);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var components_services_widget_container__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(8581);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__);




function Component({
  service
}) {
  const {
    0: refreshTimer,
    1: setRefreshTimer
  } = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(0);
  const {
    widget
  } = service;
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    if (widget?.refreshInterval) {
      setInterval(() => setRefreshTimer(refreshTimer + 1), widget?.refreshInterval < 1000 ? 1000 : widget?.refreshInterval);
    }
  }, [refreshTimer, widget?.refreshInterval]);
  const scrollingDisableStyle = widget?.allowScrolling === "no" ? {
    pointerEvents: "none",
    overflow: "hidden"
  } : {};
  const classes = widget?.classes || "h-60 sm:h-60 md:h-60 lg:h-60 xl:h-60 2xl:h-72";
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx(components_services_widget_container__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
    service: service,
    children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx("div", {
      className: classnames__WEBPACK_IMPORTED_MODULE_1___default()("bg-theme-200/50 dark:bg-theme-900/20 rounded m-1 flex-1 flex flex-col items-center justify-center text-center", "service-block"),
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx("iframe", {
        src: widget?.src,
        name: widget?.name,
        title: widget?.name,
        allow: widget?.allowPolicy,
        allowFullScreen: widget?.allowfullscreen,
        referrerPolicy: widget?.referrerPolicy,
        loading: widget?.loadingStrategy,
        scrolling: widget?.allowScrolling,
        style: {
          scrollingDisableStyle
        },
        className: `rounded w-full ${classes}`
      }, `${widget?.name}-${refreshTimer}`)
    })
  });
}

/***/ })

};
;