"use strict";
exports.id = 9384;
exports.ids = [9384];
exports.modules = {

/***/ 9384:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Component)
/* harmony export */ });
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var components_services_widget_container__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8581);
/* harmony import */ var utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4582);
/* harmony import */ var components_services_widget_block__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(403);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_2__]);
utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_2__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];






function Component({
  service
}) {
  const {
    t
  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_0__.useTranslation)();
  const {
    widget
  } = service;
  const {
    data: statusData,
    error: statusError
  } = (0,utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z)(widget, "status_page");
  const {
    data: heartbeatData,
    error: heartbeatError
  } = (0,utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z)(widget, "heartbeat");

  if (statusError || heartbeatError) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_container__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
      service: service,
      error: statusError ?? heartbeatError
    });
  }

  if (!statusData || !heartbeatData) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)(components_services_widget_container__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
      service: service,
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
        label: "uptimekuma.up"
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
        label: "uptimekuma.down"
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
        label: "uptimekuma.uptime"
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
        label: "uptimekuma.incidents"
      })]
    });
  }

  let sitesUp = 0;
  let sitesDown = 0;
  Object.values(heartbeatData.heartbeatList).forEach(siteList => {
    const lastHeartbeat = siteList[siteList.length - 1];

    if (lastHeartbeat?.status === 1) {
      sitesUp += 1;
    } else {
      sitesDown += 1;
    }
  }); // Adapted from https://github.com/bastienwirtz/homer/blob/b7cd8f9482e6836a96b354b11595b03b9c3d67cd/src/components/services/UptimeKuma.vue#L105

  const uptimeList = Object.values(heartbeatData.uptimeList);
  const percent = uptimeList.reduce((a, b) => a + b, 0) / uptimeList.length || 0;
  const uptime = (percent * 100).toFixed(1);
  const incidentTime = statusData.incident ? Math.abs(new Date(statusData.incident?.createdDate) - new Date()) / 1000 / (60 * 60) : null;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)(components_services_widget_container__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
    service: service,
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
      label: "uptimekuma.up",
      value: t("common.number", {
        value: sitesUp
      })
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
      label: "uptimekuma.down",
      value: t("common.number", {
        value: sitesDown
      })
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
      label: "uptimekuma.uptime",
      value: t("common.percent", {
        value: uptime
      })
    }), incidentTime && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
      label: "uptimekuma.incident",
      value: t("common.number", {
        value: Math.round(incidentTime)
      }) + t("uptimekuma.m")
    })]
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;