"use strict";
(() => {
var exports = {};
exports.id = 2231;
exports.ids = [2231];
exports.modules = {

/***/ 2370:
/***/ ((module) => {

module.exports = require("systeminformation");

/***/ }),

/***/ 7147:
/***/ ((module) => {

module.exports = require("fs");

/***/ }),

/***/ 6247:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ handler)
/* harmony export */ });
/* harmony import */ var fs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7147);
/* harmony import */ var fs__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(fs__WEBPACK_IMPORTED_MODULE_0__);


const si = __webpack_require__(2370);

async function handler(req, res) {
  const {
    type,
    target
  } = req.query;

  if (type === "cpu") {
    const load = await si.currentLoad();
    return res.status(200).json({
      cpu: {
        usage: load.currentLoad,
        load: load.avgLoad
      }
    });
  }

  if (type === "disk") {
    if (!(0,fs__WEBPACK_IMPORTED_MODULE_0__.existsSync)(target)) {
      return res.status(404).json({
        error: "Target not found"
      });
    }

    const fsSize = await si.fsSize();
    return res.status(200).json({
      drive: fsSize.find(fs => fs.mount === target) ?? fsSize.find(fs => fs.mount === "/")
    });
  }

  if (type === "memory") {
    return res.status(200).json({
      memory: await si.mem()
    });
  }

  if (type === "cputemp") {
    return res.status(200).json({
      cputemp: await si.cpuTemperature()
    });
  }

  if (type === "uptime") {
    const timeData = await si.time();
    return res.status(200).json({
      uptime: timeData.uptime
    });
  }

  return res.status(400).json({
    error: "invalid type"
  });
}

/***/ })

};
;

// load runtime
var __webpack_require__ = require("../../../webpack-api-runtime.js");
__webpack_require__.C(exports);
var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
var __webpack_exports__ = (__webpack_exec__(6247));
module.exports = __webpack_exports__;

})();