/// <reference types="node" />
import { ObjectCache } from './cache';
import { KubeConfig } from './config';
import { KubernetesListObject, KubernetesObject } from './types';
import http = require('http');
export declare type ObjectCallback<T extends KubernetesObject> = (obj: T) => void;
export declare type ErrorCallback = (err?: any) => void;
export declare type ListCallback<T extends KubernetesObject> = (list: T[], ResourceVersion: string) => void;
export declare type ListPromise<T extends KubernetesObject> = () => Promise<{
    response: http.IncomingMessage;
    body: KubernetesListObject<T>;
}>;
export declare const ADD = "add";
export declare type ADD = typeof ADD;
export declare const UPDATE = "update";
export declare type UPDATE = typeof UPDATE;
export declare const CHANGE = "change";
export declare type CHANGE = typeof CHANGE;
export declare const DELETE = "delete";
export declare type DELETE = typeof DELETE;
export declare const CONNECT = "connect";
export declare type CONNECT = typeof CONNECT;
export declare const ERROR = "error";
export declare type ERROR = typeof ERROR;
export interface Informer<T> {
    on(verb: ADD | UPDATE | DELETE | CHANGE, cb: ObjectCallback<T>): void;
    on(verb: ERROR | CONNECT, cb: ErrorCallback): void;
    off(verb: ADD | UPDATE | DELETE | CHANGE, cb: ObjectCallback<T>): void;
    off(verb: ERROR | CONNECT, cb: ErrorCallback): void;
    start(): Promise<void>;
    stop(): Promise<void>;
}
export declare function makeInformer<T>(kubeconfig: KubeConfig, path: string, listPromiseFn: ListPromise<T>, labelSelector?: string): Informer<T> & ObjectCache<T>;
