"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Metrics = void 0;
const request = require("request");
const api_1 = require("./gen/api");
class Metrics {
    constructor(config) {
        this.config = config;
    }
    async getNodeMetrics() {
        return this.metricsApiRequest('/apis/metrics.k8s.io/v1beta1/nodes');
    }
    async getPodMetrics(namespace, name) {
        let path;
        if (namespace !== undefined && namespace.length > 0 && name !== undefined && name.length > 0) {
            path = `/apis/metrics.k8s.io/v1beta1/namespaces/${namespace}/pods/${name}`;
            return this.metricsApiRequest(path);
        }
        if (namespace !== undefined && namespace.length > 0) {
            path = `/apis/metrics.k8s.io/v1beta1/namespaces/${namespace}/pods`;
        }
        else {
            path = '/apis/metrics.k8s.io/v1beta1/pods';
        }
        return this.metricsApiRequest(path);
    }
    async metricsApiRequest(path) {
        const cluster = this.config.getCurrentCluster();
        if (!cluster) {
            throw new Error('No currently active cluster');
        }
        const requestOptions = {
            method: 'GET',
            uri: cluster.server + path,
        };
        await this.config.applyToRequest(requestOptions);
        return new Promise((resolve, reject) => {
            const req = request(requestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else if (response.statusCode !== 200) {
                    try {
                        const deserializedBody = api_1.ObjectSerializer.deserialize(JSON.parse(body), 'V1Status');
                        reject(new api_1.HttpError(response, deserializedBody, response.statusCode));
                    }
                    catch (e) {
                        reject(new api_1.HttpError(response, body, response.statusCode));
                    }
                }
                else {
                    resolve(JSON.parse(body));
                }
            });
        });
    }
}
exports.Metrics = Metrics;
//# sourceMappingURL=metrics.js.map