import { JSONRPCRequest, JSONRPCResponse, JSONRPCParams, JSONRPCID, JSONRPCErrorResponse, ErrorListener } from "./models";
export type SimpleJSONRPCMethod<ServerParams = void> = (params: JSONRPCParams, serverParams: ServerParams) => any;
export type JSONRPCMethod<ServerParams = void> = (request: JSONRPCRequest, serverParams: ServerParams) => JSONRPCResponsePromise;
export type JSONRPCResponsePromise = PromiseLike<JSONRPCResponse | null>;
export type JSONRPCServerMiddlewareNext<ServerParams> = (request: JSONRPCRequest, serverParams: ServerParams) => JSONRPCResponsePromise;
export type JSONRPCServerMiddleware<ServerParams> = (next: JSONRPCServerMiddlewareNext<ServerParams>, request: JSONRPCRequest, serverParams: ServerParams) => JSONRPCResponsePromise;
export interface JSONRPCServerOptions {
    errorListener?: ErrorListener;
}
export declare class JSONRPCServer<ServerParams = void> {
    private nameToMethodDictionary;
    private middleware;
    private readonly errorListener;
    mapErrorToJSONRPCErrorResponse: (id: JSONRPCID, error: any) => JSONRPCErrorResponse;
    constructor(options?: JSONRPCServerOptions);
    hasMethod(name: string): boolean;
    addMethod(name: string, method: SimpleJSONRPCMethod<ServerParams>): void;
    private toJSONRPCMethod;
    addMethodAdvanced(name: string, method: JSONRPCMethod<ServerParams>): void;
    receiveJSON(json: string, serverParams?: ServerParams): PromiseLike<JSONRPCResponse | JSONRPCResponse[] | null>;
    private tryParseRequestJSON;
    receive(request: JSONRPCRequest, serverParams?: ServerParams): PromiseLike<JSONRPCResponse | null>;
    receive(request: JSONRPCRequest | JSONRPCRequest[], serverParams?: ServerParams): PromiseLike<JSONRPCResponse | JSONRPCResponse[] | null>;
    private receiveMultiple;
    private receiveSingle;
    applyMiddleware(...middlewares: JSONRPCServerMiddleware<ServerParams>[]): void;
    private combineMiddlewares;
    private middlewareReducer;
    private callMethod;
    private mapErrorToJSONRPCErrorResponseIfNecessary;
}
