#!/bin/sh

VENDOR=$1

BASE_DIR=`dirname "$0"`
cd "$BASE_DIR"

APP_NAME=`basename "$BASE_DIR" | tr A-Z a-z`
case $APP_NAME in
	phonebook) DEST_DIRNAME=PhoneBook ;;
	emailbook) DEST_DIRNAME=EmailBook ;;
	addressbook) DEST_DIRNAME=AddressBook ;;
	wirelesssetup) DEST_DIRNAME=WirelessSetup ;;
	*) echo "ERROR: Invalid application <$APP_NAME>."; return ;;
esac

DEST_PATH=/opt/$VENDOR/$DEST_DIRNAME

#remove destination
VERSION=`cat "$DEST_PATH/bin/.version"`
if rm -fr "$DEST_PATH"; then
	echo "INFO: $APP_NAME (ver.$VERSION) has been uninstalled successfully."
else
	echo "ERROR: Cannot uninstall $APP_NAME! Check your permissions."
fi
