=begin
#OpenBao API

#HTTP API that gives you full access to OpenBao. All API routes are prefixed with `/v1/`.

The version of the OpenAPI document: 2.0.0

Generated by: https://openapi-generator.tech
Generator version: 7.7.0

=end

require 'spec_helper'
require 'json'

# Unit tests for OpenbaoClient::SecretsApi
# Automatically generated by openapi-generator (https://openapi-generator.tech)
# Please update as you see appropriate
describe 'SecretsApi' do
  before do
    # run before each test
    @api_instance = OpenbaoClient::SecretsApi.new
  end

  after do
    # run after each test
  end

  describe 'test an instance of SecretsApi' do
    it 'should create an instance of SecretsApi' do
      expect(@api_instance).to be_instance_of(OpenbaoClient::SecretsApi)
    end
  end

  # unit tests for cubbyhole_delete
  # Deletes the secret at the specified location.
  # @param path Specifies the path of the secret.
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'cubbyhole_delete test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for cubbyhole_read
  # Retrieve the secret at the specified location.
  # @param path Specifies the path of the secret.
  # @param [Hash] opts the optional parameters
  # @option opts [String] :list Return a list if &#x60;true&#x60;
  # @return [nil]
  describe 'cubbyhole_read test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for cubbyhole_write
  # Store a secret at the specified location.
  # @param path Specifies the path of the secret.
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'cubbyhole_write test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for database_configure_connection
  # @param name Name of this database connection
  # @param database_mount_path Path that the backend was mounted at
  # @param database_configure_connection_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'database_configure_connection test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for database_delete_connection_configuration
  # @param name Name of this database connection
  # @param database_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'database_delete_connection_configuration test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for database_delete_role
  # Manage the roles that can be created with this backend.
  # @param name Name of the role.
  # @param database_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'database_delete_role test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for database_delete_static_role
  # Manage the static roles that can be created with this backend.
  # @param name Name of the role.
  # @param database_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'database_delete_static_role test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for database_generate_credentials
  # Request database credentials for a certain role.
  # @param name Name of the role.
  # @param database_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'database_generate_credentials test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for database_list_connections
  # Configure connection details to a database plugin.
  # @param database_mount_path Path that the backend was mounted at
  # @param list Must be set to &#x60;true&#x60;
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'database_list_connections test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for database_list_roles
  # Manage the roles that can be created with this backend.
  # @param database_mount_path Path that the backend was mounted at
  # @param list Must be set to &#x60;true&#x60;
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'database_list_roles test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for database_list_static_roles
  # Manage the static roles that can be created with this backend.
  # @param database_mount_path Path that the backend was mounted at
  # @param list Must be set to &#x60;true&#x60;
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'database_list_static_roles test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for database_read_connection_configuration
  # @param name Name of this database connection
  # @param database_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'database_read_connection_configuration test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for database_read_role
  # Manage the roles that can be created with this backend.
  # @param name Name of the role.
  # @param database_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'database_read_role test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for database_read_static_role
  # Manage the static roles that can be created with this backend.
  # @param name Name of the role.
  # @param database_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'database_read_static_role test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for database_read_static_role_credentials
  # Request database credentials for a certain static role. These credentials are rotated periodically.
  # @param name Name of the static role.
  # @param database_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'database_read_static_role_credentials test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for database_reset_connection
  # Resets a database plugin.
  # @param name Name of this database connection
  # @param database_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'database_reset_connection test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for database_rotate_root_credentials
  # @param name Name of this database connection
  # @param database_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'database_rotate_root_credentials test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for database_rotate_static_role_credentials
  # @param name Name of the static role
  # @param database_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'database_rotate_static_role_credentials test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for database_write_role
  # Manage the roles that can be created with this backend.
  # @param name Name of the role.
  # @param database_mount_path Path that the backend was mounted at
  # @param database_write_role_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'database_write_role test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for database_write_static_role
  # Manage the static roles that can be created with this backend.
  # @param name Name of the role.
  # @param database_mount_path Path that the backend was mounted at
  # @param database_write_static_role_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'database_write_static_role test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for kubernetes_check_configuration
  # @param kubernetes_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'kubernetes_check_configuration test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for kubernetes_configure
  # @param kubernetes_mount_path Path that the backend was mounted at
  # @param kubernetes_configure_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'kubernetes_configure test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for kubernetes_delete_configuration
  # @param kubernetes_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'kubernetes_delete_configuration test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for kubernetes_delete_role
  # @param name Name of the role
  # @param kubernetes_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'kubernetes_delete_role test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for kubernetes_generate_credentials
  # @param name Name of the OpenBao role
  # @param kubernetes_mount_path Path that the backend was mounted at
  # @param kubernetes_generate_credentials_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'kubernetes_generate_credentials test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for kubernetes_list_roles
  # @param kubernetes_mount_path Path that the backend was mounted at
  # @param list Must be set to &#x60;true&#x60;
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'kubernetes_list_roles test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for kubernetes_read_configuration
  # @param kubernetes_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'kubernetes_read_configuration test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for kubernetes_read_role
  # @param name Name of the role
  # @param kubernetes_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'kubernetes_read_role test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for kubernetes_write_role
  # @param name Name of the role
  # @param kubernetes_mount_path Path that the backend was mounted at
  # @param kubernetes_write_role_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'kubernetes_write_role test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for kv_delete_data_path
  # Write, Patch, Read, and Delete data in the Key-Value Store.
  # @param path Location of the secret.
  # @param kv_v2_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'kv_delete_data_path test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for kv_delete_metadata_path
  # Configures settings for the KV store
  # @param path Location of the secret.
  # @param kv_v2_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'kv_delete_metadata_path test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for kv_delete_path
  # Pass-through secret storage to the storage backend, allowing you to read/write arbitrary data into secret storage.
  # @param path Location of the secret.
  # @param kv_v1_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'kv_delete_path test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for kv_read_config
  # Read the backend level settings.
  # @param kv_v2_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'kv_read_config test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for kv_read_data_path
  # Write, Patch, Read, and Delete data in the Key-Value Store.
  # @param path Location of the secret.
  # @param kv_v2_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'kv_read_data_path test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for kv_read_metadata_path
  # Configures settings for the KV store
  # @param path Location of the secret.
  # @param kv_v2_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @option opts [String] :list Return a list if &#x60;true&#x60;
  # @return [nil]
  describe 'kv_read_metadata_path test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for kv_read_path
  # Pass-through secret storage to the storage backend, allowing you to read/write arbitrary data into secret storage.
  # @param path Location of the secret.
  # @param kv_v1_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @option opts [String] :list Return a list if &#x60;true&#x60;
  # @return [nil]
  describe 'kv_read_path test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for kv_read_subkeys_path
  # Read the structure of a secret entry from the Key-Value store with the values removed.
  # @param path Location of the secret.
  # @param kv_v2_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'kv_read_subkeys_path test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for kv_write_config
  # Configure backend level settings that are applied to every key in the key-value store.
  # @param kv_v2_mount_path Path that the backend was mounted at
  # @param kv_write_config_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'kv_write_config test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for kv_write_data_path
  # Write, Patch, Read, and Delete data in the Key-Value Store.
  # @param path Location of the secret.
  # @param kv_v2_mount_path Path that the backend was mounted at
  # @param kv_write_data_path_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'kv_write_data_path test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for kv_write_delete_path
  # Marks one or more versions as deleted in the KV store.
  # @param path Location of the secret.
  # @param kv_v2_mount_path Path that the backend was mounted at
  # @param kv_write_delete_path_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'kv_write_delete_path test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for kv_write_destroy_path
  # Permanently removes one or more versions in the KV store
  # @param path Location of the secret.
  # @param kv_v2_mount_path Path that the backend was mounted at
  # @param kv_write_destroy_path_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'kv_write_destroy_path test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for kv_write_metadata_path
  # Configures settings for the KV store
  # @param path Location of the secret.
  # @param kv_v2_mount_path Path that the backend was mounted at
  # @param kv_write_metadata_path_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'kv_write_metadata_path test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for kv_write_path
  # Pass-through secret storage to the storage backend, allowing you to read/write arbitrary data into secret storage.
  # @param path Location of the secret.
  # @param kv_v1_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'kv_write_path test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for kv_write_undelete_path
  # Undeletes one or more versions from the KV store.
  # @param path Location of the secret.
  # @param kv_v2_mount_path Path that the backend was mounted at
  # @param kv_write_undelete_path_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'kv_write_undelete_path test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for ldap_configure
  # @param ldap_mount_path Path that the backend was mounted at
  # @param ldap_configure_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'ldap_configure test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for ldap_delete_configuration
  # @param ldap_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'ldap_delete_configuration test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for ldap_delete_dynamic_role
  # @param name Name of the role (lowercase)
  # @param ldap_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'ldap_delete_dynamic_role test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for ldap_delete_static_role
  # @param name Name of the role
  # @param ldap_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'ldap_delete_static_role test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for ldap_library_check_in
  # Check service accounts in to the library.
  # @param name Name of the set.
  # @param ldap_mount_path Path that the backend was mounted at
  # @param ldap_library_check_in_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'ldap_library_check_in test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for ldap_library_check_out
  # Check a service account out from the library.
  # @param name Name of the set
  # @param ldap_mount_path Path that the backend was mounted at
  # @param ldap_library_check_out_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'ldap_library_check_out test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for ldap_library_check_status
  # Check the status of the service accounts in a library set.
  # @param name Name of the set.
  # @param ldap_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'ldap_library_check_status test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for ldap_library_configure
  # Update a library set.
  # @param name Name of the set.
  # @param ldap_mount_path Path that the backend was mounted at
  # @param ldap_library_configure_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'ldap_library_configure test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for ldap_library_delete
  # Delete a library set.
  # @param name Name of the set.
  # @param ldap_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'ldap_library_delete test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for ldap_library_force_check_in
  # Check service accounts in to the library.
  # @param name Name of the set.
  # @param ldap_mount_path Path that the backend was mounted at
  # @param ldap_library_force_check_in_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'ldap_library_force_check_in test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for ldap_library_list
  # @param ldap_mount_path Path that the backend was mounted at
  # @param list Must be set to &#x60;true&#x60;
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'ldap_library_list test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for ldap_library_read
  # Read a library set.
  # @param name Name of the set.
  # @param ldap_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'ldap_library_read test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for ldap_list_dynamic_roles
  # @param ldap_mount_path Path that the backend was mounted at
  # @param list Must be set to &#x60;true&#x60;
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'ldap_list_dynamic_roles test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for ldap_list_static_roles
  # @param ldap_mount_path Path that the backend was mounted at
  # @param list Must be set to &#x60;true&#x60;
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'ldap_list_static_roles test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for ldap_read_configuration
  # @param ldap_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'ldap_read_configuration test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for ldap_read_dynamic_role
  # @param name Name of the role (lowercase)
  # @param ldap_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'ldap_read_dynamic_role test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for ldap_read_static_role
  # @param name Name of the role
  # @param ldap_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'ldap_read_static_role test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for ldap_request_dynamic_role_credentials
  # @param name Name of the dynamic role.
  # @param ldap_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'ldap_request_dynamic_role_credentials test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for ldap_request_static_role_credentials
  # @param name Name of the static role.
  # @param ldap_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'ldap_request_static_role_credentials test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for ldap_rotate_root_credentials
  # @param ldap_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'ldap_rotate_root_credentials test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for ldap_rotate_static_role
  # @param name Name of the static role
  # @param ldap_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'ldap_rotate_static_role test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for ldap_write_dynamic_role
  # @param name Name of the role (lowercase)
  # @param ldap_mount_path Path that the backend was mounted at
  # @param ldap_write_dynamic_role_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'ldap_write_dynamic_role test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for ldap_write_static_role
  # @param name Name of the role
  # @param ldap_mount_path Path that the backend was mounted at
  # @param ldap_write_static_role_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'ldap_write_static_role test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_configure_acme
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_configure_acme_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pki_configure_acme test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_configure_auto_tidy
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_configure_auto_tidy_request 
  # @param [Hash] opts the optional parameters
  # @return [PkiConfigureAutoTidyResponse]
  describe 'pki_configure_auto_tidy test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_configure_ca
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_configure_ca_request 
  # @param [Hash] opts the optional parameters
  # @return [PkiConfigureCaResponse]
  describe 'pki_configure_ca test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_configure_cluster
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_configure_cluster_request 
  # @param [Hash] opts the optional parameters
  # @return [PkiConfigureClusterResponse]
  describe 'pki_configure_cluster test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_configure_crl
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_configure_crl_request 
  # @param [Hash] opts the optional parameters
  # @return [PkiConfigureCrlResponse]
  describe 'pki_configure_crl test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_configure_issuers
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_configure_issuers_request 
  # @param [Hash] opts the optional parameters
  # @return [PkiConfigureIssuersResponse]
  describe 'pki_configure_issuers test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_configure_keys
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_configure_keys_request 
  # @param [Hash] opts the optional parameters
  # @return [PkiConfigureKeysResponse]
  describe 'pki_configure_keys test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_configure_urls
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_configure_urls_request 
  # @param [Hash] opts the optional parameters
  # @return [PkiConfigureUrlsResponse]
  describe 'pki_configure_urls test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_cross_sign_intermediate
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_cross_sign_intermediate_request 
  # @param [Hash] opts the optional parameters
  # @return [PkiCrossSignIntermediateResponse]
  describe 'pki_cross_sign_intermediate test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_delete_eab_key
  # @param key_id EAB key identifier
  # @param pki_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pki_delete_eab_key test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_delete_issuer
  # @param issuer_ref Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
  # @param pki_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pki_delete_issuer test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_delete_key
  # @param key_ref Reference to key; either \&quot;default\&quot; for the configured default key, an identifier of a key, or the name assigned to the key.
  # @param pki_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pki_delete_key test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_delete_role
  # @param name Name of the role
  # @param pki_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pki_delete_role test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_delete_root
  # @param pki_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pki_delete_root test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_generate_eab_key
  # @param pki_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [PkiGenerateEabKeyResponse]
  describe 'pki_generate_eab_key test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_generate_eab_key_for_issuer
  # @param issuer_ref Reference to an existing issuer name or issuer id
  # @param pki_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [PkiGenerateEabKeyForIssuerResponse]
  describe 'pki_generate_eab_key_for_issuer test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_generate_eab_key_for_issuer_and_role
  # @param issuer_ref Reference to an existing issuer name or issuer id
  # @param role The desired role for the acme request
  # @param pki_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [PkiGenerateEabKeyForIssuerAndRoleResponse]
  describe 'pki_generate_eab_key_for_issuer_and_role test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_generate_eab_key_for_role
  # @param role The desired role for the acme request
  # @param pki_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [PkiGenerateEabKeyForRoleResponse]
  describe 'pki_generate_eab_key_for_role test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_generate_exported_key
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_generate_exported_key_request 
  # @param [Hash] opts the optional parameters
  # @return [PkiGenerateExportedKeyResponse]
  describe 'pki_generate_exported_key test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_generate_intermediate
  # @param exported Must be \&quot;internal\&quot;, \&quot;exported\&quot; or \&quot;kms\&quot;. If set to \&quot;exported\&quot;, the generated private key will be returned. This is your *only* chance to retrieve the private key!
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_generate_intermediate_request 
  # @param [Hash] opts the optional parameters
  # @return [PkiGenerateIntermediateResponse]
  describe 'pki_generate_intermediate test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_generate_internal_key
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_generate_internal_key_request 
  # @param [Hash] opts the optional parameters
  # @return [PkiGenerateInternalKeyResponse]
  describe 'pki_generate_internal_key test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_generate_kms_key
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_generate_kms_key_request 
  # @param [Hash] opts the optional parameters
  # @return [PkiGenerateKmsKeyResponse]
  describe 'pki_generate_kms_key test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_generate_root
  # @param exported Must be \&quot;internal\&quot;, \&quot;exported\&quot; or \&quot;kms\&quot;. If set to \&quot;exported\&quot;, the generated private key will be returned. This is your *only* chance to retrieve the private key!
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_generate_root_request 
  # @param [Hash] opts the optional parameters
  # @return [PkiGenerateRootResponse]
  describe 'pki_generate_root test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_import_key
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_import_key_request 
  # @param [Hash] opts the optional parameters
  # @return [PkiImportKeyResponse]
  describe 'pki_import_key test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_issue_with_role
  # @param role The desired role with configuration for this request
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_issue_with_role_request 
  # @param [Hash] opts the optional parameters
  # @return [PkiIssueWithRoleResponse]
  describe 'pki_issue_with_role test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_issuer_issue_with_role
  # @param issuer_ref Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
  # @param role The desired role with configuration for this request
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_issuer_issue_with_role_request 
  # @param [Hash] opts the optional parameters
  # @return [PkiIssuerIssueWithRoleResponse]
  describe 'pki_issuer_issue_with_role test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_issuer_read_crl
  # @param issuer_ref Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
  # @param pki_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [PkiIssuerReadCrlResponse]
  describe 'pki_issuer_read_crl test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_issuer_read_crl_delta
  # @param issuer_ref Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
  # @param pki_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [PkiIssuerReadCrlDeltaResponse]
  describe 'pki_issuer_read_crl_delta test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_issuer_read_crl_delta_der
  # @param issuer_ref Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
  # @param pki_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [PkiIssuerReadCrlDeltaDerResponse]
  describe 'pki_issuer_read_crl_delta_der test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_issuer_read_crl_delta_pem
  # @param issuer_ref Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
  # @param pki_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [PkiIssuerReadCrlDeltaPemResponse]
  describe 'pki_issuer_read_crl_delta_pem test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_issuer_read_crl_der
  # @param issuer_ref Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
  # @param pki_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [PkiIssuerReadCrlDerResponse]
  describe 'pki_issuer_read_crl_der test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_issuer_read_crl_pem
  # @param issuer_ref Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
  # @param pki_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [PkiIssuerReadCrlPemResponse]
  describe 'pki_issuer_read_crl_pem test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_issuer_resign_crls
  # @param issuer_ref Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_issuer_resign_crls_request 
  # @param [Hash] opts the optional parameters
  # @return [PkiIssuerResignCrlsResponse]
  describe 'pki_issuer_resign_crls test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_issuer_sign_intermediate
  # @param issuer_ref Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_issuer_sign_intermediate_request 
  # @param [Hash] opts the optional parameters
  # @return [PkiIssuerSignIntermediateResponse]
  describe 'pki_issuer_sign_intermediate test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_issuer_sign_revocation_list
  # @param issuer_ref Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_issuer_sign_revocation_list_request 
  # @param [Hash] opts the optional parameters
  # @return [PkiIssuerSignRevocationListResponse]
  describe 'pki_issuer_sign_revocation_list test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_issuer_sign_self_issued
  # @param issuer_ref Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_issuer_sign_self_issued_request 
  # @param [Hash] opts the optional parameters
  # @return [PkiIssuerSignSelfIssuedResponse]
  describe 'pki_issuer_sign_self_issued test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_issuer_sign_verbatim
  # @param issuer_ref Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_issuer_sign_verbatim_request 
  # @param [Hash] opts the optional parameters
  # @return [PkiIssuerSignVerbatimResponse]
  describe 'pki_issuer_sign_verbatim test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_issuer_sign_verbatim_with_role
  # @param issuer_ref Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
  # @param role The desired role with configuration for this request
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_issuer_sign_verbatim_with_role_request 
  # @param [Hash] opts the optional parameters
  # @return [PkiIssuerSignVerbatimWithRoleResponse]
  describe 'pki_issuer_sign_verbatim_with_role test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_issuer_sign_with_role
  # @param issuer_ref Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
  # @param role The desired role with configuration for this request
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_issuer_sign_with_role_request 
  # @param [Hash] opts the optional parameters
  # @return [PkiIssuerSignWithRoleResponse]
  describe 'pki_issuer_sign_with_role test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_issuers_generate_intermediate
  # @param exported Must be \&quot;internal\&quot;, \&quot;exported\&quot; or \&quot;kms\&quot;. If set to \&quot;exported\&quot;, the generated private key will be returned. This is your *only* chance to retrieve the private key!
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_issuers_generate_intermediate_request 
  # @param [Hash] opts the optional parameters
  # @return [PkiIssuersGenerateIntermediateResponse]
  describe 'pki_issuers_generate_intermediate test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_issuers_generate_root
  # @param exported Must be \&quot;internal\&quot;, \&quot;exported\&quot; or \&quot;kms\&quot;. If set to \&quot;exported\&quot;, the generated private key will be returned. This is your *only* chance to retrieve the private key!
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_issuers_generate_root_request 
  # @param [Hash] opts the optional parameters
  # @return [PkiIssuersGenerateRootResponse]
  describe 'pki_issuers_generate_root test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_issuers_import_bundle
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_issuers_import_bundle_request 
  # @param [Hash] opts the optional parameters
  # @return [PkiIssuersImportBundleResponse]
  describe 'pki_issuers_import_bundle test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_issuers_import_cert
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_issuers_import_cert_request 
  # @param [Hash] opts the optional parameters
  # @return [PkiIssuersImportCertResponse]
  describe 'pki_issuers_import_cert test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_list_certs
  # @param pki_mount_path Path that the backend was mounted at
  # @param list Must be set to &#x60;true&#x60;
  # @param [Hash] opts the optional parameters
  # @return [PkiListCertsResponse]
  describe 'pki_list_certs test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_list_eab_keys
  # @param pki_mount_path Path that the backend was mounted at
  # @param list Must be set to &#x60;true&#x60;
  # @param [Hash] opts the optional parameters
  # @return [PkiListEabKeysResponse]
  describe 'pki_list_eab_keys test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_list_issuers
  # @param pki_mount_path Path that the backend was mounted at
  # @param list Must be set to &#x60;true&#x60;
  # @param [Hash] opts the optional parameters
  # @return [PkiListIssuersResponse]
  describe 'pki_list_issuers test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_list_keys
  # @param pki_mount_path Path that the backend was mounted at
  # @param list Must be set to &#x60;true&#x60;
  # @param [Hash] opts the optional parameters
  # @return [PkiListKeysResponse]
  describe 'pki_list_keys test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_list_revoked_certs
  # @param pki_mount_path Path that the backend was mounted at
  # @param list Must be set to &#x60;true&#x60;
  # @param [Hash] opts the optional parameters
  # @return [PkiListRevokedCertsResponse]
  describe 'pki_list_revoked_certs test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_list_roles
  # @param pki_mount_path Path that the backend was mounted at
  # @param list Must be set to &#x60;true&#x60;
  # @param [Hash] opts the optional parameters
  # @return [PkiListRolesResponse]
  describe 'pki_list_roles test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_query_ocsp
  # @param pki_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pki_query_ocsp test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_query_ocsp_with_get_req
  # @param req base-64 encoded ocsp request
  # @param pki_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pki_query_ocsp_with_get_req test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_read_acme_configuration
  # @param pki_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pki_read_acme_configuration test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_read_acme_directory
  # @param pki_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pki_read_acme_directory test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_read_acme_new_nonce
  # @param pki_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pki_read_acme_new_nonce test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_read_auto_tidy_configuration
  # @param pki_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [PkiReadAutoTidyConfigurationResponse]
  describe 'pki_read_auto_tidy_configuration test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_read_ca_chain_pem
  # @param pki_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [PkiReadCaChainPemResponse]
  describe 'pki_read_ca_chain_pem test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_read_ca_der
  # @param pki_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [PkiReadCaDerResponse]
  describe 'pki_read_ca_der test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_read_ca_pem
  # @param pki_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [PkiReadCaPemResponse]
  describe 'pki_read_ca_pem test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_read_cert
  # @param serial Certificate serial number, in colon- or hyphen-separated octal
  # @param pki_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [PkiReadCertResponse]
  describe 'pki_read_cert test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_read_cert_ca_chain
  # @param pki_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [PkiReadCertCaChainResponse]
  describe 'pki_read_cert_ca_chain test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_read_cert_crl
  # @param pki_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [PkiReadCertCrlResponse]
  describe 'pki_read_cert_crl test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_read_cert_delta_crl
  # @param pki_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [PkiReadCertDeltaCrlResponse]
  describe 'pki_read_cert_delta_crl test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_read_cert_raw_der
  # @param serial Certificate serial number, in colon- or hyphen-separated octal
  # @param pki_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [PkiReadCertRawDerResponse]
  describe 'pki_read_cert_raw_der test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_read_cert_raw_pem
  # @param serial Certificate serial number, in colon- or hyphen-separated octal
  # @param pki_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [PkiReadCertRawPemResponse]
  describe 'pki_read_cert_raw_pem test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_read_cluster_configuration
  # @param pki_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [PkiReadClusterConfigurationResponse]
  describe 'pki_read_cluster_configuration test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_read_crl_configuration
  # @param pki_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [PkiReadCrlConfigurationResponse]
  describe 'pki_read_crl_configuration test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_read_crl_delta
  # @param pki_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [PkiReadCrlDeltaResponse]
  describe 'pki_read_crl_delta test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_read_crl_delta_pem
  # @param pki_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [PkiReadCrlDeltaPemResponse]
  describe 'pki_read_crl_delta_pem test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_read_crl_der
  # @param pki_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [PkiReadCrlDerResponse]
  describe 'pki_read_crl_der test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_read_crl_pem
  # @param pki_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [PkiReadCrlPemResponse]
  describe 'pki_read_crl_pem test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_read_issuer
  # @param issuer_ref Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
  # @param pki_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [PkiReadIssuerResponse]
  describe 'pki_read_issuer test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_read_issuer_der
  # @param issuer_ref Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
  # @param pki_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [PkiReadIssuerDerResponse]
  describe 'pki_read_issuer_der test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_read_issuer_issuer_ref_acme_directory
  # @param issuer_ref Reference to an existing issuer name or issuer id
  # @param pki_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pki_read_issuer_issuer_ref_acme_directory test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_read_issuer_issuer_ref_acme_new_nonce
  # @param issuer_ref Reference to an existing issuer name or issuer id
  # @param pki_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pki_read_issuer_issuer_ref_acme_new_nonce test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_read_issuer_issuer_ref_roles_role_acme_directory
  # @param issuer_ref Reference to an existing issuer name or issuer id
  # @param role The desired role for the acme request
  # @param pki_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pki_read_issuer_issuer_ref_roles_role_acme_directory test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_read_issuer_issuer_ref_roles_role_acme_new_nonce
  # @param issuer_ref Reference to an existing issuer name or issuer id
  # @param role The desired role for the acme request
  # @param pki_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pki_read_issuer_issuer_ref_roles_role_acme_new_nonce test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_read_issuer_json
  # @param issuer_ref Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
  # @param pki_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [PkiReadIssuerJsonResponse]
  describe 'pki_read_issuer_json test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_read_issuer_pem
  # @param issuer_ref Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
  # @param pki_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [PkiReadIssuerPemResponse]
  describe 'pki_read_issuer_pem test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_read_issuers_configuration
  # @param pki_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [PkiReadIssuersConfigurationResponse]
  describe 'pki_read_issuers_configuration test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_read_key
  # @param key_ref Reference to key; either \&quot;default\&quot; for the configured default key, an identifier of a key, or the name assigned to the key.
  # @param pki_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [PkiReadKeyResponse]
  describe 'pki_read_key test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_read_keys_configuration
  # @param pki_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [PkiReadKeysConfigurationResponse]
  describe 'pki_read_keys_configuration test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_read_role
  # @param name Name of the role
  # @param pki_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [PkiReadRoleResponse]
  describe 'pki_read_role test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_read_roles_role_acme_directory
  # @param role The desired role for the acme request
  # @param pki_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pki_read_roles_role_acme_directory test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_read_roles_role_acme_new_nonce
  # @param role The desired role for the acme request
  # @param pki_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pki_read_roles_role_acme_new_nonce test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_read_urls_configuration
  # @param pki_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [PkiReadUrlsConfigurationResponse]
  describe 'pki_read_urls_configuration test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_replace_root
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_replace_root_request 
  # @param [Hash] opts the optional parameters
  # @return [PkiReplaceRootResponse]
  describe 'pki_replace_root test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_revoke
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_revoke_request 
  # @param [Hash] opts the optional parameters
  # @return [PkiRevokeResponse]
  describe 'pki_revoke test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_revoke_issuer
  # @param issuer_ref Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
  # @param pki_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [PkiRevokeIssuerResponse]
  describe 'pki_revoke_issuer test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_revoke_with_key
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_revoke_with_key_request 
  # @param [Hash] opts the optional parameters
  # @return [PkiRevokeWithKeyResponse]
  describe 'pki_revoke_with_key test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_root_sign_intermediate
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_root_sign_intermediate_request 
  # @param [Hash] opts the optional parameters
  # @return [PkiRootSignIntermediateResponse]
  describe 'pki_root_sign_intermediate test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_root_sign_self_issued
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_root_sign_self_issued_request 
  # @param [Hash] opts the optional parameters
  # @return [PkiRootSignSelfIssuedResponse]
  describe 'pki_root_sign_self_issued test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_rotate_crl
  # @param pki_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [PkiRotateCrlResponse]
  describe 'pki_rotate_crl test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_rotate_delta_crl
  # @param pki_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [PkiRotateDeltaCrlResponse]
  describe 'pki_rotate_delta_crl test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_rotate_root
  # @param exported Must be \&quot;internal\&quot;, \&quot;exported\&quot; or \&quot;kms\&quot;. If set to \&quot;exported\&quot;, the generated private key will be returned. This is your *only* chance to retrieve the private key!
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_rotate_root_request 
  # @param [Hash] opts the optional parameters
  # @return [PkiRotateRootResponse]
  describe 'pki_rotate_root test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_set_signed_intermediate
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_set_signed_intermediate_request 
  # @param [Hash] opts the optional parameters
  # @return [PkiSetSignedIntermediateResponse]
  describe 'pki_set_signed_intermediate test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_sign_verbatim
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_sign_verbatim_request 
  # @param [Hash] opts the optional parameters
  # @return [PkiSignVerbatimResponse]
  describe 'pki_sign_verbatim test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_sign_verbatim_with_role
  # @param role The desired role with configuration for this request
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_sign_verbatim_with_role_request 
  # @param [Hash] opts the optional parameters
  # @return [PkiSignVerbatimWithRoleResponse]
  describe 'pki_sign_verbatim_with_role test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_sign_with_role
  # @param role The desired role with configuration for this request
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_sign_with_role_request 
  # @param [Hash] opts the optional parameters
  # @return [PkiSignWithRoleResponse]
  describe 'pki_sign_with_role test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_tidy
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_tidy_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pki_tidy test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_tidy_cancel
  # @param pki_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [PkiTidyCancelResponse]
  describe 'pki_tidy_cancel test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_tidy_status
  # @param pki_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [PkiTidyStatusResponse]
  describe 'pki_tidy_status test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_write_acme_account_kid
  # @param kid The key identifier provided by the CA
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_write_acme_account_kid_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pki_write_acme_account_kid test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_write_acme_authorization_auth_id
  # @param auth_id ACME authorization identifier value
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_write_acme_authorization_auth_id_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pki_write_acme_authorization_auth_id test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_write_acme_challenge_auth_id_challenge_type
  # @param auth_id ACME authorization identifier value
  # @param challenge_type ACME challenge type
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_write_acme_challenge_auth_id_challenge_type_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pki_write_acme_challenge_auth_id_challenge_type test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_write_acme_new_account
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_write_acme_new_account_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pki_write_acme_new_account test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_write_acme_new_order
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_write_acme_new_order_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pki_write_acme_new_order test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_write_acme_order_order_id
  # @param order_id The ACME order identifier to fetch
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_write_acme_order_order_id_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pki_write_acme_order_order_id test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_write_acme_order_order_id_cert
  # @param order_id The ACME order identifier to fetch
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_write_acme_order_order_id_cert_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pki_write_acme_order_order_id_cert test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_write_acme_order_order_id_finalize
  # @param order_id The ACME order identifier to fetch
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_write_acme_order_order_id_finalize_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pki_write_acme_order_order_id_finalize test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_write_acme_orders
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_write_acme_orders_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pki_write_acme_orders test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_write_acme_revoke_cert
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_write_acme_revoke_cert_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pki_write_acme_revoke_cert test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_write_issuer
  # @param issuer_ref Reference to a existing issuer; either \&quot;default\&quot; for the configured default issuer, an identifier or the name assigned to the issuer.
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_write_issuer_request 
  # @param [Hash] opts the optional parameters
  # @return [PkiWriteIssuerResponse]
  describe 'pki_write_issuer test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_write_issuer_issuer_ref_acme_account_kid
  # @param issuer_ref Reference to an existing issuer name or issuer id
  # @param kid The key identifier provided by the CA
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_write_issuer_issuer_ref_acme_account_kid_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pki_write_issuer_issuer_ref_acme_account_kid test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_write_issuer_issuer_ref_acme_authorization_auth_id
  # @param auth_id ACME authorization identifier value
  # @param issuer_ref Reference to an existing issuer name or issuer id
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_write_issuer_issuer_ref_acme_authorization_auth_id_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pki_write_issuer_issuer_ref_acme_authorization_auth_id test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_write_issuer_issuer_ref_acme_challenge_auth_id_challenge_type
  # @param auth_id ACME authorization identifier value
  # @param challenge_type ACME challenge type
  # @param issuer_ref Reference to an existing issuer name or issuer id
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_write_issuer_issuer_ref_acme_challenge_auth_id_challenge_type_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pki_write_issuer_issuer_ref_acme_challenge_auth_id_challenge_type test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_write_issuer_issuer_ref_acme_new_account
  # @param issuer_ref Reference to an existing issuer name or issuer id
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_write_issuer_issuer_ref_acme_new_account_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pki_write_issuer_issuer_ref_acme_new_account test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_write_issuer_issuer_ref_acme_new_order
  # @param issuer_ref Reference to an existing issuer name or issuer id
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_write_issuer_issuer_ref_acme_new_order_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pki_write_issuer_issuer_ref_acme_new_order test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_write_issuer_issuer_ref_acme_order_order_id
  # @param issuer_ref Reference to an existing issuer name or issuer id
  # @param order_id The ACME order identifier to fetch
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_write_issuer_issuer_ref_acme_order_order_id_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pki_write_issuer_issuer_ref_acme_order_order_id test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_write_issuer_issuer_ref_acme_order_order_id_cert
  # @param issuer_ref Reference to an existing issuer name or issuer id
  # @param order_id The ACME order identifier to fetch
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_write_issuer_issuer_ref_acme_order_order_id_cert_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pki_write_issuer_issuer_ref_acme_order_order_id_cert test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_write_issuer_issuer_ref_acme_order_order_id_finalize
  # @param issuer_ref Reference to an existing issuer name or issuer id
  # @param order_id The ACME order identifier to fetch
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_write_issuer_issuer_ref_acme_order_order_id_finalize_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pki_write_issuer_issuer_ref_acme_order_order_id_finalize test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_write_issuer_issuer_ref_acme_orders
  # @param issuer_ref Reference to an existing issuer name or issuer id
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_write_issuer_issuer_ref_acme_orders_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pki_write_issuer_issuer_ref_acme_orders test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_write_issuer_issuer_ref_acme_revoke_cert
  # @param issuer_ref Reference to an existing issuer name or issuer id
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_write_issuer_issuer_ref_acme_revoke_cert_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pki_write_issuer_issuer_ref_acme_revoke_cert test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_write_issuer_issuer_ref_roles_role_acme_account_kid
  # @param issuer_ref Reference to an existing issuer name or issuer id
  # @param kid The key identifier provided by the CA
  # @param role The desired role for the acme request
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_write_issuer_issuer_ref_roles_role_acme_account_kid_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pki_write_issuer_issuer_ref_roles_role_acme_account_kid test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_write_issuer_issuer_ref_roles_role_acme_authorization_auth_id
  # @param auth_id ACME authorization identifier value
  # @param issuer_ref Reference to an existing issuer name or issuer id
  # @param role The desired role for the acme request
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_write_issuer_issuer_ref_roles_role_acme_authorization_auth_id_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pki_write_issuer_issuer_ref_roles_role_acme_authorization_auth_id test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_write_issuer_issuer_ref_roles_role_acme_challenge_auth_id_challenge_type
  # @param auth_id ACME authorization identifier value
  # @param challenge_type ACME challenge type
  # @param issuer_ref Reference to an existing issuer name or issuer id
  # @param role The desired role for the acme request
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_write_issuer_issuer_ref_roles_role_acme_challenge_auth_id_challenge_type_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pki_write_issuer_issuer_ref_roles_role_acme_challenge_auth_id_challenge_type test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_write_issuer_issuer_ref_roles_role_acme_new_account
  # @param issuer_ref Reference to an existing issuer name or issuer id
  # @param role The desired role for the acme request
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_write_issuer_issuer_ref_roles_role_acme_new_account_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pki_write_issuer_issuer_ref_roles_role_acme_new_account test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_write_issuer_issuer_ref_roles_role_acme_new_order
  # @param issuer_ref Reference to an existing issuer name or issuer id
  # @param role The desired role for the acme request
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_write_issuer_issuer_ref_roles_role_acme_new_order_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pki_write_issuer_issuer_ref_roles_role_acme_new_order test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_write_issuer_issuer_ref_roles_role_acme_order_order_id
  # @param issuer_ref Reference to an existing issuer name or issuer id
  # @param order_id The ACME order identifier to fetch
  # @param role The desired role for the acme request
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pki_write_issuer_issuer_ref_roles_role_acme_order_order_id test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_cert
  # @param issuer_ref Reference to an existing issuer name or issuer id
  # @param order_id The ACME order identifier to fetch
  # @param role The desired role for the acme request
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_cert_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_cert test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_finalize
  # @param issuer_ref Reference to an existing issuer name or issuer id
  # @param order_id The ACME order identifier to fetch
  # @param role The desired role for the acme request
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_finalize_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pki_write_issuer_issuer_ref_roles_role_acme_order_order_id_finalize test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_write_issuer_issuer_ref_roles_role_acme_orders
  # @param issuer_ref Reference to an existing issuer name or issuer id
  # @param role The desired role for the acme request
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_write_issuer_issuer_ref_roles_role_acme_orders_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pki_write_issuer_issuer_ref_roles_role_acme_orders test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_write_issuer_issuer_ref_roles_role_acme_revoke_cert
  # @param issuer_ref Reference to an existing issuer name or issuer id
  # @param role The desired role for the acme request
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_write_issuer_issuer_ref_roles_role_acme_revoke_cert_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pki_write_issuer_issuer_ref_roles_role_acme_revoke_cert test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_write_key
  # @param key_ref Reference to key; either \&quot;default\&quot; for the configured default key, an identifier of a key, or the name assigned to the key.
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_write_key_request 
  # @param [Hash] opts the optional parameters
  # @return [PkiWriteKeyResponse]
  describe 'pki_write_key test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_write_role
  # @param name Name of the role
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_write_role_request 
  # @param [Hash] opts the optional parameters
  # @return [PkiWriteRoleResponse]
  describe 'pki_write_role test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_write_roles_role_acme_account_kid
  # @param kid The key identifier provided by the CA
  # @param role The desired role for the acme request
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_write_roles_role_acme_account_kid_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pki_write_roles_role_acme_account_kid test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_write_roles_role_acme_authorization_auth_id
  # @param auth_id ACME authorization identifier value
  # @param role The desired role for the acme request
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_write_roles_role_acme_authorization_auth_id_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pki_write_roles_role_acme_authorization_auth_id test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_write_roles_role_acme_challenge_auth_id_challenge_type
  # @param auth_id ACME authorization identifier value
  # @param challenge_type ACME challenge type
  # @param role The desired role for the acme request
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_write_roles_role_acme_challenge_auth_id_challenge_type_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pki_write_roles_role_acme_challenge_auth_id_challenge_type test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_write_roles_role_acme_new_account
  # @param role The desired role for the acme request
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_write_roles_role_acme_new_account_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pki_write_roles_role_acme_new_account test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_write_roles_role_acme_new_order
  # @param role The desired role for the acme request
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_write_roles_role_acme_new_order_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pki_write_roles_role_acme_new_order test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_write_roles_role_acme_order_order_id
  # @param order_id The ACME order identifier to fetch
  # @param role The desired role for the acme request
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_write_roles_role_acme_order_order_id_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pki_write_roles_role_acme_order_order_id test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_write_roles_role_acme_order_order_id_cert
  # @param order_id The ACME order identifier to fetch
  # @param role The desired role for the acme request
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_write_roles_role_acme_order_order_id_cert_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pki_write_roles_role_acme_order_order_id_cert test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_write_roles_role_acme_order_order_id_finalize
  # @param order_id The ACME order identifier to fetch
  # @param role The desired role for the acme request
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_write_roles_role_acme_order_order_id_finalize_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pki_write_roles_role_acme_order_order_id_finalize test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_write_roles_role_acme_orders
  # @param role The desired role for the acme request
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_write_roles_role_acme_orders_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pki_write_roles_role_acme_orders test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pki_write_roles_role_acme_revoke_cert
  # @param role The desired role for the acme request
  # @param pki_mount_path Path that the backend was mounted at
  # @param pki_write_roles_role_acme_revoke_cert_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pki_write_roles_role_acme_revoke_cert test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for rabbit_mq_configure_connection
  # Configure the connection URI, username, and password to talk to RabbitMQ management HTTP API.
  # @param rabbitmq_mount_path Path that the backend was mounted at
  # @param rabbit_mq_configure_connection_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'rabbit_mq_configure_connection test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for rabbit_mq_configure_lease
  # @param rabbitmq_mount_path Path that the backend was mounted at
  # @param rabbit_mq_configure_lease_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'rabbit_mq_configure_lease test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for rabbit_mq_delete_role
  # Manage the roles that can be created with this backend.
  # @param name Name of the role.
  # @param rabbitmq_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'rabbit_mq_delete_role test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for rabbit_mq_list_roles
  # Manage the roles that can be created with this backend.
  # @param rabbitmq_mount_path Path that the backend was mounted at
  # @param list Must be set to &#x60;true&#x60;
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'rabbit_mq_list_roles test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for rabbit_mq_read_lease_configuration
  # @param rabbitmq_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'rabbit_mq_read_lease_configuration test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for rabbit_mq_read_role
  # Manage the roles that can be created with this backend.
  # @param name Name of the role.
  # @param rabbitmq_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'rabbit_mq_read_role test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for rabbit_mq_request_credentials
  # Request RabbitMQ credentials for a certain role.
  # @param name Name of the role.
  # @param rabbitmq_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'rabbit_mq_request_credentials test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for rabbit_mq_write_role
  # Manage the roles that can be created with this backend.
  # @param name Name of the role.
  # @param rabbitmq_mount_path Path that the backend was mounted at
  # @param rabbit_mq_write_role_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'rabbit_mq_write_role test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for ssh_configure_ca
  # @param ssh_mount_path Path that the backend was mounted at
  # @param ssh_configure_ca_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'ssh_configure_ca test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for ssh_configure_zero_address
  # @param ssh_mount_path Path that the backend was mounted at
  # @param ssh_configure_zero_address_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'ssh_configure_zero_address test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for ssh_delete_ca_configuration
  # @param ssh_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'ssh_delete_ca_configuration test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for ssh_delete_role
  # Manage the &#39;roles&#39; that can be created with this backend.
  # @param role [Required for all types] Name of the role being created.
  # @param ssh_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'ssh_delete_role test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for ssh_delete_zero_address_configuration
  # @param ssh_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'ssh_delete_zero_address_configuration test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for ssh_generate_credentials
  # Creates a credential for establishing SSH connection with the remote host.
  # @param role [Required] Name of the role
  # @param ssh_mount_path Path that the backend was mounted at
  # @param ssh_generate_credentials_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'ssh_generate_credentials test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for ssh_issue_certificate
  # @param role The desired role with configuration for this request.
  # @param ssh_mount_path Path that the backend was mounted at
  # @param ssh_issue_certificate_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'ssh_issue_certificate test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for ssh_list_roles
  # Manage the &#39;roles&#39; that can be created with this backend.
  # @param ssh_mount_path Path that the backend was mounted at
  # @param list Must be set to &#x60;true&#x60;
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'ssh_list_roles test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for ssh_list_roles_by_ip
  # List all the roles associated with the given IP address.
  # @param ssh_mount_path Path that the backend was mounted at
  # @param ssh_list_roles_by_ip_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'ssh_list_roles_by_ip test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for ssh_read_ca_configuration
  # @param ssh_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'ssh_read_ca_configuration test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for ssh_read_public_key
  # Retrieve the public key.
  # @param ssh_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'ssh_read_public_key test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for ssh_read_role
  # Manage the &#39;roles&#39; that can be created with this backend.
  # @param role [Required for all types] Name of the role being created.
  # @param ssh_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'ssh_read_role test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for ssh_read_zero_address_configuration
  # @param ssh_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'ssh_read_zero_address_configuration test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for ssh_sign_certificate
  # Request signing an SSH key using a certain role with the provided details.
  # @param role The desired role with configuration for this request.
  # @param ssh_mount_path Path that the backend was mounted at
  # @param ssh_sign_certificate_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'ssh_sign_certificate test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for ssh_tidy_dynamic_host_keys
  # This endpoint removes the stored host keys used for the removed Dynamic Key feature, if present.
  # @param ssh_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'ssh_tidy_dynamic_host_keys test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for ssh_verify_otp
  # Validate the OTP provided by OpenBao SSH Agent.
  # @param ssh_mount_path Path that the backend was mounted at
  # @param ssh_verify_otp_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'ssh_verify_otp test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for ssh_write_role
  # Manage the &#39;roles&#39; that can be created with this backend.
  # @param role [Required for all types] Name of the role being created.
  # @param ssh_mount_path Path that the backend was mounted at
  # @param ssh_write_role_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'ssh_write_role test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for totp_create_key
  # @param name Name of the key.
  # @param totp_mount_path Path that the backend was mounted at
  # @param totp_create_key_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'totp_create_key test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for totp_delete_key
  # @param name Name of the key.
  # @param totp_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'totp_delete_key test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for totp_generate_code
  # @param name Name of the key.
  # @param totp_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'totp_generate_code test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for totp_list_keys
  # Manage the keys that can be created with this backend.
  # @param totp_mount_path Path that the backend was mounted at
  # @param list Must be set to &#x60;true&#x60;
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'totp_list_keys test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for totp_read_key
  # @param name Name of the key.
  # @param totp_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'totp_read_key test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for totp_validate_code
  # @param name Name of the key.
  # @param totp_mount_path Path that the backend was mounted at
  # @param totp_validate_code_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'totp_validate_code test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for transit_back_up_key
  # Backup the named key
  # @param name Name of the key
  # @param transit_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'transit_back_up_key test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for transit_byok_key
  # Securely export named encryption or signing key
  # @param destination Destination key to export to; usually the public wrapping key of another Transit instance.
  # @param source Source key to export; could be any present key within Transit.
  # @param transit_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'transit_byok_key test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for transit_byok_key_version
  # Securely export named encryption or signing key
  # @param destination Destination key to export to; usually the public wrapping key of another Transit instance.
  # @param source Source key to export; could be any present key within Transit.
  # @param version Optional version of the key to export, else all key versions are exported.
  # @param transit_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'transit_byok_key_version test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for transit_configure_cache
  # Configures a new cache of the specified size
  # @param transit_mount_path Path that the backend was mounted at
  # @param transit_configure_cache_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'transit_configure_cache test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for transit_configure_key
  # Configure a named encryption key
  # @param name Name of the key
  # @param transit_mount_path Path that the backend was mounted at
  # @param transit_configure_key_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'transit_configure_key test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for transit_configure_keys
  # @param transit_mount_path Path that the backend was mounted at
  # @param transit_configure_keys_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'transit_configure_keys test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for transit_create_key
  # @param name Name of the key
  # @param transit_mount_path Path that the backend was mounted at
  # @param transit_create_key_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'transit_create_key test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for transit_decrypt
  # Decrypt a ciphertext value using a named key
  # @param name Name of the key
  # @param transit_mount_path Path that the backend was mounted at
  # @param transit_decrypt_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'transit_decrypt test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for transit_delete_key
  # @param name Name of the key
  # @param transit_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'transit_delete_key test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for transit_encrypt
  # Encrypt a plaintext value or a batch of plaintext blocks using a named key
  # @param name Name of the key
  # @param transit_mount_path Path that the backend was mounted at
  # @param transit_encrypt_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'transit_encrypt test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for transit_export_key
  # Export named encryption or signing key
  # @param name Name of the key
  # @param type Type of key to export (encryption-key, signing-key, hmac-key, public-key)
  # @param transit_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'transit_export_key test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for transit_export_key_version
  # Export named encryption or signing key
  # @param name Name of the key
  # @param type Type of key to export (encryption-key, signing-key, hmac-key, public-key)
  # @param version Version of the key
  # @param transit_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'transit_export_key_version test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for transit_generate_data_key
  # Generate a data key
  # @param name The backend key used for encrypting the data key
  # @param plaintext \&quot;plaintext\&quot; will return the key in both plaintext and ciphertext; \&quot;wrapped\&quot; will return the ciphertext only.
  # @param transit_mount_path Path that the backend was mounted at
  # @param transit_generate_data_key_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'transit_generate_data_key test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for transit_generate_hmac
  # Generate an HMAC for input data using the named key
  # @param name The key to use for the HMAC function
  # @param transit_mount_path Path that the backend was mounted at
  # @param transit_generate_hmac_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'transit_generate_hmac test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for transit_generate_hmac_with_algorithm
  # Generate an HMAC for input data using the named key
  # @param name The key to use for the HMAC function
  # @param urlalgorithm Algorithm to use (POST URL parameter)
  # @param transit_mount_path Path that the backend was mounted at
  # @param transit_generate_hmac_with_algorithm_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'transit_generate_hmac_with_algorithm test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for transit_generate_random
  # Generate random bytes
  # @param transit_mount_path Path that the backend was mounted at
  # @param transit_generate_random_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'transit_generate_random test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for transit_generate_random_with_bytes
  # Generate random bytes
  # @param urlbytes The number of bytes to generate (POST URL parameter)
  # @param transit_mount_path Path that the backend was mounted at
  # @param transit_generate_random_with_bytes_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'transit_generate_random_with_bytes test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for transit_generate_random_with_source
  # Generate random bytes
  # @param source Which system to source random data from, ether \&quot;platform\&quot;, \&quot;seal\&quot;, or \&quot;all\&quot;.
  # @param transit_mount_path Path that the backend was mounted at
  # @param transit_generate_random_with_source_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'transit_generate_random_with_source test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for transit_generate_random_with_source_and_bytes
  # Generate random bytes
  # @param source Which system to source random data from, ether \&quot;platform\&quot;, \&quot;seal\&quot;, or \&quot;all\&quot;.
  # @param urlbytes The number of bytes to generate (POST URL parameter)
  # @param transit_mount_path Path that the backend was mounted at
  # @param transit_generate_random_with_source_and_bytes_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'transit_generate_random_with_source_and_bytes test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for transit_hash
  # Generate a hash sum for input data
  # @param transit_mount_path Path that the backend was mounted at
  # @param transit_hash_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'transit_hash test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for transit_hash_with_algorithm
  # Generate a hash sum for input data
  # @param urlalgorithm Algorithm to use (POST URL parameter)
  # @param transit_mount_path Path that the backend was mounted at
  # @param transit_hash_with_algorithm_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'transit_hash_with_algorithm test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for transit_import_key
  # Imports an externally-generated key into a new transit key
  # @param name The name of the key
  # @param transit_mount_path Path that the backend was mounted at
  # @param transit_import_key_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'transit_import_key test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for transit_import_key_version
  # Imports an externally-generated key into an existing imported key
  # @param name The name of the key
  # @param transit_mount_path Path that the backend was mounted at
  # @param transit_import_key_version_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'transit_import_key_version test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for transit_list_keys
  # Managed named encryption keys
  # @param transit_mount_path Path that the backend was mounted at
  # @param list Must be set to &#x60;true&#x60;
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'transit_list_keys test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for transit_read_cache_configuration
  # Returns the size of the active cache
  # @param transit_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'transit_read_cache_configuration test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for transit_read_key
  # @param name Name of the key
  # @param transit_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'transit_read_key test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for transit_read_keys_configuration
  # @param transit_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'transit_read_keys_configuration test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for transit_read_wrapping_key
  # Returns the public key to use for wrapping imported keys
  # @param transit_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'transit_read_wrapping_key test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for transit_restore_and_rename_key
  # Restore the named key
  # @param name If set, this will be the name of the restored key.
  # @param transit_mount_path Path that the backend was mounted at
  # @param transit_restore_and_rename_key_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'transit_restore_and_rename_key test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for transit_restore_key
  # Restore the named key
  # @param transit_mount_path Path that the backend was mounted at
  # @param transit_restore_key_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'transit_restore_key test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for transit_rewrap
  # Rewrap ciphertext
  # @param name Name of the key
  # @param transit_mount_path Path that the backend was mounted at
  # @param transit_rewrap_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'transit_rewrap test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for transit_rotate_key
  # Rotate named encryption key
  # @param name Name of the key
  # @param transit_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'transit_rotate_key test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for transit_sign
  # Generate a signature for input data using the named key
  # @param name The key to use
  # @param transit_mount_path Path that the backend was mounted at
  # @param transit_sign_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'transit_sign test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for transit_sign_with_algorithm
  # Generate a signature for input data using the named key
  # @param name The key to use
  # @param urlalgorithm Hash algorithm to use (POST URL parameter)
  # @param transit_mount_path Path that the backend was mounted at
  # @param transit_sign_with_algorithm_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'transit_sign_with_algorithm test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for transit_soft_delete_key
  # @param name Name of the key
  # @param transit_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'transit_soft_delete_key test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for transit_soft_delete_restore_key
  # @param name Name of the key
  # @param transit_mount_path Path that the backend was mounted at
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'transit_soft_delete_restore_key test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for transit_trim_key
  # Trim key versions of a named key
  # @param name Name of the key
  # @param transit_mount_path Path that the backend was mounted at
  # @param transit_trim_key_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'transit_trim_key test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for transit_verify
  # Verify a signature or HMAC for input data created using the named key
  # @param name The key to use
  # @param transit_mount_path Path that the backend was mounted at
  # @param transit_verify_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'transit_verify test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for transit_verify_with_algorithm
  # Verify a signature or HMAC for input data created using the named key
  # @param name The key to use
  # @param urlalgorithm Hash algorithm to use (POST URL parameter)
  # @param transit_mount_path Path that the backend was mounted at
  # @param transit_verify_with_algorithm_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'transit_verify_with_algorithm test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

end
