---
page_type: sample
languages:
  - python
products:
  - azure
  - azure-maps-weather
---

# Samples for Azure Maps Weather client library for Python

These code samples show common scenario operations with the Azure Maps Weather client library.

Authenticate the client with Azure Maps Weather [API Key Credential](https://learn.microsoft.com/azure/azure-maps/how-to-manage-account-keys):

Then for common Azure Maps Weather operations:

* Get air quality daily forecasts: [get_air_quality_daily_forecasts.py](https://github.com/Azure/azure-sdk-for-python/blob/main/sdk/maps/azure-maps-weather/samples/get_air_quality_daily_forecasts.py) ([async version](https://github.com/Azure/azure-sdk-for-python/blob/main/sdk/maps/azure-maps-weather/samples/async_samples/get_air_quality_daily_forecasts_async.py))

* Get air quality hourly forecasts: [get_air_quality_hourly_forecasts.py](https://github.com/Azure/azure-sdk-for-python/blob/main/sdk/maps/azure-maps-weather/samples/get_air_quality_hourly_forecasts.py) ([async version](https://github.com/Azure/azure-sdk-for-python/blob/main/sdk/maps/azure-maps-weather/samples/async_samples/get_air_quality_hourly_forecasts_async.py))

* Get current air quality: [get_current_air_quality.py](https://github.com/Azure/azure-sdk-for-python/blob/main/sdk/maps/azure-maps-weather/samples/get_current_air_quality.py) ([async version](https://github.com/Azure/azure-sdk-for-python/blob/main/sdk/maps/azure-maps-weather/samples/async_samples/get_current_air_quality_async.py))

* Get current conditions: [get_current_conditions.py](https://github.com/Azure/azure-sdk-for-python/blob/main/sdk/maps/azure-maps-weather/samples/get_current_conditions.py) ([async version](https://github.com/Azure/azure-sdk-for-python/blob/main/sdk/maps/azure-maps-weather/samples/async_samples/get_current_conditions_async.py))

* Get daily forecast: [get_daily_forecast.py](https://github.com/Azure/azure-sdk-for-python/blob/main/sdk/maps/azure-maps-weather/samples/get_daily_forecast.py) ([async version](https://github.com/Azure/azure-sdk-for-python/blob/main/sdk/maps/azure-maps-weather/samples/async_samples/get_daily_forecast_async.py))

* Get daily historical actuals: [get_daily_historical_actuals.py](https://github.com/Azure/azure-sdk-for-python/blob/main/sdk/maps/azure-maps-weather/samples/get_daily_historical_actuals.py) ([async version](https://github.com/Azure/azure-sdk-for-python/blob/main/sdk/maps/azure-maps-weather/samples/async_samples/get_daily_historical_actuals_async.py))

* Get daily historical normals: [get_daily_historical_normals.py](https://github.com/Azure/azure-sdk-for-python/blob/main/sdk/maps/azure-maps-weather/samples/get_daily_historical_normals.py) ([async version](https://github.com/Azure/azure-sdk-for-python/blob/main/sdk/maps/azure-maps-weather/samples/async_samples/get_daily_historical_normals_async.py))

* Get daily historical records: [get_daily_historical_records.py](https://github.com/Azure/azure-sdk-for-python/blob/main/sdk/maps/azure-maps-weather/samples/get_daily_historical_records.py) ([async version](https://github.com/Azure/azure-sdk-for-python/blob/main/sdk/maps/azure-maps-weather/samples/async_samples/get_daily_historical_records_async.py))

* Get daily indices: [get_daily_indices.py](https://github.com/Azure/azure-sdk-for-python/blob/main/sdk/maps/azure-maps-weather/samples/get_daily_indices.py) ([async version](https://github.com/Azure/azure-sdk-for-python/blob/main/sdk/maps/azure-maps-weather/samples/async_samples/get_daily_indices_async.py))

* Get hourly forecast: [get_hourly_forecast.py](https://github.com/Azure/azure-sdk-for-python/blob/main/sdk/maps/azure-maps-weather/samples/get_hourly_forecast.py) ([async version](https://github.com/Azure/azure-sdk-for-python/blob/main/sdk/maps/azure-maps-weather/samples/async_samples/get_hourly_forecast_async.py))

* Get minute forecast: [get_minute_forecast.py](https://github.com/Azure/azure-sdk-for-python/blob/main/sdk/maps/azure-maps-weather/samples/get_minute_forecast.py) ([async version](https://github.com/Azure/azure-sdk-for-python/blob/main/sdk/maps/azure-maps-weather/samples/async_samples/get_minute_forecast_async.py))

* Get quarter day forecast: [get_quarter_day_forecast.py](https://github.com/Azure/azure-sdk-for-python/blob/main/sdk/maps/azure-maps-weather/samples/get_quarter_day_forecast.py) ([async version](https://github.com/Azure/azure-sdk-for-python/blob/main/sdk/maps/azure-maps-weather/samples/async_samples/get_quarter_day_forecast_async.py))

* Get severe weather alerts: [get_severe_weather_alerts.py](https://github.com/Azure/azure-sdk-for-python/blob/main/sdk/maps/azure-maps-weather/samples/get_severe_weather_alerts.py) ([async version](https://github.com/Azure/azure-sdk-for-python/blob/main/sdk/maps/azure-maps-weather/samples/async_samples/get_severe_weather_alerts_async.py))

* Get tropical storm active: [get_tropical_storm_active.py](https://github.com/Azure/azure-sdk-for-python/blob/main/sdk/maps/azure-maps-weather/samples/get_tropical_storm_active.py) ([async version](https://github.com/Azure/azure-sdk-for-python/blob/main/sdk/maps/azure-maps-weather/samples/async_samples/get_tropical_storm_active_async.py))

* Get tropical storm forecast: [get_tropical_storm_forecast.py](https://github.com/Azure/azure-sdk-for-python/blob/main/sdk/maps/azure-maps-weather/samples/get_tropical_storm_forecast.py) ([async version](https://github.com/Azure/azure-sdk-for-python/blob/main/sdk/maps/azure-maps-weather/samples/async_samples/get_tropical_storm_forecast_async.py))

* Get tropical storm locations: [get_tropical_storm_locations.py](https://github.com/Azure/azure-sdk-for-python/blob/main/sdk/maps/azure-maps-weather/samples/get_tropical_storm_locations.py) ([async version](https://github.com/Azure/azure-sdk-for-python/blob/main/sdk/maps/azure-maps-weather/samples/async_samples/get_tropical_storm_locations_async.py))

* Get tropical storm search: [get_tropical_storm_search.py](https://github.com/Azure/azure-sdk-for-python/blob/main/sdk/maps/azure-maps-weather/samples/get_tropical_storm_search.py) ([async version](https://github.com/Azure/azure-sdk-for-python/blob/main/sdk/maps/azure-maps-weather/samples/async_samples/get_tropical_storm_search_async.py))

* Get weather along route: [get_weather_along_route.py](https://github.com/Azure/azure-sdk-for-python/blob/main/sdk/maps/azure-maps-weather/samples/get_weather_along_route.py) ([async version](https://github.com/Azure/azure-sdk-for-python/blob/main/sdk/maps/azure-maps-weather/samples/async_samples/get_weather_along_route_async.py))

## Prerequisites

* Python 3.8 or later is required to use this package
* You must have an [Azure subscription](https://azure.microsoft.com/free/)
* A deployed Maps Services resource. You can create the resource via [Azure Portal][azure_portal] or [Azure CLI][azure_cli].

## Setup

1. Install the Azure Maps Weather client library for Python with [pip](https://pypi.org/project/pip/):

   ```bash
   pip install azure-maps-weather --pre
   ```

2. Clone or download [this repository](https://github.com/Azure/azure-sdk-for-python)
3. Open this sample folder in [Visual Studio Code](https://code.visualstudio.com) or your IDE of choice.

## Running the samples

1. Open a terminal window and `cd` to the directory that the samples are saved in.
2. Set the environment variables specified in the sample file you wish to run.
3. Follow the usage described in the file, e.g. `python get_daily_forecast.py`

## Next steps

Check out the [API reference documentation](https://learn.microsoft.com/rest/api/maps/weather)
to learn more about what you can do with the Azure Maps Weather client library.

<!-- LINKS -->
[azure_portal]: https://portal.azure.com
[azure_cli]: https://learn.microsoft.com/cli/azure
