package coremodules

import (
	"fmt"
	"io/ioutil"

	"github.com/heysion/deepin-system-update-tools/internal/controller/fixpkg"
	"github.com/heysion/deepin-system-update-tools/pkg/log"
	"github.com/heysion/deepin-system-update-tools/pkg/utils/ecode"
	"github.com/heysion/deepin-system-update-tools/pkg/utils/fs"
	"github.com/spf13/cobra"
)

// versionCmd represents the version command
var fixConfig bool

var fixPkg = &cobra.Command{
	Use:   "fix",
	Short: "Check system update",
	Long:  `Check system update with rules that pre/mid/post-check.`,
	Run: func(cmd *cobra.Command, args []string) {
		// log.Debugf("check")
		// log.Debugf("config:%s", ConfigCfg)
		if fixConfig {
			fixConfigOut, err2 := ioutil.TempFile("/tmp/", "fixout_")
			if err2 != nil {
				//return fmt.Errorf("fix/out create output %v", err2)
				CheckRetMsg.SetErrorExtMsg(ecode.CHK_INVALID_INPUT, ecode.SYS_INTERNAL_ERROR, fmt.Sprintf("fix/out init output %v", err2))
				return
			}
			if err := fixpkg.FixConfig(fixConfigOut.Name()); err != nil {
				log.Errorf("fix/cfg error: %v", err)
				if err := fs.CheckFileExistState(fixConfigOut.Name()); err != nil {
					CheckRetMsg.LogPath = append(CheckRetMsg.LogPath, fixConfigOut.Name())
				}
				CheckRetMsg.SetErrorExtMsg(ecode.CHK_ERROR, ecode.PKG_FIX_FAILED, fmt.Sprintf("fix/cfg error: %v", err))
				return
			} else {
				log.Debugf("have not found error")
				return
			}
		} else {
			if err := fixpkg.CheckDpkgListStat(); err != nil {
				CheckRetMsg.SetErrorExtMsg(ecode.CHK_ERROR, ecode.SYS_INTERNAL_ERROR, fmt.Sprintf("fix dpkg state: %v", err))
			}
		}
	},
}

func init() {
	rootCmd.AddCommand(fixPkg)
	fixPkg.Flags().BoolVarP(&fixConfig, "fix-config", "", false, "fix package configure")
}
