/*
 * Copyright (c) 1991, 1992 Paul Kranenburg <pk@cs.few.eur.nl>
 * Copyright (c) 1993 Branko Lankester <branko@hacktic.nl>
 * Copyright (c) 1993 Ulrich Pegelow <pegelow@moorea.uni-muenster.de>
 * Copyright (c) 1995, 1996 Michael Elizabeth Chastain <mec@duracef.shout.net>
 * Copyright (c) 1993, 1994, 1995, 1996 Rick Sladkey <jrs@world.std.com>
 * Copyright (C) 1998-2001 Wichert Akkerman <wakkerma@deephackmode.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
/* For an N64 strace decode the N64 64-bit syscalls., base is 5000 */
[  0] = { 3,	TD,		SEN(read),			"read"			}, /* start of Linux N64 */
[  1] = { 3,	TD,		SEN(write),			"write"			},
[  2] = { 3,	TD|TF,		SEN(open),			"open"			},
[  3] = { 1,	TD,		SEN(close),			"close"			},
[  4] = { 2,	TF,		SEN(stat),			"stat"			},
[  5] = { 2,	TD,		SEN(fstat),			"fstat"			},
[  6] = { 2,	TF,		SEN(lstat),			"lstat"			},
[  7] = { 3,	TD,		SEN(poll),			"poll"			},
[  8] = { 3,	TD,		SEN(lseek),			"lseek"			},
[  9] = { 6,	TD|TM|SI,	SEN(mmap),			"mmap"			},
[ 10] = { 3,	TM|SI,		SEN(mprotect),			"mprotect"		},
[ 11] = { 2,	TM|SI,		SEN(munmap),			"munmap"		},
[ 12] = { 1,	TM|SI,		SEN(brk),			"brk"			},
[ 13] = { 4,	TS,		SEN(rt_sigaction),		"rt_sigaction"		},
[ 14] = { 4,	TS,		SEN(rt_sigprocmask),		"rt_sigprocmask"	},
[ 15] = { 3,	TD,		SEN(ioctl),			"ioctl"			},
[ 16] = { 4,	TD,		SEN(pread),			"pread64"		},
[ 17] = { 4,	TD,		SEN(pwrite),			"pwrite64"		},
[ 18] = { 3,	TD,		SEN(readv),			"readv"			},
[ 19] = { 3,	TD,		SEN(writev),			"writev"		},
[ 20] = { 2,	TF,		SEN(access),			"access"		},
[ 21] = { 0,	TD,		SEN(pipe),			"pipe"			},
[ 22] = { 5,	TD,		SEN(select),			"_newselect"		},
[ 23] = { 0,	0,		SEN(sched_yield),		"sched_yield"		},
[ 24] = { 5,	TM|SI,		SEN(mremap),			"mremap"		},
[ 25] = { 3,	TM,		SEN(msync),			"msync"			},
[ 26] = { 3,	TM,		SEN(mincore),			"mincore"		},
[ 27] = { 3,	TM,		SEN(madvise),			"madvise"		},
[ 28] = { 3,	TI,		SEN(shmget),			"shmget"		},
[ 29] = { 3,	TI|TM|SI,	SEN(shmat),			"shmat"			},
[ 30] = { 3,	TI,		SEN(shmctl),			"shmctl"		},
[ 31] = { 1,	TD,		SEN(dup),			"dup"			},
[ 32] = { 2,	TD,		SEN(dup2),			"dup2"			},
[ 33] = { 0,	TS,		SEN(pause),			"pause"			},
[ 34] = { 2,	0,		SEN(nanosleep),			"nanosleep"		},
[ 35] = { 2,	0,		SEN(getitimer),			"getitimer"		},
[ 36] = { 3,	0,		SEN(setitimer),			"setitimer"		},
[ 37] = { 1,	0,		SEN(alarm),			"alarm"			},
[ 38] = { 0,	NF,		SEN(getpid),			"getpid"		},
[ 39] = { 4,	TD|TN,		SEN(sendfile),			"sendfile"		},
[ 40] = { 3,	TN,		SEN(socket),			"socket"		},
[ 41] = { 3,	TN,		SEN(connect),			"connect"		},
[ 42] = { 3,	TN,		SEN(accept),			"accept"		},
[ 43] = { 6,	TN,		SEN(sendto),			"sendto"		},
[ 44] = { 6,	TN,		SEN(recvfrom),			"recvfrom"		},
[ 45] = { 3,	TN,		SEN(sendmsg),			"sendmsg"		},
[ 46] = { 3,	TN,		SEN(recvmsg),			"recvmsg"		},
[ 47] = { 2,	TN,		SEN(shutdown),			"shutdown"		},
[ 48] = { 3,	TN,		SEN(bind),			"bind"			},
[ 49] = { 2,	TN,		SEN(listen),			"listen"		},
[ 50] = { 3,	TN,		SEN(getsockname),		"getsockname"		},
[ 51] = { 3,	TN,		SEN(getpeername),		"getpeername"		},
[ 52] = { 4,	TN,		SEN(socketpair),		"socketpair"		},
[ 53] = { 5,	TN,		SEN(setsockopt),		"setsockopt"		},
[ 54] = { 5,	TN,		SEN(getsockopt),		"getsockopt"		},
[ 55] = { 5,	TP,		SEN(clone),			"clone"			},
[ 56] = { 0,	TP,		SEN(fork),			"fork"			},
[ 57] = { 3,	TF|TP|SE|SI,	SEN(execve),			"execve"		},
[ 58] = { 1,	TP|SE,		SEN(exit),			"exit"			},
[ 59] = { 4,	TP,		SEN(wait4),			"wait4"			},
[ 60] = { 2,	TS,		SEN(kill),			"kill"			},
[ 61] = { 1,	0,		SEN(uname),			"uname"			},
[ 62] = { 3,	TI,		SEN(semget),			"semget"		},
[ 63] = { 3,	TI,		SEN(semop),			"semop"			},
[ 64] = { 4,	TI,		SEN(semctl),			"semctl"		},
[ 65] = { 1,	TI|TM|SI,	SEN(shmdt),			"shmdt"			},
[ 66] = { 2,	TI,		SEN(msgget),			"msgget"		},
[ 67] = { 4,	TI,		SEN(msgsnd),			"msgsnd"		},
[ 68] = { 5,	TI,		SEN(msgrcv),			"msgrcv"		},
[ 69] = { 3,	TI,		SEN(msgctl),			"msgctl"		},
[ 70] = { 3,	TD,		SEN(fcntl),			"fcntl"			},
[ 71] = { 2,	TD,		SEN(flock),			"flock"			},
[ 72] = { 1,	TD,		SEN(fsync),			"fsync"			},
[ 73] = { 1,	TD,		SEN(fdatasync),			"fdatasync"		},
[ 74] = { 2,	TF,		SEN(truncate),			"truncate"		},
[ 75] = { 2,	TD,		SEN(ftruncate),			"ftruncate"		},
[ 76] = { 3,	TD,		SEN(getdents),			"getdents"		},
[ 77] = { 2,	TF,		SEN(getcwd),			"getcwd"		},
[ 78] = { 1,	TF,		SEN(chdir),			"chdir"			},
[ 79] = { 1,	TD,		SEN(fchdir),			"fchdir"		},
[ 80] = { 2,	TF,		SEN(rename),			"rename"		},
[ 81] = { 2,	TF,		SEN(mkdir),			"mkdir"			},
[ 82] = { 1,	TF,		SEN(rmdir),			"rmdir"			},
[ 83] = { 2,	TD|TF,		SEN(creat),			"creat"			},
[ 84] = { 2,	TF,		SEN(link),			"link"			},
[ 85] = { 1,	TF,		SEN(unlink),			"unlink"		},
[ 86] = { 2,	TF,		SEN(symlink),			"symlink"		},
[ 87] = { 3,	TF,		SEN(readlink),			"readlink"		},
[ 88] = { 2,	TF,		SEN(chmod),			"chmod"			},
[ 89] = { 2,	TD,		SEN(fchmod),			"fchmod"		},
[ 90] = { 3,	TF,		SEN(chown),			"chown"			},
[ 91] = { 3,	TD,		SEN(fchown),			"fchown"		},
[ 92] = { 3,	TF,		SEN(chown),			"lchown"		},
[ 93] = { 1,	NF,		SEN(umask),			"umask"			},
[ 94] = { 2,	0,		SEN(gettimeofday),		"gettimeofday"		},
[ 95] = { 2,	0,		SEN(getrlimit),			"getrlimit"		},
[ 96] = { 2,	0,		SEN(getrusage),			"getrusage"		},
[ 97] = { 1,	0,		SEN(sysinfo),			"sysinfo"		},
[ 98] = { 1,	0,		SEN(times),			"times"			},
[ 99] = { 4,	0,		SEN(ptrace),			"ptrace"		},
[100] = { 0,	NF,		SEN(getuid),			"getuid"		},
[101] = { 3,	0,		SEN(syslog),			"syslog"		},
[102] = { 0,	NF,		SEN(getgid),			"getgid"		},
[103] = { 1,	0,		SEN(setuid),			"setuid"		},
[104] = { 1,	0,		SEN(setgid),			"setgid"		},
[105] = { 0,	NF,		SEN(geteuid),			"geteuid"		},
[106] = { 0,	NF,		SEN(getegid),			"getegid"		},
[107] = { 2,	0,		SEN(setpgid),			"setpgid"		},
[108] = { 0,	NF,		SEN(getppid),			"getppid"		},
[109] = { 0,	0,		SEN(getpgrp),			"getpgrp"		},
[110] = { 0,	0,		SEN(setsid),			"setsid"		},
[111] = { 2,	0,		SEN(setreuid),			"setreuid"		},
[112] = { 2,	0,		SEN(setregid),			"setregid"		},
[113] = { 2,	0,		SEN(getgroups),			"getgroups"		},
[114] = { 2,	0,		SEN(setgroups),			"setgroups"		},
[115] = { 3,	0,		SEN(setresuid),			"setresuid"		},
[116] = { 3,	0,		SEN(getresuid),			"getresuid"		},
[117] = { 3,	0,		SEN(setresgid),			"setresgid"		},
[118] = { 3,	0,		SEN(getresgid),			"getresgid"		},
[119] = { 1,	0,		SEN(getpgid),			"getpgid"		},
[120] = { 1,	NF,		SEN(setfsuid),			"setfsuid"		},
[121] = { 1,	NF,		SEN(setfsgid),			"setfsgid"		},
[122] = { 1,	0,		SEN(getsid),			"getsid"		},
[123] = { 2,	0,		SEN(capget),			"capget"		},
[124] = { 2,	0,		SEN(capset),			"capset"		},
[125] = { 2,	TS,		SEN(rt_sigpending),		"rt_sigpending"		},
[126] = { 4,	TS,		SEN(rt_sigtimedwait),		"rt_sigtimedwait"	},
[127] = { 3,	TS,		SEN(rt_sigqueueinfo),		"rt_sigqueueinfo"	},
[128] = { 2,	TS,		SEN(rt_sigsuspend),		"rt_sigsuspend"		},
[129] = { 2,	TS,		SEN(sigaltstack),		"sigaltstack"		},
[130] = { 2,	TF,		SEN(utime),			"utime"			},
[131] = { 3,	TF,		SEN(mknod),			"mknod"			},
[132] = { 1,	NF,		SEN(personality),		"personality"		},
[133] = { 2,	0,		SEN(ustat),			"ustat"			},
[134] = { 2,	TF,		SEN(statfs),			"statfs"		},
[135] = { 2,	TD,		SEN(fstatfs),			"fstatfs"		},
[136] = { 3,	0,		SEN(sysfs),			"sysfs"			},
[137] = { 2,	0,		SEN(getpriority),		"getpriority"		},
[138] = { 3,	0,		SEN(setpriority),		"setpriority"		},
[139] = { 2,	0,		SEN(sched_setparam),		"sched_setparam"	},
[140] = { 2,	0,		SEN(sched_getparam),		"sched_getparam"	},
[141] = { 3,	0,		SEN(sched_setscheduler),	"sched_setscheduler"	},
[142] = { 1,	0,		SEN(sched_getscheduler),	"sched_getscheduler"	},
[143] = { 1,	0,		SEN(sched_get_priority_max),	"sched_get_priority_max"},
[144] = { 1,	0,		SEN(sched_get_priority_min),	"sched_get_priority_min"},
[145] = { 2,	0,		SEN(sched_rr_get_interval),	"sched_rr_get_interval"	},
[146] = { 2,	TM,		SEN(mlock),			"mlock"			},
[147] = { 2,	TM,		SEN(munlock),			"munlock"		},
[148] = { 1,	TM,		SEN(mlockall),			"mlockall"		},
[149] = { 0,	TM,		SEN(munlockall),		"munlockall"		},
[150] = { 0,	0,		SEN(vhangup),			"vhangup"		},
[151] = { 2,	TF,		SEN(pivotroot),			"pivot_root"		},
[152] = { 1,	0,		SEN(sysctl),			"_sysctl"		},
[153] = { 5,	0,		SEN(prctl),			"prctl"			},
[154] = { 1,	0,		SEN(adjtimex),			"adjtimex"		},
[155] = { 2,	0,		SEN(setrlimit),			"setrlimit"		},
[156] = { 1,	TF,		SEN(chroot),			"chroot"		},
[157] = { 0,	0,		SEN(sync),			"sync"			},
[158] = { 1,	TF,		SEN(acct),			"acct"			},
[159] = { 2,	0,		SEN(settimeofday),		"settimeofday"		},
[160] = { 5,	TF,		SEN(mount),			"mount"			},
[161] = { 2,	TF,		SEN(umount2),			"umount2"		},
[162] = { 2,	TF,		SEN(swapon),			"swapon"		},
[163] = { 1,	TF,		SEN(swapoff),			"swapoff"		},
[164] = { 4,	0,		SEN(reboot),			"reboot"		},
[165] = { 2,	0,		SEN(sethostname),		"sethostname"		},
[166] = { 2,	0,		SEN(setdomainname),		"setdomainname"		},
[167] = { 2,	0,		SEN(create_module),		"create_module"		},
[168] = { 3,	0,		SEN(init_module),		"init_module"		},
[169] = { 2,	0,		SEN(delete_module),		"delete_module"		},
[170] = { 1,	0,		SEN(get_kernel_syms),		"get_kernel_syms"	},
[171] = { 5,	0,		SEN(query_module),		"query_module"		},
[172] = { 4,	TF,		SEN(quotactl),			"quotactl"		},
[173] = { 3,	0,		SEN(nfsservctl),		"nfsservctl"		},
[174] = { 5,	TN,		SEN(getpmsg),			"getpmsg"		},
[175] = { 5,	TN,		SEN(putpmsg),			"putpmsg"		},
[176] = { 0,	0,		SEN(afs_syscall),		"afs_syscall"		},
[177] = { 0,	0,		SEN(printargs),			"reserved177"		},
[178] = { 0,	NF,		SEN(gettid),			"gettid"		},
[179] = { 3,	TD,		SEN(readahead),			"readahead"		},
[180] = { 5,	TF,		SEN(setxattr),			"setxattr"		},
[181] = { 5,	TF,		SEN(setxattr),			"lsetxattr"		},
[182] = { 5,	TD,		SEN(fsetxattr),			"fsetxattr"		},
[183] = { 4,	TF,		SEN(getxattr),			"getxattr"		},
[184] = { 4,	TF,		SEN(getxattr),			"lgetxattr"		},
[185] = { 4,	TD,		SEN(fgetxattr),			"fgetxattr"		},
[186] = { 3,	TF,		SEN(listxattr),			"listxattr"		},
[187] = { 3,	TF,		SEN(listxattr),			"llistxattr"		},
[188] = { 3,	TD,		SEN(flistxattr),		"flistxattr"		},
[189] = { 2,	TF,		SEN(removexattr),		"removexattr"		},
[190] = { 2,	TF,		SEN(removexattr),		"lremovexattr"		},
[191] = { 2,	TD,		SEN(fremovexattr),		"fremovexattr"		},
[192] = { 2,	TS,		SEN(kill),			"tkill"			},
[193] = { 1,	0,		SEN(time),			"time"			},
[194] = { 6,	0,		SEN(futex),			"futex"			},
[195] = { 3,	0,		SEN(sched_setaffinity),		"sched_setaffinity"	},
[196] = { 3,	0,		SEN(sched_getaffinity),		"sched_getaffinity"	},
[197] = { 3,	0,		SEN(printargs),			"cacheflush"		},
[198] = { 3,	0,		SEN(printargs),			"cachectl"		},
[199] = { 4,	0,		SEN(sysmips),			"sysmips"		},
[200] = { 2,	TM,		SEN(io_setup),			"io_setup"		},
[201] = { 1,	TM,		SEN(io_destroy),		"io_destroy"		},
[202] = { 5,	0,		SEN(io_getevents),		"io_getevents"		},
[203] = { 3,	0,		SEN(io_submit),			"io_submit"		},
[204] = { 3,	0,		SEN(io_cancel),			"io_cancel"		},
[205] = { 1,	TP|SE,		SEN(exit),			"exit_group"		},
[206] = { 3,	0,		SEN(lookup_dcookie),		"lookup_dcookie"	},
[207] = { 1,	TD,		SEN(epoll_create),		"epoll_create"		},
[208] = { 4,	TD,		SEN(epoll_ctl),			"epoll_ctl"		},
[209] = { 4,	TD,		SEN(epoll_wait),		"epoll_wait"		},
[210] = { 5,	TM|SI,		SEN(remap_file_pages),		"remap_file_pages"	},
[211] = { 0,	TS,		SEN(rt_sigreturn),		"rt_sigreturn"		},
[212] = { 1,	0,		SEN(set_tid_address),		"set_tid_address"	},
[213] = { 0,	0,		SEN(restart_syscall),		"restart_syscall"	},
[214] = { 4,	TI,		SEN(semtimedop),		"semtimedop"		},
[215] = { 4,	TD,		SEN(fadvise64),			"fadvise64"		},
[216] = { 3,	0,		SEN(timer_create),		"timer_create"		},
[217] = { 4,	0,		SEN(timer_settime),		"timer_settime"		},
[218] = { 2,	0,		SEN(timer_gettime),		"timer_gettime"		},
[219] = { 1,	0,		SEN(timer_getoverrun),		"timer_getoverrun"	},
[220] = { 1,	0,		SEN(timer_delete),		"timer_delete"		},
[221] = { 2,	0,		SEN(clock_settime),		"clock_settime"		},
[222] = { 2,	0,		SEN(clock_gettime),		"clock_gettime"		},
[223] = { 2,	0,		SEN(clock_getres),		"clock_getres"		},
[224] = { 4,	0,		SEN(clock_nanosleep),		"clock_nanosleep"	},
[225] = { 3,	TS,		SEN(tgkill),			"tgkill"		},
[226] = { 2,	TF,		SEN(utimes),			"utimes"		},
[227] = { 6,	TM,		SEN(mbind),			"mbind"			},
[228] = { 5,	TM,		SEN(get_mempolicy),		"get_mempolicy"		},
[229] = { 3,	TM,		SEN(set_mempolicy),		"set_mempolicy"		},
[230] = { 4,	0,		SEN(mq_open),			"mq_open"		},
[231] = { 1,	0,		SEN(mq_unlink),			"mq_unlink"		},
[232] = { 5,	0,		SEN(mq_timedsend),		"mq_timedsend"		},
[233] = { 5,	0,		SEN(mq_timedreceive),		"mq_timedreceive"	},
[234] = { 2,	0,		SEN(mq_notify),			"mq_notify"		},
[235] = { 3,	0,		SEN(mq_getsetattr),		"mq_getsetattr"		},
[236] = { 5,	0,		SEN(vserver),			"vserver"		},
[237] = { 5,	TP,		SEN(waitid),			"waitid"		},
[238] = { },
[239] = { 5,	0,		SEN(add_key),			"add_key"		},
[240] = { 4,	0,		SEN(request_key),		"request_key"		},
[241] = { 5,	0,		SEN(keyctl),			"keyctl"		},
[242] = { 1,	0,		SEN(set_thread_area),		"set_thread_area"	},
[243] = { 0,	TD,		SEN(inotify_init),		"inotify_init"		},
[244] = { 3,	TD,		SEN(inotify_add_watch),		"inotify_add_watch"	},
[245] = { 2,	TD,		SEN(inotify_rm_watch),		"inotify_rm_watch"	},
[246] = { 4,	TM,		SEN(migrate_pages),		"migrate_pages"		},
[247] = { 4,	TD|TF,		SEN(openat),			"openat"		},
[248] = { 3,	TD|TF,		SEN(mkdirat),			"mkdirat"		},
[249] = { 4,	TD|TF,		SEN(mknodat),			"mknodat"		},
[250] = { 5,	TD|TF,		SEN(fchownat),			"fchownat"		},
[251] = { 3,	TD|TF,		SEN(futimesat),			"futimesat"		},
[252] = { 4,	TD|TF,		SEN(newfstatat),		"newfstatat"		},
[253] = { 3,	TD|TF,		SEN(unlinkat),			"unlinkat"		},
[254] = { 4,	TD|TF,		SEN(renameat),			"renameat"		},
[255] = { 5,	TD|TF,		SEN(linkat),			"linkat"		},
[256] = { 3,	TD|TF,		SEN(symlinkat),			"symlinkat"		},
[257] = { 4,	TD|TF,		SEN(readlinkat),		"readlinkat"		},
[258] = { 3,	TD|TF,		SEN(fchmodat),			"fchmodat"		},
[259] = { 3,	TD|TF,		SEN(faccessat),			"faccessat"		},
[260] = { 6,	TD,		SEN(pselect6),			"pselect6"		},
[261] = { 5,	TD,		SEN(ppoll),			"ppoll"			},
[262] = { 1,	TP,		SEN(unshare),			"unshare"		},
[263] = { 6,	TD,		SEN(splice),			"splice"		},
[264] = { 4,	TD,		SEN(sync_file_range),		"sync_file_range"	},
[265] = { 4,	TD,		SEN(tee),			"tee"			},
[266] = { 4,	TD,		SEN(vmsplice),			"vmsplice"		},
[267] = { 6,	TM,		SEN(move_pages),		"move_pages"		},
[268] = { 2,	0,		SEN(set_robust_list),		"set_robust_list"	},
[269] = { 3,	0,		SEN(get_robust_list),		"get_robust_list"	},
[270] = { 4,	0,		SEN(kexec_load),		"kexec_load"		},
[271] = { 3,	0,		SEN(getcpu),			"getcpu"		},
[272] = { 6,	TD,		SEN(epoll_pwait),		"epoll_pwait"		},
[273] = { 3,	0,		SEN(ioprio_set),		"ioprio_set"		},
[274] = { 2,	0,		SEN(ioprio_get),		"ioprio_get"		},
[275] = { 4,	TD|TF,		SEN(utimensat),			"utimensat"		},
[276] = { 3,	TD|TS,		SEN(signalfd),			"signalfd"		},
[277] = { 4,	TD,		SEN(timerfd),			"timerfd"		},
[278] = { 1,	TD,		SEN(eventfd),			"eventfd"		},
[279] = { 4,	TD,		SEN(fallocate),			"fallocate"		},
[280] = { 2,	TD,		SEN(timerfd_create),		"timerfd_create"	},
[281] = { 2,	TD,		SEN(timerfd_gettime),		"timerfd_gettime"	},
[282] = { 4,	TD,		SEN(timerfd_settime),		"timerfd_settime"	},
[283] = { 4,	TD|TS,		SEN(signalfd4),			"signalfd4"		},
[284] = { 2,	TD,		SEN(eventfd2),			"eventfd2"		},
[285] = { 1,	TD,		SEN(epoll_create1),		"epoll_create1"		},
[286] = { 3,	TD,		SEN(dup3),			"dup3"			},
[287] = { 2,	TD,		SEN(pipe2),			"pipe2"			},
[288] = { 1,	TD,		SEN(inotify_init1),		"inotify_init1"		},
[289] = { 4,	TD,		SEN(preadv),			"preadv"		},
[290] = { 4,	TD,		SEN(pwritev),			"pwritev"		},
[291] = { 4,	TP|TS,		SEN(rt_tgsigqueueinfo),		"rt_tgsigqueueinfo"	},
[292] = { 5,	TD,		SEN(perf_event_open),		"perf_event_open"	},
[293] = { 4,	TN,		SEN(accept4),			"accept4"		},
[294] = { 5,	TN,		SEN(recvmmsg),			"recvmmsg"		},
[295] = { 2,	TD,		SEN(fanotify_init),		"fanotify_init"		},
[296] = { 5,	TD|TF,		SEN(fanotify_mark),		"fanotify_mark"		},
[297] = { 4,	0,		SEN(prlimit64),			"prlimit64"		},
[298] = { 5,	TD|TF,		SEN(name_to_handle_at),		"name_to_handle_at"	},
[299] = { 3,	TD,		SEN(open_by_handle_at),		"open_by_handle_at"	},
[300] = { 2,	0,		SEN(clock_adjtime),		"clock_adjtime"		},
[301] = { 1,	TD,		SEN(syncfs),			"syncfs"		},
[302] = { 4,	TN,		SEN(sendmmsg),			"sendmmsg"		},
[303] = { 2,	TD,		SEN(setns),			"setns"			},
[304] = { 6,	0,		SEN(process_vm_readv),		"process_vm_readv"	},
[305] = { 6,	0,		SEN(process_vm_writev),		"process_vm_writev"	},
[306] = { 5,	0,		SEN(kcmp),			"kcmp"			},
[307] = { 3,	TD,		SEN(finit_module),		"finit_module"		},
[308] = { 3,	TD,		SEN(getdents64),		"getdents64"		},
[309] = { 3,	0,		SEN(sched_setattr),		"sched_setattr"		},
[310] = { 4,	0,		SEN(sched_getattr),		"sched_getattr"		},
[311] = { 5,	TD|TF,		SEN(renameat2),			"renameat2"		},
[312] = { 3,	0,		SEN(seccomp),			"seccomp",		},
[313] = { 3,	0,		SEN(getrandom),			"getrandom",		},
[314] = { 2,	TD,		SEN(memfd_create),		"memfd_create",		},
[315] = { 3,	TD,		SEN(bpf),			"bpf",			},
[316] = { 5,	TD|TF|TP|SE|SI,	SEN(execveat),			"execveat",		},
[317] = { 1,	TD,		SEN(userfaultfd),		"userfaultfd",		},
[318] = { 2,	0,		SEN(membarrier),		"membarrier",		},
[319] = { 3,	TM,		SEN(mlock2),			"mlock2"		},
[320] = { 6,	TD,		SEN(copy_file_range),		"copy_file_range"	},
[321] = { 6,	TD,		SEN(preadv2),			"preadv2"		},
[322] = { 6,	TD,		SEN(pwritev2),			"pwritev2"		},
[323] = { 4,	TM|SI,		SEN(pkey_mprotect),		"pkey_mprotect"		},
[324] = { 2,	0,		SEN(pkey_alloc),		"pkey_alloc"		},
[325] = { 1,	0,		SEN(pkey_free),			"pkey_free"		},
