{ -*- buffer-read-only: t -*-

  Copyright 2015-2018 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in nodes_specification/components/ ,
  - and regenerate include files by running
    nodes_specification/x3d-nodes-to-pascal/x3d-nodes-to-pascal.lpr .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetInitialDestination: TVector2;
    procedure SetInitialDestination(const Value: TVector2);
    function GetInitialValue: TVector2;
    procedure SetInitialValue(const Value: TVector2);
  public
    property InitialDestination: TVector2 read GetInitialDestination write SetInitialDestination;
    property InitialValue: TVector2 read GetInitialValue write SetInitialValue;

{$endif read_interface}

{$ifdef read_implementation}

{ TPositionDamper2DNode ----------------------------------------------- }

function TPositionDamper2DNode.GetInitialDestination: TVector2;
begin
  Result := FdInitialDestination.Value;
end;

procedure TPositionDamper2DNode.SetInitialDestination(const Value: TVector2);
begin
  FdInitialDestination.Send(Value);
end;

function TPositionDamper2DNode.GetInitialValue: TVector2;
begin
  Result := FdInitialValue.Value;
end;

procedure TPositionDamper2DNode.SetInitialValue(const Value: TVector2);
begin
  FdInitialValue.Send(Value);
end;

{$endif read_implementation}
