#include "monitor_thread.h"
#include <QDir>
#include <QFile>
#include <QImage>
#include <QDebug>
#include <unistd.h>
#include <sys/stat.h>

extern QString getLockImagePath(uid_t uid);
extern bool makeBlurImage(const QString &inputImagePath, const QString &outputImagePath);
extern int getCurrentSpaceNumber();

MonitorThread::MonitorThread(int iPurpose)
{
    userId(getuid());
    purpose(iPurpose);
    start();
#ifdef QT_DEBUG
    qInfo() << Q_FUNC_INFO;
#endif
}


MonitorThread::~MonitorThread()
{
#ifdef QT_DEBUG
    qInfo() << Q_FUNC_INFO;
#endif
}

void MonitorThread::run()
{
    qInfo() << "monitor thread: " << QThread::currentThreadId() << ", UserId: " << m_iUserId << ", purpose: " << m_iPurpose << " started.";
    while (isRunning()) {
#ifdef QT_DEBUG
        qInfo() << "monitor thread: " << QThread::currentThreadId() << ", UserId: " << m_iUserId << ", purpose: " << m_iPurpose << " processing.";
#endif
        QString settingPath = getLockImagePath(m_iUserId);
        if (settingPath.isEmpty() || !QFile::exists(settingPath)) {
            qInfo() << "getLockImagePath got invalid image path. user: " << m_iUserId << ", purpose: " << m_iPurpose << "path: " << settingPath;
        } else {
            if (m_lastSettingPath != settingPath) {
                m_lastSettingPath = settingPath;
                updateWorkSpaceImagePath();
                makeBlurImage(settingPath, m_userImagePath);
            }
        }
        QThread::sleep(m_iSecondSpan);
    }
    qInfo() << "monitor thread: " << m_iUserId << " ended.";
}

void MonitorThread::userId(uid_t uid)
{
    if (uid == m_iUserId)
        return;
    m_iUserId = uid;
}

uid_t MonitorThread::userId()
{
    return m_iUserId;
}


void MonitorThread::purpose(int iPurpose)
{
    m_iPurpose = iPurpose;
    updateWorkSpaceImagePath();
}


int MonitorThread::purpose()
{
    return m_iPurpose;
}

void MonitorThread::secondSpan(int iSpan)
{
    if (iSpan == m_iSecondSpan) {
        return;
    }
    m_iSecondSpan = iSpan;
}

int MonitorThread::secondSpan()
{
    return m_iSecondSpan;
}

void MonitorThread::updateWorkSpaceImagePath() 
{
    QDir d = QDir::home();
    if (!d.exists(m_blurPath)) {
        if (d.mkpath(m_blurPath)) {
            qDebug() << "updateWorkSpaceImagePath mkpath:" << m_blurPath;
            chmod(d.absolutePath().toUtf8(), S_IXUSR | S_IRUSR | S_IWUSR | S_IRGRP | S_IXGRP | S_IROTH | S_IXOTH);
        } else {
            qDebug() << "updateWorkSpaceImagePath mkpath failed:" << m_blurPath << ", cd .cache:" << d.cd(".cache");
        }
    }
    d.cd(m_blurPath);
    m_userImagePath = d.absoluteFilePath(QString::number(m_iPurpose) + ".jpg");
}
